/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.model;

import com.spket.js.model.Context;
import com.spket.js.model.Flags;
import com.spket.js.model.FunctionWrapper;
import com.spket.js.model.ICompletionRequestor;
import com.spket.js.model.ISlot;
import com.spket.js.model.JSFunction;
import com.spket.js.model.JSObject;
import com.spket.js.model.Slot;
import com.spket.js.model.SlotWrapper;
import com.spket.util.Debug;
import java.util.HashMap;
import java.util.Map;

public class ObjectWrapper
implements JSObject {
    private Map properties;
    private Object value;
    private JSObject scope;
    private JSObject wrapper;
    private JSObject base;
    private JSObject prototype;

    public ObjectWrapper(JSObject jSObject) {
        if (jSObject instanceof ObjectWrapper) {
            Debug.warn((String)("Wrapper: " + jSObject.getClassName()));
        }
        this.wrapper = jSObject;
    }

    public int prototype() {
        return this.wrapper.prototype();
    }

    protected boolean isEmpty() {
        return this.properties == null || this.properties.isEmpty();
    }

    public String getClassName() {
        return this.wrapper.getClassName();
    }

    public void setClassName(String string) {
        this.wrapper.setClassName(string);
    }

    public Object getValue() {
        return this.value == null ? this.wrapper.getValue() : this.value;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public ISlot getLocalSlot(String string) {
        return this.getSlot(string);
    }

    public JSObject getProperty(String string) {
        ISlot iSlot = this.getSlot(string);
        return iSlot == null ? null : iSlot.getObject();
    }

    public JSObject getPrototype() {
        JSObject jSObject;
        if (this.prototype == null && this.wrapper != null && (jSObject = this.wrapper.getPrototype()) != null) {
            this.prototype = this.wrap(jSObject);
        }
        return this.prototype;
    }

    public void setPrototype(JSObject jSObject) {
        this.prototype = jSObject;
    }

    public ISlot getSlot(String string) {
        ISlot iSlot = null;
        JSObject jSObject = this.getBase();
        if (jSObject != null) {
            iSlot = jSObject.getSlot(string);
        }
        if (iSlot == null && !this.isEmpty()) {
            iSlot = (ISlot)this.properties.get(string);
        }
        if (iSlot == null) {
            JSObject jSObject2 = this.prototype;
            if (jSObject2 != null) {
                iSlot = jSObject2.getSlot(string);
            }
            if (iSlot == null) {
                jSObject2 = this.wrapper;
                iSlot = jSObject2.getSlot(string);
            }
            if (iSlot != null) {
                JSObject jSObject3 = iSlot.getObject();
                JSObject jSObject4 = Context.getTopLevelScope(this);
                iSlot = new SlotWrapper(iSlot);
                if (jSObject3 == null) {
                    jSObject3 = jSObject2.createProperty(jSObject4, string);
                }
                if (jSObject3 != null) {
                    iSlot.setObject(this.wrap(jSObject3));
                }
                if (this.properties == null) {
                    this.properties = new HashMap();
                }
                this.properties.put(string, iSlot);
            }
        }
        return iSlot;
    }

    public JSObject createProperty(JSObject jSObject, String string) {
        return this.wrapper.createProperty(jSObject, string);
    }

    public boolean hasProperty(String string) {
        return this.properties != null && this.properties.containsKey(string);
    }

    public JSObject getParentScope() {
        return this.scope;
    }

    public void setParentScope(JSObject jSObject) {
        this.base = null;
        this.scope = jSObject;
    }

    public void setProperty(String string, JSObject jSObject) {
        ISlot iSlot = this.getSlot(string);
        if (iSlot == null) {
            iSlot = new Slot();
            if (this.properties == null) {
                this.properties = new HashMap();
            }
            this.properties.put(string, iSlot);
        }
        if (!Flags.isReadonly(iSlot.getFlags()) && !Flags.isPrototype(iSlot.getFlags())) {
            iSlot.setObject(jSObject);
        }
    }

    public void codeComplete(ICompletionRequestor iCompletionRequestor) {
        Object object;
        if (!this.isEmpty() && iCompletionRequestor.accept(this)) {
            object = this.properties.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                ISlot iSlot = (ISlot)entry.getValue();
                if (iSlot instanceof SlotWrapper) continue;
                iCompletionRequestor.accept(this, entry.getKey().toString(), iSlot);
            }
        }
        if (this.prototype != null) {
            this.prototype.codeComplete(iCompletionRequestor);
        }
        this.wrapper.codeComplete(iCompletionRequestor);
        object = this.getBase();
        if (object != null) {
            object.codeComplete(iCompletionRequestor);
        }
    }

    public void codeComplete(ICompletionRequestor iCompletionRequestor, int n) {
        Object object;
        if (!this.isEmpty() && iCompletionRequestor.accept(this)) {
            object = this.properties.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                ISlot iSlot = (ISlot)entry.getValue();
                if (iSlot instanceof SlotWrapper) continue;
                iCompletionRequestor.accept(this, entry.getKey().toString(), iSlot);
            }
        }
        if (this.prototype != null) {
            this.prototype.codeComplete(iCompletionRequestor);
        }
        this.wrapper.codeComplete(iCompletionRequestor, n);
        object = this.getBase();
        if (object != null) {
            object.codeComplete(iCompletionRequestor, n);
        }
    }

    public JSObject unwrap() {
        return this.wrapper;
    }

    protected JSObject wrap(JSObject jSObject) {
        if (jSObject != null && !(jSObject instanceof ObjectWrapper)) {
            jSObject = jSObject instanceof JSFunction ? new FunctionWrapper(jSObject) : new ObjectWrapper(jSObject);
            JSObject jSObject2 = this.getParentScope();
            jSObject.setParentScope(jSObject2 == null ? this : jSObject2);
        }
        return jSObject;
    }

    private JSObject getBase() {
        if (this.base == null && this.scope != null) {
            JSObject jSObject = null;
            jSObject = this.wrapper.prototype() != 2 ? Context.getObjectPrototype(this.scope) : Context.getFunctionPrototype(this.scope);
            if (jSObject != this) {
                this.base = jSObject;
            }
        }
        return this.base;
    }
}

