/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.internal.text;

import com.spket.as.internal.compiler.parser.BufferedScanner;
import com.spket.js.internal.JSPlugin;
import com.spket.js.parser.ILexerListener;
import com.spket.js.parser.LexerProvider;
import com.spket.js.parser.ScriptParser;
import com.spket.ui.text.IFoldingSupport;
import com.spket.util.Debug;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;

public class JSFoldingSupport
implements IFoldingSupport {
    private static final int T_COMMENT = 1;
    private static final Annotation[] EMTPY_ANN = new Annotation[0];
    private boolean fChanged;
    private boolean fProjectionEnabled;
    private int fLineSpace;
    private LexerProvider fProvider;
    private ProjectionViewer fViewer;
    private FoldingListener fListener;

    public JSFoldingSupport(LexerProvider lexerProvider) {
        this.fProvider = lexerProvider;
    }

    public void install(ProjectionViewer projectionViewer) {
        this.fViewer = projectionViewer;
        this.fListener = new FoldingListener();
        this.fViewer.addProjectionListener((IProjectionListener)this.fListener);
        if (this.fProjectionEnabled) {
            this.fProvider.addLexerListener(this.fListener);
        }
    }

    public void uninstall() {
        this.fProjectionEnabled = false;
        if (this.fViewer != null) {
            if (this.fListener != null) {
                this.fViewer.removeProjectionListener((IProjectionListener)this.fListener);
            }
            this.fViewer = null;
        }
        if (this.fProvider != null) {
            if (this.fListener != null) {
                this.fProvider.removeLexerListener(this.fListener);
            }
            this.fProvider = null;
        }
        this.fListener = null;
    }

    public void reconcile() {
    }

    public void initialize() {
        if (this.fProjectionEnabled && this.fProvider != null) {
            int n = 0;
            IPreferenceStore iPreferenceStore = JSPlugin.getDefault().getPreferenceStore();
            if (iPreferenceStore.getBoolean("js_folding_comments")) {
                n |= 1;
            }
            this.process(this.fProvider.getLexer(false), n);
        }
    }

    public int affects(String string) {
        if ("js_folding".equals(string)) {
            return 1;
        }
        if ("js_folding_blocks".equals(string) || "js_folding_lines".equals(string)) {
            return 2;
        }
        return 0;
    }

    public void configure(IPreferenceStore iPreferenceStore, boolean bl) {
        int n = -1;
        if (iPreferenceStore.getBoolean("js_folding_blocks")) {
            n = iPreferenceStore.getInt("js_folding_lines");
        }
        if (this.fLineSpace != n) {
            this.fLineSpace = n;
            if (bl && this.fProjectionEnabled && this.fProvider != null) {
                this.process(this.fProvider.getLexer(), 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onLexerAboutToBeChanged() {
        JSFoldingSupport jSFoldingSupport = this;
        synchronized (jSFoldingSupport) {
            this.fChanged = true;
        }
    }

    protected void onLexerChanged(BufferedScanner bufferedScanner) {
        this.process(bufferedScanner, 0);
    }

    protected void onProjectionDisabled() {
        this.fProjectionEnabled = false;
        if (this.fProvider != null && this.fListener != null) {
            this.fProvider.removeLexerListener(this.fListener);
        }
    }

    protected void onProjectionEnabled() {
        this.fProjectionEnabled = true;
        if (this.fProvider != null && this.fListener != null) {
            this.fProvider.addLexerListener(this.fListener);
        }
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(BufferedScanner bufferedScanner, int n) {
        Object object;
        if (!this.fProjectionEnabled || this.fViewer == null || this.fProvider == null) {
            return;
        }
        JSFoldingSupport jSFoldingSupport = this;
        synchronized (jSFoldingSupport) {
            this.fChanged = false;
        }
        jSFoldingSupport = this.fViewer.getProjectionAnnotationModel();
        if (this.fChanged || jSFoldingSupport == null) {
            return;
        }
        if (bufferedScanner == null || bufferedScanner.getSize() == 0) {
            jSFoldingSupport.removeAllAnnotations();
            return;
        }
        Set set = Collections.EMPTY_SET;
        try {
            object = bufferedScanner;
            synchronized (object) {
                bufferedScanner.setRange(0, bufferedScanner.getSize());
                set = this.folding(bufferedScanner);
            }
        }
        catch (BadLocationException badLocationException) {
            Debug.debug((Throwable)badLocationException);
            return;
        }
        object = Collections.EMPTY_LIST;
        if (this.fChanged) {
            return;
        }
        if (set.size() > 0) {
            object = new ArrayList();
            this.match((ProjectionAnnotationModel)jSFoldingSupport, set, (List)object);
        }
        if (!(this.fChanged || set.size() <= 0 && object.size() <= 0)) {
            Annotation[] annotationArray = EMTPY_ANN;
            HashMap<JSProjectionAnnotation, Position> hashMap = Collections.EMPTY_MAP;
            if (set.size() > 0) {
                hashMap = new HashMap<JSProjectionAnnotation, Position>(set.size());
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Pair pair = (Pair)iterator.next();
                    hashMap.put(new JSProjectionAnnotation(pair.type, (pair.type & n) != 0), pair.position);
                }
            }
            if (!this.fChanged) {
                if (object.size() > 0) {
                    annotationArray = new Annotation[object.size()];
                    object.toArray(annotationArray);
                }
                if (!this.fChanged) {
                    jSFoldingSupport.modifyAnnotations(annotationArray, hashMap, EMTPY_ANN);
                }
            }
        }
    }

    protected void match(ProjectionAnnotationModel projectionAnnotationModel, Set set, List list) {
        Iterator iterator = projectionAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof JSProjectionAnnotation)) continue;
            JSProjectionAnnotation jSProjectionAnnotation = (JSProjectionAnnotation)((Object)e);
            Position position = projectionAnnotationModel.getPosition((Annotation)jSProjectionAnnotation);
            Pair pair = new Pair(jSProjectionAnnotation.getFoldingType(), position);
            if (set.remove(pair)) continue;
            list.add(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Set folding(BufferedScanner bufferedScanner) throws BadLocationException {
        Folding folding;
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        ArrayList<Folding> arrayList = new ArrayList<Folding>();
        HashSet<Pair> hashSet = new HashSet<Pair>();
        IDocument iDocument = this.fViewer.getDocument();
        int n6 = iDocument.getNumberOfLines() - 1;
        if (bufferedScanner.commentPtr != -1) {
            for (int i = 0; i <= bufferedScanner.commentPtr && !this.fChanged; ++i) {
                n2 = bufferedScanner.commentStarts[i];
                if (n2 < 0) continue;
                n5 = iDocument.getLineOfOffset(n2);
                n = bufferedScanner.commentStops[i];
                if (n < 0) {
                    n = -n;
                }
                if (n <= n2 || (n3 = iDocument.getLineOfOffset(n)) <= n5) continue;
                hashSet.add(new Pair(1, this.createPosition(iDocument, n6, n2, n)));
            }
            n5 = 0;
            n3 = 0;
        }
        block9: while (!this.fChanged) {
            int n7 = bufferedScanner.getNextToken();
            if (bufferedScanner.crPos > 0) {
                ++n3;
            }
            switch (n7) {
                case 45: {
                    break block9;
                }
                case 50: {
                    n2 = bufferedScanner.startPosition;
                    n = bufferedScanner.getOffset();
                    n5 = this.skipFunction(bufferedScanner);
                    if (n5 == -1) {
                        bufferedScanner.setOffset(n);
                        break;
                    }
                    folding = new Folding();
                    folding.line = n3;
                    folding.offset = n2;
                    folding.braces = n4;
                    n4 = 1;
                    arrayList.add(folding);
                    n3 += n5;
                    break;
                }
                case 48: 
                case 49: {
                    if (this.fLineSpace <= 0) break;
                }
                case 70: {
                    if (bufferedScanner.peek() != 46) break;
                    folding = new Folding();
                    folding.line = n3;
                    folding.braces = n4;
                    folding.offset = bufferedScanner.startPosition;
                    if (48 == n7) {
                        folding.lineSpace = this.fLineSpace;
                    }
                    n4 = 1;
                    arrayList.add(folding);
                    bufferedScanner.getNextToken();
                    if (bufferedScanner.crPos <= 0) break;
                    ++n3;
                    break;
                }
                case 46: {
                    if (this.fLineSpace > 0) {
                        folding = new Folding();
                        folding.line = n3;
                        folding.braces = n4;
                        folding.lineSpace = this.fLineSpace;
                        folding.offset = bufferedScanner.startPosition;
                        n4 = 1;
                        arrayList.add(folding);
                        break;
                    }
                    ++n4;
                    break;
                }
                case 44: {
                    if (--n4 != 0 || arrayList.size() <= 0) break;
                    folding = (Folding)arrayList.remove(arrayList.size() - 1);
                    n4 = folding.braces;
                    if (n3 < folding.line + folding.lineSpace) break;
                    hashSet.add(new Pair(this.createPosition(iDocument, n6, folding.offset, bufferedScanner.startPosition)));
                }
            }
        }
        n3 = n6;
        n = iDocument.getLength();
        n2 = arrayList.size();
        while (n2 > 0) {
            folding = (Folding)arrayList.remove(--n2);
            if (n3 < folding.line + folding.lineSpace) continue;
            hashSet.add(new Pair(this.createPosition(iDocument, n6, folding.offset, n)));
        }
        return hashSet;
    }

    private Position createPosition(IDocument iDocument, int n, int n2, int n3) throws BadLocationException {
        n2 = iDocument.getLineInformationOfOffset(n2).getOffset();
        n3 = (n3 = iDocument.getLineOfOffset(n3)) == n ? iDocument.getLength() : iDocument.getLineOffset(n3 + 1);
        return new Position(n2, n3 - n2);
    }

    private int skipFunction(BufferedScanner bufferedScanner) {
        block7: {
            int n = 0;
            int n2 = bufferedScanner.peek();
            if (ScriptParser.isIdentifier(n2)) {
                bufferedScanner.getNextToken();
                if (bufferedScanner.crPos > 0) {
                    ++n;
                }
                n2 = bufferedScanner.peek();
            }
            if (4 != n2) break block7;
            int n3 = 0;
            while (true) {
                n2 = bufferedScanner.getNextToken();
                if (bufferedScanner.crPos > 0) {
                    ++n;
                }
                if (4 == n2) {
                    ++n3;
                    continue;
                }
                if (48 == n2) {
                    if (--n3 != 0 || 46 != (n2 = bufferedScanner.getNextToken())) continue;
                    if (bufferedScanner.crPos > 0) {
                        ++n;
                    }
                    return n;
                }
                if (45 == n2) break;
            }
        }
        return -1;
    }

    private final class FoldingListener
    implements ILexerListener,
    IProjectionListener {
        private FoldingListener() {
        }

        public void lexerAboutToBeChanged() {
            JSFoldingSupport.this.onLexerAboutToBeChanged();
        }

        public void lexerChanged(BufferedScanner bufferedScanner) {
            JSFoldingSupport.this.onLexerChanged(bufferedScanner);
        }

        public void projectionDisabled() {
            JSFoldingSupport.this.onProjectionDisabled();
        }

        public void projectionEnabled() {
            JSFoldingSupport.this.onProjectionEnabled();
        }
    }

    private static class Folding {
        public int offset;
        public int braces;
        public int line;
        public int lineSpace = 1;

        private Folding() {
        }
    }

    private static final class JSProjectionAnnotation
    extends ProjectionAnnotation {
        private int fType;

        public JSProjectionAnnotation(int n, boolean bl) {
            super(bl);
            this.fType = n;
        }

        public int getFoldingType() {
            return this.fType;
        }
    }

    private static class Pair {
        public int type;
        public Position position;

        public Pair(Position position) {
            this.position = position;
        }

        public Pair(int n, Position position) {
            this.type = n;
            this.position = position;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Pair) {
                Pair pair = (Pair)object;
                return this.type == pair.type && this.position.equals((Object)pair.position);
            }
            return false;
        }

        public int hashCode() {
            return this.type << 30 | this.position.hashCode();
        }
    }
}

