/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.internal.text;

import com.spket.ui.text.html.SingleCharReader;
import java.io.IOException;

public class JSDocCommentReader
extends SingleCharReader {
    private String text;
    private int fCurrPos;
    private int fStartPos;
    private int fEndPos;
    private boolean fWasNewLine;

    public static boolean isLineDelimiterChar(char c) {
        return c == '\n' || c == '\r';
    }

    public JSDocCommentReader(String string, int n, int n2) {
        this.text = string;
        this.fStartPos = n;
        this.fStartPos += 2;
        if (string.charAt(this.fStartPos + 1) == '*') {
            ++this.fStartPos;
        }
        this.fEndPos = n2 - 2;
        this.reset();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read() throws IOException {
        char c;
        if (this.fCurrPos >= this.fEndPos) return -1;
        if (this.fWasNewLine) {
            do {
                c = this.text.charAt(this.fCurrPos++);
            } while (this.fCurrPos < this.fEndPos && Character.isWhitespace(c));
            if (c == '*') {
                if (this.fCurrPos >= this.fEndPos) return -1;
                while ((c = this.text.charAt(this.fCurrPos++)) == '*') {
                }
            }
        } else {
            c = this.text.charAt(this.fCurrPos++);
        }
        this.fWasNewLine = JSDocCommentReader.isLineDelimiterChar(c);
        return c;
    }

    public void close() {
        this.text = null;
    }

    public void reset() {
        this.fWasNewLine = true;
        this.fCurrPos = this.fStartPos;
    }
}

