/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.internal.text;

import com.spket.as.internal.compiler.impl.CompilerOptions;
import com.spket.as.internal.compiler.parser.BufferedScanner;
import com.spket.js.internal.JSPlugin;
import com.spket.js.internal.text.JSCompletionCollector;
import com.spket.js.model.ILexerContext;
import com.spket.js.model.ILexerProvider;
import com.spket.js.parser.CompletionEngine;
import com.spket.ui.internal.UIImages;
import com.spket.ui.text.CompletionProposalComparator;
import com.spket.ui.text.EncodedTemplateContext;
import com.spket.ui.text.TemplateInformationControlCreator;
import com.spket.ui.text.TextTools;
import com.spket.util.Debug;
import com.spket.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class JSContentAssistProcessor
implements IContentAssistProcessor {
    private static final Comparator fgProposalComparator = new CompletionProposalComparator(true);
    protected int fOffset;
    protected int fSelLength;
    protected ITextViewer fViewer;
    private boolean escaping;
    private boolean computeTemplate;
    private ILexerContext fContext;
    private char[] autoActivationCharacters = null;

    public static String getProject(IPath iPath) {
        if (iPath != null && iPath.getDevice() == null && iPath.isAbsolute() && iPath.segmentCount() > 0) {
            return iPath.segment(0);
        }
        return null;
    }

    public JSContentAssistProcessor(ILexerContext iLexerContext) {
        this.fContext = iLexerContext;
    }

    public void setActivationCharacters(char[] cArray) {
        this.autoActivationCharacters = cArray;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer iTextViewer, int n) {
        ICompletionProposal[] iCompletionProposalArray = null;
        this.reset(iTextViewer, n);
        iCompletionProposalArray = this.determineProposals();
        if (this.computeTemplate) {
            iCompletionProposalArray = this.mergeProposals(iCompletionProposalArray, this.determineTemplateProposals());
        }
        return iCompletionProposalArray;
    }

    public IContextInformation[] computeContextInformation(ITextViewer iTextViewer, int n) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.autoActivationCharacters;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    protected void reset(ITextViewer iTextViewer, int n) {
        this.fSelLength = 0;
        this.fOffset = n;
        this.escaping = false;
        this.computeTemplate = true;
        this.fViewer = iTextViewer;
        if (iTextViewer == null) {
            return;
        }
        Point point = iTextViewer.getSelectedRange();
        if (point != null && point.x != -1 && point.y > 0) {
            this.fSelLength = point.y;
        }
    }

    protected CompilerOptions getCompilerOptions() {
        CompilerOptions compilerOptions = new CompilerOptions();
        compilerOptions.sourceLevel = 6;
        return compilerOptions;
    }

    protected List getIncludes() {
        return Collections.EMPTY_LIST;
    }

    protected ICompletionProposal[] determineProposals() {
        BufferedScanner bufferedScanner = null;
        ILexerProvider iLexerProvider = this.fContext.getLexerProvider(this.fOffset);
        if (iLexerProvider != null) {
            bufferedScanner = iLexerProvider.getLexer();
        }
        if (bufferedScanner != null) {
            this.escaping = (bufferedScanner.flags & 4) != 0;
            JSCompletionCollector jSCompletionCollector = new JSCompletionCollector(this.fOffset, this.fSelLength);
            CompletionEngine completionEngine = new CompletionEngine(iLexerProvider);
            completionEngine.setLexer(bufferedScanner);
            completionEngine.codeComplete(jSCompletionCollector, this.fOffset);
            this.computeTemplate = !completionEngine.hasLeftHandSideExpression();
            ICompletionProposal[] iCompletionProposalArray = jSCompletionCollector.getCompletionProposals();
            if (iCompletionProposalArray != null) {
                Arrays.sort(iCompletionProposalArray, new CompletionProposalComparator());
                return iCompletionProposalArray;
            }
        }
        return null;
    }

    protected ICompletionProposal[] determineTemplateProposals() {
        String string = this.extractPrefix(this.fViewer, this.fOffset);
        Region region = new Region(this.fOffset - string.length(), this.fSelLength + string.length());
        TemplateContext templateContext = this.createContext(this.fViewer, (IRegion)region);
        if (templateContext != null) {
            ArrayList<ICompletionProposal> arrayList = new ArrayList<ICompletionProposal>();
            String string2 = templateContext.getContextType().getId();
            Image image = UIImages.getImage((String)"template_obj.gif");
            Template[] templateArray = JSPlugin.getDefault().getTemplateStore().getTemplates();
            if (this.fSelLength > 0) {
                String string3 = null;
                try {
                    string3 = this.fViewer.getDocument().get(this.fOffset, this.fSelLength);
                }
                catch (BadLocationException badLocationException) {
                    Debug.debug((Throwable)badLocationException);
                }
                templateContext.setVariable("selection", string3);
            }
            templateContext.setVariable("project", JSContentAssistProcessor.getProject(this.fContext.getPath()));
            for (int i = 0; i < templateArray.length; ++i) {
                Template template = templateArray[i];
                if (!template.matches(string, string2) || !StringUtils.startsWith((String)template.getName(), (String)string, (boolean)false) || !templateContext.canEvaluate(template)) continue;
                arrayList.add(this.createProposal(template, templateContext, (IRegion)region, image));
            }
            if (arrayList.size() > 0) {
                ICompletionProposal[] iCompletionProposalArray = new ICompletionProposal[arrayList.size()];
                arrayList.toArray(iCompletionProposalArray);
                Arrays.sort(iCompletionProposalArray, fgProposalComparator);
                return iCompletionProposalArray;
            }
        }
        return null;
    }

    protected TemplateContext createContext(ITextViewer iTextViewer, IRegion iRegion) {
        TemplateContextType templateContextType = JSPlugin.getDefault().getTemplateContextRegistry().getContextType("JavaScript");
        if (templateContextType != null) {
            IDocument iDocument = iTextViewer.getDocument();
            EncodedTemplateContext encodedTemplateContext = new EncodedTemplateContext(templateContextType, iDocument, iRegion.getOffset(), iRegion.getLength());
            encodedTemplateContext.setEscaping(this.escaping);
            return encodedTemplateContext;
        }
        return null;
    }

    protected String extractPrefix(ITextViewer iTextViewer, int n) {
        int n2 = n;
        IDocument iDocument = iTextViewer.getDocument();
        if (n2 > iDocument.getLength()) {
            return "";
        }
        try {
            char c;
            while (n2 > 0 && Character.isJavaIdentifierPart(c = iDocument.getChar(n2 - 1))) {
                --n2;
            }
            return iDocument.get(n2, n - n2);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    protected ICompletionProposal createProposal(Template template, TemplateContext templateContext, IRegion iRegion, Image image) {
        TemplateProposal templateProposal = new TemplateProposal(template, templateContext, iRegion, image, 0);
        templateProposal.setInformationControlCreator((IInformationControlCreator)new TemplateInformationControlCreator((TextTools)JSPlugin.getDefault().getTextTools()));
        return templateProposal;
    }

    protected ICompletionProposal[] mergeProposals(ICompletionProposal[] iCompletionProposalArray, ICompletionProposal[] iCompletionProposalArray2) {
        if (iCompletionProposalArray == null || iCompletionProposalArray.length == 0) {
            return iCompletionProposalArray2;
        }
        if (iCompletionProposalArray2 == null || iCompletionProposalArray2.length == 0) {
            return iCompletionProposalArray;
        }
        ICompletionProposal[] iCompletionProposalArray3 = new ICompletionProposal[iCompletionProposalArray.length + iCompletionProposalArray2.length];
        System.arraycopy(iCompletionProposalArray, 0, iCompletionProposalArray3, 0, iCompletionProposalArray.length);
        System.arraycopy(iCompletionProposalArray2, 0, iCompletionProposalArray3, iCompletionProposalArray.length, iCompletionProposalArray2.length);
        return iCompletionProposalArray3;
    }
}

