/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.internal.text;

import com.spket.js.internal.JSImages;
import com.spket.js.internal.text.JSCompletionProposal;
import com.spket.js.model.ICompletionRequestor;
import com.spket.js.model.ISlot;
import com.spket.js.model.JSDoc;
import com.spket.js.model.JSFunction;
import com.spket.js.model.JSObject;
import com.spket.js.model.ObjectWrapper;
import com.spket.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;

public class JSCompletionCollector
implements ICompletionRequestor {
    protected static final int R_GLOBAL_VAR = 16;
    protected static final int R_GLOBAL_FUNC = 32;
    protected static final int R_ID_VAR = 64;
    protected static final int R_LOCAL_VAR = 128;
    protected static final int R_FIELD = 256;
    protected static final int R_EVENT = 512;
    protected static final int R_METHOD = 1024;
    protected static final int R_CLASS = 2048;
    protected static final int R_CLASS_NODE = 4096;
    protected static final Image IMG_CLASS = JSImages.get("c.s.js.class_obj.gif");
    protected static final Image IMG_FIELD = JSImages.get("c.s.js.field_public_obj.gif");
    protected static final Image IMG_FIELD_PRIV = JSImages.get("c.s.js.field_private_obj.gif");
    protected static final Image IMG_FUNCTION = JSImages.get("c.s.js.function_obj.gif");
    protected static final Image IMG_FUNC_PRIV = JSImages.get("c.s.js.function_private.gif");
    protected static final char[] VAR_TRIGGERS = new char[]{'\t', ' ', '=', ';', '.'};
    protected static final char[] TYPE_TRIGGERS = new char[]{'.', '\t', '[', '(', ' '};
    protected static final char[] METHOD_WITH_ARGUMENTS_TRIGGERS = new char[]{'(', '-', ' '};
    protected static final char[] METHOD_TRIGGERS = new char[]{'(', ';', ',', '.', '\t', '[', ' '};
    private boolean isNewExp;
    private char[] prefix;
    private int dotOffset = -1;
    private int fOffset;
    private int fLength;
    private Map objects = new HashMap();
    private Map members = new HashMap();
    private List proposals = new ArrayList();

    protected static String getLabel(JSObject jSObject, String string, ISlot iSlot) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        string = jSObject.getClassName();
        if (string != null) {
            stringBuffer.append(" - ").append(string);
        }
        return stringBuffer.toString();
    }

    protected static boolean isValid(String string) {
        if (Character.isJavaIdentifierStart(string.charAt(0))) {
            int n = string.length();
            for (int i = 1; i < n; ++i) {
                if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected static boolean isPrivate(ISlot iSlot) {
        Object object = iSlot.getData(ISlot.P_COMMENT);
        if (object instanceof JSDoc) {
            return ((JSDoc)object).hasPrivateTag();
        }
        return false;
    }

    protected static boolean isClass(String string, ISlot iSlot) {
        JSObject jSObject = iSlot.getObject();
        if (jSObject instanceof ObjectWrapper) {
            jSObject = ((ObjectWrapper)jSObject).unwrap();
        }
        if (jSObject instanceof JSFunction) {
            return ((JSFunction)jSObject).isClass();
        }
        return false;
    }

    public JSCompletionCollector(int n, int n2) {
        this.fOffset = n;
        this.fLength = n2;
        this.prefix = StringUtils.EMPTY_CHARS;
    }

    public void setPrefix(char[] cArray) {
        this.prefix = cArray == null ? StringUtils.EMPTY_CHARS : cArray;
        this.fOffset -= this.prefix.length;
        this.fLength += this.prefix.length;
    }

    public void setOffset(int n) {
        this.dotOffset = n;
    }

    public void setNewExpression(boolean bl) {
        this.isNewExp = bl;
    }

    public boolean accept(JSObject jSObject) {
        if (this.objects.containsKey(jSObject)) {
            return false;
        }
        this.objects.put(jSObject, Boolean.TRUE);
        return true;
    }

    public void accept(JSObject jSObject, String string, ISlot iSlot) {
        if ((iSlot.getFlags() & 0x400000) != 0) {
            return;
        }
        if (this.members.containsKey(string)) {
            return;
        }
        this.members.put(string, Boolean.TRUE);
        if (this.prefix.length == 0 || StringUtils.startsWith((String)string, (char[])this.prefix, (boolean)false)) {
            Image image;
            String string2;
            int n = this.fOffset;
            int n2 = this.fLength;
            JSFunction jSFunction = null;
            boolean bl = false;
            String string3 = JSCompletionCollector.getLabel(jSObject, string, iSlot);
            JSObject jSObject2 = iSlot.getObject();
            int n3 = 256;
            if (JSCompletionCollector.isValid(string)) {
                string2 = string;
            } else {
                if (this.dotOffset == -1) {
                    --n;
                    ++n2;
                } else {
                    n2 += n - this.dotOffset;
                    n = this.dotOffset;
                }
                string2 = "['" + string + "']";
            }
            if (jSObject2 instanceof JSFunction) {
                bl = JSCompletionCollector.isClass(string, iSlot);
                jSFunction = (JSFunction)jSObject2;
                if (this.isNewExp || !bl) {
                    string2 = string2 + "()";
                }
                if (bl) {
                    image = IMG_CLASS;
                    n3 = 2048;
                } else {
                    image = JSCompletionCollector.isPrivate(iSlot) ? IMG_FUNC_PRIV : IMG_FUNCTION;
                    n3 = 1024;
                }
            } else {
                image = JSCompletionCollector.isPrivate(iSlot) ? IMG_FIELD_PRIV : IMG_FIELD;
            }
            JSCompletionProposal jSCompletionProposal = new JSCompletionProposal(string2, n, n2, image, string3, n3);
            if (jSFunction != null) {
                if (this.isNewExp || !bl) {
                    if (jSFunction.getNumberOfParameters() > 0) {
                        jSCompletionProposal.setCursorPosition(jSCompletionProposal.getCursorPosition() - 1);
                        jSCompletionProposal.setTriggerCharacters(METHOD_WITH_ARGUMENTS_TRIGGERS);
                    } else {
                        jSCompletionProposal.setTriggerCharacters(METHOD_TRIGGERS);
                    }
                } else {
                    jSCompletionProposal.setTriggerCharacters(TYPE_TRIGGERS);
                }
            } else {
                jSCompletionProposal.setTriggerCharacters(VAR_TRIGGERS);
            }
            jSCompletionProposal.setAdditionalProposalInfo(string, iSlot);
            this.proposals.add(jSCompletionProposal);
        }
    }

    public ICompletionProposal[] getCompletionProposals() {
        if (this.proposals != null && this.proposals.size() > 0) {
            ICompletionProposal[] iCompletionProposalArray = new ICompletionProposal[this.proposals.size()];
            this.proposals.toArray(iCompletionProposalArray);
            return iCompletionProposalArray;
        }
        return null;
    }
}

