/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.internal.text;

import com.spket.ui.text.CombinedWordRule;
import com.spket.ui.text.ConfigurableScanner;
import com.spket.ui.text.IColorManager;
import com.spket.util.Assert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;

public class JSCommentScanner
extends ConfigurableScanner {
    private static final String ENABLED = "enabled";
    protected static final String TASK_TAG = "js_task_tag";
    private static final String COMPILER_TASK_TAGS = "spket.taskTags";
    private static final String COMPILER_TASK_CASE_SENSITIVE = "spket.taskCaseSensitive";
    private String[] fTokenProperties;
    private String fDefaultTokenProperty;
    private TaskTagMatcher fTaskTagMatcher;

    public JSCommentScanner(IColorManager iColorManager, IPreferenceStore iPreferenceStore, String string, String[] stringArray) {
        super(iColorManager, iPreferenceStore);
        this.fTokenProperties = stringArray;
        this.fDefaultTokenProperty = string;
        this.initialize();
    }

    public JSCommentScanner(IColorManager iColorManager, IPreferenceStore iPreferenceStore, String string) {
        this(iColorManager, iPreferenceStore, string, new String[]{string, TASK_TAG});
    }

    protected List createRules() {
        ArrayList<CombinedWordRule> arrayList = new ArrayList<CombinedWordRule>();
        Token token = this.getToken(this.fDefaultTokenProperty);
        List list = this.createMatchers();
        if (list.size() > 0) {
            CombinedWordRule combinedWordRule = new CombinedWordRule((IWordDetector)new AtJavaIdentifierDetector(), (IToken)token);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                combinedWordRule.addWordMatcher((CombinedWordRule.WordMatcher)list.get(i));
            }
            arrayList.add(combinedWordRule);
        }
        this.setDefaultReturnToken((IToken)token);
        return arrayList;
    }

    protected List createMatchers() {
        ArrayList<TaskTagMatcher> arrayList = new ArrayList<TaskTagMatcher>();
        String string = null;
        boolean bl = true;
        string = this.getPreferenceStore().getString(COMPILER_TASK_TAGS);
        bl = ENABLED.equals(this.getPreferenceStore().getString(COMPILER_TASK_CASE_SENSITIVE));
        if (string != null) {
            this.fTaskTagMatcher = new TaskTagMatcher((IToken)this.getToken(TASK_TAG));
            this.fTaskTagMatcher.addTaskTags(string);
            this.fTaskTagMatcher.setCaseSensitive(bl);
            arrayList.add(this.fTaskTagMatcher);
        }
        return arrayList;
    }

    public boolean affectsTextPresentation(PropertyChangeEvent propertyChangeEvent) {
        return propertyChangeEvent.getProperty().equals(COMPILER_TASK_TAGS) || propertyChangeEvent.getProperty().equals(COMPILER_TASK_CASE_SENSITIVE) || super.affectsTextPresentation(propertyChangeEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeConfiguration(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if (COMPILER_TASK_TAGS.equals(string)) {
            Object object;
            if (this.fTaskTagMatcher != null && (object = propertyChangeEvent.getNewValue()) instanceof String) {
                TaskTagMatcher taskTagMatcher = this.fTaskTagMatcher;
                synchronized (taskTagMatcher) {
                    this.fTaskTagMatcher.clearWords();
                    this.fTaskTagMatcher.addTaskTags((String)object);
                }
            }
            return;
        }
        if (COMPILER_TASK_CASE_SENSITIVE.equals(string)) {
            Object object;
            if (this.fTaskTagMatcher != null && (object = propertyChangeEvent.getNewValue()) instanceof String) {
                this.fTaskTagMatcher.setCaseSensitive(ENABLED.equals(object));
            }
            return;
        }
        super.changeConfiguration(propertyChangeEvent);
    }

    protected String[] getTokenProperties() {
        return this.fTokenProperties;
    }

    private class TaskTagMatcher
    extends CombinedWordRule.WordMatcher {
        private IToken fToken;
        private Map fUppercaseWords = new HashMap();
        private boolean fCaseSensitive = true;
        private CombinedWordRule.CharacterBuffer fBuffer = new CombinedWordRule.CharacterBuffer(16);

        public TaskTagMatcher(IToken iToken) {
            this.fToken = iToken;
        }

        public synchronized void clearWords() {
            super.clearWords();
            this.fUppercaseWords.clear();
        }

        public synchronized void addTaskTags(String string) {
            String[] stringArray = this.split(string, ",");
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].length() <= 0) continue;
                this.addWord(stringArray[i], this.fToken);
            }
        }

        private String[] split(String string, String string2) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            int n = stringTokenizer.countTokens();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2++] = stringTokenizer.nextToken();
            }
            return stringArray;
        }

        public synchronized void addWord(String string, IToken iToken) {
            Assert.isNotNull((Object)string);
            Assert.isNotNull((Object)iToken);
            super.addWord(string, iToken);
            this.fUppercaseWords.put(new CombinedWordRule.CharacterBuffer(string.toUpperCase()), iToken);
        }

        public synchronized IToken evaluate(ICharacterScanner iCharacterScanner, CombinedWordRule.CharacterBuffer characterBuffer) {
            if (this.fCaseSensitive) {
                return super.evaluate(iCharacterScanner, characterBuffer);
            }
            this.fBuffer.clear();
            int n = characterBuffer.length();
            for (int i = 0; i < n; ++i) {
                this.fBuffer.append(Character.toUpperCase(characterBuffer.charAt(i)));
            }
            IToken iToken = (IToken)this.fUppercaseWords.get(this.fBuffer);
            if (iToken != null) {
                return iToken;
            }
            return Token.UNDEFINED;
        }

        public boolean isCaseSensitive() {
            return this.fCaseSensitive;
        }

        public void setCaseSensitive(boolean bl) {
            this.fCaseSensitive = bl;
        }
    }

    private static class AtJavaIdentifierDetector
    implements IWordDetector {
        private AtJavaIdentifierDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '@' || Character.isJavaIdentifierStart(c);
        }

        public boolean isWordPart(char c) {
            return Character.isJavaIdentifierPart(c);
        }
    }
}

