/*
 * Decompiled with CFR 0.152.
 */
package com.spket.laszlo.model;

import com.spket.buffer.IBuffer;
import com.spket.js.internal.text.JSDoc2HTMLTextReader;
import com.spket.js.model.JSDoc;
import com.spket.js.model.JSNamespace;
import com.spket.laszlo.internal.LaszloPlugin;
import com.spket.ui.text.IDocumentation;
import com.spket.ui.text.html.HTMLPrinter;
import com.spket.xml.INodeRegion;
import com.spket.xml.XMLComment;
import com.spket.xml.XMLNode;
import com.spket.xml.XMLUtils;
import java.io.CharArrayReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LzDoc
implements JSDoc,
IDocumentation {
    private static Map TYPES = new HashMap();
    private static final int F_INIT = 1;
    private static final int F_PRIVATE = 2;
    private static final int F_PROTECTED = 4;
    private static final int T_xref = 1;
    private static final int T_tagname = 2;
    private static final int T_classname = 3;
    private static final int T_example = 4;
    private static final int T_programlisting = 5;
    private static final int T_method = 6;
    private static final int T_class = 7;
    private static final int T_constant = 8;
    private static final int T_varname = 9;
    private static final int T_event = 10;
    private static final int T_END = 64;
    private static final char[] xref = "xref".toCharArray();
    private static final char[] tagname = "tagname".toCharArray();
    private static final char[] example = "example".toCharArray();
    private static final char[] classname = "classname".toCharArray();
    private static final char[] programlisting = "programlisting".toCharArray();
    private static final char[] method = "method".toCharArray();
    private static final char[] S_class = "class".toCharArray();
    private static final char[] constant = "constant".toCharArray();
    private static final char[] varname = "varname".toCharArray();
    private static final char[] event = "event".toCharArray();
    private static final char[] A_title = "title".toCharArray();
    private static final char[] A_linkend = "linkend".toCharArray();
    private int start;
    private List params;
    private String type;
    private int fStates;
    private char[] comment;
    private XMLComment xmlComment;

    public static String normalize(char[] cArray, int n, int n2) {
        if (n < n2) {
            int n3 = -1;
            char c = cArray[n];
            if (c == '[') {
                n3 = n++;
                c = cArray[n];
            }
            if (Character.isJavaIdentifierStart(c)) {
                String string;
                String string2;
                ++n;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(c);
                while (n < n2) {
                    c = cArray[n];
                    if (c == ']') {
                        if (n3 == -1) break;
                        ++n;
                        break;
                    }
                    if (!Character.isJavaIdentifierPart(c)) break;
                    ++n;
                    stringBuffer.append(c);
                }
                if ((string2 = (String)TYPES.get((string = stringBuffer.toString()).toLowerCase())) != null) {
                    string = string2;
                }
                if (n3 != -1) {
                    string = '[' + string + ']';
                }
                return string;
            }
            if (n3 != -1) {
                n = n3;
            }
        }
        return null;
    }

    public LzDoc(XMLComment xMLComment) {
        this.xmlComment = xMLComment;
    }

    public LzDoc(String string) {
        if (string != null && string.length() > 0) {
            this.comment = string.toCharArray();
        }
    }

    public LzDoc(char[] cArray, int n, int n2) {
        this.comment = new char[n2];
        System.arraycopy(cArray, n, this.comment, 0, n2);
    }

    public String getComment() {
        this.prepare();
        if (this.comment != null && this.comment.length > 0) {
            return new String(this.comment);
        }
        return null;
    }

    public String getDocument() {
        return this.getComment();
    }

    public String getDocumentAsHTML() {
        this.prepare();
        if (this.comment != null && this.comment.length > 0) {
            StringBuffer stringBuffer = new StringBuffer(this.comment.length);
            JSDoc2HTMLTextReader jSDoc2HTMLTextReader = new JSDoc2HTMLTextReader((Reader)new CharArrayReader(this.comment));
            HTMLPrinter.addParagraph((StringBuffer)stringBuffer, (Reader)jSDoc2HTMLTextReader);
            return stringBuffer.toString();
        }
        return null;
    }

    public String getStyleSheet() {
        return LaszloPlugin.getStyleSheet();
    }

    public JSDoc.Param getParameter(int n) {
        this.prepare();
        if (this.params != null && n < this.params.size()) {
            return (JSDoc.Param)this.params.get(n);
        }
        return null;
    }

    public JSDoc.Param getParameter(String string) {
        this.prepare();
        if (this.params != null) {
            for (int i = 0; i < this.params.size(); ++i) {
                JSDoc.Param param = (JSDoc.Param)this.params.get(i);
                if (!string.equals(param.name)) continue;
                return param;
            }
        }
        return null;
    }

    public String[] getTypes() {
        this.prepare();
        if (this.type == null) {
            return null;
        }
        return new String[]{this.type};
    }

    public JSNamespace getNamespace() {
        return null;
    }

    public boolean isValid() {
        return true;
    }

    public boolean hasClassTag() {
        return false;
    }

    public boolean hasPrivateTag() {
        this.prepare();
        return (this.fStates & 2) != 0;
    }

    protected void prepare() {
        INodeRegion iNodeRegion;
        if ((this.fStates & 1) != 0) {
            return;
        }
        this.fStates |= 1;
        if (this.comment == null && this.xmlComment != null && (iNodeRegion = this.xmlComment.getRegion()) != null) {
            int n = iNodeRegion.getStart();
            int n2 = iNodeRegion.getEnd();
            IBuffer iBuffer = XMLUtils.getBuffer((XMLNode)this.xmlComment);
            if (iBuffer != null) {
                String string;
                n += 4;
                if (iBuffer.get(n2 - 1) == '>') {
                    n2 -= 3;
                }
                if (n2 > n && (string = iBuffer.get(n, n2 - n)) != null && string.length() > 0) {
                    this.comment = string.toCharArray();
                }
            }
        }
        if (this.comment != null) {
            this.parseComment();
        }
    }

    protected void parseComment() {
        char c = '\u0000';
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = null;
        block13: for (int i = 0; i < this.comment.length; ++i) {
            char c2 = this.comment[i];
            switch (c2) {
                case '<': {
                    if (bl) continue block13;
                    n2 = i;
                    bl2 = true;
                    continue block13;
                }
                case '\"': 
                case '\'': {
                    if (c2 == c) {
                        c = '\u0000';
                        continue block13;
                    }
                    if (c != '\u0000' || !bl2) continue block13;
                    c = c2;
                    continue block13;
                }
                case '>': {
                    if (!bl2 || c != '\u0000') continue block13;
                    bl2 = false;
                    int n3 = this.getTag(n2, i);
                    if (n3 == 0) continue block13;
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(this.comment.length);
                    }
                    if (n2 > n) {
                        stringBuffer.append(this.comment, n, n2 - n);
                    }
                    switch (n3) {
                        case 1: {
                            String string = this.parseAttribute(n2 + 4, A_linkend);
                            if (string == null) break;
                            stringBuffer.append("<u>").append(string).append("</u>");
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: {
                            stringBuffer.append("<code>");
                            break;
                        }
                        case 66: 
                        case 67: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: {
                            stringBuffer.append("</code>");
                            break;
                        }
                        case 4: {
                            String string = this.parseAttribute(n2 + 7, A_title);
                            if (string != null) {
                                stringBuffer.append("<h5>").append(string).append("</h5>\n");
                            }
                            stringBuffer.append("<pre class='code'>");
                            break;
                        }
                        case 68: {
                            stringBuffer.append("</pre>");
                        }
                    }
                    n2 = n = i + 1;
                    continue block13;
                }
                case '@': {
                    if (this.skipTag(i)) {
                        if (i > n && !bl) {
                            if (stringBuffer == null) {
                                stringBuffer = new StringBuffer(this.comment.length);
                            }
                            stringBuffer.append(this.comment, n, i - n);
                        }
                        n2 = n = i;
                        bl = true;
                        continue block13;
                    }
                    if (!bl) continue block13;
                    bl = false;
                    n2 = n = i;
                    continue block13;
                }
            }
        }
        if (stringBuffer != null) {
            if (n < this.comment.length && !bl) {
                stringBuffer.append(this.comment, n, this.comment.length - n);
            }
            this.comment = stringBuffer.toString().toCharArray();
        }
    }

    protected boolean skipTag(int n) {
        if (++n < this.comment.length) {
            try {
                switch (this.comment[n++]) {
                    case 'a': {
                        if (this.comment[n++] == 'c' && this.comment[n++] == 'c' && this.comment[n++] == 'e' && this.comment[n++] == 's' && this.comment[n++] == 's') {
                            if (!Character.isWhitespace(this.comment[n])) break;
                            this.parseKeywords(n);
                            break;
                        }
                        if (this.comment[n] != 'u' || this.comment[n++] != 't' || this.comment[n++] != 'h' || this.comment[n++] != 'o' || this.comment[n++] != 'r' || !Character.isWhitespace(this.comment[n])) break;
                        return false;
                    }
                    case 'k': {
                        if (this.comment[n++] != 'e' || this.comment[n++] != 'y' || this.comment[n++] != 'w' || this.comment[n++] != 'o' || this.comment[n++] != 'r' || this.comment[n++] != 'd' || this.comment[n++] != 's' || !Character.isWhitespace(this.comment[n])) break;
                        this.parseKeywords(n);
                        break;
                    }
                    case 'p': {
                        if (this.comment[n++] != 'a' || this.comment[n++] != 'r' || this.comment[n++] != 'a' || this.comment[n++] != 'm' || !Character.isWhitespace(this.comment[n])) break;
                        this.parseParameter(n);
                        return false;
                    }
                    case 'r': {
                        if (this.comment[n++] != 'e' || this.comment[n++] != 't' || this.comment[n++] != 'u' || this.comment[n++] != 'r' || this.comment[n++] != 'n' || !Character.isWhitespace(this.comment[n])) break;
                        this.type = this.parseReturn(n);
                        return false;
                    }
                    case 's': {
                        if (!(this.comment[n++] == 'e' && this.comment[n++] == 'e' ? Character.isWhitespace(this.comment[n]) : this.comment[n] == 'i' && this.comment[n++] == 'n' && this.comment[n++] == 'c' && this.comment[n++] == 'e' && Character.isWhitespace(this.comment[n]))) break;
                        return false;
                    }
                    case 't': {
                        if (this.comment[n++] != 'y' || this.comment[n++] != 'p' || this.comment[n++] != 'e' || !Character.isWhitespace(this.comment[n])) break;
                        this.start = n;
                        if (!this.skipWhitespace()) {
                            this.type = this.parseType();
                        }
                        return false;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String parseAttribute(int n, char[] cArray) {
        char c = '\u0000';
        char c2 = ' ';
        char c3 = cArray[0];
        boolean bl = false;
        int n2 = this.comment.length;
        try {
            block2: while (n < n2) {
                char c4;
                if ((c4 = this.comment[n++]) == '\"' || c4 == '\'') {
                    if (c == '\u0000') {
                        c = c4;
                        this.start = n;
                    } else if (c == c4) {
                        c = '\u0000';
                        if (bl) {
                            return new String(this.comment, this.start, n - this.start - 1);
                        }
                    }
                }
                if (c != '\u0000') continue;
                if (c4 == c3) {
                    if (!Character.isWhitespace(c2)) continue;
                    bl = true;
                } else {
                    c2 = c4;
                    continue;
                }
                for (int i = 1; i < cArray.length; ++i) {
                    if (this.comment[n++] == cArray[i]) continue;
                    bl = false;
                    c2 = this.comment[--n];
                    continue block2;
                }
            }
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    protected int getTag(int n, int n2) {
        int n3 = 0;
        ++n;
        try {
            char c;
            if (this.comment[n] == '/') {
                ++n;
                n3 |= 0x40;
            }
            char[] cArray = null;
            switch (this.comment[n]) {
                case 'c': {
                    if (n + S_class.length <= n2 && ((c = this.comment[n + S_class.length]) == ' ' || c == '>' || c == '/')) {
                        cArray = S_class;
                        n3 |= 7;
                        break;
                    }
                    if (n + constant.length <= n2 && ((c = this.comment[n + constant.length]) == ' ' || c == '>' || c == '/')) {
                        cArray = constant;
                        n3 |= 8;
                        break;
                    }
                    cArray = classname;
                    n3 |= 3;
                    break;
                }
                case 'e': {
                    if (n + event.length <= n2 && ((c = this.comment[n + event.length]) == ' ' || c == '>' || c == '/')) {
                        cArray = event;
                        n3 |= 0xA;
                        break;
                    }
                    cArray = example;
                    n3 |= 4;
                    break;
                }
                case 'm': {
                    cArray = method;
                    n3 |= 6;
                    break;
                }
                case 'p': {
                    cArray = programlisting;
                    n3 |= 5;
                    break;
                }
                case 't': {
                    cArray = tagname;
                    n3 |= 2;
                    break;
                }
                case 'v': {
                    cArray = varname;
                    n3 |= 9;
                    break;
                }
                case 'x': {
                    cArray = xref;
                    n3 |= 1;
                }
            }
            if (cArray != null && n + cArray.length <= n2) {
                c = this.comment[n + cArray.length];
                if (c == ' ' || c == '>' || c == '/') {
                    for (int i = 0; i < cArray.length; ++i) {
                        if (cArray[i] == this.comment[i + n]) continue;
                        return 0;
                    }
                }
                return n3;
            }
            return 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0;
        }
    }

    protected void parseKeywords(int n) {
        char c = ' ';
        try {
            block6: while (true) {
                char c2 = this.comment[n++];
                switch (c2) {
                    case '\n': {
                        return;
                    }
                    case 'p': {
                        if (Character.isWhitespace(c) && this.comment[n] == 'r') {
                            if (this.comment[++n] == 'i' && this.comment[++n] == 'v' && this.comment[++n] == 'a' && this.comment[++n] == 't' && this.comment[++n] == 'e') {
                                this.fStates |= 2;
                                return;
                            }
                            if (this.comment[n] == 'o' && this.comment[++n] == 't' && this.comment[++n] == 'e' && this.comment[++n] == 'c' && this.comment[++n] == 't' && this.comment[++n] == 'e' && this.comment[++n] == 'd') {
                                this.fStates |= 4;
                                return;
                            }
                        }
                        c = c2;
                        continue block6;
                    }
                }
                c = c2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    protected boolean skipWhitespace() {
        int n = this.comment.length;
        while (this.start < n) {
            char c = this.comment[this.start];
            if (c == '\n' || c == '\r') {
                return true;
            }
            if (!Character.isWhitespace(c)) break;
            ++this.start;
        }
        return false;
    }

    protected String parseType() {
        int n = this.comment.length;
        if (this.start < n) {
            int n2 = -1;
            char c = this.comment[this.start];
            if (c == '[') {
                n2 = this.start++;
                c = this.comment[this.start];
            }
            if (Character.isJavaIdentifierStart(c)) {
                String string;
                String string2;
                ++this.start;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(c);
                while (this.start < n) {
                    c = this.comment[this.start];
                    if (c == ']') {
                        if (n2 == -1) break;
                        ++this.start;
                        break;
                    }
                    if (!Character.isJavaIdentifierPart(c)) break;
                    ++this.start;
                    stringBuffer.append(c);
                }
                if ((string2 = (String)TYPES.get((string = stringBuffer.toString()).toLowerCase())) != null) {
                    string = string2;
                }
                if (n2 != -1) {
                    string = '[' + string + ']';
                }
                return string;
            }
            if (n2 != -1) {
                this.start = n2;
            }
        }
        return null;
    }

    protected String parseName() {
        char c;
        int n = this.comment.length;
        if (this.start < n && Character.isJavaIdentifierStart(c = this.comment[this.start])) {
            ++this.start;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(c);
            while (this.start < n && Character.isJavaIdentifierPart(c = this.comment[this.start])) {
                ++this.start;
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    protected void parseParameter(int n) {
        String string;
        this.start = n;
        if (!this.skipWhitespace() && (string = this.parseType()) != null) {
            String string2;
            boolean bl = false;
            if (this.comment[this.start] == '.' && this.comment[this.start + 1] == '.' && this.comment[this.start + 2] == '.') {
                this.start += 3;
                bl = true;
            }
            if (Character.isWhitespace(this.comment[this.start]) && !this.skipWhitespace() && (string2 = this.parseName()) != null) {
                char c = this.comment[this.start];
                if (Character.isWhitespace(c) && !this.skipWhitespace()) {
                    c = this.comment[this.start];
                }
                if (c == ':') {
                    JSDoc.Param param = new JSDoc.Param();
                    param.name = string2;
                    if (bl) {
                        param.optional = true;
                    }
                    if (this.params == null) {
                        this.params = new ArrayList(4);
                    }
                    this.params.add(param);
                }
            }
        }
    }

    protected String parseReturn(int n) {
        String string;
        this.start = n;
        if (!this.skipWhitespace() && (string = this.parseType()) != null) {
            int n2 = this.comment.length;
            while (this.start < n2) {
                char c = this.comment[this.start++];
                switch (c) {
                    case ':': {
                        return string;
                    }
                    case '\n': 
                    case '\r': {
                        return null;
                    }
                }
                if (Character.isWhitespace(c)) continue;
                return null;
            }
        }
        return null;
    }

    static {
        TYPES.put("bool", "Boolean");
        TYPES.put("boolean", "Boolean");
        TYPES.put("int", "Number");
        TYPES.put("integer", "Number");
        TYPES.put("long", "Number");
        TYPES.put("float", "Number");
        TYPES.put("double", "Number");
        TYPES.put("number", "Number");
        TYPES.put("string", "String");
        TYPES.put("object", "Object");
        TYPES.put("array", "Array");
        TYPES.put("function", "Function");
        TYPES.put("any", "Object");
    }
}

