/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xml.text;

import com.spket.buffer.CharBuffer;
import com.spket.buffer.IBuffer;
import com.spket.ui.tasks.AbstractTaskScanner;
import com.spket.ui.tasks.Options;
import com.spket.ui.tasks.Task;
import com.spket.util.StringUtils;
import com.spket.xml.INodeRegion;
import com.spket.xml.XMLComment;
import com.spket.xml.XMLDocument;
import com.spket.xml.XMLElement;
import com.spket.xml.XMLModelParser;
import com.spket.xml.XMLNode;
import com.spket.xml.grammars.GrammarManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class XMLTaskScanner
extends AbstractTaskScanner {
    private static final int MIN = 16;
    private static final int COLUMNS = 60;
    private static final int[] NO_LINES = new int[0];

    public Task[] scan(IFile iFile, Options options) throws CoreException {
        char[] cArray = this.getResourceContentsAsCharArray(iFile);
        if (cArray == null || cArray.length == 0) {
            return null;
        }
        CharBuffer charBuffer = new CharBuffer(iFile.getLocation(), cArray);
        XMLModelParser xMLModelParser = new XMLModelParser(GrammarManager.getSymbolTable());
        xMLModelParser.parse((IBuffer)charBuffer);
        XMLDocument xMLDocument = xMLModelParser.getDocument();
        if (xMLDocument != null) {
            ArrayList arrayList = new ArrayList();
            this.visit(xMLDocument, arrayList, cArray, options);
            if (arrayList.size() > 0) {
                int[] nArray = null;
                Task[] taskArray = new Task[arrayList.size()];
                arrayList.toArray(taskArray);
                for (int i = 0; i < taskArray.length; ++i) {
                    Task task = taskArray[i];
                    if (task.getSourceLineNumber() != -1) continue;
                    if (nArray == null) {
                        nArray = this.getLineEnds(cArray);
                    }
                    task.setLineNumber(XMLTaskScanner.getLineNumber((int)task.getSourceStart(), (int[])nArray, (int)0, (int)(nArray.length - 1)));
                }
                return taskArray;
            }
        }
        return null;
    }

    protected void visit(XMLNode xMLNode, List list, char[] cArray, Options options) {
        int n = xMLNode.getChildrenCount();
        if (n > 0) {
            XMLNode[] xMLNodeArray = xMLNode.getChildren();
            block4: for (int i = 0; i < n; ++i) {
                XMLNode xMLNode2 = xMLNodeArray[i];
                switch (xMLNode2.getNodeType()) {
                    case 5: {
                        this.scan((XMLComment)xMLNode2, list, cArray, options);
                        continue block4;
                    }
                    case 1: {
                        if (!this.visit((XMLElement)xMLNode2, list, cArray, options)) continue block4;
                        this.visit(xMLNode2, list, cArray, options);
                    }
                }
            }
        }
    }

    protected void scan(XMLComment xMLComment, List list, char[] cArray, Options options) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        INodeRegion iNodeRegion = xMLComment.getRegion();
        if (iNodeRegion == null) {
            return;
        }
        int n7 = iNodeRegion.getStart() + 4;
        int n8 = iNodeRegion.getEnd();
        if (n8 > cArray.length) {
            n8 = cArray.length;
        }
        if (cArray[n8 - 1] == '>') {
            --n8;
        }
        if (cArray[n8 - 1] == '-') {
            --n8;
        }
        if (cArray[n8 - 1] == '-') {
            --n8;
        }
        if (n7 >= n8) {
            return;
        }
        int n9 = 0;
        Object object = null;
        Object object2 = null;
        Object object3 = null;
        Object object4 = null;
        char[][] cArray2 = options.taskTags;
        char[][] cArray3 = options.taskPriorities;
        boolean bl = options.isTaskCaseSensitive;
        char c = cArray[n7];
        for (n6 = n7 + 1; n6 < n8; ++n6) {
            char[] cArray4 = null;
            char[] cArray5 = null;
            if (c != '@') {
                block1: for (n5 = 0; n5 < cArray2.length; ++n5) {
                    cArray4 = cArray2[n5];
                    n4 = cArray4.length;
                    if (n4 == 0 || Character.isJavaIdentifierStart(cArray4[0]) && Character.isJavaIdentifierPart(c)) continue;
                    for (n3 = 0; n3 < n4; ++n3) {
                        char c2;
                        int n10 = n6 + n3;
                        if (n10 >= n8 || (n2 = cArray[n6 + n3]) != (c2 = cArray4[n3]) && (bl || Character.toLowerCase((char)n2) != Character.toLowerCase(c2))) continue block1;
                    }
                    if (n6 + n4 < n8 && Character.isJavaIdentifierPart(cArray[n6 + n4 - 1]) && Character.isJavaIdentifierPart(cArray[n6 + n4])) continue;
                    if (object == null) {
                        object = new char[5][];
                        object2 = new char[5][];
                        object3 = new char[5][];
                        object4 = new int[5][];
                    } else if (n9 == ((char[][])object).length) {
                        Object object5 = object;
                        char[][] cArrayArray = new char[n9 * 2][];
                        object = cArrayArray;
                        System.arraycopy(object5, 0, cArrayArray, 0, n9);
                        Object object6 = object2;
                        char[][] cArrayArray2 = new char[n9 * 2][];
                        object2 = cArrayArray2;
                        System.arraycopy(object6, 0, cArrayArray2, 0, n9);
                        Object object7 = object3;
                        char[][] cArrayArray3 = new char[n9 * 2][];
                        object3 = cArrayArray3;
                        System.arraycopy(object7, 0, cArrayArray3, 0, n9);
                        Object object8 = object4;
                        int[][] nArrayArray = new int[n9 * 2][];
                        object4 = nArrayArray;
                        System.arraycopy(object8, 0, nArrayArray, 0, n9);
                    }
                    cArray5 = cArray3 != null && n5 < cArray3.length ? cArray3[n5] : null;
                    object[n9] = cArray4;
                    object3[n9] = cArray5;
                    object4[n9] = new int[]{n6, n6 + n4 - 1};
                    object2[n9] = StringUtils.EMPTY_CHARS;
                    ++n9;
                    n6 += n4 - 1;
                    break;
                }
            }
            c = cArray[n6];
        }
        n6 = 0;
        for (n = 0; n < n9; ++n) {
            int n11 = object4[n][0] + object[n].length;
            int n12 = n5 = n + 1 < n9 ? object4[n + 1][0] - 1 : n8 - 1;
            if (n5 < n11) {
                n5 = n11;
            }
            n4 = -1;
            for (n2 = n11; n2 < n5; ++n2) {
                n3 = cArray[n2];
                if (n3 != 10 && n3 != 13) continue;
                n4 = n2 - 1;
                break;
            }
            if (n4 == -1) {
                for (n2 = n5; n2 > n11; --n2) {
                    n3 = cArray[n2];
                    if (n3 != 42) continue;
                    n4 = n2 - 1;
                    break;
                }
                if (n4 == -1) {
                    n4 = n5;
                }
            }
            if (n11 == n4) {
                n6 = 1;
                continue;
            }
            while (Character.isWhitespace(cArray[n4]) && n11 <= n4) {
                --n4;
            }
            while (Character.isWhitespace(cArray[n11]) && n11 <= n4) {
                ++n11;
            }
            object4[n][1] = n4;
            n2 = n4 - n11 + 1;
            char[] cArray6 = new char[n2];
            System.arraycopy(cArray, n11, cArray6, 0, n2);
            object2[n] = cArray6;
        }
        if (n6 != 0) {
            int n13 = n9;
            block8: for (n = 0; n < n13; ++n) {
                if (object2[n].length != 0) continue;
                for (n5 = n + 1; n5 < n13; ++n5) {
                    if (object2[n5].length == 0) continue;
                    object2[n] = object2[n5];
                    object4[n][1] = object4[n5][1];
                    continue block8;
                }
            }
        }
        for (n = 0; n < n9; ++n) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(object[n]);
            char[] cArray7 = object2[n];
            if (cArray7 != null && cArray7.length > 0) {
                stringBuffer.append(' ').append(cArray7);
            }
            n4 = object4[n][0];
            list.add(new Task(0, stringBuffer.toString(), XMLTaskScanner.getPriority((char[])object3[n]), -1, n4, object4[n][1]));
        }
    }

    protected boolean visit(XMLElement xMLElement, List list, char[] cArray, Options options) {
        return xMLElement.getChildrenCount() > 0;
    }

    protected int[] getLineEnds(char[] cArray) {
        int n = cArray.length;
        int n2 = n / 60;
        int[] nArray = new int[n2 < 16 ? 16 : n2];
        n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            switch (cArray[n3++]) {
                case '\r': {
                    if (n3 < n && cArray[n3] == '\n') {
                        ++n3;
                    }
                }
                case '\n': {
                    if (n2 == nArray.length) {
                        int n4 = (cArray.length - n3) / 60;
                        int[] nArray2 = new int[n2 + (n4 < 16 ? 16 : n4)];
                        System.arraycopy(nArray, 0, nArray2, 0, n2);
                        nArray = nArray2;
                    }
                    nArray[n2++] = n3 - 1;
                }
            }
        }
        if (n2 == 0) {
            return NO_LINES;
        }
        if (n2 < nArray.length) {
            int[] nArray3 = new int[n2];
            System.arraycopy(nArray, 0, nArray3, 0, n2);
            return nArray3;
        }
        return nArray;
    }
}

