/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xml.internal.text;

import com.spket.ui.text.ProblemAnnotation;
import com.spket.ui.text.html.HTMLPrinter;
import com.spket.ui.text.html.HTMLTextPresenter;
import com.spket.util.Debug;
import com.spket.util.StringUtils;
import java.util.Iterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;

public class XMLTextHover
implements ITextHover,
ITextHoverExtension {
    public String getHoverInfo(ITextViewer iTextViewer, IRegion iRegion) {
        if (!(iTextViewer instanceof ISourceViewer)) {
            return null;
        }
        ISourceViewer iSourceViewer = (ISourceViewer)iTextViewer;
        IAnnotationModel iAnnotationModel = iSourceViewer.getAnnotationModel();
        if (iAnnotationModel != null) {
            Iterator iterator = iAnnotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                String string;
                Position position;
                Annotation annotation = (Annotation)iterator.next();
                if (!(annotation instanceof ProblemAnnotation) || !(position = iAnnotationModel.getPosition(annotation)).overlapsWith(iRegion.getOffset(), iRegion.getLength()) || StringUtils.isEmpty((String)(string = annotation.getText()))) continue;
                return this.formatMessage(string);
            }
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer iTextViewer, int n) {
        if (iTextViewer != null) {
            return XMLTextHover.getRegion(iTextViewer, n);
        }
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new DefaultInformationControl(shell, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
            }
        };
    }

    private String formatMessage(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        HTMLPrinter.addPageProlog((StringBuffer)stringBuffer);
        HTMLPrinter.addParagraph((StringBuffer)stringBuffer, (String)HTMLPrinter.convertToHTMLContent((String)string));
        HTMLPrinter.addPageEpilog((StringBuffer)stringBuffer);
        return stringBuffer.toString();
    }

    public static IRegion getRegion(ITextViewer iTextViewer, int n) {
        IDocument iDocument = iTextViewer.getDocument();
        int n2 = -1;
        int n3 = -1;
        try {
            char c;
            int n4;
            for (n4 = n; n4 >= 0 && ((c = iDocument.getChar(n4)) == '.' || c == '-' || c == '/' || c == '\\' || Character.isJavaIdentifierPart(c)); --n4) {
            }
            n2 = n4;
            int n5 = iDocument.getLength();
            for (n4 = n; n4 < n5 && ((c = iDocument.getChar(n4)) == '.' || c == '-' || Character.isJavaIdentifierPart(c)); ++n4) {
            }
            n3 = n4;
        }
        catch (BadLocationException badLocationException) {
            Debug.debug((Throwable)badLocationException);
        }
        if (n2 > -1 && n3 > -1) {
            if (n2 == n && n3 == n) {
                return new Region(n, 0);
            }
            if (n2 == n) {
                return new Region(n2, n3 - n2);
            }
            return new Region(n2 + 1, n3 - n2 - 1);
        }
        return null;
    }
}

