/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xml.editors;

import com.spket.buffer.IBuffer;
import com.spket.xml.INodeRegion;
import com.spket.xml.XMLAttr;
import com.spket.xml.XMLDocument;
import com.spket.xml.XMLElement;
import com.spket.xml.XMLModel;
import com.spket.xml.XMLNode;
import com.spket.xml.internal.XMLImages;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class XMLLabelProvider
extends LabelProvider {
    private static final int MAX_LENGTH = 32;
    private static final String L_DOCTYPE = "DOCTYPE";
    protected static Image imgTag = XMLImages.get("_mime.tag.gif");
    protected static Image imgEmptyTag = XMLImages.get("_mime.emptytag.gif");
    protected static Image imgCdata = XMLImages.get("_mime.cdata.gif");
    protected static Image imgComment = XMLImages.get("_mime.comment.gif");
    protected static Image imgPI = XMLImages.get("_mime.proc_instr.gif");
    protected static Image imgDoctype = XMLImages.get("_mime.doctype.gif");
    private XMLModel fModel;
    private boolean fShowAttribute;

    public XMLLabelProvider(XMLModel xMLModel) {
        this.fModel = xMLModel;
    }

    public boolean isShowAttribute() {
        return this.fShowAttribute;
    }

    public void setShowAttribute(boolean bl) {
        this.fShowAttribute = bl;
    }

    public Image getImage(Object object) {
        Image image = null;
        if (this.fModel != null) {
            image = this.fModel.getImage(object);
        }
        if (image == null) {
            if (object instanceof XMLDocument) {
                image = imgTag;
            } else if (object instanceof XMLNode) {
                XMLNode xMLNode = (XMLNode)object;
                switch (xMLNode.getNodeType()) {
                    case 1: {
                        XMLElement xMLElement = (XMLElement)object;
                        if (xMLElement.isEmptyTag()) {
                            image = imgEmptyTag;
                            break;
                        }
                        image = imgTag;
                        break;
                    }
                    case 5: {
                        image = imgComment;
                        break;
                    }
                    case 4: {
                        image = imgCdata;
                        break;
                    }
                    case 7: {
                        image = imgPI;
                        break;
                    }
                    case 6: {
                        image = imgDoctype;
                    }
                }
            }
        }
        return image;
    }

    public String getText(Object object) {
        String string = null;
        if (object instanceof XMLNode) {
            XMLNode xMLNode = (XMLNode)object;
            string = xMLNode.getName();
            switch (xMLNode.getNodeType()) {
                case 0: {
                    if (this.fModel == null) break;
                    IPath iPath = this.fModel.getPath();
                    if (iPath == null) {
                        string = xMLNode.getName();
                        break;
                    }
                    string = iPath.lastSegment();
                    break;
                }
                case 6: {
                    if (string == null || string.length() == 0) {
                        string = L_DOCTYPE;
                        break;
                    }
                    string = "DOCTYPE:" + string;
                    break;
                }
                case 1: {
                    INodeRegion iNodeRegion;
                    CharSequence charSequence;
                    XMLAttr xMLAttr;
                    XMLElement xMLElement;
                    int n;
                    if (!this.fShowAttribute || string == null || string.length() <= 0 || (n = (xMLElement = (XMLElement)xMLNode).getAttrCount()) <= 0) break;
                    int n2 = 0;
                    XMLAttr[] xMLAttrArray = xMLElement.getAttrs();
                    for (int i = 0; i < n; ++i) {
                        xMLAttr = xMLAttrArray[i];
                        charSequence = xMLAttr.getName();
                        if ("id".equals(charSequence)) {
                            n2 = i;
                            break;
                        }
                        if (!"name".equals(charSequence)) continue;
                        n2 = i;
                    }
                    if ((iNodeRegion = (xMLAttr = xMLAttrArray[n2]).getValueRegion()) == null || iNodeRegion.getLength() <= 2) break;
                    charSequence = new StringBuffer(string.length() + 2 + Math.min(32, iNodeRegion.getLength()));
                    ((StringBuffer)charSequence).append(string).append(' ');
                    this.append((StringBuffer)charSequence, xMLElement.getStartTagRegion().getStart(), iNodeRegion);
                    string = ((StringBuffer)charSequence).toString();
                }
            }
        }
        return string == null ? "" : string;
    }

    protected void append(StringBuffer stringBuffer, int n, INodeRegion iNodeRegion) {
        IBuffer iBuffer = this.fModel.getBuffer();
        if (iBuffer != null) {
            int n2 = iNodeRegion.getLength() - 1;
            int n3 = n + iNodeRegion.getStart();
            if (iBuffer.get(n3) == iBuffer.get(n3 + n2)) {
                --n2;
            }
            ++n3;
            if (n2 > 0) {
                stringBuffer.append(iBuffer.get(n3, n2 < 32 ? n2 : 32));
                if (n2 > 32) {
                    stringBuffer.append("...");
                }
            }
        }
    }
}

