/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xml;

import com.spket.buffer.IBuffer;
import com.spket.util.StringUtils;
import com.spket.xml.ParentNode;
import com.spket.xml.XMLDocType;
import com.spket.xml.XMLElement;
import com.spket.xml.XMLNode;

public class XMLDocument
extends ParentNode {
    protected String fEncoding;
    protected String fVersion;
    protected IBuffer fBuffer;

    public String getName() {
        return "#document";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.fBuffer != null && object instanceof XMLDocument) {
            XMLDocument xMLDocument = (XMLDocument)object;
            return this.fBuffer == xMLDocument.fBuffer;
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public int contains(int n) {
        return 0;
    }

    public XMLElement getDocumentElement() {
        for (int i = 0; i < this.fChildrenCount; ++i) {
            if (this.fChildren[i].getNodeType() != 1) continue;
            return (XMLElement)this.fChildren[i];
        }
        return null;
    }

    public XMLDocType getDoctype() {
        for (int i = 0; i < this.fChildrenCount; ++i) {
            if (this.fChildren[i].getNodeType() != 6) continue;
            return (XMLDocType)this.fChildren[i];
        }
        return null;
    }

    public short getNodeType() {
        return 0;
    }

    public String getEncoding() {
        return this.fEncoding;
    }

    protected void setEncoding(String string) {
        this.fEncoding = string;
    }

    public String getVersion() {
        return this.fVersion;
    }

    protected void setVersion(String string) {
        this.fVersion = string;
    }

    public IBuffer getBuffer() {
        return this.fBuffer;
    }

    public void setBuffer(IBuffer iBuffer) {
        this.fBuffer = iBuffer;
    }

    public XMLDocument getDocument() {
        return this;
    }

    public static String getCharValue(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 0) {
            return null;
        }
        if (string.charAt(0) == '#') {
            if (n == 1) {
                return null;
            }
            int n2 = 10;
            String string2 = null;
            if (string.charAt(1) == 'x') {
                n2 = 16;
                string2 = string.substring(2);
            } else {
                string2 = string.substring(1);
            }
            if (string2 == null || string2.length() == 0) {
                return null;
            }
            if (string2.charAt(0) == '-') {
                return null;
            }
            char c = '\u0000';
            try {
                c = (char)Integer.parseInt(string2, n2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (c == '\u0000') {
                return null;
            }
            return String.valueOf(c);
        }
        if ("lt".equals(string)) {
            return "<";
        }
        if ("gt".equals(string)) {
            return ">";
        }
        if ("quot".equals(string)) {
            return "\"";
        }
        if ("apos".equals(string)) {
            return "'";
        }
        if ("amp".equals(string)) {
            return "&";
        }
        return null;
    }

    public XMLNode getParent() {
        return null;
    }

    protected boolean isSame(XMLNode xMLNode) {
        if (this.getNodeType() != xMLNode.getNodeType()) {
            return false;
        }
        if (this.getChildrenCount() != xMLNode.getChildrenCount()) {
            return false;
        }
        XMLDocument xMLDocument = (XMLDocument)xMLNode;
        if (!StringUtils.equals((Object)this.getVersion(), (Object)xMLDocument.getVersion())) {
            return false;
        }
        if (!StringUtils.equals((Object)this.getEncoding(), (Object)xMLDocument.getEncoding())) {
            return false;
        }
        if (this.fChildrenCount > 0) {
            XMLNode[] xMLNodeArray = xMLDocument.getChildren();
            for (int i = 0; i < this.fChildrenCount; ++i) {
                if (this.fChildren[i].isSame(xMLNodeArray[i])) continue;
                return false;
            }
        }
        return true;
    }
}

