/*
 * Decompiled with CFR 0.152.
 */
package com.spket.widget;

import com.spket.widget.CItem;
import com.spket.widget.CPicker;
import com.spket.widget.Dialog;
import com.spket.widget.Messages;
import com.spket.widget.SymbolDialog;
import com.spket.widget.SymbolList;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.CPopup;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;

public class SymbolPicker
extends CPicker {
    private static final int SYMBOL_COUNT = 32;
    private Font font;
    private SymbolList list;
    private SymbolList.Symbol symbol;
    private List fSymbols = new ArrayList(32);

    public SymbolPicker(Composite composite, int n) {
        super(composite, n);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.createFont();
    }

    public boolean setSymbol(SymbolList.Symbol symbol) {
        if (this.symbol == symbol) {
            return false;
        }
        if (this.symbol == null || !this.symbol.equals(symbol)) {
            this.symbol = symbol;
            this.createFont();
            this.redraw();
            return true;
        }
        return false;
    }

    protected CPopup createPopup(Composite composite, int n) {
        int n2;
        this.list = new SymbolList(composite, n);
        this.list.ensureCapacity(256);
        this.list.setColumnCount(16);
        for (n2 = 161; n2 <= 191; n2 = (int)((char)(n2 + 1))) {
            this.list.addItem(null, (char)n2);
        }
        this.list.addSeparator();
        for (n2 = 913; n2 <= 937; n2 = (char)(n2 + 1)) {
            if (n2 == 930) continue;
            this.list.addItem(null, (char)n2);
        }
        for (n2 = 945; n2 <= 969; n2 = (char)(n2 + '\u0001')) {
            this.list.addItem(null, (char)n2);
        }
        if (this.fSymbols.size() > 0) {
            this.list.addSeparator();
            for (n2 = 0; n2 < this.fSymbols.size(); ++n2) {
                this.list.addItem((SymbolList.Symbol)this.fSymbols.get(n2));
            }
        }
        this.list.addSeparator();
        this.list.addCustomItem(Messages.getString("symbol.custom.text"));
        this.list.setSelection(this.symbol);
        return this.list;
    }

    protected void onDispose() {
        if (this.font != null) {
            this.font.dispose();
            this.font = null;
        }
        super.onDispose();
    }

    protected void createFont() {
        if (this.font != null) {
            this.font.dispose();
            this.font = null;
        }
        if (this.symbol != null && this.symbol.getFontName() != null) {
            FontData[] fontDataArray;
            int n = 9;
            Font font = this.getFont();
            if (font != null && (fontDataArray = font.getFontData()) != null && fontDataArray.length > 0 && fontDataArray[0] != null) {
                n = fontDataArray[0].getHeight();
            }
            this.font = new Font((Device)this.getDisplay(), this.symbol.getFontName(), n, 0);
        }
    }

    protected void paintContent(GC gC, int n, int n2, int n3, int n4) {
        if (this.symbol == null) {
            int n5 = this.getItemSize();
            if (n5 > n3) {
                n5 = n3;
            } else {
                n += (n3 - n5) / 2;
            }
            gC.setForeground(this.getDisplay().getSystemColor(17));
            gC.drawRectangle(n, n2, n5, n4 - 1);
        } else {
            Font font = null;
            if (this.font != null) {
                font = gC.getFont();
                gC.setFont(this.font);
            }
            String string = String.valueOf(this.symbol.getValue());
            Point point = gC.stringExtent(string);
            if (point.x < n3) {
                n += (n3 - point.x) / 2;
            }
            if (point.y < n4) {
                n2 += (n4 - point.y) / 2;
            }
            gC.setForeground(this.getForeground());
            gC.drawString(string, n, n2, true);
            if (font != null) {
                gC.setFont(font);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onSelectionChanged() {
        if (this.list != null) {
            SymbolList.Symbol symbol;
            CItem cItem = this.list.getSelection();
            if (!this.list.isDisposed()) {
                this.list.dispose();
            }
            this.list = null;
            if (cItem != null && (symbol = (SymbolList.Symbol)cItem.getData()) != null) {
                Object object;
                Object object2;
                if (symbol == SymbolList.CUSTOM_ITEM) {
                    object2 = this.getShell();
                    object2.setCursor(this.getDisplay().getSystemCursor(1));
                    try {
                        object = new SymbolDialog((Shell)object2);
                        ((Dialog)object).create();
                    }
                    finally {
                        object2.setCursor(null);
                    }
                    if (((Dialog)object).open() == 1) {
                        return;
                    }
                    symbol = ((SymbolDialog)object).getSymbol();
                    if (symbol != null && !this.fSymbols.contains(symbol)) {
                        if (this.fSymbols.size() > 32) {
                            this.fSymbols.remove(0);
                        }
                        this.fSymbols.add(symbol);
                    }
                }
                object2 = this.symbol;
                if (this.setSymbol(symbol)) {
                    object = new Event();
                    ((Event)object).data = object2;
                    this.notifyListeners(24, (Event)object);
                }
            }
        }
    }
}

