/*
 * Decompiled with CFR 0.152.
 */
package com.spket.widget;

import com.spket.widget.UIUtils;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class SourceDragTracker {
    private Rectangle fLineBounds = new Rectangle(0, 0, 0, 0);
    private StyledText fStyleText;
    private Rectangle fBounds;
    private int detail;
    private int dx;
    private int dy;
    private int lineHeight;
    private int lineCount;
    private int currentLine;
    private int px;
    private int py;
    private Listener listener = new Listener(){

        public void handleEvent(Event event) {
            switch (event.type) {
                case 9: {
                    SourceDragTracker.this.onPaint(event);
                }
            }
        }
    };
    private DropTargetListener dropListener = new DropTargetListener(){

        public void dragEnter(DropTargetEvent dropTargetEvent) {
            SourceDragTracker.this.onDragEnter(dropTargetEvent);
        }

        public void dragLeave(DropTargetEvent dropTargetEvent) {
            SourceDragTracker.this.onDragLeave(dropTargetEvent);
        }

        public void dragOperationChanged(DropTargetEvent dropTargetEvent) {
            SourceDragTracker.this.onDragOperationChanged(dropTargetEvent);
        }

        public void dragOver(DropTargetEvent dropTargetEvent) {
            SourceDragTracker.this.onDragOver(dropTargetEvent);
        }

        public void drop(DropTargetEvent dropTargetEvent) {
            SourceDragTracker.this.onDrop(dropTargetEvent);
        }

        public void dropAccept(DropTargetEvent dropTargetEvent) {
            SourceDragTracker.this.onDropAccept(dropTargetEvent);
        }
    };

    public void install(StyledText styledText, DropTarget dropTarget) {
        this.uninstall();
        this.fStyleText = styledText;
        dropTarget.addDropListener(this.dropListener);
        styledText.addListener(9, this.listener);
    }

    public void uninstall() {
        if (this.fStyleText != null) {
            if (!this.fStyleText.isDisposed()) {
                this.fStyleText.removeListener(9, this.listener);
                this.drawFeedback(-1, -1);
            }
            this.fStyleText = null;
        }
    }

    public int getInsertOffset(int n, int n2) {
        int n3 = -1;
        if (UIUtils.okToUse((Widget)this.fStyleText) && this.fBounds.contains(n += this.dx, n2 += this.dy)) {
            int n4 = this.fLineBounds.y + this.fLineBounds.height;
            int n5 = this.fLineBounds.x + this.fLineBounds.width;
            if (n2 >= n4 && this.currentLine == this.lineCount - 1) {
                n2 = this.fLineBounds.y;
            }
            if (n2 >= this.fLineBounds.y && n2 < n4) {
                if (n >= this.fLineBounds.x && n < n5) {
                    n3 = this.fStyleText.getOffsetAtLocation(new Point(n, n2));
                } else {
                    n3 = this.fStyleText.getOffsetAtLine(this.currentLine);
                    String string = this.fStyleText.getContent().getLine(this.currentLine);
                    if (string != null) {
                        n3 += string.length();
                    }
                }
            } else {
                this.currentLine = (n2 + this.fStyleText.getTopPixel()) / this.lineHeight;
                if (this.currentLine > this.lineCount - 1) {
                    this.currentLine = this.lineCount - 1;
                }
                n3 = this.fStyleText.getOffsetAtLine(this.currentLine);
            }
        }
        return n3;
    }

    protected void onDragEnter(DropTargetEvent dropTargetEvent) {
        if (!UIUtils.okToUse((Widget)this.fStyleText)) {
            return;
        }
        this.resetBounds();
        this.lineHeight = this.fStyleText.getLineHeight();
        this.lineCount = this.fStyleText.getLineCount();
        this.detail = dropTargetEvent.detail;
        if (this.detail != 4) {
            dropTargetEvent.detail = this.detail = 1;
        }
    }

    protected void onDragOperationChanged(DropTargetEvent dropTargetEvent) {
        if (!UIUtils.okToUse((Widget)this.fStyleText)) {
            return;
        }
        this.detail = dropTargetEvent.detail;
        if (this.detail != 4) {
            dropTargetEvent.detail = this.detail = 1;
        }
    }

    protected void onDragOver(DropTargetEvent dropTargetEvent) {
        if (!UIUtils.okToUse((Widget)this.fStyleText)) {
            return;
        }
        int n = dropTargetEvent.x + this.dx;
        int n2 = dropTargetEvent.y + this.dy;
        if (this.fBounds.contains(n, n2)) {
            int n3 = this.fLineBounds.y + this.fLineBounds.height;
            int n4 = this.fLineBounds.x + this.fLineBounds.width;
            if (n2 >= n3 && this.currentLine == this.lineCount - 1) {
                n2 = this.fLineBounds.y;
            }
            if (n2 >= this.fLineBounds.y && n2 < n3) {
                if (n >= this.fLineBounds.x && n < n4) {
                    Point point = new Point(n, n2);
                    int n5 = this.fStyleText.getOffsetAtLocation(point);
                    point = this.fStyleText.getLocationAtOffset(n5);
                    this.drawFeedback(point.x, point.y);
                } else {
                    this.drawFeedback(n4, this.fLineBounds.y);
                }
            } else {
                int n6;
                this.currentLine = (n2 + this.fStyleText.getTopPixel()) / this.lineHeight;
                if (this.currentLine > this.lineCount - 1) {
                    this.currentLine = this.lineCount - 1;
                }
                int n7 = n6 = this.fStyleText.getOffsetAtLine(this.currentLine);
                String string = this.fStyleText.getContent().getLine(this.currentLine);
                if (string != null) {
                    n7 += string.length();
                }
                Point point = this.fStyleText.getLocationAtOffset(n6);
                Point point2 = this.fStyleText.getLocationAtOffset(n7);
                this.fLineBounds.x = point.x;
                this.fLineBounds.y = point.y;
                this.fLineBounds.width = point2.x - point.x;
                this.fLineBounds.height = this.lineHeight;
                this.drawFeedback(-1, -1);
            }
            dropTargetEvent.detail = this.detail;
        } else {
            dropTargetEvent.detail = 0;
            this.drawFeedback(-1, -1);
        }
    }

    protected void onDragLeave(DropTargetEvent dropTargetEvent) {
        this.drawFeedback(-1, -1);
    }

    protected void onDropAccept(DropTargetEvent dropTargetEvent) {
    }

    protected void onDrop(DropTargetEvent dropTargetEvent) {
        dropTargetEvent.detail = 0;
        this.drawFeedback(-1, -1);
    }

    protected void onPaint(Event event) {
    }

    protected void resetBounds() {
        this.fBounds = this.fStyleText.getClientArea();
        Point point = this.fStyleText.toControl(0, 0);
        this.dx = point.x;
        this.dy = point.y;
        this.px = -1;
        this.py = -1;
    }

    protected void drawFeedback(int n, int n2) {
        if (!UIUtils.okToUse((Widget)this.fStyleText)) {
            return;
        }
        if (this.px != n || this.py != n2) {
            int n3 = this.px;
            int n4 = this.py;
            this.px = n;
            this.py = n2;
            if (n3 >= 0 && n4 >= 0) {
                this.fStyleText.redraw(n3, n4, 4, this.lineHeight, false);
            }
            if (this.px >= 0 && this.py >= 0) {
                this.fStyleText.redraw(this.px, this.py, 4, this.lineHeight, false);
            }
            this.fStyleText.update();
        }
    }
}

