/*
 * Decompiled with CFR 0.152.
 */
package com.spket.widget;

import com.spket.widget.Messages;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public abstract class Dialog {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    public static final int BUTTON_WIDTH = 61;
    private static final int HORIZONTAL_DIALOG_UNIT_PER_CHAR = 4;
    private Shell parentShell;
    private FontMetrics fontMetrics;
    private Shell shell;
    private int returnCode = 0;

    protected static Point centerPoint(Rectangle rectangle) {
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
    }

    protected static int distanceSquared(Point point, Point point2) {
        int n = point.x - point2.x;
        int n2 = point.y - point2.y;
        return n * n + n2 * n2;
    }

    protected static Monitor getClosestMonitor(Display display, Point point) {
        int n = Integer.MAX_VALUE;
        Monitor[] monitorArray = display.getMonitors();
        Monitor monitor = monitorArray[0];
        for (int i = 0; i < monitorArray.length; ++i) {
            Monitor monitor2 = monitorArray[i];
            Rectangle rectangle = monitor2.getClientArea();
            if (rectangle.contains(point)) {
                return monitor2;
            }
            int n2 = Dialog.distanceSquared(Dialog.centerPoint(rectangle), point);
            if (n2 >= n) continue;
            n = n2;
            monitor = monitor2;
        }
        return monitor;
    }

    public static int convertHorizontalDLUsToPixels(FontMetrics fontMetrics, int n) {
        return (fontMetrics.getAverageCharWidth() * n + 2) / 4;
    }

    public Dialog(Shell shell) {
        this.parentShell = shell;
    }

    public Shell getShell() {
        return this.shell;
    }

    public void create() {
        this.shell = new Shell(this.parentShell, 67680);
        this.configureShell(this.shell);
        this.createContents((Composite)this.shell);
        this.initializeBounds();
    }

    public boolean close() {
        if (this.shell == null || this.shell.isDisposed()) {
            return true;
        }
        this.shell.dispose();
        this.shell = null;
        return true;
    }

    public int open() {
        if (this.shell == null || this.shell.isDisposed()) {
            this.shell = null;
            this.create();
        }
        this.constrainShellSize();
        this.shell.open();
        this.runEventLoop(this.shell);
        return this.returnCode;
    }

    protected void initializeBounds() {
        Point point = this.getInitialSize();
        Point point2 = this.getInitialLocation(point);
        this.shell.setBounds(this.getConstrainedShellBounds(new Rectangle(point2.x, point2.y, point.x, point.y)));
    }

    protected Point getInitialSize() {
        return this.shell.computeSize(-1, -1, true);
    }

    protected Point getInitialLocation(Point point) {
        Composite composite = this.shell.getParent();
        Monitor monitor = this.shell.getDisplay().getPrimaryMonitor();
        if (composite != null) {
            monitor = composite.getMonitor();
        }
        Rectangle rectangle = monitor.getClientArea();
        Point point2 = composite != null ? Dialog.centerPoint(composite.getBounds()) : Dialog.centerPoint(rectangle);
        return new Point(point2.x - point.x / 2, Math.max(rectangle.y, Math.min(point2.y - point.y * 2 / 3, rectangle.y + rectangle.height - point.y)));
    }

    protected void constrainShellSize() {
        Rectangle rectangle;
        Rectangle rectangle2 = this.shell.getBounds();
        if (!rectangle2.equals((Object)(rectangle = this.getConstrainedShellBounds(rectangle2)))) {
            this.shell.setBounds(rectangle);
        }
    }

    protected Rectangle getConstrainedShellBounds(Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Monitor monitor = Dialog.getClosestMonitor(this.getShell().getDisplay(), Dialog.centerPoint(rectangle2));
        Rectangle rectangle3 = monitor.getClientArea();
        if (rectangle2.height > rectangle3.height) {
            rectangle2.height = rectangle3.height;
        }
        if (rectangle2.width > rectangle3.width) {
            rectangle2.width = rectangle3.width;
        }
        rectangle2.x = Math.max(rectangle3.x, Math.min(rectangle2.x, rectangle3.x + rectangle3.width - rectangle2.width));
        rectangle2.y = Math.max(rectangle3.y, Math.min(rectangle2.y, rectangle3.y + rectangle3.height - rectangle2.height));
        return rectangle2;
    }

    protected void configureShell(Shell shell) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        shell.setLayout((Layout)gridLayout);
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        this.createDialogArea(composite2);
        this.createButtonBar(composite2);
        return composite2;
    }

    protected Control createButtonBar(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(0, true));
        composite2.setLayoutData((Object)new GridData(132));
        this.createButtonsForButtonBar(composite2);
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, Messages.getString("ok"), true);
        this.createButton(composite, 1, Messages.getString("cancel"), false);
    }

    protected Button createButton(Composite composite, int n, String string, boolean bl) {
        Shell shell;
        ++((GridLayout)composite.getLayout()).numColumns;
        Button button = new Button(composite, 8);
        button.setText(string);
        button.setData((Object)new Integer(n));
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Dialog.this.buttonPressed((Integer)event.widget.getData());
            }
        });
        if (bl && (shell = composite.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        this.setButtonLayoutData(button);
        return button;
    }

    protected void setReturnCode(int n) {
        this.returnCode = n;
    }

    protected void buttonPressed(int n) {
        if (0 == n || 1 == n) {
            this.setReturnCode(n);
            this.close();
        }
    }

    protected void setButtonLayoutData(Button button) {
        GridData gridData = new GridData(256);
        int n = Dialog.convertHorizontalDLUsToPixels(this.getFontMetrics(), 61);
        Point point = button.computeSize(-1, -1, true);
        gridData.widthHint = Math.max(n, point.x);
        button.setLayoutData((Object)gridData);
    }

    protected FontMetrics getFontMetrics() {
        if (this.fontMetrics == null) {
            GC gC = new GC((Drawable)this.shell);
            this.fontMetrics = gC.getFontMetrics();
            gC.dispose();
        }
        return this.fontMetrics;
    }

    protected abstract Control createDialogArea(Composite var1);

    private void runEventLoop(Shell shell) {
        Display display = this.shell == null ? Display.getCurrent() : shell.getDisplay();
        while (shell != null && !shell.isDisposed()) {
            try {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        display.update();
    }
}

