/*
 * Decompiled with CFR 0.152.
 */
package com.spket.widget;

import com.spket.widget.CItem;
import com.spket.widget.CPicker;
import com.spket.widget.ColorList;
import com.spket.widget.Colors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.CPopup;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class ColorPicker
extends CPicker {
    private RGB rgb;
    private Color color;
    private ColorList list;

    public ColorPicker(Composite composite, int n) {
        super(composite, n);
    }

    public RGB getRGB() {
        if (this.rgb != null) {
            return new RGB(this.rgb.red, this.rgb.green, this.rgb.blue);
        }
        return this.rgb;
    }

    public boolean setRGB(RGB rGB) {
        if (this.rgb == rGB) {
            return false;
        }
        if (this.rgb == null || !this.rgb.equals((Object)rGB)) {
            this.rgb = rGB;
            if (this.color != null) {
                this.color.dispose();
                this.color = null;
            }
            if (this.rgb != null) {
                this.color = new Color((Device)this.getDisplay(), this.rgb);
            }
            this.redraw();
            return true;
        }
        return false;
    }

    protected CPopup createPopup(Composite composite, int n) {
        this.list = new ColorList(composite, n | 0x800000);
        this.list.addDefaultItems();
        this.list.setSelection(this.rgb);
        return this.list;
    }

    protected void onDispose() {
        if (this.color != null) {
            this.color.dispose();
            this.color = null;
        }
        super.onDispose();
    }

    protected void paintContent(GC gC, int n, int n2, int n3, int n4) {
        if (this.color == null) {
            int n5 = Math.min(n3, n4) / 2;
            if (n5 > 1) {
                int n6;
                int n7 = n;
                int n8 = n + n3;
                int n9 = n2 + n4;
                boolean bl = false;
                gC.setBackground(this.getDisplay().getSystemColor(17));
                Rectangle rectangle = gC.getClipping();
                gC.setClipping(n7, n6, n3, n4);
                for (n6 = n2; n6 < n9; n6 += n5) {
                    n7 = n;
                    if (bl) {
                        n7 += n5;
                    }
                    boolean bl2 = bl = !bl;
                    while (n7 < n8) {
                        gC.fillRectangle(n7, n6, n5, n5);
                        n7 += n5 * 2;
                    }
                }
                gC.setClipping(rectangle);
            }
        } else {
            gC.setBackground(this.color);
            gC.fillRectangle(n, n2, n3, n4);
        }
        gC.setForeground(this.getForeground());
        gC.drawRectangle(n, n2, n3 - 1, n4 - 1);
    }

    protected void onSelectionChanged() {
        if (this.list != null) {
            Colors.NamedColor namedColor;
            CItem cItem = this.list.getSelection();
            if (!this.list.isDisposed()) {
                this.list.dispose();
            }
            this.list = null;
            if (cItem != null && (namedColor = (Colors.NamedColor)cItem.getData()) != null) {
                RGB rGB;
                RGB rGB2 = null;
                if (namedColor == ColorList.CUSTOM_ITEM) {
                    rGB = new ColorDialog(this.getShell(), 0);
                    if (this.rgb != null) {
                        rGB.setRGB(this.rgb);
                    }
                    if ((rGB2 = rGB.open()) == null) {
                        return;
                    }
                } else if (namedColor != ColorList.DEFAULT_ITEM) {
                    rGB2 = namedColor.getRGB();
                }
                rGB = this.rgb;
                if (this.setRGB(rGB2)) {
                    Event event = new Event();
                    event.data = rGB;
                    event.detail = Colors.rgb(this.rgb);
                    this.notifyListeners(24, event);
                }
            }
        }
    }
}

