/*
 * Decompiled with CFR 0.152.
 */
package com.spket.palette;

import com.spket.palette.IPaletteProvider;
import com.spket.palette.PaletteCategory;
import com.spket.palette.PaletteEntry;
import com.spket.palette.PaletteList;
import com.spket.palette.PaletteListener;
import com.spket.palette.PaletteSnippet;
import com.spket.palette.PaletteState;
import com.spket.util.LocalSelectionTransfer;
import com.spket.widget.ListItem;
import com.spket.widget.UIUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class PalettePage
implements IPaletteProvider {
    private Clipboard clipboard;
    private PaletteState state;
    private PaletteSnippet snippet;
    protected PaletteList paletteList;
    private List listeners = new ArrayList(2);
    private List categories = Collections.EMPTY_LIST;

    public void createControl(Composite composite) {
        this.paletteList = new PaletteList(composite, 0x800000);
        this.addListeners();
        this.update(this.state);
    }

    public Control getControl() {
        return this.paletteList;
    }

    public void dispose() {
        if (this.state != null) {
            this.saveState(this.state);
            this.state = null;
        }
        if (this.paletteList != null) {
            this.paletteList.dispose();
            this.paletteList = null;
        }
        this.listeners.clear();
        this.categories = Collections.EMPTY_LIST;
    }

    public void setFocus() {
        if (UIUtils.okToUse((Widget)this.paletteList)) {
            this.paletteList.setFocus();
        }
    }

    public void setInput(List list) {
        this.saveState(this.state);
        this.setInput(list, this.state);
    }

    public void setInput(List list, PaletteState paletteState) {
        if (list == null) {
            this.categories = Collections.EMPTY_LIST;
        } else {
            this.categories = new ArrayList(list);
            Collections.sort(this.categories);
        }
        this.update(paletteState);
    }

    public void saveState(PaletteState paletteState) {
        if (paletteState != null && UIUtils.okToUse((Widget)this.paletteList)) {
            paletteState.saveState(this.paletteList);
        }
    }

    protected ListItem findItem(ListItem listItem, PaletteSnippet paletteSnippet) {
        if (listItem != null && listItem.getItemCount() > 0) {
            for (int i = 0; i < listItem.getItemCount(); ++i) {
                ListItem listItem2 = listItem.getItem(i);
                if (listItem2.getData() != paletteSnippet) continue;
                return listItem2;
            }
        }
        return null;
    }

    public PaletteSnippet getSnippet() {
        return this.snippet;
    }

    public void setSnippet(PaletteSnippet paletteSnippet) {
        if (this.snippet == paletteSnippet) {
            return;
        }
        this.snippet = paletteSnippet;
        if (UIUtils.okToUse((Widget)this.paletteList)) {
            this.paletteList.setRedraw(false);
            ListItem listItem = null;
            ListItem listItem2 = null;
            if (this.snippet == null) {
                listItem = this.paletteList.getItem(this.paletteList.getSelectionIndex());
                if (listItem == null) {
                    listItem = this.paletteList.getHighlightItem();
                }
                if (listItem != null && !listItem.isCategory()) {
                    listItem = listItem.getParent();
                }
                listItem2 = this.findItem(listItem, this.snippet);
            } else {
                ListItem[] listItemArray = this.paletteList.getItems();
                for (int i = 0; i < listItemArray.length; ++i) {
                    listItem = listItemArray[i];
                    if (listItem.getData() == this.snippet) {
                        listItem2 = listItemArray[i];
                        listItem = listItem2.getParent();
                        break;
                    }
                    if (listItem.isCategory() && (listItem2 = this.findItem(listItem, this.snippet)) != null) break;
                }
            }
            if (listItem != null && listItem.isCategory() && !listItem.isExpanded()) {
                this.paletteList.expend(this.paletteList.getIndex(listItem));
            }
            this.paletteList.setSelection(listItem2, this.paletteList.getOffset());
            this.paletteList.setRedraw(true);
        }
        this.snippet = this.getSelectedSnippet();
        this.fireSnippetChanged();
    }

    public void addPaletteListener(PaletteListener paletteListener) {
        if (!this.listeners.contains(paletteListener)) {
            this.listeners.add(paletteListener);
        }
    }

    public void removePaletteListener(PaletteListener paletteListener) {
        this.listeners.remove(paletteListener);
    }

    protected void add(PaletteCategory paletteCategory) {
        ListItem listItem = new ListItem(paletteCategory.getLabel());
        listItem.setCategory(true);
        listItem.setData(paletteCategory);
        this.paletteList.addItem(listItem);
        ListItem listItem2 = new ListItem("Select");
        listItem2.setImage(UIUtils.getImage("arrow.gif"));
        listItem.addItem(listItem2);
        List list = paletteCategory.getSnippets();
        int n = list.size();
        if (n > 0) {
            Object[] objectArray = new PaletteSnippet[n];
            list.toArray(objectArray);
            Arrays.sort(objectArray);
            for (int i = 0; i < n; ++i) {
                Object object = objectArray[i];
                listItem2 = new ListItem(((PaletteEntry)object).getLabel());
                listItem2.setData(object);
                listItem2.setImage(((PaletteEntry)object).getIcon());
                listItem.addItem(listItem2);
            }
        }
    }

    protected void update(PaletteState paletteState) {
        this.state = paletteState;
        if (!UIUtils.okToUse((Widget)this.paletteList)) {
            return;
        }
        this.paletteList.setRedraw(false);
        this.paletteList.removeAll();
        int n = this.categories.size();
        for (int i = 0; i < n; ++i) {
            this.add((PaletteCategory)this.categories.get(i));
        }
        if (paletteState != null) {
            paletteState.restoreState(this.paletteList);
        }
        this.paletteList.setRedraw(true);
        this.snippet = this.getSelectedSnippet();
    }

    protected void addListeners() {
        int n = 7;
        Transfer[] transferArray = new Transfer[]{LocalSelectionTransfer.getInstance(), TextTransfer.getInstance()};
        DragSource dragSource = new DragSource((Control)this.paletteList, n);
        dragSource.setTransfer(transferArray);
        dragSource.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent dragSourceEvent) {
                PalettePage.this.onDragStart(dragSourceEvent);
            }

            public void dragSetData(DragSourceEvent dragSourceEvent) {
                PalettePage.this.onDragSetData(dragSourceEvent);
            }

            public void dragFinished(DragSourceEvent dragSourceEvent) {
                PalettePage.this.onDragFinished(dragSourceEvent);
                PalettePage.this.paletteList.resetMouseState();
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        PalettePage.this.onSelectionChanged(event);
                        break;
                    }
                    case 1: {
                        PalettePage.this.onKeyDown(event);
                        break;
                    }
                    case 12: {
                        PalettePage.this.onDispose();
                    }
                }
            }
        };
        this.paletteList.addListener(13, listener);
        this.paletteList.addListener(1, listener);
    }

    protected void onDragStart(DragSourceEvent dragSourceEvent) {
        if (this.snippet == null) {
            dragSourceEvent.doit = false;
            return;
        }
        int n = this.paletteList.getIndexAtPoint(dragSourceEvent.x, dragSourceEvent.y);
        if (n == -1 || n != this.paletteList.getSelectionIndex()) {
            dragSourceEvent.doit = false;
            return;
        }
        ArrayList<PaletteSnippet> arrayList = new ArrayList<PaletteSnippet>(1);
        arrayList.add(this.snippet);
        LocalSelectionTransfer.getInstance().setSelection(arrayList);
    }

    protected void onDragSetData(DragSourceEvent dragSourceEvent) {
        if (this.snippet == null) {
            return;
        }
        if (LocalSelectionTransfer.getInstance().isSupportedType(dragSourceEvent.dataType)) {
            dragSourceEvent.data = LocalSelectionTransfer.getInstance().getSelection();
            return;
        }
        if (TextTransfer.getInstance().isSupportedType(dragSourceEvent.dataType)) {
            String string = this.getContent(this.snippet);
            if (string == null) {
                string = this.snippet.getClass().getName();
            }
            dragSourceEvent.data = string;
        }
    }

    protected void onDragFinished(DragSourceEvent dragSourceEvent) {
        LocalSelectionTransfer.getInstance().setSelection(null);
    }

    protected void fireSnippetChanged() {
        int n = this.listeners.size();
        if (n == 0) {
            return;
        }
        PaletteListener[] paletteListenerArray = new PaletteListener[n];
        this.listeners.toArray(paletteListenerArray);
        for (int i = 0; i < paletteListenerArray.length; ++i) {
            paletteListenerArray[i].snippetChanged(this.snippet);
        }
    }

    protected void onKeyDown(Event event) {
        if (this.snippet != null) {
            if (event.keyCode == 99 || event.keyCode == 67) {
                if (UIUtils.isControlDown(event.stateMask)) {
                    this.onCopy(event);
                }
            } else if (event.character == '\u001b') {
                this.setSnippet(null);
            }
        }
    }

    protected void onDispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
    }

    protected void onCopy(Event event) {
        String string = this.getContent(this.snippet);
        if (string != null) {
            if (this.clipboard == null) {
                this.clipboard = new Clipboard(UIUtils.getDisplay());
            }
            this.clipboard.setContents(new Object[]{string}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    protected String getContent(PaletteSnippet paletteSnippet) {
        String string = null;
        if (paletteSnippet != null && ((string = paletteSnippet.toSource(2)) == null || string.length() == 0) && (string = paletteSnippet.getLabel()) != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    protected void onSelectionChanged(Event event) {
        PaletteSnippet paletteSnippet = this.getSelectedSnippet();
        if (this.snippet != paletteSnippet) {
            this.snippet = paletteSnippet;
            this.fireSnippetChanged();
        }
    }

    protected PaletteSnippet getSelectedSnippet() {
        Object object;
        ListItem listItem = this.paletteList.getItem(this.paletteList.getSelectionIndex());
        if (listItem != null && listItem.isCategory()) {
            listItem = this.paletteList.getHighlightItem();
        }
        if (listItem != null && (object = listItem.getData()) instanceof PaletteSnippet) {
            return (PaletteSnippet)object;
        }
        return null;
    }
}

