/*
 * Decompiled with CFR 0.152.
 */
package com.spket.palette;

import com.spket.widget.ListItem;
import com.spket.widget.UIUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public class PaletteList
extends Composite {
    protected static final int F_LAYOUTED = 1;
    protected static final int F_MOUSE_DOWN = 2;
    protected static final int F_SHOW_TOOLTIP = 4;
    protected static final int F_DIRTY = 8;
    protected static final int F_DOUBLE_BUFFER = 16;
    protected static final int LEFT_BORDER = 14;
    protected static final ListItem[] EMPTY_ITEMS = new ListItem[0];
    private int fOffset;
    private int fSelectedIndex = -1;
    private ListItem fHighlightItem;
    protected int fMouseOverIndex = -1;
    private Font fBoldFont;
    private Image fCategoryImg;
    private Color fBorderColor;
    private Color fMouseOverColor;
    private Color fSelectionColor;
    private Color fSelectionHoverColor;
    private int flags;
    private int fItemCount;
    private int fTextHeight = 9;
    private int fItemHeight = 20;
    private ListItem fRoot = new ListItem();
    private ListItem[] fItems = EMPTY_ITEMS;
    private Image plusImage;
    private Image minusImage;

    private static int checkStyle(int n) {
        n = (n & 0x800000) != 0 ? 0x800000 : ((n & 0x800) != 0 ? 2048 : 0);
        n = n | 0x40000 | 0x100000 | 0x200;
        return n;
    }

    public PaletteList(Composite composite, int n) {
        super(composite, PaletteList.checkStyle(n));
        this.fBorderColor = UIUtils.getColor("color.border");
        this.fMouseOverColor = UIUtils.getColor("color.over");
        this.fSelectionColor = UIUtils.getColor("color.selection");
        this.fSelectionHoverColor = UIUtils.getColor("color.selection.hover");
        this.plusImage = UIUtils.getImage("plus.gif");
        this.minusImage = UIUtils.getImage("minus.gif");
        this.init();
        this.installListeners();
    }

    protected void init() {
        this.setFlag(8, true);
        GC gC = new GC((Drawable)this);
        this.fTextHeight = gC.stringExtent((String)"gM").y;
        gC.dispose();
        this.fItemHeight = Math.max(16, this.fTextHeight) + 4;
        if (this.fCategoryImg != null) {
            this.fCategoryImg.dispose();
            this.fCategoryImg = null;
        }
        int n = 10;
        int n2 = this.fItemHeight;
        Display display = this.getDisplay();
        this.fCategoryImg = new Image((Device)display, n, n2);
        gC = new GC((Drawable)this.fCategoryImg);
        RGB rGB = this.getBackground().getRGB();
        Color color = new Color((Device)display, (int)((double)rGB.red * 0.94), (int)((double)rGB.green * 0.94), (int)((double)rGB.blue * 0.94));
        Color color2 = new Color((Device)display, (int)((double)rGB.red * 0.83), (int)((double)rGB.green * 0.83), (int)((double)rGB.blue * 0.83));
        gC.setBackground(this.getBackground());
        gC.fillRectangle(0, 0, n, n2);
        gC.setForeground(color);
        gC.setBackground(color2);
        gC.fillGradientRectangle(0, 0, n, n2 - 3, true);
        gC.drawLine(0, n2 - 2, n, n2 - 2);
        color.dispose();
        color2.dispose();
        gC.dispose();
    }

    protected void installListeners() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 5: {
                        PaletteList.this.onMouseMove(event);
                        break;
                    }
                    case 9: {
                        PaletteList.this.onPaint(event);
                        break;
                    }
                    case 3: {
                        PaletteList.this.onMouseDown(event);
                        break;
                    }
                    case 4: {
                        PaletteList.this.onMouseUp(event);
                        break;
                    }
                    case 7: {
                        PaletteList.this.onMouseExit(event);
                        break;
                    }
                    case 1: {
                        PaletteList.this.onKeyDown(event);
                        break;
                    }
                    case 31: {
                        PaletteList.this.onTraverse(event);
                        break;
                    }
                    case 11: {
                        PaletteList.this.onResize(event);
                        break;
                    }
                    case 12: {
                        PaletteList.this.onDispose();
                    }
                }
            }
        };
        this.addListener(9, listener);
        this.addListener(5, listener);
        this.addListener(3, listener);
        this.addListener(4, listener);
        this.addListener(7, listener);
        this.addListener(1, listener);
        this.addListener(31, listener);
        this.addListener(11, listener);
        this.addListener(12, listener);
        ScrollBar scrollBar = this.getVerticalBar();
        if (scrollBar != null) {
            scrollBar.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    PaletteList.this.onScroll(event);
                }
            });
        }
    }

    public void addItem(ListItem listItem) {
        this.setFlag(8, true);
        this.fRoot.addItem(listItem);
    }

    public void removeAll() {
        if (this.fRoot.getItemCount() > 0) {
            this.setFlag(8, true);
            this.fRoot.removeAll();
        }
    }

    public ListItem getItem(int n) {
        if (n < 0 || n >= this.fItemCount) {
            return null;
        }
        return this.fItems[n];
    }

    public int getItemCount() {
        return this.fItemCount;
    }

    public ListItem[] getItems() {
        if (this.fRoot != null) {
            return this.fRoot.getItems();
        }
        return EMPTY_ITEMS;
    }

    public void setFont(Font font) {
        if (this.fBoldFont != null) {
            this.fBoldFont.dispose();
            this.fBoldFont = null;
        }
        super.setFont(font);
        this.init();
        this.redraw();
    }

    public void setDoubleBuffered(boolean bl) {
        this.setFlag(16, bl);
    }

    public boolean isDoubleBuffered() {
        return this.getFlag(16);
    }

    public void setLayout(Layout layout) {
    }

    public Rectangle getBounds(int n) {
        if (n < this.fOffset || n >= this.fItemCount) {
            return null;
        }
        Rectangle rectangle = this.getClientArea();
        int n2 = (n - this.fOffset) * this.fItemHeight;
        if (n2 <= rectangle.height) {
            return new Rectangle(rectangle.x, rectangle.y + n2, rectangle.width, this.fItemHeight);
        }
        return null;
    }

    public int getOffset() {
        return this.fOffset;
    }

    ListItem getHighlightItem() {
        return this.fHighlightItem;
    }

    public int getSelectionIndex() {
        return this.fSelectedIndex;
    }

    public int getMouseOverIndex() {
        return this.fMouseOverIndex;
    }

    public void setSelection(int n) {
        if (n == this.fSelectedIndex) {
            return;
        }
        this.checkWidget();
        int n2 = this.fItemCount;
        int n3 = this.fSelectedIndex;
        this.fSelectedIndex = n >= 0 && n < n2 ? n : -1;
        int n4 = -1;
        ListItem listItem = this.getItem(this.fSelectedIndex);
        if (listItem != null && this.fHighlightItem != listItem && !listItem.isCategory()) {
            if (this.fHighlightItem != null) {
                Rectangle rectangle = this.getClientArea();
                int n5 = rectangle.y;
                int n6 = n5 + rectangle.height;
                for (int i = this.fOffset; i < this.fItemCount; ++i) {
                    if (this.fItems[i] == this.fHighlightItem) {
                        n4 = i;
                        break;
                    }
                    if ((n5 += this.fItemHeight) > n6) break;
                }
            }
            this.fHighlightItem = listItem;
        }
        if (n3 != -1) {
            this.redrawItem(n3);
        }
        if (n4 != -1 && n3 != n4) {
            this.redrawItem(n4);
        }
        if (this.fSelectedIndex != -1) {
            this.redrawItem(this.fSelectedIndex);
        }
        if (n3 != -1 || this.fSelectedIndex != -1) {
            this.update();
        }
    }

    public void setSelection(int n, int n2) {
        if (this.getFlag(8)) {
            this.layoutItems();
        }
        if (n != -1) {
            if (n >= this.fItemCount) {
                n = this.fItemCount - 1;
            }
            this.fOffset = Math.max(0, n - n2);
            Rectangle rectangle = this.getClientArea();
            int n3 = rectangle.height / this.fItemHeight;
            if (this.fOffset + n3 > this.fItemCount) {
                this.fOffset = this.fItemCount - n3;
            } else if (this.fOffset < n) {
                int n4 = n - this.fOffset;
                if (n4 >= n3) {
                    this.fOffset += n4 - n3 + 1;
                }
            } else {
                this.fOffset = n;
            }
            if (this.fOffset < 0) {
                this.fOffset = 0;
            }
        } else {
            this.fOffset = 0;
        }
        this.layout(true);
        if (this.fSelectedIndex == n) {
            this.fSelectedIndex = -1;
            this.fHighlightItem = null;
        }
        this.setSelection(n);
        this.redraw();
    }

    public void setSelection(ListItem listItem, int n) {
        if (this.getFlag(8)) {
            this.layoutItems();
        }
        int n2 = -1;
        for (int i = 0; i < this.fItemCount; ++i) {
            if (this.fItems[i] != listItem) continue;
            n2 = i;
            break;
        }
        this.setSelection(n2, n);
    }

    protected void showItem(int n) {
        int n2 = this.fItemCount;
        if (n < 0 || n >= n2) {
            return;
        }
        int n3 = this.fOffset;
        if (n < n3) {
            n3 = n;
        } else {
            Rectangle rectangle = this.getClientArea();
            int n4 = rectangle.height / this.fItemHeight;
            if (n >= n3 + n4) {
                n3 = n - n4 + 1;
            }
        }
        if (n3 != this.fOffset) {
            this.fOffset = n3;
            this.setFlag(1, false);
            this.redraw();
        }
    }

    protected void setSelection(int n, boolean bl) {
        if (n != this.fSelectedIndex) {
            int n2 = this.fSelectedIndex;
            this.setSelection(n);
            if (bl) {
                Event event = new Event();
                event.detail = n2;
                event.data = this.getItem(n);
                this.notifyListeners(13, event);
            }
        }
    }

    protected void onPaint(Event event) {
        GC gC;
        this.layout(false);
        Image image = null;
        Rectangle rectangle = this.getClientArea();
        if (this.getFlag(16)) {
            Rectangle rectangle2 = event.gc.getClipping();
            int n = rectangle2.x + rectangle2.width;
            int n2 = rectangle2.y + rectangle2.height;
            if (n > rectangle.width) {
                n = rectangle.width;
            }
            if (n2 > rectangle.height) {
                n2 = rectangle.height;
            }
            image = new Image((Device)this.getDisplay(), n, n2);
            gC = new GC((Drawable)image);
            gC.setFont(this.getFont());
            gC.setBackground(this.getBackground());
            gC.setForeground(this.getForeground());
            gC.fillRectangle(0, 0, rectangle.width, rectangle.height);
            gC.setClipping(rectangle2);
        } else {
            gC = event.gc;
        }
        int n = this.fItemHeight * (this.fItemCount - this.fOffset);
        if (n < rectangle.height) {
            gC.fillRectangle(rectangle.x, rectangle.y + n, rectangle.width, rectangle.height - n);
        }
        if (rectangle.height >= this.fItemHeight) {
            this.drawItems(gC, rectangle);
        }
        if (image != null) {
            gC.dispose();
            event.gc.drawImage(image, 0, 0);
            image.dispose();
        }
    }

    protected void redrawItem(int n) {
        ListItem listItem = this.getItem(n);
        if (listItem == null) {
            return;
        }
        Rectangle rectangle = this.getBounds(n);
        if (rectangle == null) {
            return;
        }
        this.redraw(rectangle.x, rectangle.y, rectangle.width, this.fItemHeight, false);
    }

    protected void drawSign(GC gC, int n, int n2, int n3, boolean bl) {
        Rectangle rectangle = this.getSignRectangle(n, n2, n3);
        if (bl) {
            if (this.minusImage != null) {
                gC.drawImage(this.minusImage, rectangle.x, rectangle.y);
            }
        } else if (this.plusImage != null) {
            gC.drawImage(this.plusImage, rectangle.x, rectangle.y);
        }
    }

    protected void drawItem(GC gC, int n, ListItem listItem, Rectangle rectangle) {
        String string = listItem.getText();
        if (listItem.isCategory()) {
            if (this.fCategoryImg != null) {
                gC.drawImage(this.fCategoryImg, 0, 0, 1, this.fItemHeight, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                gC.fillRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            int n2 = this.fTextHeight * 2;
            int n3 = rectangle.y + rectangle.height - this.fTextHeight - 5;
            int n4 = rectangle.x + 14 + this.getTextIndent(listItem.getLevel());
            if (string != null && string.length() > 0) {
                Font font = gC.getFont();
                gC.setFont(this.getBoldFont(gC));
                string = UIUtils.shortenText(gC, string, rectangle.width + rectangle.x - n4);
                gC.drawString(string, n4, n3, true);
                if (n == this.fSelectedIndex) {
                    n2 = gC.stringExtent((String)string).x + (n4 - (rectangle.x + 14)) + 4;
                }
                gC.setFont(font);
            }
            if (n == this.fSelectedIndex && n2 > 0) {
                n4 = Math.max(n4 - 3, rectangle.x - 14 + 1);
                gC.drawFocus(n4, n3, n2, this.fTextHeight + 1);
            }
            this.drawSign(gC, rectangle.x, rectangle.y, listItem.getLevel(), listItem.isExpanded());
        } else {
            int n5 = rectangle.x;
            int n6 = rectangle.y;
            this.drawBorder(gC, n, listItem, n5, n6, rectangle.width, rectangle.height);
            n5 += 5;
            if (listItem.getImage() != null) {
                Rectangle rectangle2 = gC.getClipping();
                gC.setClipping(n5, n6 += (rectangle.height - 16) / 2, 16, 16);
                gC.drawImage(listItem.getImage(), n5, n6);
                gC.setClipping(rectangle2);
            }
            if (string != null && string.length() > 0) {
                string = UIUtils.shortenText(gC, string, rectangle.width + rectangle.x - (n5 += 20) - 2);
                gC.drawString(string, n5, rectangle.y + (rectangle.height - this.fTextHeight) / 2, true);
            }
        }
    }

    protected void drawBorder(GC gC, int n, ListItem listItem, int n2, int n3, int n4, int n5) {
        gC.fillRectangle(n2, n3, n4, n5);
        n2 += 3;
        if ((n4 -= 4) > 0 && n == this.fMouseOverIndex || this.fHighlightItem == listItem) {
            Color color = this.getBackground();
            gC.setBackground(this.fSelectionColor);
            if (!this.getFlag(2) && n == this.fMouseOverIndex) {
                if (this.fHighlightItem == listItem) {
                    gC.setBackground(this.fSelectionHoverColor);
                } else {
                    gC.setBackground(this.fMouseOverColor);
                }
            }
            gC.fillRectangle(n2, n3, n4, n5);
            gC.setBackground(color);
            color = gC.getForeground();
            gC.setForeground(this.fBorderColor);
            gC.drawRectangle(n2, n3, n4 - 1, n5 - 1);
            gC.setForeground(color);
        }
    }

    protected int getIndent(int n) {
        if (n > 1) {
            return (n - 1) * 14;
        }
        return 0;
    }

    protected int getTextIndent(int n) {
        int n2 = this.getIndent(n) + 1;
        if (n <= 1) {
            n2 += 2;
        }
        return n2;
    }

    protected Font getBoldFont(GC gC) {
        if (this.fBoldFont == null) {
            this.fBoldFont = UIUtils.getFont(this.getDisplay(), gC.getFont(), 1, -1);
        }
        return this.fBoldFont;
    }

    protected void drawItems(GC gC, Rectangle rectangle) {
        int n = rectangle.y + rectangle.height;
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, this.fItemHeight);
        Rectangle rectangle3 = gC.getClipping();
        for (int i = this.fOffset; i < this.fItemCount; ++i) {
            if (rectangle2.intersects(rectangle3)) {
                this.drawItem(gC, i, this.fItems[i], rectangle2);
            }
            rectangle2.y += this.fItemHeight;
            if (rectangle2.y > n) break;
        }
    }

    int getIndex(ListItem listItem) {
        if (listItem != null) {
            ListItem[] listItemArray = this.getItems();
            for (int i = 0; i < listItemArray.length; ++i) {
                if (listItem != listItemArray[i]) continue;
                return i;
            }
        }
        return -1;
    }

    void resetMouseState() {
        this.fMouseOverIndex = -1;
        this.setFlag(2, false);
    }

    protected int getIndexAtPoint(int n, int n2) {
        Rectangle rectangle = this.getClientArea();
        int n3 = this.fOffset + (n2 - rectangle.y) / this.fItemHeight;
        if (n3 < this.fItemCount) {
            return n3;
        }
        return -1;
    }

    protected boolean isSignPosition(int n, int n2, int n3) {
        ListItem listItem = this.getItem(n);
        if (listItem != null && listItem.getItemCount() > 0) {
            Rectangle rectangle = this.getClientArea();
            int n4 = (n - this.fOffset) * this.fItemHeight + rectangle.y;
            rectangle = this.getSignRectangle(rectangle.x, n4, listItem.getLevel());
            return rectangle.contains(n2, n3);
        }
        return false;
    }

    protected Rectangle getSignRectangle(int n, int n2, int n3) {
        Rectangle rectangle = new Rectangle(0, 0, 9, 9);
        n += this.getIndent(n3);
        rectangle.x = n += (14 - rectangle.width) / 2;
        rectangle.y = n2 += (this.fItemHeight - rectangle.height) / 2;
        return rectangle;
    }

    protected void onMouseDown(Event event) {
        this.setFlag(2, true);
        int n = this.getIndexAtPoint(event.x, event.y);
        if (n != -1) {
            int n2 = this.fSelectedIndex;
            this.setSelection(n, true);
            ListItem listItem = this.getItem(this.fSelectedIndex);
            if (!listItem.isCategory()) {
                this.showItem(this.fSelectedIndex);
            }
            if (n2 == n) {
                this.redrawItem(n);
                this.update();
            }
        }
    }

    protected void onMouseUp(Event event) {
        ListItem listItem;
        if (!this.getFlag(2)) {
            return;
        }
        this.setFlag(2, false);
        this.fMouseOverIndex = this.getIndexAtPoint(event.x, event.y);
        if (UIUtils.isLeftMouseButton(event) && this.fSelectedIndex != -1 && this.fMouseOverIndex == this.fSelectedIndex && (listItem = this.getItem(this.fSelectedIndex)) != null && listItem.isCategory()) {
            this.switchState(this.fSelectedIndex);
        }
        if (this.fMouseOverIndex != -1) {
            this.redrawItem(this.fMouseOverIndex);
            this.update();
        }
    }

    protected void onMouseExit(Event event) {
        if (this.fMouseOverIndex != -1) {
            int n = this.fMouseOverIndex;
            this.fMouseOverIndex = -1;
            this.redrawItem(n);
            this.update();
        }
    }

    protected void onMouseMove(Event event) {
        if (this.getFlag(2)) {
            return;
        }
        int n = this.getIndexAtPoint(event.x, event.y);
        if (n != this.fMouseOverIndex) {
            int n2 = this.fMouseOverIndex;
            this.fMouseOverIndex = n;
            if (n2 != -1) {
                this.redrawItem(n2);
            }
            if (this.fMouseOverIndex != -1) {
                this.redrawItem(this.fMouseOverIndex);
            }
            this.update();
        }
    }

    protected void onTraverse(Event event) {
        switch (event.detail) {
            case 8: 
            case 16: {
                event.doit = true;
            }
        }
    }

    protected void expend(int n) {
        this.switchState(n, true);
    }

    protected void collapse(int n) {
        this.switchState(n, false);
    }

    protected void switchState(int n) {
        ListItem listItem = this.getItem(n);
        if (listItem != null) {
            this.switchState(n, !listItem.isExpanded());
        }
    }

    protected void switchState(int n, boolean bl) {
        ListItem listItem = this.getItem(n);
        if (listItem != null && listItem.getItemCount() > 0 && listItem.isExpanded() != bl) {
            int n2 = this.fOffset;
            listItem.setExpanded(bl);
            this.setFlag(8, true);
            this.layout(true);
            if (n2 != this.fOffset) {
                this.redraw();
            } else {
                Rectangle rectangle = this.getBounds(n);
                if (rectangle == null) {
                    this.redraw();
                } else {
                    Rectangle rectangle2 = this.getClientArea();
                    this.redraw(rectangle2.x, rectangle.y, rectangle2.width, rectangle2.height + rectangle2.y - rectangle.y, false);
                }
            }
        }
    }

    protected void onKeyDown(Event event) {
        int n = this.fItemCount;
        if (n == 0) {
            return;
        }
        int n2 = this.fSelectedIndex;
        if (n2 != -1) {
            switch (event.character) {
                case '+': 
                case '=': {
                    this.expend(n2);
                    return;
                }
                case '-': 
                case '_': {
                    this.collapse(n2);
                    return;
                }
                case '\r': {
                    this.switchState(n2);
                    return;
                }
            }
        }
        switch (event.keyCode) {
            case 0x1000001: {
                n2 = Math.max(0, n2 - 1);
                this.setSelection(n2, true);
                this.showItem(this.fSelectedIndex);
                break;
            }
            case 0x1000003: {
                ListItem listItem;
                if (n2 != -1 && (listItem = this.getItem(n2)) != null && listItem.isExpanded()) {
                    this.collapse(n2);
                    return;
                }
                n2 = Math.max(0, n2 - 1);
                this.setSelection(n2, true);
                this.showItem(this.fSelectedIndex);
                break;
            }
            case 0x1000002: {
                n2 = Math.min(n - 1, n2 + 1);
                this.setSelection(n2, true);
                this.showItem(this.fSelectedIndex);
                break;
            }
            case 0x1000004: {
                ListItem listItem;
                if (n2 != -1 && (listItem = this.getItem(n2)) != null && listItem.getItemCount() > 0 && !listItem.isExpanded()) {
                    this.expend(n2);
                    return;
                }
                n2 = Math.min(n - 1, n2 + 1);
                this.setSelection(n2, true);
                this.showItem(this.fSelectedIndex);
                break;
            }
            case 0x1000007: {
                n2 = 0;
                this.setSelection(n2, true);
                this.showItem(this.fSelectedIndex);
                break;
            }
            case 0x1000008: {
                n2 = n - 1;
                this.setSelection(n2, true);
                this.showItem(this.fSelectedIndex);
                break;
            }
            case 0x1000005: {
                Rectangle rectangle = this.getClientArea();
                int n3 = rectangle.height / this.fItemHeight;
                n2 = Math.max(0, n2 - n3);
                this.setSelection(n2);
                n2 = this.fOffset;
                this.fOffset -= n3;
                this.setFlag(1, false);
                if (n2 == this.fOffset) break;
                this.redraw();
                break;
            }
            case 0x1000006: {
                Rectangle rectangle = this.getClientArea();
                int n4 = rectangle.height / this.fItemHeight;
                n2 = Math.min(n - 1, n2 + n4);
                this.setSelection(n2);
                n2 = this.fOffset;
                this.fOffset += n4;
                this.setFlag(1, false);
                if (n2 == this.fOffset) break;
                this.redraw();
            }
        }
    }

    protected void onResize(Event event) {
        this.setFlag(1, false);
        this.redraw();
    }

    protected void onScroll(Event event) {
        int n;
        ScrollBar scrollBar = this.getVerticalBar();
        if (scrollBar != null && scrollBar.isVisible() && this.fOffset != (n = scrollBar.getSelection())) {
            this.fOffset = n;
            this.redraw();
        }
    }

    protected void onDispose() {
        if (this.fBoldFont != null) {
            this.fBoldFont.dispose();
            this.fBoldFont = null;
        }
        if (this.fCategoryImg != null) {
            this.fCategoryImg.dispose();
            this.fCategoryImg = null;
        }
        if (this.fRoot != null) {
            this.fRoot.removeAll();
            this.fRoot = null;
        }
        this.fItems = null;
    }

    protected boolean getFlag(int n) {
        return (this.flags & n) != 0;
    }

    protected void setFlag(int n, boolean bl) {
        this.flags = bl ? (this.flags |= n) : (this.flags &= ~n);
    }

    public void layout(boolean bl) {
        if (this.needLayout() || bl) {
            this.doLayout();
            this.setFlag(1, true);
        }
    }

    protected boolean needLayout() {
        return this.getFlag(8) || !this.getFlag(1);
    }

    protected void layoutItems() {
        if (!this.getFlag(8)) {
            return;
        }
        this.setFlag(8, false);
        int n = this.fRoot.getExpandedItemCount();
        int n2 = this.fItems.length;
        if (n >= n2 || n2 > 256 && n2 > n * 2) {
            this.fItems = new ListItem[n];
        } else {
            for (int i = n; i < this.fItemCount; ++i) {
                this.fItems[i] = null;
            }
        }
        if (n > 0) {
            this.fRoot.fill(this.fItems, 0, 1);
        }
        this.fItemCount = n;
    }

    protected void doLayout() {
        boolean bl;
        this.layoutItems();
        ScrollBar scrollBar = this.getVerticalBar();
        if (scrollBar == null) {
            return;
        }
        Rectangle rectangle = this.getClientArea();
        int n = this.fItemCount * this.fItemHeight;
        boolean bl2 = bl = rectangle.height < n;
        if (bl) {
            int n2 = rectangle.height / this.fItemHeight;
            int n3 = this.fItemCount - n2;
            if (this.fOffset > n3) {
                this.fOffset = n3;
            } else if (this.fOffset < 0) {
                this.fOffset = 0;
            }
            scrollBar.setValues(this.fOffset, scrollBar.getMinimum(), this.fItemCount, n2, 1, n2);
        } else {
            this.fOffset = 0;
        }
        if (bl != scrollBar.getVisible()) {
            scrollBar.setVisible(bl);
        }
    }
}

