/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ywt.model;

import com.spket.as.internal.compiler.parser.BufferedScanner;
import com.spket.buffer.IBuffer;
import com.spket.js.model.Context;
import com.spket.js.model.ISlot;
import com.spket.js.model.JSFunction;
import com.spket.js.model.JSObject;
import com.spket.js.model.ObjectImpl;
import com.spket.js.model.ObjectWrapper;
import com.spket.mime.text.LexerProvider;
import com.spket.util.StringUtils;
import com.spket.xml.INodeRegion;
import com.spket.xml.PositionInfo;
import com.spket.xml.XMLAttr;
import com.spket.xml.XMLCDATA;
import com.spket.xml.XMLDocument;
import com.spket.xml.XMLElement;
import com.spket.xml.XMLModel;
import com.spket.xml.XMLNode;
import com.spket.ywt.model.YWTLibrary;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.graphics.Point;

public class YWTLexerProvider
extends LexerProvider {
    private String[] fIncludes;
    private BufferedScanner[] fScripts;

    public YWTLexerProvider(XMLModel xMLModel, int n) {
        super(xMLModel, n);
    }

    public Context getContext() {
        return YWTLibrary.getInstance();
    }

    public JSObject getGlobalForEdit() {
        ObjectImpl objectImpl;
        YWTLibrary yWTLibrary = YWTLibrary.getInstance();
        if (yWTLibrary.isInitialized()) {
            objectImpl = new ObjectWrapper(yWTLibrary.getGlobal());
            XMLDocument xMLDocument = this.fModel.getXMLDocument();
            if (xMLDocument != null) {
                this.visit(xMLDocument.getDocumentElement(), (JSObject)objectImpl);
            }
        } else {
            objectImpl = new ObjectImpl();
        }
        return objectImpl;
    }

    public String[] getIncludes() {
        this.prepare();
        return this.fIncludes;
    }

    public BufferedScanner[] getScripts() {
        this.prepare();
        return this.fScripts;
    }

    public JSObject getThisScope(JSObject jSObject) {
        return jSObject;
    }

    protected boolean isScript() {
        PositionInfo positionInfo = this.getPosition();
        switch (positionInfo.nodeType) {
            case 3: 
            case 4: {
                XMLNode xMLNode = positionInfo.node;
                if (xMLNode.getNodeType() != 1) {
                    xMLNode = xMLNode.getParent();
                }
                if (xMLNode != null && xMLNode.getNodeType() == 1) {
                    String string = xMLNode.getLocalName();
                    if ("action".equals(string)) {
                        return true;
                    }
                    return this.isEvent(string);
                }
            }
            case 2: {
                return this.isEvent(positionInfo.node.getLocalName());
            }
        }
        return false;
    }

    protected boolean isEvent(String string) {
        return string != null && string.length() > 2 && string.charAt(0) == 'o' && string.charAt(1) == 'n';
    }

    protected void prepare() {
        int n;
        XMLElement xMLElement;
        if (this.fIncludes != null) {
            return;
        }
        this.fIncludes = StringUtils.EMPTY_STRINGS;
        XMLDocument xMLDocument = this.fModel.getXMLDocument();
        if (xMLDocument != null && (xMLElement = xMLDocument.getDocumentElement()) != null && (n = xMLElement.getChildrenCount()) > 0) {
            ArrayList<String> arrayList = new ArrayList<String>(2);
            ArrayList<IBuffer> arrayList2 = new ArrayList<IBuffer>(2);
            XMLNode[] xMLNodeArray = xMLElement.getChildren();
            for (int i = 0; i < n; ++i) {
                XMLNode xMLNode = xMLNodeArray[i];
                if (1 != xMLNode.getNodeType() || !"action".equals(xMLNode.getLocalName())) continue;
                XMLElement xMLElement2 = (XMLElement)xMLNode;
                XMLAttr xMLAttr = xMLElement2.getAttr("file");
                if (xMLAttr == null) {
                    IBuffer iBuffer;
                    Object object;
                    if (xMLElement2.isEmptyTag() || !xMLElement2.hasStartTag()) continue;
                    int n2 = -1;
                    int n3 = 0;
                    INodeRegion iNodeRegion = xMLElement2.getStartTagRegion();
                    if (iNodeRegion.getStart() < this.fOffset) {
                        n2 = iNodeRegion.getEnd();
                        iNodeRegion = xMLElement2.getEndTagRegion();
                        if (iNodeRegion == null || iNodeRegion.getEnd() >= this.fOffset) continue;
                        n3 = iNodeRegion.getStart() - n2;
                    }
                    if ((xMLAttr = xMLElement2.getAttr("trigger")) == null || !"onLoad".equals(xMLAttr.getValue())) continue;
                    if (xMLElement2.getChildrenCount() == 1) {
                        n2 = -1;
                        object = xMLElement2.getChildren()[0];
                        if (4 == object.getNodeType()) {
                            iNodeRegion = object.getRegion();
                            n2 = iNodeRegion.getStart() + 9;
                            n3 = iNodeRegion.getEnd() - n2;
                            if (((XMLCDATA)object).isClosed()) {
                                n3 -= 3;
                            }
                        }
                    }
                    if (n2 <= 0 || n3 <= 0) continue;
                    object = null;
                    if (n3 > 0 && (iBuffer = this.fModel.getBuffer()) != null) {
                        object = iBuffer.get(n2, n3);
                    }
                    if (object == null) continue;
                    iBuffer = new BufferedScanner(Context.JS_1_6);
                    iBuffer.setSourceOffset(n2);
                    iBuffer.setSource(((String)object).toCharArray());
                    iBuffer.prepare();
                    arrayList2.add(iBuffer);
                    continue;
                }
                String string = xMLAttr.getValue();
                if (string == null) continue;
                arrayList.add(string);
            }
            if (arrayList.size() > 0) {
                this.fIncludes = new String[arrayList.size()];
                arrayList.toArray(this.fIncludes);
            }
            if (arrayList2.size() > 0) {
                this.fScripts = new BufferedScanner[arrayList2.size()];
                arrayList2.toArray(this.fScripts);
            }
        }
    }

    protected void visit(XMLElement xMLElement, JSObject jSObject) {
        int n;
        if (xMLElement == null) {
            return;
        }
        boolean bl = false;
        XMLAttr xMLAttr = xMLElement.getAttr("name");
        if (xMLAttr != null) {
            bl = true;
            this.define(xMLElement, (XMLNode)xMLAttr, jSObject);
        }
        if ((n = xMLElement.getChildrenCount()) > 0) {
            XMLNode[] xMLNodeArray = xMLElement.getChildren();
            for (int i = 0; i < n; ++i) {
                XMLNode xMLNode = xMLNodeArray[i];
                if (1 != xMLNode.getNodeType()) continue;
                if ("name".equals(xMLNode.getLocalName())) {
                    if (bl) continue;
                    this.define(xMLElement, xMLNode, jSObject);
                    continue;
                }
                this.visit((XMLElement)xMLNode, jSObject);
            }
        }
    }

    protected void define(XMLElement xMLElement, XMLNode xMLNode, JSObject jSObject) {
        Object object;
        int n = -1;
        int n2 = 0;
        if (xMLNode.getNodeType() == 2) {
            INodeRegion iNodeRegion;
            if (xMLElement.hasStartTag() && (iNodeRegion = (object = (XMLAttr)xMLNode).getValueRegion()) != null) {
                n = xMLElement.getStartTagRegion().getStart() + iNodeRegion.getStart();
                n2 = iNodeRegion.getLength() - 1;
            }
        } else {
            INodeRegion iNodeRegion;
            object = (XMLElement)xMLNode;
            if (!object.isEmptyTag() && (iNodeRegion = object.getStartTagRegion()) != null) {
                n = iNodeRegion.getEnd();
                iNodeRegion = object.getEndTagRegion();
                if (iNodeRegion != null) {
                    n2 = iNodeRegion.getStart() - n;
                }
            }
        }
        if (n > 0 && n2 > 0) {
            JSObject jSObject2;
            object = null;
            IBuffer iBuffer = this.fModel.getBuffer();
            if (2 == xMLNode.getNodeType()) {
                if (iBuffer.get(n) == iBuffer.get(n + n2)) {
                    --n2;
                }
                ++n;
                if (n2 <= 0) {
                    return;
                }
            }
            if (jSObject.hasProperty((String)(object = iBuffer.get(n, n2)))) {
                return;
            }
            YWTLibrary yWTLibrary = YWTLibrary.getInstance();
            String string = yWTLibrary.mapClass(xMLElement.getLocalName());
            if (string != null && (jSObject2 = jSObject.getProperty(string)) instanceof JSFunction && (jSObject2 = ((JSFunction)jSObject2).construct((Context)yWTLibrary, jSObject, null)) != null) {
                jSObject.setProperty((String)object, jSObject2);
                ISlot iSlot = jSObject.getSlot((String)object);
                if (iSlot != null) {
                    IPath iPath = this.fModel.getPath();
                    if (iPath != null) {
                        iSlot.setData((Object)ISlot.P_SOURCE, (Object)iPath.toPortableString());
                    }
                    iSlot.setData((Object)ISlot.P_RANGE, (Object)new Point(n, n + n2 - 1));
                }
            }
        }
    }
}

