<?php
/************************************************************************/
/* RankQuest: Search Engine Optimization Tools                          */
/* ============================================                         */
/*                                                                      */
/* Copyright (c) 2006 by RankQuest                                      */
/* http://www.rankquest.com                                             */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/*                                                                      */
/* This program is distributed in the hope that it will be useful, but  */ 
/* WITHOUT ANY WARRANTY; without even the implied warranty of           */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU     */
/* General Public License for more details                              */
/************************************************************************/

include 'config.php';

/*********************************************************************

	Function Name : getContent

	Argument      : string
  
	Task          : To fetch a content of a given URL

	Returns       : Status Code
		      : Content  	

*********************************************************************/

function getContent($url)
{
	Global $connectionType,$proxy_name,$proxy_port,$proxy_user,$proxy_passWord;

	if($connectionType == "proxy")
	{
		$proxy_cont = '';

		$proxy_fp = @fsockopen($proxy_name, $proxy_port);
		if (!$proxy_fp)    
		{
			return false;
		}
	
		$userAgent = $_SERVER['HTTP_USER_AGENT'];
		fputs($proxy_fp, "GET $url  HTTP/1.0\r\nHost: $proxy_name\r\nUser-Agent: $userAgent\r\n");
		fputs($proxy_fp, "Proxy-Authorization: Basic " . base64_encode ("$proxy_user:$proxy_passWord") . "\r\n\r\n");
		while(!feof($proxy_fp)) 
		{
			$proxy_cont .= fread($proxy_fp,4096);
		}
		fclose($proxy_fp);
	}
	else
	{	
		$content = "";

		$parse_url = parse_url($url);
		$domain = '';
		$domain = $parse_url['host'];

		$fp = @fsockopen($domain,80,$errno, $errstr, 30);

		$resourcePath = "";
		$resourcePath = str_replace('http://','',$url);
		$resourcePath = str_replace($domain,'',$resourcePath);
		if($resourcePath == "")
		$resourcePath = "/";

		if (!$fp)
		{
			return false;
		}
		else
		{
			$useragent = $_SERVER['HTTP_USER_AGENT'];
			$requesT = "GET $resourcePath HTTP/1.0\r\n";
			$requesT .="User-Agent: $useragent\r\n";
			$requesT .= "Host: $domain\r\n";
			$requesT .= "Connection: Close\r\n\r\n";

			fwrite($fp, $requesT);
			while (!feof($fp))
			{
				$proxy_cont.=fgets($fp,4096);
			}
			fclose($fp);
		}
	}
		
   	$pattern = "/HTTP\/1.\\d* (\\d*) .*/i";
   	preg_match_all($pattern, $proxy_cont, $statusCode);

   	$headContent = $proxy_cont;	
   	$proxy_cont = substr($proxy_cont, strpos($proxy_cont,"\r\n\r\n")+4);

   	$result = array($statusCode[1][0],$proxy_cont,$headContent);
   	return $result;
}

/*********************************************************************

	Function Name : getRedirectContent

	Argument      : string
		      : string	
  
	Task          : To get the redirected URL

	Return        : Redirected URL

*********************************************************************/
function getRedirectContent($content,$url)
{
	$parts = parse_url($url);
        $url = "http://".$parts['host'];
        $pattern = "/Location:\s*([^\s]+)/i";
        preg_match($pattern, $content, $redirectionUrl);
        $parsedURL = parse_url($redirectionUrl[1]);
        if($parsedURL['host']=="")
        {
                $path = $parsedURL['path'];
                if($path[0]!="/")
                {
                         $redirectionUrl[1] = $url."/".$redirectionUrl[1];
                }
                else
                        $redirectionUrl[1] = $url.$redirectionUrl[1];
        }
        return $redirectionUrl;
}

/*********************************************************************

	Function Name : getURLContent

	Argument      : string
  
	Task          : To get the content of url with redirection handling

	Returns       : Status Code
		      : Content 	

*********************************************************************/

function getURLContent($url)
{
	if($url!= "")
	{
		$content = getContent($url);
		if($content[0]=="302" || $content[0]=="301" || $content[0]=="304" || $content[0]=="303")
		{
			$content = getRedirectContent($content[2],$url);
			print_r($content[2]);
			if($content[1]!="")
				$content = getContent($content[1]);
		}
	}
	return $content;
}

/*********************************************************************

	Function Name : getFileName

	Argument      : filename (string) 
  
	Task          : Move given file to the tmp directory

	Return        : New file name

*********************************************************************/
function getFileName($fileName)
{
	$newFileName='tmp/'.rand(1,1000).'.html';
        if(!@copy($fileName,$newFileName))
        {
                if(!@move_uploaded_file($fileName,$newFileName))
                {
                        $error = TRUE;
                        if(!empty($error_msg))
                        {
                                $error_msg .= '<br />';
                        }
                        $error_msg .= sprintf($lang['General_upload_error'], './' . $newFileName);
                        return;
                }
        }
        @chmod($newFileName, 0666);
	return $newFileName;
}
?>
