/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.utility;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Resource;
import net.sf.mpxj.Task;
import net.sf.mpxj.mpp.MPPReader;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MppClean {
    private ProjectFile m_project;
    private DirectoryEntry m_projectDir;

    public static void main(String[] args) {
        try {
            if (args.length != 2) {
                System.out.println("Usage: MppClean <input mpp file name> <output mpp file name>");
            } else {
                System.out.println("Clean started.");
                long start = System.currentTimeMillis();
                MppClean clean = new MppClean();
                clean.process(args[0], args[1]);
                long elapsed = System.currentTimeMillis() - start;
                System.out.println("Clean completed in " + elapsed + "ms");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void process(String input, String output) throws MPXJException, IOException {
        String varDataFileName;
        String projectDirName;
        MPPReader reader = new MPPReader();
        this.m_project = reader.read(input);
        switch (this.m_project.getMppFileType()) {
            case 8: {
                projectDirName = "   1";
                varDataFileName = "FixDeferFix   0";
                break;
            }
            case 9: {
                projectDirName = "   19";
                varDataFileName = "Var2Data";
                break;
            }
            case 12: {
                projectDirName = "   112";
                varDataFileName = "Var2Data";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported file type " + this.m_project.getMppFileType());
            }
        }
        FileInputStream is = new FileInputStream(input);
        POIFSFileSystem fs = new POIFSFileSystem((InputStream)is);
        is.close();
        DirectoryEntry root = fs.getRoot();
        this.m_projectDir = (DirectoryEntry)root.getEntry(projectDirName);
        HashMap<String, String> replacements = new HashMap<String, String>();
        for (Task task : this.m_project.getAllTasks()) {
            this.mapText(task.getName(), replacements);
        }
        this.processReplacements((DirectoryEntry)this.m_projectDir.getEntry("TBkndTask"), varDataFileName, replacements, true);
        replacements.clear();
        for (Resource resource : this.m_project.getAllResources()) {
            this.mapText(resource.getName(), replacements);
            this.mapText(resource.getInitials(), replacements);
        }
        this.processReplacements((DirectoryEntry)this.m_projectDir.getEntry("TBkndRsc"), varDataFileName, replacements, true);
        replacements.clear();
        ProjectHeader header = this.m_project.getProjectHeader();
        this.mapText(header.getProjectTitle(), replacements);
        this.processReplacements(this.m_projectDir, "Props", replacements, true);
        replacements.clear();
        this.mapText(header.getProjectTitle(), replacements);
        this.mapText(header.getSubject(), replacements);
        this.mapText(header.getAuthor(), replacements);
        this.mapText(header.getKeywords(), replacements);
        this.mapText(header.getComments(), replacements);
        this.processReplacements(root, "\u0005SummaryInformation", replacements, false);
        replacements.clear();
        this.mapText(header.getManager(), replacements);
        this.mapText(header.getCompany(), replacements);
        this.mapText(header.getCategory(), replacements);
        this.processReplacements(root, "\u0005DocumentSummaryInformation", replacements, false);
        FileOutputStream os = new FileOutputStream(output);
        fs.writeFilesystem((OutputStream)os);
        os.flush();
        os.close();
    }

    private void processReplacements(DirectoryEntry parentDirectory, String fileName, Map<String, String> replacements, boolean unicode) throws IOException {
        ArrayList<String> keys = new ArrayList<String>(replacements.keySet());
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        });
        DocumentEntry targetFile = (DocumentEntry)parentDirectory.getEntry(fileName);
        DocumentInputStream dis = new DocumentInputStream(targetFile);
        int dataSize = dis.available();
        byte[] data = new byte[dataSize];
        dis.read(data);
        for (String findText : keys) {
            String replaceText = replacements.get(findText);
            this.replaceData(data, findText, replaceText, unicode);
        }
        targetFile.delete();
        parentDirectory.createDocument(fileName, (InputStream)new ByteArrayInputStream(data));
    }

    private void mapText(String oldText, Map<String, String> replacements) {
        char c2 = '\u0000';
        if (oldText != null && oldText.length() != 0 && !replacements.containsKey(oldText)) {
            StringBuffer newText = new StringBuffer(oldText.length());
            for (int loop = 0; loop < oldText.length(); ++loop) {
                char c = oldText.charAt(loop);
                if (Character.isUpperCase(c)) {
                    newText.append('X');
                    continue;
                }
                if (Character.isLowerCase(c)) {
                    newText.append('x');
                    continue;
                }
                if (Character.isDigit(c)) {
                    newText.append('0');
                    continue;
                }
                if (Character.isLetter(c)) {
                    if (c2 == '\u0000') {
                        c2 = c;
                    }
                    newText.append(c2);
                    continue;
                }
                newText.append(c);
            }
            replacements.put(oldText, newText.toString());
        }
    }

    private void replaceData(byte[] data, String findText, String replaceText, boolean unicode) {
        boolean replaced = false;
        byte[] findBytes = this.getBytes(findText, unicode);
        byte[] replaceBytes = this.getBytes(replaceText, unicode);
        int endIndex = data.length - findBytes.length;
        for (int index = 0; index <= endIndex; ++index) {
            if (!this.compareBytes(findBytes, data, index)) continue;
            System.arraycopy(replaceBytes, 0, data, index, replaceBytes.length);
            index += replaceBytes.length;
            System.out.println(findText + " -> " + replaceText);
            replaced = true;
        }
        if (!replaced) {
            System.out.println("Failed to find " + findText);
        }
    }

    private byte[] getBytes(String value, boolean unicode) {
        byte[] result = null;
        if (unicode) {
            byte[] bytes;
            int start = 0;
            try {
                bytes = value.getBytes("UTF-16");
            }
            catch (UnsupportedEncodingException e) {
                bytes = value.getBytes();
            }
            if (bytes.length > 2 && bytes[0] == -2 && bytes[1] == -1) {
                start = 2;
            }
            result = new byte[bytes.length - start];
            for (int loop = start; loop < bytes.length - 1; loop += 2) {
                result[loop - start] = bytes[loop + 1];
                result[loop + 1 - start] = bytes[loop];
            }
        } else {
            result = new byte[value.length() + 1];
            System.arraycopy(value.getBytes(), 0, result, 0, value.length());
        }
        return result;
    }

    private boolean compareBytes(byte[] lhs, byte[] rhs, int rhsOffset) {
        boolean result = true;
        for (int loop = 0; loop < lhs.length; ++loop) {
            if (lhs[loop] == rhs[rhsOffset + loop]) continue;
            result = false;
            break;
        }
        return result;
    }
}

