/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.utility;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;

public final class DateUtility {
    private static final int DEFAULT_DST_SAVINGS = 3600000;
    private static boolean HAS_DST_SAVINGS;

    private DateUtility() {
    }

    public static Date getDayStartDate(Date date) {
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            date = cal.getTime();
        }
        return date;
    }

    public static Date getDayEndDate(Date date) {
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.set(14, 999);
            cal.set(13, 59);
            cal.set(12, 59);
            cal.set(11, 23);
            date = cal.getTime();
        }
        return date;
    }

    public static Date getCanonicalTime(Date date) {
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.set(6, 1);
            cal.set(1, 1);
            date = cal.getTime();
        }
        return date;
    }

    public static int compare(Date startDate, Date endDate, Date targetDate) {
        return DateUtility.compare(startDate, endDate, targetDate.getTime());
    }

    public static int compare(Date startDate, Date endDate, long targetDate) {
        int result = 0;
        if (targetDate < startDate.getTime()) {
            result = -1;
        } else if (targetDate > endDate.getTime()) {
            result = 1;
        }
        return result;
    }

    public static int compare(Date d1, Date d2) {
        long diff;
        int result = d1 == null || d2 == null ? (d1 == d2 ? 0 : (d1 == null ? 1 : -1)) : ((diff = d1.getTime() - d2.getTime()) == 0L ? 0 : (diff > 0L ? 1 : -1));
        return result;
    }

    public static Duration getVariance(Task task, Date date1, Date date2, TimeUnit format) {
        Duration variance = null;
        if (date1 != null & date2 != null) {
            ProjectCalendar calendar = task.getCalendar();
            if (calendar == null) {
                ProjectFile file = task.getParentFile();
                calendar = file.getBaseCalendar(file.getProjectHeader().getCalendarName());
            }
            if (calendar != null) {
                variance = calendar.getWork(date1, date2, format);
            }
        }
        if (variance == null) {
            variance = Duration.getInstance(0, format);
        }
        return variance;
    }

    public static Date getDateFromLong(long date) {
        TimeZone tz = TimeZone.getDefault();
        return new Date(date - (long)tz.getRawOffset());
    }

    public static Date getTimestampFromLong(long timestamp) {
        Date result;
        TimeZone tz = TimeZone.getDefault();
        if (tz.inDaylightTime(result = new Date(timestamp - (long)tz.getRawOffset()))) {
            int savings = HAS_DST_SAVINGS ? tz.getDSTSavings() : 3600000;
            result = new Date(result.getTime() - (long)savings);
        }
        return result;
    }

    public static Date getTime(int hour, int minutes) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, hour);
        cal.set(12, minutes);
        cal.set(13, 0);
        return cal.getTime();
    }

    static {
        Class<TimeZone> tz = TimeZone.class;
        try {
            tz.getMethod("getDSTSavings", null);
            HAS_DST_SAVINGS = true;
        }
        catch (NoSuchMethodException ex) {
            HAS_DST_SAVINGS = false;
        }
    }
}

