/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.planner;

import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.planner.schema.Allocation;
import net.sf.mpxj.planner.schema.Allocations;
import net.sf.mpxj.planner.schema.Calendar;
import net.sf.mpxj.planner.schema.Calendars;
import net.sf.mpxj.planner.schema.Constraint;
import net.sf.mpxj.planner.schema.Days;
import net.sf.mpxj.planner.schema.DefaultWeek;
import net.sf.mpxj.planner.schema.Interval;
import net.sf.mpxj.planner.schema.OverriddenDayType;
import net.sf.mpxj.planner.schema.OverriddenDayTypes;
import net.sf.mpxj.planner.schema.Predecessor;
import net.sf.mpxj.planner.schema.Predecessors;
import net.sf.mpxj.planner.schema.Project;
import net.sf.mpxj.planner.schema.Resources;
import net.sf.mpxj.planner.schema.Tasks;
import net.sf.mpxj.reader.AbstractProjectReader;
import net.sf.mpxj.utility.NumberUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class PlannerReader
extends AbstractProjectReader {
    private ProjectFile m_projectFile;
    private ProjectCalendar m_defaultCalendar;
    private NumberFormat m_twoDigitFormat = new DecimalFormat("00");
    private NumberFormat m_fourDigitFormat = new DecimalFormat("0000");
    private List<DateRange> m_defaultWorkingHours = new LinkedList<DateRange>();
    private static Map<String, RelationType> RELATIONSHIP_TYPES = new HashMap<String, RelationType>();

    public ProjectFile read(InputStream stream) throws MPXJException {
        try {
            this.m_projectFile = new ProjectFile();
            this.m_projectFile.setAutoCalendarUniqueID(true);
            this.m_projectFile.setAutoResourceID(true);
            this.m_projectFile.setAutoTaskID(true);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(stream);
            JAXBContext context = JAXBContext.newInstance((String)"net.sf.mpxj.planner.schema");
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Project plannerProject = (Project)unmarshaller.unmarshal((Node)doc);
            this.readProjectHeader(plannerProject);
            this.readCalendars(plannerProject);
            this.readResources(plannerProject);
            this.readTasks(plannerProject);
            this.readAssignments(plannerProject);
            this.m_projectFile.updateUniqueCounters();
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (ParserConfigurationException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        catch (JAXBException ex) {
            throw new MPXJException("Failed to parse file", (Exception)((Object)ex));
        }
        catch (SAXException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        catch (IOException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        finally {
            this.m_projectFile = null;
            this.m_defaultCalendar = null;
        }
    }

    private void readProjectHeader(Project project) throws MPXJException {
        ProjectHeader header = this.m_projectFile.getProjectHeader();
        header.setCompany(project.getCompany());
        header.setManager(project.getManager());
        header.setName(project.getName());
        header.setStartDate(this.getDateTime(project.getProjectStart()));
    }

    private void readCalendars(Project project) throws MPXJException {
        Calendars calendars = project.getCalendars();
        if (calendars != null) {
            for (Calendar cal : calendars.getCalendar()) {
                this.readCalendar(cal, null);
            }
            Integer defaultCalendarID = this.getInteger(project.getCalendar());
            this.m_defaultCalendar = this.m_projectFile.getBaseCalendarByUniqueID(defaultCalendarID);
            if (this.m_defaultCalendar != null) {
                this.m_projectFile.getProjectHeader().setCalendarName(this.m_defaultCalendar.getName());
            }
        }
    }

    private void readCalendar(Calendar plannerCalendar, ProjectCalendar parentMpxjCalendar) throws MPXJException {
        ProjectCalendar mpxjCalendar = parentMpxjCalendar == null ? this.m_projectFile.addBaseCalendar() : this.m_projectFile.addResourceCalendar();
        mpxjCalendar.setUniqueID(this.getInteger(plannerCalendar.getId()));
        mpxjCalendar.setName(plannerCalendar.getName());
        mpxjCalendar.setBaseCalendar(parentMpxjCalendar);
        DefaultWeek dw = plannerCalendar.getDefaultWeek();
        this.setWorkingDay(mpxjCalendar, Day.MONDAY, dw.getMon());
        this.setWorkingDay(mpxjCalendar, Day.TUESDAY, dw.getTue());
        this.setWorkingDay(mpxjCalendar, Day.WEDNESDAY, dw.getWed());
        this.setWorkingDay(mpxjCalendar, Day.THURSDAY, dw.getThu());
        this.setWorkingDay(mpxjCalendar, Day.FRIDAY, dw.getFri());
        this.setWorkingDay(mpxjCalendar, Day.SATURDAY, dw.getSat());
        this.setWorkingDay(mpxjCalendar, Day.SUNDAY, dw.getSun());
        this.processWorkingHours(mpxjCalendar, plannerCalendar);
        this.processExceptionDays(mpxjCalendar, plannerCalendar);
        List<Calendar> calendarList = plannerCalendar.getCalendar();
        if (calendarList != null) {
            for (Calendar cal : calendarList) {
                this.readCalendar(cal, mpxjCalendar);
            }
        }
    }

    private void setWorkingDay(ProjectCalendar mpxjCalendar, Day mpxjDay, String plannerDay) {
        int dayType = 2;
        if (plannerDay != null) {
            switch (this.getInt(plannerDay)) {
                case 0: {
                    dayType = 1;
                    break;
                }
                case 1: {
                    dayType = 0;
                }
            }
        }
        mpxjCalendar.setWorkingDay(mpxjDay, dayType);
    }

    private void processWorkingHours(ProjectCalendar mpxjCalendar, Calendar plannerCalendar) throws MPXJException {
        List<OverriddenDayType> typeList;
        OverriddenDayTypes types = plannerCalendar.getOverriddenDayTypes();
        if (types != null && (typeList = types.getOverriddenDayType()) != null) {
            List<Interval> intervalList;
            Iterator<OverriddenDayType> iter = typeList.iterator();
            OverriddenDayType odt = null;
            while (iter.hasNext() && this.getInt((odt = iter.next()).getId()) != 0) {
                odt = null;
            }
            if (odt != null && (intervalList = odt.getInterval()) != null) {
                ProjectCalendarHours mondayHours = null;
                ProjectCalendarHours tuesdayHours = null;
                ProjectCalendarHours wednesdayHours = null;
                ProjectCalendarHours thursdayHours = null;
                ProjectCalendarHours fridayHours = null;
                ProjectCalendarHours saturdayHours = null;
                ProjectCalendarHours sundayHours = null;
                if (mpxjCalendar.isWorkingDay(Day.MONDAY)) {
                    mondayHours = mpxjCalendar.addCalendarHours(Day.MONDAY);
                }
                if (mpxjCalendar.isWorkingDay(Day.TUESDAY)) {
                    tuesdayHours = mpxjCalendar.addCalendarHours(Day.TUESDAY);
                }
                if (mpxjCalendar.isWorkingDay(Day.WEDNESDAY)) {
                    wednesdayHours = mpxjCalendar.addCalendarHours(Day.WEDNESDAY);
                }
                if (mpxjCalendar.isWorkingDay(Day.THURSDAY)) {
                    thursdayHours = mpxjCalendar.addCalendarHours(Day.THURSDAY);
                }
                if (mpxjCalendar.isWorkingDay(Day.FRIDAY)) {
                    fridayHours = mpxjCalendar.addCalendarHours(Day.FRIDAY);
                }
                if (mpxjCalendar.isWorkingDay(Day.SATURDAY)) {
                    saturdayHours = mpxjCalendar.addCalendarHours(Day.SATURDAY);
                }
                if (mpxjCalendar.isWorkingDay(Day.SUNDAY)) {
                    sundayHours = mpxjCalendar.addCalendarHours(Day.SUNDAY);
                }
                for (Interval interval : intervalList) {
                    Date startTime = this.getTime(interval.getStart());
                    Date endTime = this.getTime(interval.getEnd());
                    this.m_defaultWorkingHours.add(new DateRange(startTime, endTime));
                    if (mondayHours != null) {
                        mondayHours.addDateRange(new DateRange(startTime, endTime));
                    }
                    if (tuesdayHours != null) {
                        tuesdayHours.addDateRange(new DateRange(startTime, endTime));
                    }
                    if (wednesdayHours != null) {
                        wednesdayHours.addDateRange(new DateRange(startTime, endTime));
                    }
                    if (thursdayHours != null) {
                        thursdayHours.addDateRange(new DateRange(startTime, endTime));
                    }
                    if (fridayHours != null) {
                        fridayHours.addDateRange(new DateRange(startTime, endTime));
                    }
                    if (saturdayHours != null) {
                        saturdayHours.addDateRange(new DateRange(startTime, endTime));
                    }
                    if (sundayHours == null) continue;
                    sundayHours.addDateRange(new DateRange(startTime, endTime));
                }
            }
        }
    }

    private void processExceptionDays(ProjectCalendar mpxjCalendar, Calendar plannerCalendar) throws MPXJException {
        List<net.sf.mpxj.planner.schema.Day> dayList;
        Days days = plannerCalendar.getDays();
        if (days != null && (dayList = days.getDay()) != null) {
            for (net.sf.mpxj.planner.schema.Day day : dayList) {
                DateRange range;
                if (!day.getType().equals("day-type")) continue;
                Date exceptionDate = this.getDate(day.getDate());
                ProjectCalendarException exception = mpxjCalendar.addCalendarException();
                exception.setFromDate(exceptionDate);
                exception.setToDate(exceptionDate);
                exception.setWorking(this.getInt(day.getId()) == 0);
                if (!exception.getWorking()) continue;
                if (this.m_defaultWorkingHours.size() > 0) {
                    range = this.m_defaultWorkingHours.get(0);
                    exception.setFromTime1(range.getStartDate());
                    exception.setToTime1(range.getEndDate());
                }
                if (this.m_defaultWorkingHours.size() > 1) {
                    range = this.m_defaultWorkingHours.get(1);
                    exception.setFromTime2(range.getStartDate());
                    exception.setToTime2(range.getEndDate());
                }
                if (this.m_defaultWorkingHours.size() > 2) {
                    range = this.m_defaultWorkingHours.get(2);
                    exception.setFromTime3(range.getStartDate());
                    exception.setToTime3(range.getEndDate());
                }
                if (this.m_defaultWorkingHours.size() > 3) {
                    range = this.m_defaultWorkingHours.get(3);
                    exception.setFromTime4(range.getStartDate());
                    exception.setToTime4(range.getEndDate());
                }
                if (this.m_defaultWorkingHours.size() <= 4) continue;
                range = this.m_defaultWorkingHours.get(4);
                exception.setFromTime5(range.getStartDate());
                exception.setToTime5(range.getEndDate());
            }
        }
    }

    private void readResources(Project plannerProject) throws MPXJException {
        Resources resources = plannerProject.getResources();
        if (resources != null) {
            for (net.sf.mpxj.planner.schema.Resource res : resources.getResource()) {
                this.readResource(res);
            }
        }
    }

    private void readResource(net.sf.mpxj.planner.schema.Resource plannerResource) throws MPXJException {
        Resource mpxjResource = this.m_projectFile.addResource();
        mpxjResource.setEmailAddress(plannerResource.getEmail());
        mpxjResource.setUniqueID(this.getInteger(plannerResource.getId()));
        mpxjResource.setName(plannerResource.getName());
        mpxjResource.setNotes(plannerResource.getNote());
        mpxjResource.setInitials(plannerResource.getShortName());
        mpxjResource.setType(this.getInt(plannerResource.getType()) == 2 ? ResourceType.MATERIAL : ResourceType.WORK);
        ProjectCalendar calendar = mpxjResource.addResourceCalendar();
        calendar.setWorkingDay(Day.SUNDAY, 2);
        calendar.setWorkingDay(Day.MONDAY, 2);
        calendar.setWorkingDay(Day.TUESDAY, 2);
        calendar.setWorkingDay(Day.WEDNESDAY, 2);
        calendar.setWorkingDay(Day.THURSDAY, 2);
        calendar.setWorkingDay(Day.FRIDAY, 2);
        calendar.setWorkingDay(Day.SATURDAY, 2);
        ProjectCalendar baseCalendar = this.m_projectFile.getBaseCalendarByUniqueID(this.getInteger(plannerResource.getCalendar()));
        if (baseCalendar == null) {
            baseCalendar = this.m_defaultCalendar;
        }
        calendar.setBaseCalendar(baseCalendar);
        this.m_projectFile.fireResourceReadEvent(mpxjResource);
    }

    private void readTasks(Project plannerProject) throws MPXJException {
        Tasks tasks = plannerProject.getTasks();
        if (tasks != null) {
            for (net.sf.mpxj.planner.schema.Task task : tasks.getTask()) {
                this.readTask(null, task);
            }
            for (net.sf.mpxj.planner.schema.Task task : tasks.getTask()) {
                this.readPredecessors(task);
            }
        }
        this.m_projectFile.updateStructure();
    }

    private void readTask(Task parentTask, net.sf.mpxj.planner.schema.Task plannerTask) throws MPXJException {
        Task mpxjTask;
        if (parentTask == null) {
            mpxjTask = this.m_projectFile.addTask();
            mpxjTask.setOutlineLevel(new Integer(1));
        } else {
            mpxjTask = parentTask.addTask();
            mpxjTask.setOutlineLevel(new Integer(parentTask.getOutlineLevel() + 1));
        }
        Integer percentComplete = this.getInteger(plannerTask.getPercentComplete());
        mpxjTask.setFinish(this.getDateTime(plannerTask.getEnd()));
        mpxjTask.setUniqueID(this.getInteger(plannerTask.getId()));
        mpxjTask.setName(plannerTask.getName());
        mpxjTask.setNotes(plannerTask.getNote());
        mpxjTask.setPercentageComplete(percentComplete);
        mpxjTask.setPercentageWorkComplete(percentComplete);
        mpxjTask.setPriority(Priority.getInstance(this.getInt(plannerTask.getPriority()) / 10));
        mpxjTask.setType(this.getTaskType(plannerTask.getScheduling()));
        mpxjTask.setMilestone(plannerTask.getType().equals("milestone"));
        mpxjTask.setWork(this.getDuration(plannerTask.getWork()));
        mpxjTask.setStart(this.getDateTime(plannerTask.getWorkStart()));
        ConstraintType mpxjConstraintType = ConstraintType.AS_SOON_AS_POSSIBLE;
        Constraint constraint = plannerTask.getConstraint();
        if (constraint != null) {
            if (constraint.getType().equals("start-no-earlier-than")) {
                mpxjConstraintType = ConstraintType.START_NO_EARLIER_THAN;
            } else if (constraint.getType().equals("must-start-on")) {
                mpxjConstraintType = ConstraintType.MUST_START_ON;
            }
            mpxjTask.setConstraintDate(this.getDateTime(constraint.getTime()));
        }
        mpxjTask.setConstraintType(mpxjConstraintType);
        String calendarName = this.m_projectFile.getProjectHeader().getCalendarName();
        ProjectCalendar calendar = this.m_projectFile.getBaseCalendar(calendarName);
        Duration duration = calendar.getWork(mpxjTask.getStart(), mpxjTask.getFinish(), TimeUnit.HOURS);
        double durationDays = duration.getDuration() / 8.0;
        if (durationDays > 0.0) {
            duration = Duration.getInstance(durationDays, TimeUnit.DAYS);
        }
        mpxjTask.setDuration(duration);
        if (percentComplete != 0) {
            mpxjTask.setActualStart(mpxjTask.getStart());
            if (percentComplete == 100) {
                mpxjTask.setActualFinish(mpxjTask.getFinish());
                mpxjTask.setActualDuration(duration);
                mpxjTask.setActualWork(mpxjTask.getWork());
                mpxjTask.setRemainingWork(Duration.getInstance(0, TimeUnit.HOURS));
            } else {
                Duration work = mpxjTask.getWork();
                Duration actualWork = Duration.getInstance(work.getDuration() * percentComplete.doubleValue() / 100.0, work.getUnits());
                mpxjTask.setActualDuration(Duration.getInstance(duration.getDuration() * percentComplete.doubleValue() / 100.0, duration.getUnits()));
                mpxjTask.setActualWork(actualWork);
                mpxjTask.setRemainingWork(Duration.getInstance(work.getDuration() - actualWork.getDuration(), work.getUnits()));
            }
        }
        mpxjTask.setEffortDriven(true);
        this.m_projectFile.fireTaskReadEvent(mpxjTask);
        List<net.sf.mpxj.planner.schema.Task> childTasks = plannerTask.getTask();
        if (childTasks != null) {
            for (net.sf.mpxj.planner.schema.Task childTask : childTasks) {
                this.readTask(mpxjTask, childTask);
            }
        }
    }

    private void readPredecessors(net.sf.mpxj.planner.schema.Task plannerTask) {
        List<net.sf.mpxj.planner.schema.Task> childTasks;
        List<Predecessor> predecessorList;
        Task mpxjTask = this.m_projectFile.getTaskByUniqueID(this.getInteger(plannerTask.getId()));
        Predecessors predecessors = plannerTask.getPredecessors();
        if (predecessors != null && (predecessorList = predecessors.getPredecessor()) != null) {
            for (Predecessor predecessor : predecessorList) {
                Integer predecessorID = this.getInteger(predecessor.getPredecessorId());
                Task predecessorTask = this.m_projectFile.getTaskByUniqueID(predecessorID);
                if (predecessorTask == null) continue;
                Duration lag = this.getDuration(predecessor.getLag());
                if (lag == null) {
                    lag = Duration.getInstance(0, TimeUnit.HOURS);
                }
                Relation relationship = mpxjTask.addPredecessor(predecessorTask);
                relationship.setDuration(lag);
                relationship.setType(RELATIONSHIP_TYPES.get(predecessor.getType()));
            }
        }
        if ((childTasks = plannerTask.getTask()) != null) {
            for (net.sf.mpxj.planner.schema.Task childTask : childTasks) {
                this.readPredecessors(childTask);
            }
        }
    }

    private void readAssignments(Project plannerProject) {
        Allocations allocations = plannerProject.getAllocations();
        List<Allocation> allocationList = allocations.getAllocation();
        if (allocationList != null) {
            Duration actualWork;
            Duration work;
            HashSet<Task> tasksWithAssignments = new HashSet<Task>();
            for (Allocation allocation : allocationList) {
                Integer taskID = this.getInteger(allocation.getTaskId());
                Integer resourceID = this.getInteger(allocation.getResourceId());
                Integer units = this.getInteger(allocation.getUnits());
                Task task = this.m_projectFile.getTaskByUniqueID(taskID);
                Resource resource = this.m_projectFile.getResourceByUniqueID(resourceID);
                if (task == null || resource == null) continue;
                work = task.getWork();
                int percentComplete = NumberUtility.getInt(task.getPercentageComplete());
                ResourceAssignment assignment = task.addResourceAssignment(resource);
                assignment.setUnits(units);
                assignment.setWork(work);
                if (percentComplete != 0) {
                    actualWork = Duration.getInstance(work.getDuration() * (double)percentComplete / 100.0, work.getUnits());
                    assignment.setActualWork(actualWork);
                    assignment.setRemainingWork(Duration.getInstance(work.getDuration() - actualWork.getDuration(), work.getUnits()));
                } else {
                    assignment.setRemainingWork(work);
                }
                assignment.setStart(task.getStart());
                assignment.setFinish(task.getFinish());
                tasksWithAssignments.add(task);
            }
            for (Task task : tasksWithAssignments) {
                List<ResourceAssignment> assignments = task.getResourceAssignments();
                if (assignments.size() <= 1) continue;
                double maxUnits = 0.0;
                for (ResourceAssignment assignment : assignments) {
                    maxUnits += assignment.getUnits().doubleValue();
                }
                for (ResourceAssignment assignment : assignments) {
                    Duration remainingWork;
                    work = assignment.getWork();
                    double factor = assignment.getUnits().doubleValue() / maxUnits;
                    work = Duration.getInstance(work.getDuration() * factor, work.getUnits());
                    assignment.setWork(work);
                    actualWork = assignment.getActualWork();
                    if (actualWork != null) {
                        actualWork = Duration.getInstance(actualWork.getDuration() * factor, actualWork.getUnits());
                        assignment.setActualWork(actualWork);
                    }
                    if ((remainingWork = assignment.getRemainingWork()) == null) continue;
                    remainingWork = Duration.getInstance(remainingWork.getDuration() * factor, remainingWork.getUnits());
                    assignment.setRemainingWork(remainingWork);
                }
            }
        }
    }

    private Date getDateTime(String value) throws MPXJException {
        try {
            Number year = this.m_fourDigitFormat.parse(value.substring(0, 4));
            Number month = this.m_twoDigitFormat.parse(value.substring(4, 6));
            Number day = this.m_twoDigitFormat.parse(value.substring(6, 8));
            Number hours = this.m_twoDigitFormat.parse(value.substring(9, 11));
            Number minutes = this.m_twoDigitFormat.parse(value.substring(11, 13));
            java.util.Calendar cal = java.util.Calendar.getInstance();
            cal.set(1, year.intValue());
            cal.set(2, month.intValue() - 1);
            cal.set(5, day.intValue());
            cal.set(11, hours.intValue());
            cal.set(12, minutes.intValue());
            cal.set(13, 0);
            cal.set(14, 0);
            return cal.getTime();
        }
        catch (ParseException ex) {
            throw new MPXJException("Failed to parse date-time " + value, ex);
        }
    }

    private Date getDate(String value) throws MPXJException {
        try {
            Number year = this.m_fourDigitFormat.parse(value.substring(0, 4));
            Number month = this.m_twoDigitFormat.parse(value.substring(4, 6));
            Number day = this.m_twoDigitFormat.parse(value.substring(6, 8));
            java.util.Calendar cal = java.util.Calendar.getInstance();
            cal.set(1, year.intValue());
            cal.set(2, month.intValue() - 1);
            cal.set(5, day.intValue());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            return cal.getTime();
        }
        catch (ParseException ex) {
            throw new MPXJException("Failed to parse date " + value, ex);
        }
    }

    private Date getTime(String value) throws MPXJException {
        try {
            Number hours = this.m_twoDigitFormat.parse(value.substring(0, 2));
            Number minutes = this.m_twoDigitFormat.parse(value.substring(2, 4));
            java.util.Calendar cal = java.util.Calendar.getInstance();
            cal.set(11, hours.intValue());
            cal.set(12, minutes.intValue());
            cal.set(13, 0);
            cal.set(14, 0);
            return cal.getTime();
        }
        catch (ParseException ex) {
            throw new MPXJException("Failed to parse time " + value, ex);
        }
    }

    private Integer getInteger(String value) {
        return NumberUtility.getInteger(value);
    }

    private int getInt(String value) {
        return Integer.parseInt(value);
    }

    private long getLong(String value) {
        return Long.parseLong(value);
    }

    private TaskType getTaskType(String value) {
        TaskType result = TaskType.FIXED_UNITS;
        if (value != null && value.equals("fixed-duration")) {
            result = TaskType.FIXED_DURATION;
        }
        return result;
    }

    private Duration getDuration(String value) {
        Duration result = null;
        if (value != null && value.length() != 0) {
            double seconds = this.getLong(value);
            double hours = seconds / 3600.0;
            double days = hours / 8.0;
            if (days < 1.0) {
                result = Duration.getInstance(hours, TimeUnit.HOURS);
            } else {
                double durationDays = hours / 8.0;
                result = Duration.getInstance(durationDays, TimeUnit.DAYS);
            }
        }
        return result;
    }

    static {
        RELATIONSHIP_TYPES.put("FF", RelationType.FINISH_FINISH);
        RELATIONSHIP_TYPES.put("FS", RelationType.FINISH_START);
        RELATIONSHIP_TYPES.put("SF", RelationType.START_FINISH);
        RELATIONSHIP_TYPES.put("SS", RelationType.START_START);
    }
}

