/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.EnumSet;
import java.util.Iterator;
import net.sf.mpxj.utility.MpxjEnum;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TimescaleUnits implements MpxjEnum
{
    NONE(-1, "None"),
    MINUTES(0, "Minutes"),
    HOURS(1, "Hours"),
    DAYS(2, "Days"),
    WEEKS(3, "Weeks"),
    THIRDS_OF_MONTHS(4, "Thirds of Months"),
    MONTHS(5, "Months"),
    QUARTERS(6, "Quarters"),
    HALF_YEARS(7, "Half Years"),
    YEARS(8, "Years");

    private static final TimescaleUnits[] TYPE_VALUES;
    private int m_value;
    private String m_name;

    private TimescaleUnits(int type, String name) {
        this.m_value = type;
        this.m_name = name;
    }

    public static TimescaleUnits getInstance(int type) {
        TimescaleUnits result = type < 0 || type >= TYPE_VALUES.length ? NONE : TYPE_VALUES[type];
        return result;
    }

    public static TimescaleUnits getInstance(Number type) {
        int value = type == null ? -1 : NumberUtility.getInt(type);
        return TimescaleUnits.getInstance(value);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    public String getName() {
        return this.m_name;
    }

    public String toString() {
        return this.getName();
    }

    static {
        TYPE_VALUES = new TimescaleUnits[9];
        Iterator i$ = EnumSet.range(MINUTES, YEARS).iterator();
        while (i$.hasNext()) {
            TimescaleUnits e;
            TimescaleUnits.TYPE_VALUES[e.getValue()] = e = (TimescaleUnits)i$.next();
        }
    }
}

