/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.utility.NumberUtility;
import org.apache.poi.hpsf.Property;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.Section;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SummaryInformation {
    private String m_projectTitle;
    private String m_subject;
    private String m_author;
    private String m_keywords;
    private String m_comments;
    private Integer m_revision;
    private String m_category;
    private String m_manager;
    private String m_company;
    private HashMap<Integer, Object> m_documentSummaryInformation;
    private static final Integer PROJECT_TITLE = new Integer(102);
    private static final Integer SUBJECT = new Integer(103);
    private static final Integer AUTHOR = new Integer(104);
    private static final Integer KEYWORDS = new Integer(105);
    private static final Integer COMMENTS = new Integer(106);
    private static final Integer REVISION_NUMBER = new Integer(109);
    private static final Integer CATEGORY = new Integer(102);
    private static final Integer MANAGER = new Integer(114);
    private static final Integer COMPANY = new Integer(115);

    public SummaryInformation(DirectoryEntry rootDir) throws MPXJException {
        try {
            PropertySet ps = new PropertySet((InputStream)new DocumentInputStream((DocumentEntry)rootDir.getEntry("\u0005SummaryInformation")));
            HashMap<Integer, Object> map = this.getPropertyMap(ps);
            this.m_projectTitle = (String)map.get(PROJECT_TITLE);
            this.m_subject = (String)map.get(SUBJECT);
            this.m_author = (String)map.get(AUTHOR);
            this.m_keywords = (String)map.get(KEYWORDS);
            this.m_comments = (String)map.get(COMMENTS);
            this.m_revision = NumberUtility.parseInteger((String)map.get(REVISION_NUMBER));
            ps = new PropertySet((InputStream)new DocumentInputStream((DocumentEntry)rootDir.getEntry("\u0005DocumentSummaryInformation")));
            map = this.getPropertyMap(ps);
            this.m_category = (String)map.get(CATEGORY);
            this.m_company = (String)map.get(COMPANY);
            this.m_manager = (String)map.get(MANAGER);
            this.m_documentSummaryInformation = map;
        }
        catch (Exception ex) {
            throw new MPXJException("Error reading file", ex);
        }
    }

    private HashMap<Integer, Object> getPropertyMap(PropertySet ps) {
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        List sections = ps.getSections();
        int index = 100;
        for (Section section : sections) {
            Property[] properties = section.getProperties();
            for (int loop = 0; loop < properties.length; ++loop) {
                Property property = properties[loop];
                map.put(new Integer(index + (int)property.getID()), property.getValue());
            }
            index += 100;
        }
        return map;
    }

    public String getAuthor() {
        return this.m_author;
    }

    public String getComments() {
        return this.m_comments;
    }

    public String getCompany() {
        return this.m_company;
    }

    public String getKeywords() {
        return this.m_keywords;
    }

    public String getManager() {
        return this.m_manager;
    }

    public String getProjectTitle() {
        return this.m_projectTitle;
    }

    public String getSubject() {
        return this.m_subject;
    }

    public String getCategory() {
        return this.m_category;
    }

    public Integer getRevision() {
        return this.m_revision;
    }

    public Map<Integer, Object> getDocumentSummaryInformation() {
        return this.m_documentSummaryInformation;
    }
}

