/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Set;
import java.util.TreeMap;
import net.sf.mpxj.mpp.MPPComponent;
import net.sf.mpxj.mpp.MPPUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Props
extends MPPComponent {
    public static final Integer PROJECT_START_DATE = new Integer(0x2400002);
    public static final Integer PROJECT_FINISH_DATE = new Integer(37748739);
    public static final Integer SCHEDULE_FROM = new Integer(0x2400004);
    public static final Integer DEFAULT_CALENDAR_NAME = new Integer(37748750);
    public static final Integer CURRENCY_SYMBOL = new Integer(37748752);
    public static final Integer CURRENCY_PLACEMENT = new Integer(37748753);
    public static final Integer CURRENCY_DIGITS = new Integer(37748754);
    public static final Integer DURATION_UNITS = new Integer(37748757);
    public static final Integer WORK_UNITS = new Integer(37748758);
    public static final Integer TASK_UPDATES_RESOURCE = new Integer(37748761);
    public static final Integer SPLIT_TASKS = new Integer(37748762);
    public static final Integer START_TIME = new Integer(37748764);
    public static final Integer MINUTES_PER_DAY = new Integer(37748765);
    public static final Integer MINUTES_PER_WEEK = new Integer(37748766);
    public static final Integer STANDARD_RATE = new Integer(37748767);
    public static final Integer OVERTIME_RATE = new Integer(0x2400020);
    public static final Integer END_TIME = new Integer(37748769);
    public static final Integer CALCULATE_MULTIPLE_CRITICAL_PATHS = new Integer(37748793);
    public static final Integer TASK_FIELD_NAME_ALIASES = new Integer(0x100001);
    public static final Integer RESOURCE_FIELD_NAME_ALIASES = new Integer(0x100002);
    public static final Integer TASK_FIELD_CUSTOM_VALUE_LISTS = new Integer(37753744);
    public static final Integer PASSWORD_FLAG = new Integer(893386752);
    public static final Integer PROTECTION_PASSWORD_HASH = new Integer(893386756);
    public static final Integer WRITE_RESERVATION_PASSWORD_HASH = new Integer(893386757);
    public static final Integer ENCRYPTION_CODE = new Integer(893386759);
    public static final Integer STATUS_DATE = new Integer(37748805);
    public static final Integer SUBPROJECT_COUNT = new Integer(37748868);
    public static final Integer SUBPROJECT_DATA = new Integer(37748898);
    public static final Integer SUBPROJECT_TASK_COUNT = new Integer(37748900);
    public static final Integer GRAPHICAL_INDICATOR_DATA = new Integer(37753744);
    public static final Integer FONT_BASES = new Integer(0x3400000);
    public static final Integer AUTO_FILTER = new Integer(893386767);
    public static final Integer PROJECT_FILE_PATH = new Integer(893386760);
    protected TreeMap<Integer, byte[]> m_map = new TreeMap();

    Props() {
    }

    public byte[] getByteArray(Integer type) {
        return this.m_map.get(type);
    }

    public byte getByte(Integer type) {
        byte result = 0;
        byte[] item = this.m_map.get(type);
        if (item != null) {
            result = item[0];
        }
        return result;
    }

    public int getShort(Integer type) {
        int result = 0;
        byte[] item = this.m_map.get(type);
        if (item != null) {
            result = MPPUtility.getShort(item);
        }
        return result;
    }

    public int getInt(Integer type) {
        int result = 0;
        byte[] item = this.m_map.get(type);
        if (item != null) {
            result = MPPUtility.getInt(item);
        }
        return result;
    }

    public double getDouble(Integer type) {
        double result = 0.0;
        byte[] item = this.m_map.get(type);
        if (item != null) {
            result = MPPUtility.getDouble(item);
        }
        return result;
    }

    public Date getTime(Integer type) {
        Date result = null;
        byte[] item = this.m_map.get(type);
        if (item != null) {
            result = MPPUtility.getTime(item);
        }
        return result;
    }

    public Date getTimestamp(Integer type) {
        Date result = null;
        byte[] item = this.m_map.get(type);
        if (item != null) {
            result = MPPUtility.getTimestamp(item);
        }
        return result;
    }

    public boolean getBoolean(Integer type) {
        boolean result = false;
        byte[] item = this.m_map.get(type);
        if (item != null) {
            result = MPPUtility.getShort(item) != 0;
        }
        return result;
    }

    public String getUnicodeString(Integer type) {
        String result = null;
        byte[] item = this.m_map.get(type);
        if (item != null) {
            result = MPPUtility.getUnicodeString(item);
        }
        return result;
    }

    public Date getDate(Integer type) {
        Date result = null;
        byte[] item = this.m_map.get(type);
        if (item != null) {
            result = MPPUtility.getDate(item, 0);
        }
        return result;
    }

    public Set<Integer> keySet() {
        return this.m_map.keySet();
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("BEGIN Props");
        for (Integer key : this.m_map.keySet()) {
            pw.println("   Key: " + key + " Value: ");
            pw.println(MPPUtility.hexdump(this.m_map.get(key), true, 16, "      "));
        }
        pw.println("END Props");
        pw.println();
        pw.close();
        return sw.toString();
    }
}

