/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpd;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.Task;
import net.sf.mpxj.mpd.MPD9AbstractReader;
import net.sf.mpxj.mpd.ResultSetRow;
import net.sf.mpxj.mpd.Row;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MPD9DatabaseReader
extends MPD9AbstractReader {
    private DataSource m_dataSource;
    private boolean m_allocatedConnection;
    private Connection m_connection;
    private PreparedStatement m_ps;
    private ResultSet m_rs;
    private Map<String, Integer> m_meta = new HashMap<String, Integer>();

    public ProjectFile read() throws MPXJException {
        try {
            this.m_project = new ProjectFile();
            this.processProjectHeader();
            this.processCalendars();
            this.processResources();
            this.processTasks();
            this.processLinks();
            this.processAssignments();
            this.processExtendedAttributes();
            this.processSubProjects();
            this.postProcessing();
            ProjectFile projectFile = this.m_project;
            return projectFile;
        }
        catch (SQLException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        finally {
            if (this.m_allocatedConnection && this.m_connection != null) {
                try {
                    this.m_connection.close();
                }
                catch (SQLException ex) {}
                this.m_connection = null;
            }
        }
    }

    private void processProjectHeader() throws SQLException {
        List<ResultSetRow> rows = this.getRows("select * from msp_projects where proj_id=?", this.m_projectID);
        if (!rows.isEmpty()) {
            this.processProjectHeader(rows.get(0));
        }
    }

    private void processCalendars() throws SQLException {
        for (ResultSetRow row : this.getRows("select * from msp_calendars where proj_id=?", this.m_projectID)) {
            this.processCalendar(row);
        }
        this.updateBaseCalendarNames();
        this.processCalendarData(this.m_project.getBaseCalendars());
        this.processCalendarData(this.m_project.getResourceCalendars());
    }

    private void processCalendarData(List<ProjectCalendar> calendars) throws SQLException {
        for (ProjectCalendar calendar : calendars) {
            this.processCalendarData(calendar, this.getRows("select * from msp_calendar_data where proj_id=? and cal_uid=?", this.m_projectID, calendar.getUniqueID()));
        }
    }

    private void processCalendarData(ProjectCalendar calendar, List<ResultSetRow> calendarData) {
        for (ResultSetRow row : calendarData) {
            this.processCalendarData(calendar, row);
        }
    }

    private void processResources() throws SQLException {
        for (ResultSetRow row : this.getRows("select * from msp_resources where proj_id=?", this.m_projectID)) {
            this.processResource(row);
        }
    }

    private void processTasks() throws SQLException {
        for (ResultSetRow row : this.getRows("select * from msp_tasks where proj_id=?", this.m_projectID)) {
            this.processTask(row);
        }
    }

    private void processLinks() throws SQLException {
        for (ResultSetRow row : this.getRows("select * from msp_links where proj_id=?", this.m_projectID)) {
            this.processLink(row);
        }
    }

    private void processAssignments() throws SQLException {
        for (ResultSetRow row : this.getRows("select * from msp_assignments where proj_id=?", this.m_projectID)) {
            this.processAssignment(row);
        }
    }

    private void processExtendedAttributes() throws SQLException {
        this.processTextFields();
        this.processNumberFields();
        this.processFlagFields();
        this.processDurationFields();
        this.processDateFields();
        this.processOutlineCodeFields();
    }

    private void processSubProjects() {
        for (Task task : this.m_project.getAllTasks()) {
            String subProjectFileName = task.getSubprojectName();
            int subprojectIndex = 1;
            if (subProjectFileName == null) continue;
            String fileName = subProjectFileName;
            int offset = 0x1000000 + subprojectIndex * 0x400000;
            int index = subProjectFileName.lastIndexOf(92);
            if (index != -1) {
                fileName = subProjectFileName.substring(index + 1);
            }
            SubProject sp = new SubProject();
            sp.setFileName(fileName);
            sp.setFullPath(subProjectFileName);
            sp.setUniqueIDOffset(new Integer(offset));
            sp.setTaskUniqueID(task.getUniqueID());
            task.setSubProject(sp);
            ++subprojectIndex;
        }
    }

    private void processTextFields() throws SQLException {
        for (ResultSetRow row : this.getRows("select * from msp_text_fields where proj_id=?", this.m_projectID)) {
            this.processTextField(row);
        }
    }

    private void processNumberFields() throws SQLException {
        for (ResultSetRow row : this.getRows("select * from msp_number_fields where proj_id=?", this.m_projectID)) {
            this.processNumberField(row);
        }
    }

    private void processFlagFields() throws SQLException {
        for (ResultSetRow row : this.getRows("select * from msp_flag_fields where proj_id=?", this.m_projectID)) {
            this.processFlagField(row);
        }
    }

    private void processDurationFields() throws SQLException {
        for (ResultSetRow row : this.getRows("select * from msp_duration_fields where proj_id=?", this.m_projectID)) {
            this.processDurationField(row);
        }
    }

    private void processDateFields() throws SQLException {
        for (ResultSetRow row : this.getRows("select * from msp_date_fields where proj_id=?", this.m_projectID)) {
            this.processDateField(row);
        }
    }

    private void processOutlineCodeFields() throws SQLException {
        for (ResultSetRow row : this.getRows("select * from msp_code_fields where proj_id=?", this.m_projectID)) {
            this.processOutlineCodeFields(row);
        }
    }

    private void processOutlineCodeFields(Row parentRow) throws SQLException {
        Integer entityID = parentRow.getInteger("CODE_REF_UID");
        Integer outlineCodeEntityID = parentRow.getInteger("CODE_UID");
        for (ResultSetRow row : this.getRows("select * from msp_outline_codes where code_uid=?", outlineCodeEntityID)) {
            this.processOutlineCodeField(entityID, row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ResultSetRow> getRows(String sql, Integer var) throws SQLException {
        this.allocateConnection();
        try {
            LinkedList<ResultSetRow> result = new LinkedList<ResultSetRow>();
            this.m_ps = this.m_connection.prepareStatement(sql);
            this.m_ps.setInt(1, NumberUtility.getInt(var));
            this.m_rs = this.m_ps.executeQuery();
            this.populateMetaData();
            while (this.m_rs.next()) {
                result.add(new ResultSetRow(this.m_rs, this.m_meta));
            }
            LinkedList<ResultSetRow> linkedList = result;
            return linkedList;
        }
        finally {
            this.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ResultSetRow> getRows(String sql, Integer var1, Integer var2) throws SQLException {
        this.allocateConnection();
        try {
            LinkedList<ResultSetRow> result = new LinkedList<ResultSetRow>();
            this.m_ps = this.m_connection.prepareStatement(sql);
            this.m_ps.setInt(1, NumberUtility.getInt(var1));
            this.m_ps.setInt(2, NumberUtility.getInt(var2));
            this.m_rs = this.m_ps.executeQuery();
            this.populateMetaData();
            while (this.m_rs.next()) {
                result.add(new ResultSetRow(this.m_rs, this.m_meta));
            }
            LinkedList<ResultSetRow> linkedList = result;
            return linkedList;
        }
        finally {
            this.releaseConnection();
        }
    }

    private void allocateConnection() throws SQLException {
        if (this.m_connection == null) {
            this.m_connection = this.m_dataSource.getConnection();
            this.m_allocatedConnection = true;
        }
    }

    private void releaseConnection() {
        if (this.m_rs != null) {
            try {
                this.m_rs.close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            this.m_rs = null;
        }
        if (this.m_ps != null) {
            try {
                this.m_ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.m_ps = null;
        }
    }

    private void populateMetaData() throws SQLException {
        this.m_meta.clear();
        ResultSetMetaData meta = this.m_rs.getMetaData();
        int columnCount = meta.getColumnCount() + 1;
        for (int loop = 1; loop < columnCount; ++loop) {
            String name = meta.getColumnName(loop);
            Integer type = new Integer(meta.getColumnType(loop));
            this.m_meta.put(name, type);
        }
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public void setConnection(Connection connection) {
        this.m_connection = connection;
    }
}

