/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import java.text.SimpleDateFormat;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mspdi.MSPDIReader;

public class MppEnterpriseTest
extends MPXJTestCase {
    public void testMpp9EnterpriseFields() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9enterprise.mpp");
        this.testEnterpriseFields(mpp);
    }

    public void testMpp12EnterpriseFields() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp12enterprise.mpp");
        this.testEnterpriseFields(mpp);
    }

    public void testMspdiEnterpriseFields() throws Exception {
        ProjectFile mpp = new MSPDIReader().read(this.m_basedir + "/enterprise.xml");
        this.testEnterpriseFields(mpp);
    }

    private void testEnterpriseFields(ProjectFile mpp) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        Task task = mpp.getTaskByID(new Integer(1));
        MppEnterpriseTest.assertEquals((int)1, (int)task.getEnterpriseCost(1).intValue());
        MppEnterpriseTest.assertEquals((int)10, (int)task.getEnterpriseCost(10).intValue());
        MppEnterpriseTest.assertEquals((String)"01/01/1991", (String)df.format(task.getEnterpriseDate(1)));
        MppEnterpriseTest.assertEquals((String)"01/01/2020", (String)df.format(task.getEnterpriseDate(30)));
        MppEnterpriseTest.assertEquals((int)1, (int)((int)task.getEnterpriseDuration(1).getDuration()));
        MppEnterpriseTest.assertEquals((Object)TimeUnit.DAYS, (Object)task.getEnterpriseDuration(1).getUnits());
        MppEnterpriseTest.assertEquals((int)10, (int)((int)task.getEnterpriseDuration(10).getDuration()));
        MppEnterpriseTest.assertEquals((Object)TimeUnit.DAYS, (Object)task.getEnterpriseDuration(10).getUnits());
        MppEnterpriseTest.assertEquals((int)1, (int)task.getEnterpriseNumber(1).intValue());
        MppEnterpriseTest.assertEquals((int)40, (int)task.getEnterpriseNumber(40).intValue());
        MppEnterpriseTest.assertEquals((String)"ET1", (String)task.getEnterpriseText(1));
        MppEnterpriseTest.assertEquals((String)"ET40", (String)task.getEnterpriseText(40));
        MppEnterpriseTest.assertEquals((boolean)true, (boolean)task.getEnterpriseFlag(1));
        MppEnterpriseTest.assertEquals((boolean)false, (boolean)task.getEnterpriseFlag(20));
        Resource resource = mpp.getResourceByID(new Integer(1));
        MppEnterpriseTest.assertEquals((int)1, (int)resource.getEnterpriseCost(1).intValue());
        MppEnterpriseTest.assertEquals((int)10, (int)resource.getEnterpriseCost(10).intValue());
        MppEnterpriseTest.assertEquals((String)"01/01/2008", (String)df.format(resource.getEnterpriseDate(1)));
        MppEnterpriseTest.assertEquals((String)"30/01/2008", (String)df.format(resource.getEnterpriseDate(30)));
        MppEnterpriseTest.assertEquals((int)1, (int)((int)resource.getEnterpriseDuration(1).getDuration()));
        MppEnterpriseTest.assertEquals((Object)TimeUnit.DAYS, (Object)resource.getEnterpriseDuration(1).getUnits());
        MppEnterpriseTest.assertEquals((int)10, (int)((int)resource.getEnterpriseDuration(10).getDuration()));
        MppEnterpriseTest.assertEquals((Object)TimeUnit.DAYS, (Object)resource.getEnterpriseDuration(10).getUnits());
        MppEnterpriseTest.assertEquals((int)1, (int)resource.getEnterpriseNumber(1).intValue());
        MppEnterpriseTest.assertEquals((int)40, (int)resource.getEnterpriseNumber(40).intValue());
        MppEnterpriseTest.assertEquals((String)"RET1", (String)resource.getEnterpriseText(1));
        MppEnterpriseTest.assertEquals((String)"RET40", (String)resource.getEnterpriseText(40));
        MppEnterpriseTest.assertEquals((boolean)false, (boolean)resource.getEnterpriseFlag(1));
        MppEnterpriseTest.assertEquals((boolean)true, (boolean)resource.getEnterpriseFlag(20));
    }
}

