/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.mpxj.Duration;
import net.sf.mpxj.Filter;
import net.sf.mpxj.FilterCriteria;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TestOperator;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpp.GanttChartView;
import net.sf.mpxj.mpp.MPPReader;

public class MppAutoFilterTest
extends MPXJTestCase {
    public void testMpp9Filters() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9autofilter.mpp");
        this.testFilters(mpp);
    }

    public void testMpp12Filters() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp12autofilter.mpp");
        this.testFilters(mpp);
    }

    private void testFilters(ProjectFile mpp) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        GanttChartView view = (GanttChartView)mpp.getViews().get(0);
        Filter filter = view.getAutoFilterByType(TaskField.DURATION);
        FilterCriteria criteria = filter.getCriteria().get(0);
        MppAutoFilterTest.assertEquals((Object)TaskField.DURATION, (Object)criteria.getField());
        MppAutoFilterTest.assertEquals((Object)TestOperator.EQUALS, (Object)criteria.getOperator());
        MppAutoFilterTest.assertEquals((int)9, (int)((int)((Duration)criteria.getValue(0)).getDuration()));
        MppAutoFilterTest.assertEquals((Object)TimeUnit.DAYS, (Object)((Duration)criteria.getValue(0)).getUnits());
        MppAutoFilterTest.assertTrue((boolean)criteria.getLogicalAnd());
        criteria = filter.getCriteria().get(1);
        MppAutoFilterTest.assertEquals((Object)TaskField.DURATION, (Object)criteria.getField());
        MppAutoFilterTest.assertEquals((Object)TestOperator.EQUALS, (Object)criteria.getOperator());
        MppAutoFilterTest.assertEquals((int)99, (int)((int)((Duration)criteria.getValue(0)).getDuration()));
        MppAutoFilterTest.assertEquals((Object)TimeUnit.DAYS, (Object)((Duration)criteria.getValue(0)).getUnits());
        filter = view.getAutoFilterByType(TaskField.NUMBER1);
        criteria = filter.getCriteria().get(0);
        MppAutoFilterTest.assertEquals((Object)TaskField.NUMBER1, (Object)criteria.getField());
        MppAutoFilterTest.assertEquals((Object)TestOperator.EQUALS, (Object)criteria.getOperator());
        MppAutoFilterTest.assertEquals((int)9, (int)((Double)criteria.getValue(0)).intValue());
        MppAutoFilterTest.assertFalse((boolean)criteria.getLogicalAnd());
        criteria = filter.getCriteria().get(1);
        MppAutoFilterTest.assertEquals((Object)TaskField.NUMBER1, (Object)criteria.getField());
        MppAutoFilterTest.assertEquals((Object)TestOperator.EQUALS, (Object)criteria.getOperator());
        MppAutoFilterTest.assertEquals((int)99, (int)((Double)criteria.getValue(0)).intValue());
        filter = view.getAutoFilterByType(TaskField.PERCENT_COMPLETE);
        criteria = filter.getCriteria().get(0);
        MppAutoFilterTest.assertEquals((Object)TaskField.PERCENT_COMPLETE, (Object)criteria.getField());
        MppAutoFilterTest.assertEquals((Object)TestOperator.EQUALS, (Object)criteria.getOperator());
        MppAutoFilterTest.assertEquals((int)9, (int)((Double)criteria.getValue(0)).intValue());
        MppAutoFilterTest.assertFalse((boolean)criteria.getLogicalAnd());
        criteria = filter.getCriteria().get(1);
        MppAutoFilterTest.assertEquals((Object)TaskField.PERCENT_COMPLETE, (Object)criteria.getField());
        MppAutoFilterTest.assertEquals((Object)TestOperator.EQUALS, (Object)criteria.getOperator());
        MppAutoFilterTest.assertEquals((int)99, (int)((Double)criteria.getValue(0)).intValue());
        filter = view.getAutoFilterByType(TaskField.COST1);
        criteria = filter.getCriteria().get(0);
        MppAutoFilterTest.assertEquals((Object)TaskField.COST1, (Object)criteria.getField());
        MppAutoFilterTest.assertEquals((Object)TestOperator.EQUALS, (Object)criteria.getOperator());
        MppAutoFilterTest.assertEquals((int)9, (int)((Double)criteria.getValue(0)).intValue());
        MppAutoFilterTest.assertFalse((boolean)criteria.getLogicalAnd());
        criteria = filter.getCriteria().get(1);
        MppAutoFilterTest.assertEquals((Object)TaskField.COST1, (Object)criteria.getField());
        MppAutoFilterTest.assertEquals((Object)TestOperator.EQUALS, (Object)criteria.getOperator());
        MppAutoFilterTest.assertEquals((int)99, (int)((Double)criteria.getValue(0)).intValue());
        filter = view.getAutoFilterByType(TaskField.TEXT1);
        criteria = filter.getCriteria().get(0);
        MppAutoFilterTest.assertEquals((Object)TaskField.TEXT1, (Object)criteria.getField());
        MppAutoFilterTest.assertEquals((Object)TestOperator.EQUALS, (Object)criteria.getOperator());
        MppAutoFilterTest.assertEquals((Object)"9", (Object)criteria.getValue(0));
        MppAutoFilterTest.assertFalse((boolean)criteria.getLogicalAnd());
        criteria = filter.getCriteria().get(1);
        MppAutoFilterTest.assertEquals((Object)TaskField.TEXT1, (Object)criteria.getField());
        MppAutoFilterTest.assertEquals((Object)TestOperator.EQUALS, (Object)criteria.getOperator());
        MppAutoFilterTest.assertEquals((Object)"99", (Object)criteria.getValue(0));
        filter = view.getAutoFilterByType(TaskField.FLAG1);
        criteria = filter.getCriteria().get(0);
        MppAutoFilterTest.assertEquals((Object)TaskField.FLAG1, (Object)criteria.getField());
        MppAutoFilterTest.assertEquals((Object)TestOperator.EQUALS, (Object)criteria.getOperator());
        MppAutoFilterTest.assertEquals((Object)Boolean.TRUE, (Object)criteria.getValue(0));
        MppAutoFilterTest.assertFalse((boolean)criteria.getLogicalAnd());
        criteria = filter.getCriteria().get(1);
        MppAutoFilterTest.assertEquals((Object)TaskField.FLAG1, (Object)criteria.getField());
        MppAutoFilterTest.assertEquals((Object)TestOperator.EQUALS, (Object)criteria.getOperator());
        MppAutoFilterTest.assertEquals((Object)Boolean.FALSE, (Object)criteria.getValue(0));
        filter = view.getAutoFilterByType(TaskField.DATE1);
        criteria = filter.getCriteria().get(0);
        MppAutoFilterTest.assertEquals((Object)TaskField.DATE1, (Object)criteria.getField());
        MppAutoFilterTest.assertEquals((Object)TestOperator.EQUALS, (Object)criteria.getOperator());
        MppAutoFilterTest.assertEquals((String)"09/09/1999", (String)df.format((Date)criteria.getValue(0)));
        MppAutoFilterTest.assertFalse((boolean)criteria.getLogicalAnd());
        criteria = filter.getCriteria().get(1);
        MppAutoFilterTest.assertEquals((Object)TaskField.DATE1, (Object)criteria.getField());
        MppAutoFilterTest.assertEquals((Object)TestOperator.EQUALS, (Object)criteria.getOperator());
        MppAutoFilterTest.assertEquals((String)"09/09/2009", (String)df.format((Date)criteria.getValue(0)));
        filter = view.getAutoFilterByType(TaskField.NUMBER2);
        criteria = filter.getCriteria().get(0);
        MppAutoFilterTest.assertEquals((Object)TestOperator.DOES_NOT_EQUAL, (Object)criteria.getOperator());
        filter = view.getAutoFilterByType(TaskField.NUMBER3);
        criteria = filter.getCriteria().get(0);
        MppAutoFilterTest.assertEquals((Object)TestOperator.IS_GREATER_THAN, (Object)criteria.getOperator());
        filter = view.getAutoFilterByType(TaskField.NUMBER4);
        criteria = filter.getCriteria().get(0);
        MppAutoFilterTest.assertEquals((Object)TestOperator.IS_GREATER_THAN_OR_EQUAL_TO, (Object)criteria.getOperator());
        filter = view.getAutoFilterByType(TaskField.NUMBER5);
        criteria = filter.getCriteria().get(0);
        MppAutoFilterTest.assertEquals((Object)TestOperator.IS_LESS_THAN, (Object)criteria.getOperator());
        filter = view.getAutoFilterByType(TaskField.NUMBER6);
        criteria = filter.getCriteria().get(0);
        MppAutoFilterTest.assertEquals((Object)TestOperator.IS_LESS_THAN_OR_EQUAL_TO, (Object)criteria.getOperator());
        filter = view.getAutoFilterByType(TaskField.NUMBER7);
        criteria = filter.getCriteria().get(0);
        MppAutoFilterTest.assertEquals((Object)TestOperator.IS_WITHIN, (Object)criteria.getOperator());
        filter = view.getAutoFilterByType(TaskField.NUMBER8);
        criteria = filter.getCriteria().get(0);
        MppAutoFilterTest.assertEquals((Object)TestOperator.IS_NOT_WITHIN, (Object)criteria.getOperator());
    }
}

