/*
 * Decompiled with CFR 0.152.
 */
package com.standbysoft.component.date.swing.plaf.basic;

import com.standbysoft.component.date.swing.DateRenderer;
import com.standbysoft.component.date.swing.DefaultDateRenderer;
import com.standbysoft.component.date.swing.JDateComponent;
import com.standbysoft.component.date.swing.JMonth;
import com.standbysoft.component.date.swing.JMonthView;
import com.standbysoft.component.date.swing.plaf.DateUI;
import com.standbysoft.component.date.swing.plaf.basic.BasicMonthUI;
import com.standbysoft.component.date.swing.plaf.basic.DateRendererUIResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;

public abstract class AbstractMonthViewUI
extends DateUI {
    protected JMonthView monthView;
    protected JButton previousYearButton;
    protected JButton nextYearButton;
    protected JButton previousMonthButton;
    protected JButton nextMonthButton;
    protected JComponent todayComponent;
    protected JComponent noneComponent;
    private PropertyChangeListener A;
    private Timer B;
    private Timer C;
    private static final String D = "JMonthView.monthUI";

    protected Object[] createDefaults() {
        Object[] objectArray = new Object[]{"MonthView.font", new FontUIResource("Dialog", 0, 12), "MonthView.gridColor", new ColorUIResource(Color.BLACK), "MonthView.titleBackground", new ColorUIResource(AbstractMonthViewUI.getInternalColor("activeCaption", new Color(0, 0, 128))), "MonthView.titleForeground", new ColorUIResource(AbstractMonthViewUI.getInternalColor("activeCaptionText", Color.WHITE)), "MonthView.foreground", new ColorUIResource(AbstractMonthViewUI.getInternalColor("controlText", Color.BLACK)), "MonthView.trailingForeground", new ColorUIResource(AbstractMonthViewUI.getInternalColor("controlShadow", Color.LIGHT_GRAY)), "MonthView.monthBackground", new ColorUIResource(AbstractMonthViewUI.getInternalColor("window", Color.WHITE)), "MonthView.dateRenderer", new DateRendererUIResource(new DefaultDateRenderer())};
        return objectArray;
    }

    protected void initializeDefaults() {
        Object[] objectArray = this.createDefaults();
        int n = objectArray.length;
        for (int i = 0; i < n; i += 2) {
            UIManager.put(objectArray[i], objectArray[i + 1]);
        }
    }

    public void installUI(JComponent jComponent) {
        this.monthView = (JMonthView)jComponent;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        DateRenderer dateRenderer;
        Color color;
        Color color2;
        Color color3;
        Color color4;
        Color color5;
        Color color6;
        this.initializeDefaults();
        Font font = this.monthView.getFont();
        if (font == null || font instanceof UIResource) {
            this.monthView.setFont(UIManager.getFont("MonthView.font"));
        }
        if ((color6 = this.monthView.getGridColor()) == null || color6 instanceof UIResource) {
            this.monthView.setGridColor(UIManager.getColor("MonthView.gridColor"));
        }
        if ((color5 = this.monthView.getTitleBackground()) == null || color5 instanceof UIResource) {
            this.monthView.setTitleBackground(UIManager.getColor("MonthView.titleBackground"));
        }
        if ((color4 = this.monthView.getTitleForeground()) == null || color4 instanceof UIResource) {
            this.monthView.setTitleForeground(UIManager.getColor("MonthView.titleForeground"));
        }
        if ((color3 = this.monthView.getForeground()) == null || color3 instanceof UIResource) {
            this.monthView.setForeground(UIManager.getColor("MonthView.foreground"));
        }
        if ((color2 = this.monthView.getTrailingForeground()) == null || color2 instanceof UIResource) {
            this.monthView.setTrailingForeground(UIManager.getColor("MonthView.trailingForeground"));
        }
        if ((color = this.monthView.getMonthBackground()) == null || color instanceof UIResource) {
            this.monthView.setMonthBackground(UIManager.getColor("MonthView.monthBackground"));
        }
        if ((dateRenderer = this.monthView.getDateRenderer()) == null || dateRenderer instanceof UIResource) {
            this.monthView.setDateRenderer((DateRenderer)UIManager.get("MonthView.dateRenderer"));
        }
    }

    protected void installComponents() {
        this.monthView.setLayout(this.createLayout());
        this.monthView.setBorder(BorderFactory.createLineBorder(Color.black));
        this.monthView.setOpaque(true);
        this.previousYearButton = this.createPreviousYearButton();
        this.nextYearButton = this.createNextYearButton();
        this.previousMonthButton = this.createPreviousMonthButton();
        this.nextMonthButton = this.createNextMonthButton();
        this.todayComponent = this.createTodayComponent();
        this.noneComponent = this.createNoneComponent();
        if (this.previousYearButton != null) {
            this.monthView.add((Component)this.previousYearButton, "Previous_Year");
        }
        if (this.nextYearButton != null) {
            this.monthView.add((Component)this.nextYearButton, "Next_Year");
        }
        if (this.previousMonthButton != null) {
            this.monthView.add((Component)this.previousMonthButton, "Previous");
        }
        if (this.nextMonthButton != null) {
            this.monthView.add((Component)this.nextMonthButton, "Next");
        }
        if (this.todayComponent != null) {
            this.monthView.add((Component)this.todayComponent, "Today");
        }
        if (this.noneComponent != null) {
            this.monthView.add((Component)this.noneComponent, "None");
        }
        this.updateRowsColumns();
        this.updateFont();
        this.updateWeekLabelsHighlight();
        this.updateMonthUI();
        this.updateEnabled();
        this.updateLocale();
        this.updateTimeZone();
        this.updateRenderer();
        this.updateForeground();
        this.updateMonthBackground();
        this.updateTitleBackground();
        this.updateTitleForeground();
        this.updateTrailingForeground();
        this.updateTrailingNextEnabled();
        this.updateTrailingPreviousEnabled();
        this.updateDateSelectionModel();
        this.updateMonthModel();
        this.updateWeekModel();
        this.updateWeekNumbersVisible();
        this.updateWeekNamesVisible();
        this.updateDisplayToday();
        this.updateNoneButtonVisible();
        this.updateHorizontalLinesVisible();
        this.updateVerticalLinesVisible();
        this.updateToggleDateSelectionEnabled();
        this.updateDatesOrientation();
    }

    protected LayoutManager createLayout() {
        return new CalendarLayout();
    }

    protected abstract JButton createPreviousMonthButton();

    protected abstract JButton createNextMonthButton();

    protected abstract JButton createPreviousYearButton();

    protected abstract JButton createNextYearButton();

    protected abstract JComponent createTodayComponent();

    protected abstract JComponent createNoneComponent();

    protected abstract JMonth createMonth();

    protected void installListeners() {
        if (this.A == null) {
            this.A = this.B();
            this.monthView.addPropertyChangeListener(this.A);
        }
    }

    private PropertyChangeListener B() {
        return new _A();
    }

    protected void installKeyboardActions() {
        ActionListener actionListener;
        ActionMap actionMap = this.A();
        InputMap inputMap = this.A(0);
        SwingUtilities.replaceUIActionMap(this.monthView, actionMap);
        SwingUtilities.replaceUIInputMap(this.monthView, 0, inputMap);
        final Calendar calendar = this.monthView.getCalendar();
        if (this.previousYearButton != null) {
            this.C = new Timer(60, null);
            this.C.setInitialDelay(300);
            this.previousYearButton.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getComponent().isEnabled()) {
                        AbstractMonthViewUI.this.C.start();
                    }
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    AbstractMonthViewUI.this.C.stop();
                }
            });
            actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = 1;
                    calendar.set(AbstractMonthViewUI.this.monthView.getYear(), AbstractMonthViewUI.this.monthView.getMonth(), 1);
                    calendar.add(1, -n);
                    int n2 = calendar.get(2);
                    int n3 = calendar.get(1);
                    if (BasicMonthUI.A(AbstractMonthViewUI.this.monthView, n2, n3)) {
                        AbstractMonthViewUI.this.monthView.setMonth(n2);
                        AbstractMonthViewUI.this.monthView.setYear(n3);
                    } else {
                        Calendar calendar2 = AbstractMonthViewUI.this.monthView.getCalendar();
                        calendar2.setTime(AbstractMonthViewUI.this.monthView.getDateSelectionModel().getMinimumAllowed());
                        AbstractMonthViewUI.this.monthView.setMonth(calendar2.get(2));
                        AbstractMonthViewUI.this.monthView.setYear(calendar2.get(1));
                    }
                    AbstractMonthViewUI.this.monthView.requestFocus();
                }
            };
            this.previousYearButton.addActionListener(actionListener);
            this.C.addActionListener(actionListener);
            this.previousYearButton.setEnabled(this.monthView.isEnabled());
        }
        if (this.nextYearButton != null) {
            this.B = new Timer(60, null);
            this.B.setInitialDelay(300);
            this.nextYearButton.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getComponent().isEnabled()) {
                        AbstractMonthViewUI.this.B.start();
                    }
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    AbstractMonthViewUI.this.B.stop();
                }
            });
            actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = 1;
                    calendar.set(AbstractMonthViewUI.this.monthView.getYear(), AbstractMonthViewUI.this.monthView.getMonth(), 1);
                    calendar.add(1, n);
                    int n2 = calendar.get(2);
                    int n3 = calendar.get(1);
                    if (BasicMonthUI.A(AbstractMonthViewUI.this.monthView, n2, n3)) {
                        AbstractMonthViewUI.this.monthView.setMonth(n2);
                        AbstractMonthViewUI.this.monthView.setYear(n3);
                    } else {
                        Calendar calendar2 = AbstractMonthViewUI.this.monthView.getCalendar();
                        calendar2.setTime(AbstractMonthViewUI.this.monthView.getDateSelectionModel().getMaximumAllowed());
                        AbstractMonthViewUI.this.monthView.setMonth(calendar2.get(2));
                        AbstractMonthViewUI.this.monthView.setYear(calendar2.get(1));
                    }
                    AbstractMonthViewUI.this.monthView.requestFocus();
                }
            };
            this.nextYearButton.addActionListener(actionListener);
            this.B.addActionListener(actionListener);
            this.nextYearButton.setEnabled(this.monthView.isEnabled());
        }
        if (this.previousMonthButton != null) {
            this.previousMonthButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = AbstractMonthViewUI.this.monthView.getScrollingDelta();
                    calendar.set(AbstractMonthViewUI.this.monthView.getYear(), AbstractMonthViewUI.this.monthView.getMonth(), 1);
                    calendar.add(2, -n);
                    int n2 = calendar.get(2);
                    int n3 = calendar.get(1);
                    if (BasicMonthUI.A(AbstractMonthViewUI.this.monthView, n2, n3)) {
                        AbstractMonthViewUI.this.monthView.setMonth(n2);
                        AbstractMonthViewUI.this.monthView.setYear(n3);
                    } else {
                        Calendar calendar2 = AbstractMonthViewUI.this.monthView.getCalendar();
                        calendar2.setTime(AbstractMonthViewUI.this.monthView.getDateSelectionModel().getMinimumAllowed());
                        AbstractMonthViewUI.this.monthView.setMonth(calendar2.get(2));
                        AbstractMonthViewUI.this.monthView.setYear(calendar2.get(1));
                    }
                    AbstractMonthViewUI.this.monthView.requestFocus();
                }
            });
            this.previousMonthButton.setEnabled(this.monthView.isEnabled());
        }
        if (this.nextMonthButton != null) {
            this.nextMonthButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = AbstractMonthViewUI.this.monthView.getScrollingDelta();
                    calendar.set(AbstractMonthViewUI.this.monthView.getYear(), AbstractMonthViewUI.this.monthView.getMonth(), 1);
                    calendar.add(2, n);
                    int n2 = calendar.get(2);
                    int n3 = calendar.get(1);
                    if (BasicMonthUI.A(AbstractMonthViewUI.this.monthView, n2, n3)) {
                        AbstractMonthViewUI.this.monthView.setMonth(n2);
                        AbstractMonthViewUI.this.monthView.setYear(n3);
                    } else {
                        Calendar calendar2 = AbstractMonthViewUI.this.monthView.getCalendar();
                        calendar2.setTime(AbstractMonthViewUI.this.monthView.getDateSelectionModel().getMaximumAllowed());
                        AbstractMonthViewUI.this.monthView.setMonth(calendar2.get(2));
                        AbstractMonthViewUI.this.monthView.setYear(calendar2.get(1));
                    }
                    AbstractMonthViewUI.this.monthView.requestFocus();
                }
            });
            this.nextMonthButton.setEnabled(this.monthView.isEnabled());
        }
    }

    InputMap A(int n) {
        if (n == 0) {
            InputMap inputMap = LookAndFeel.makeInputMap(new Object[]{"RIGHT", "select-next-day", "KP_RIGHT", "select-next-day", "LEFT", "select-previous-day", "KP_LEFT", "select-previous-day", "UP", "select-same-day-previous-week", "KP_UP", "select-same-day-previous-week", "DOWN", "select-same-day-next-week", "KP_DOWN", "select-same-day-next-week", "PAGE_UP", "select-same-day-previous-month", "PAGE_DOWN", "select-same-day-next-month", "ctrl PAGE_UP", "select-same-day-previous-year", "ctrl PAGE_DOWN", "select-same-day-next-year", "HOME", "select-first-day", "ctrl HOME", "select-first-day", "END", "select-last-day", "ctrl END", "select-last-day", "DELETE", "select-none", "KP_DELETE", "select-none", "BACK_SPACE", "select-none"});
            return inputMap;
        }
        return null;
    }

    ActionMap A() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("select-next-day", new JDateComponent.RollDateAction(5, true));
        actionMapUIResource.put("select-previous-day", new JDateComponent.RollDateAction(5, false));
        actionMapUIResource.put("select-first-day", new JDateComponent.SelectFirstDayAction());
        actionMapUIResource.put("select-last-day", new JDateComponent.SelectLastDayAction());
        actionMapUIResource.put("select-same-day-next-week", new JDateComponent.RollDateAction(3, true));
        actionMapUIResource.put("select-same-day-previous-week", new JDateComponent.RollDateAction(3, false));
        actionMapUIResource.put("select-same-day-next-month", new JDateComponent.RollDateAction(2, true));
        actionMapUIResource.put("select-same-day-previous-month", new JDateComponent.RollDateAction(2, false));
        actionMapUIResource.put("select-same-day-next-year", new JDateComponent.RollDateAction(1, true));
        actionMapUIResource.put("select-same-day-previous-year", new JDateComponent.RollDateAction(1, false));
        actionMapUIResource.put("select-none", new JDateComponent.SelectNoneAction());
        return actionMapUIResource;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallComponents();
    }

    protected void uninstallListeners() {
        if (this.A != null) {
            this.monthView.removePropertyChangeListener(this.A);
            this.A = null;
        }
    }

    protected void uninstallComponents() {
        this.monthView.removeAll();
        this.monthView.setLayout(null);
        this.monthView = null;
        this.previousYearButton = null;
        this.previousMonthButton = null;
        this.nextYearButton = null;
        this.nextMonthButton = null;
        this.todayComponent = null;
        this.noneComponent = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.monthView, 1, null);
        SwingUtilities.replaceUIActionMap(this.monthView, null);
    }

    protected abstract void updateFont();

    protected abstract void updateLocale();

    protected abstract void updateEnabled();

    protected abstract void updateRenderer();

    protected abstract void updateMonthBackground();

    protected abstract void updateForeground();

    protected abstract void updateTitleBackground();

    protected abstract void updateTitleForeground();

    protected abstract void updateTrailingForeground();

    protected abstract void updateTrailingNextEnabled();

    protected abstract void updateTrailingPreviousEnabled();

    protected abstract void updateGridColor();

    protected abstract void updateWeekNumbersVisible();

    protected abstract void updateWeekNamesVisible();

    protected abstract void updateHorizontalLinesVisible();

    protected abstract void updateVerticalLinesVisible();

    protected abstract void updateDisplayToday();

    protected abstract void updateNoneButtonVisible();

    protected abstract void updateDateSelectionModel();

    protected abstract void updateToggleDateSelectionEnabled();

    protected abstract void updateMonthModel();

    protected abstract void updateWeekModel();

    protected abstract void updateRowsColumns();

    protected abstract void updateTimeZone();

    protected abstract void updateWeekLabelsHighlight();

    protected abstract void updateMonthUI();

    protected abstract void updateDatesOrientation();

    private class _A
    implements PropertyChangeListener {
        private _A() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("font")) {
                AbstractMonthViewUI.this.updateFont();
            } else if (string.equals("JMonth.isWeekLabelsHighlighted")) {
                AbstractMonthViewUI.this.updateWeekLabelsHighlight();
            } else if (string.equals(AbstractMonthViewUI.D)) {
                AbstractMonthViewUI.this.updateMonthUI();
            } else if (string.equals("gridColor")) {
                AbstractMonthViewUI.this.updateGridColor();
            } else if (string.equals("foreground")) {
                AbstractMonthViewUI.this.updateForeground();
            } else if (string.equals("monthBackground")) {
                AbstractMonthViewUI.this.updateMonthBackground();
            } else if (string.equals("titleBackground")) {
                AbstractMonthViewUI.this.updateTitleBackground();
            } else if (string.equals("titleForeground")) {
                AbstractMonthViewUI.this.updateTitleForeground();
            } else if (string.equals("trailingForeground")) {
                AbstractMonthViewUI.this.updateTrailingForeground();
            } else if (string.equals("trailingNextEnabled")) {
                AbstractMonthViewUI.this.updateTrailingNextEnabled();
            } else if (string.equals("trailingPreviousEnabled")) {
                AbstractMonthViewUI.this.updateTrailingPreviousEnabled();
            } else if (string.equals("dateSelectionModel")) {
                AbstractMonthViewUI.this.updateDateSelectionModel();
            } else if (string.equals("toggleDateSelectionEnabled")) {
                AbstractMonthViewUI.this.updateToggleDateSelectionEnabled();
            } else if (string.equals("monthModel")) {
                AbstractMonthViewUI.this.updateMonthModel();
            } else if (string.equals("weekModel")) {
                AbstractMonthViewUI.this.updateWeekModel();
            } else if (string.equals("enabled")) {
                AbstractMonthViewUI.this.updateEnabled();
            } else if (string.equals("weekNumbersVisible")) {
                AbstractMonthViewUI.this.updateWeekNumbersVisible();
            } else if (string.equals("weekNamesVisible")) {
                AbstractMonthViewUI.this.updateWeekNamesVisible();
            } else if (string.equals("statusVisible")) {
                AbstractMonthViewUI.this.updateDisplayToday();
                AbstractMonthViewUI.this.updateNoneButtonVisible();
                AbstractMonthViewUI.this.monthView.revalidate();
            } else if (string.equals("todayButtonVisible")) {
                AbstractMonthViewUI.this.updateDisplayToday();
            } else if (string.equals("noneButtonVisible")) {
                AbstractMonthViewUI.this.updateNoneButtonVisible();
            } else if (string.equals("horizontalLinesVisible")) {
                AbstractMonthViewUI.this.updateHorizontalLinesVisible();
            } else if (string.equals("verticalLinesVisible")) {
                AbstractMonthViewUI.this.updateVerticalLinesVisible();
            } else if (string.equals("locale")) {
                AbstractMonthViewUI.this.updateLocale();
            } else if (string.equals("timeZone")) {
                AbstractMonthViewUI.this.updateTimeZone();
            } else if (string.equals("dateRenderer")) {
                AbstractMonthViewUI.this.updateRenderer();
            } else if (string.equals("rows")) {
                AbstractMonthViewUI.this.updateRowsColumns();
            } else if (string.equals("columns")) {
                AbstractMonthViewUI.this.updateRowsColumns();
            } else if (string.equals("datesOrientation")) {
                AbstractMonthViewUI.this.updateDatesOrientation();
            }
            AbstractMonthViewUI.this.monthView.repaint();
        }
    }

    public static class CalendarLayout
    implements LayoutManager {
        public static final String PREVIOUS_YEAR = "Previous_Year";
        public static final String NEXT_YEAR = "Next_Year";
        public static final String PREVIOUS = "Previous";
        public static final String NEXT = "Next";
        public static final String TODAY = "Today";
        public static final String NONE = "None";
        public static final String MONTH = "Month";
        protected Component nextButton = null;
        protected Component previousButton = null;
        protected Component todayLabel = null;
        protected Component noneLabel = null;
        protected Component nextYearButton = null;
        protected Component previousYearButton = null;
        protected List months;
        protected int rows = 1;
        protected int columns = 1;
        private int A;
        private int C;
        private int E;
        private int D;
        private Insets B = new Insets(5, 5, 0, 5);

        public CalendarLayout() {
            this(10, 10, 20, 15);
        }

        public CalendarLayout(int n, int n2, int n3, int n4) {
            this.months = new ArrayList();
            this.A = n;
            this.C = n2;
            this.E = n3;
            this.D = n4;
        }

        public void setRows(int n) {
            this.rows = n;
        }

        public void setColumns(int n) {
            this.columns = n;
        }

        public void addLayoutComponent(String string, Component component) {
            if (string.equals(PREVIOUS_YEAR)) {
                this.previousYearButton = component;
            } else if (string.equals(NEXT_YEAR)) {
                this.nextYearButton = component;
            } else if (string.equals(PREVIOUS)) {
                this.previousButton = component;
            } else if (string.equals(NEXT)) {
                this.nextButton = component;
            } else if (string.equals(TODAY)) {
                this.todayLabel = component;
            } else if (string.equals(NONE)) {
                this.noneLabel = component;
            } else if (string.equals(MONTH)) {
                this.months.add(component);
            }
        }

        public void removeLayoutComponent(Component component) {
            if (component.equals(this.nextYearButton)) {
                this.nextYearButton = null;
            } else if (component.equals(this.previousYearButton)) {
                this.previousYearButton = null;
            } else if (component.equals(this.nextButton)) {
                this.nextButton = null;
            } else if (component.equals(this.previousButton)) {
                this.previousButton = null;
            } else if (component.equals(this.todayLabel)) {
                this.todayLabel = null;
            } else if (component.equals(this.noneLabel)) {
                this.noneLabel = null;
            } else if (this.months.contains(component)) {
                this.months.remove(component);
            }
        }

        public Dimension preferredLayoutSize(Container container) {
            return container.getPreferredSize();
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            this.layoutNavigationButtonsInContainer(container);
            this.layoutMonthsInContainer(container);
            this.layoutNoneAndTodayComponentsInContainer(container);
        }

        protected void layoutNavigationButtonsInContainer(Container container) {
            Insets insets = container.getInsets();
            boolean bl = this.previousYearButton != null || this.nextYearButton != null;
            int n = 0;
            if (bl) {
                n = this.B.left + this.E;
            }
            if (this.previousYearButton != null) {
                this.previousYearButton.setBounds(insets.left + this.B.left, insets.top + this.B.top, this.E, this.D);
            }
            if (this.nextYearButton != null) {
                this.nextYearButton.setBounds(container.getSize().width - insets.left - insets.right - this.B.left - this.E, insets.top + this.B.top, this.E, this.D);
            }
            if (this.previousButton != null) {
                this.previousButton.setBounds(insets.left + this.B.left + n, insets.top + this.B.top, this.E, this.D);
            }
            if (this.nextButton != null) {
                this.nextButton.setBounds(container.getSize().width - insets.left - insets.right - this.B.left - this.E - n, insets.top + this.B.top, this.E, this.D);
            }
        }

        protected void layoutMonthsInContainer(Container container) {
            Insets insets = container.getInsets();
            Dimension dimension = new Dimension(container.getSize().width - insets.left - insets.right, container.getSize().height - insets.bottom - insets.top);
            int n = ((JMonthView)container).isStatusVisible() ? (int)(dimension.getHeight() * 0.9) : (int)dimension.getHeight();
            Dimension dimension2 = new Dimension((int)(dimension.getWidth() - (double)(this.A * (this.columns - 1))) / this.columns, (n - this.C * (this.rows - 1)) / this.rows);
            int n2 = insets.left;
            int n3 = insets.top;
            int n4 = dimension.width - (dimension2.width * this.columns + this.A * (this.columns - 1));
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    int n5 = j + this.columns * i;
                    if (n5 >= this.months.size()) continue;
                    Component component = (Component)this.months.get(n5);
                    int n6 = n2 + j * (dimension2.width + this.A);
                    int n7 = j <= n4 ? j : n4;
                    int n8 = n3 + i * (dimension2.height + this.C);
                    component.setBounds(n6 += n7, n8, dimension2.width, dimension2.height);
                }
            }
        }

        protected void layoutNoneAndTodayComponentsInContainer(Container container) {
            Insets insets = container.getInsets();
            Dimension dimension = new Dimension(container.getSize().width - insets.left - insets.right, container.getSize().height - insets.bottom - insets.top);
            Dimension dimension2 = new Dimension(container.getWidth(), (int)(dimension.getHeight() * 0.1));
            if (this.todayLabel != null) {
                int n = 0;
                if (this.noneLabel != null) {
                    n = this.noneLabel.getPreferredSize().width;
                }
                this.todayLabel.setBounds(insets.left + this.B.left, dimension.height - dimension2.height + this.B.bottom, dimension.width - this.B.left * 3 - n, dimension2.height);
            }
            if (this.noneLabel != null) {
                this.noneLabel.setBounds(insets.left + dimension.width - this.noneLabel.getPreferredSize().width - this.B.left, dimension.height - dimension2.height + this.B.bottom, this.noneLabel.getPreferredSize().width, dimension2.height);
            }
        }
    }
}

