#ifndef WORKBOOK_H
#define WORKBOOK_H

#include <string>
#include <vector>

namespace Libexcel {

	class WorkbookImpl;
	class Worksheet;
	class Format;

	// Class for creating Excel workbook (xls-file)
	
	class Workbook 
	{
	public:

		Workbook(std::string filename);                                    // create a new workbook (xls-file)
		~Workbook();                                                  
		Worksheet* addWorksheet(std::wstring name = L"");                  // add a new worksheet
		Format* addFormat();                                               // add a new format   
		std::vector<Worksheet*> sheets();                                  // returns an array of the worksheet objects    
		void setCustomColor(int index, int red, int green, int blue);      // change the RGB components of color index
		bool setKey(std::string name, std::string email, std::string key); // set registration key
		int version() const;										       // get version of this library			
		bool close();												       // close and save this workbook	  	           

	private:	
		WorkbookImpl* m_impl;
	};
}

#endif
