VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "COMCTL32.OCX"
Object = "{52048434-75AA-4F36-AF72-D806E64F9CF7}#8.0#0"; "rspmp3ocx320sw.ocx"
Begin VB.Form frmMixer 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "RSP Mixing Demo"
   ClientHeight    =   6195
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   8070
   Icon            =   "Mixer.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   6195
   ScaleWidth      =   8070
   StartUpPosition =   2  'CenterScreen
   Begin RSPMP3_320.RSPMP3 rspLeftPlyr 
      Left            =   2280
      Top             =   3480
      _ExtentX        =   979
      _ExtentY        =   979
   End
   Begin RSPMP3_320.RSPMP3 rspRightPlyr 
      Left            =   6600
      Top             =   3240
      _ExtentX        =   979
      _ExtentY        =   979
   End
   Begin VB.TextBox Text1 
      Height          =   285
      Left            =   3240
      TabIndex        =   34
      Text            =   "3"
      Top             =   2280
      Width           =   495
   End
   Begin VB.CheckBox Check1 
      Caption         =   "Use fixed number of seconds in fade"
      Height          =   255
      Left            =   240
      TabIndex        =   33
      Top             =   2280
      Width           =   3015
   End
   Begin VB.Timer tmrLeftPlyr 
      Enabled         =   0   'False
      Interval        =   50
      Left            =   6000
      Top             =   3600
   End
   Begin VB.Timer tmrRightPlyr 
      Enabled         =   0   'False
      Interval        =   50
      Left            =   2700
      Top             =   3600
   End
   Begin VB.ListBox List1 
      Height          =   450
      Left            =   240
      TabIndex        =   28
      Top             =   5400
      Width           =   7575
   End
   Begin VB.TextBox txtDefFadePos 
      Height          =   375
      Left            =   2280
      MaxLength       =   2
      TabIndex        =   27
      Text            =   "97"
      Top             =   2700
      Width           =   315
   End
   Begin VB.CommandButton cmdCueLeftIn 
      Caption         =   "Cue Left In"
      Height          =   555
      Left            =   2160
      TabIndex        =   25
      Top             =   4680
      Width           =   1515
   End
   Begin VB.CommandButton cmdCueFade 
      Caption         =   "Fade"
      Height          =   375
      Left            =   7380
      TabIndex        =   12
      Top             =   1200
      Width           =   555
   End
   Begin VB.CommandButton cmdFade 
      Caption         =   "Fade"
      Height          =   375
      Left            =   7380
      TabIndex        =   11
      Top             =   180
      Width           =   555
   End
   Begin VB.CommandButton cmdStop 
      Caption         =   "Stop"
      Height          =   555
      Left            =   6120
      TabIndex        =   10
      Top             =   4680
      Width           =   1635
   End
   Begin VB.CommandButton cmdCueRightIn 
      Caption         =   "Cue Right In"
      Height          =   555
      Left            =   4200
      TabIndex        =   9
      Top             =   4680
      Width           =   1515
   End
   Begin VB.CommandButton cmdStart 
      Caption         =   "Start"
      Height          =   555
      Left            =   240
      TabIndex        =   8
      Top             =   4680
      Width           =   1515
   End
   Begin VB.CommandButton cmdCueTrack 
      Caption         =   "..."
      Height          =   375
      Left            =   6780
      TabIndex        =   5
      Top             =   1200
      Width           =   495
   End
   Begin VB.TextBox txtRightTrack 
      Height          =   375
      Left            =   1380
      TabIndex        =   4
      Top             =   1200
      Width           =   5235
   End
   Begin VB.CommandButton cmdCurrTrack 
      Caption         =   "..."
      Height          =   375
      Left            =   6780
      TabIndex        =   2
      Top             =   180
      Width           =   495
   End
   Begin VB.TextBox txtLeftTrack 
      Height          =   375
      Left            =   1380
      TabIndex        =   1
      Top             =   180
      Width           =   5235
   End
   Begin MSComDlg.CommonDialog cmDlgOpen 
      Left            =   6840
      Top             =   660
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin ComctlLib.Slider sldrCurrTrack 
      Height          =   375
      Left            =   1260
      TabIndex        =   6
      Top             =   660
      Width           =   5475
      _ExtentX        =   9657
      _ExtentY        =   661
      _Version        =   327682
      Max             =   100
   End
   Begin ComctlLib.Slider SldrCueTrack 
      Height          =   375
      Left            =   1260
      TabIndex        =   7
      Top             =   1680
      Width           =   5475
      _ExtentX        =   9657
      _ExtentY        =   661
      _Version        =   327682
      Max             =   100
   End
   Begin VB.Label lblFadeInSecs 
      Caption         =   "Fade in seconds"
      Height          =   255
      Left            =   2760
      TabIndex        =   32
      Top             =   2640
      Width           =   3615
   End
   Begin VB.Label lblFadeIn 
      Caption         =   "Fade in "
      Height          =   255
      Left            =   2760
      TabIndex        =   31
      Top             =   2880
      Width           =   1095
   End
   Begin VB.Label lblFadeOut 
      Caption         =   "Fade out "
      Height          =   255
      Left            =   3960
      TabIndex        =   30
      Top             =   2880
      Width           =   1215
   End
   Begin VB.Label Label1 
      Caption         =   "Mixing demo by Norman Mackay"
      Height          =   255
      Left            =   5520
      TabIndex        =   29
      Top             =   5880
      Width           =   3375
   End
   Begin VB.Label lblUI 
      BackStyle       =   0  'Transparent
      Caption         =   "Default Track Fade Out %:"
      Height          =   195
      Index           =   8
      Left            =   240
      TabIndex        =   26
      Top             =   2760
      Width           =   2130
   End
   Begin VB.Line Line4 
      X1              =   240
      X2              =   7800
      Y1              =   2220
      Y2              =   2220
   End
   Begin VB.Label lblRTrackPercent 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      ForeColor       =   &H00000080&
      Height          =   195
      Left            =   6000
      TabIndex        =   24
      Top             =   4080
      Width           =   45
   End
   Begin VB.Label lblLTrackPercent 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      ForeColor       =   &H00000080&
      Height          =   195
      Left            =   2280
      TabIndex        =   23
      Top             =   4140
      Width           =   1485
   End
   Begin VB.Label lblRTrackPos 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      ForeColor       =   &H00000080&
      Height          =   195
      Left            =   6000
      TabIndex        =   22
      Top             =   3720
      Width           =   45
   End
   Begin VB.Label lblLTrackPos 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      ForeColor       =   &H00000080&
      Height          =   195
      Left            =   2280
      TabIndex        =   21
      Top             =   3780
      Width           =   1485
   End
   Begin VB.Label lblRTrackLen 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      ForeColor       =   &H00000080&
      Height          =   195
      Left            =   6000
      TabIndex        =   20
      Top             =   3360
      Width           =   45
   End
   Begin VB.Label lblLTrackLen 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      ForeColor       =   &H00000080&
      Height          =   195
      Left            =   2280
      TabIndex        =   19
      Top             =   3420
      Width           =   1125
   End
   Begin VB.Label lblUI 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "% Played:"
      Height          =   195
      Index           =   7
      Left            =   3960
      TabIndex        =   18
      Top             =   4140
      Width           =   690
   End
   Begin VB.Label lblUI 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Track Position (secs):"
      Height          =   195
      Index           =   6
      Left            =   3960
      TabIndex        =   17
      Top             =   3780
      Width           =   1530
   End
   Begin VB.Label lblUI 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Track length (secs):"
      Height          =   195
      Index           =   5
      Left            =   3960
      TabIndex        =   16
      Top             =   3420
      Width           =   1410
   End
   Begin VB.Label lblUI 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "% Played:"
      Height          =   195
      Index           =   4
      Left            =   300
      TabIndex        =   15
      Top             =   4140
      Width           =   690
   End
   Begin VB.Label lblUI 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Track Position (secs):"
      Height          =   195
      Index           =   3
      Left            =   240
      TabIndex        =   14
      Top             =   3780
      Width           =   1530
   End
   Begin VB.Label lblUI 
      BackStyle       =   0  'Transparent
      Caption         =   "Track length (secs):"
      Height          =   195
      Index           =   2
      Left            =   240
      TabIndex        =   13
      Top             =   3420
      Width           =   1410
   End
   Begin VB.Line Line3 
      X1              =   7800
      X2              =   180
      Y1              =   4560
      Y2              =   4560
   End
   Begin VB.Line Line2 
      X1              =   3840
      X2              =   3840
      Y1              =   3180
      Y2              =   4560
   End
   Begin VB.Line Line1 
      X1              =   240
      X2              =   7800
      Y1              =   3180
      Y2              =   3180
   End
   Begin VB.Label lblUI 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Right Track:"
      Height          =   195
      Index           =   1
      Left            =   240
      TabIndex        =   3
      Top             =   1200
      Width           =   885
   End
   Begin VB.Label lblUI 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Left Track:"
      Height          =   195
      Index           =   0
      Left            =   240
      TabIndex        =   0
      Top             =   180
      Width           =   780
   End
End
Attribute VB_Name = "frmMixer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False


'/******************************************************************
'/
'/ Name             : frmMixer
'/ Version          : 1.0.0
'/ Author           : Norman Mackay
'/ Date Created     : 18 Jan 2005
'/ Dev Tool         : VB6 Enterprise (SP6)
'/ Copyright        : Digital Tanagent Limited
'/ Project          : R&D
'/
'/******************************************************************

Option Explicit
Option Base 0

Private m_bCancelfade As Boolean    '// Cancel active fade
Private m_bLIsRunning As Boolean    '// Left player is running
Private m_bLeftPlaying As Boolean   '// Left player has active playback
Private m_bRIsRunning As Boolean    '// Right player is running
Private m_bRightPlaying As Boolean  '// Right player has active playback
Private m_lLeftPos As Long          '// Playback position for left player
Private m_lRightPos As Long         '// Playback position for right player
Private m_lSecsLeft As Long         '// Seconds of playback left, can be set for manual fade in/out

Private Declare Function Sleep Lib "kernel32" (ByVal Miliseconds As Long) As Long


Private Sub cmdCueFade_Click()
    
    Dim PauseTime As Double
    Dim Start As Double
    Dim lFadeIn As Long
    Dim lFadeOut As Long

    
    If m_bLIsRunning = True Then
        
        Debug.Print Time & " Already executing , exiting "
        Exit Sub
        
    End If
    
    m_bCancelfade = False
    lFadeOut = 100
    lFadeIn = 0
    m_bLIsRunning = True
    
    
    m_lSecsLeft = 3
    
    If Check1.Value = 1 Then
        
        m_lSecsLeft = Text1.Text
        
    End If
    
    PauseTime = (m_lSecsLeft) / 100
    
    lblFadeInSecs.Caption = "Fade in seconds : " & m_lSecsLeft
    
    rspRightPlyr.InternalVolume lFadeOut
    rspLeftPlyr.InternalVolume lFadeIn
    
    With rspLeftPlyr
        .PlayFile CStr(txtLeftTrack)
    End With
    
    Do While lFadeOut >= 0
        
        Sleep 1
        
        lblRTrackLen = rspRightPlyr.GetLength
        lblRTrackPos = rspRightPlyr.GetTime
        
        If rspRightPlyr.GetLength <> 0 Then
            
            lblRTrackPercent = Format(rspRightPlyr.GetTime / rspRightPlyr.GetLength * 100, "0.0") & "%"
            lblRTrackPercent.Refresh
            
        End If
        
        lblLTrackLen = rspLeftPlyr.GetLength
        lblLTrackPos = rspLeftPlyr.GetTime
        
        If rspLeftPlyr.GetLength <> 0 Then
            
            lblLTrackPercent = Format(rspLeftPlyr.GetTime / rspLeftPlyr.GetLength * 100, "0.0") & "%"
            
            lblLTrackPercent.Refresh
            
        End If
        
        lblFadeOut.Caption = "Fade out :  " & lFadeOut
        lblFadeIn.Caption = "Fade in :  " & lFadeIn
        
        rspRightPlyr.InternalVolume lFadeOut
        rspLeftPlyr.InternalVolume lFadeIn
        
        Start = Timer
        
        Do While Timer < Start + PauseTime
            Sleep 1
            If m_bCancelfade Then
                GoTo final
            End If
            
            DoEvents
            
        Loop
        
        lFadeOut = (lFadeOut - 1)
        lFadeIn = (lFadeIn + 1)
        
        If m_bCancelfade Then
            GoTo final
        End If
        
        DoEvents
        
    Loop
    
    DoEvents
    
    rspRightPlyr.CancelPlayback
    m_bRightPlaying = False
    
final:
    m_bCancelfade = False
    m_bLIsRunning = False
    
End Sub

Private Sub cmdCueLeftIn_Click()
    
    m_bCancelfade = True
    
    rspLeftPlyr.CancelPlayback
    rspRightPlyr.CancelPlayback
    
    m_lSecsLeft = 3
    
    tmrLeftPlyr.Enabled = True
    
End Sub

Private Sub cmdCueRightIn_Click()
    
    m_bCancelfade = True
    
    rspLeftPlyr.CancelPlayback
    rspRightPlyr.CancelPlayback
    
    m_lSecsLeft = 3
    
    tmrRightPlyr.Enabled = True
    
    
End Sub

Private Sub cmdCueTrack_Click()
    
    On Error Resume Next
    
    cmDlgOpen.CancelError = True
    cmDlgOpen.ShowOpen
    
    If Err.Number <> cdlCancel Then
        txtRightTrack = cmDlgOpen.Filename
    End If
    
End Sub

Private Sub cmdCurrTrack_Click()
    
    On Error Resume Next
    
    cmDlgOpen.CancelError = True
    cmDlgOpen.ShowOpen
    
    If Err.Number <> cdlCancel Then
        txtLeftTrack = cmDlgOpen.Filename
    End If
    
End Sub

Private Sub cmdFade_Click()
    
    Dim PauseTime As Double
    Dim Start As Double
    Dim lFadeOut As Long
    Dim lFadeIn As Long
    
    
    
    
    If m_bRIsRunning = True Then
        
        Debug.Print Time & " Already executing , exiting "
        Exit Sub
    End If
    
    
    m_bCancelfade = False
    m_bRIsRunning = True
    
    
    lFadeOut = 100
    lFadeIn = 0
    
    m_lSecsLeft = 3
    
    
    If Check1.Value = 1 Then
        
        m_lSecsLeft = Text1.Text
        
    End If
    
    PauseTime = (m_lSecsLeft) / 100
    
    lblFadeInSecs.Caption = "Fade in seconds : " & m_lSecsLeft
    
    rspLeftPlyr.InternalVolume lFadeOut
    
    rspRightPlyr.InternalVolume lFadeIn
    
    With rspRightPlyr
        
        .PlayFile CStr(txtRightTrack)
        
    End With
    
    Do While lFadeOut >= 0
        
        Sleep 1
        
        lblRTrackLen = rspRightPlyr.GetLength
        
        lblRTrackPos = rspRightPlyr.GetTime
        
        If rspRightPlyr.GetLength <> 0 Then
            
            lblRTrackPercent = Format(rspRightPlyr.GetTime / rspRightPlyr.GetLength * 100, "0.0") & "%"
            
            lblRTrackPercent.Refresh
            
        End If
        
        lblLTrackLen = rspLeftPlyr.GetLength
        
        lblLTrackPos = rspLeftPlyr.GetTime
        
        If rspLeftPlyr.GetLength <> 0 Then
            
            lblLTrackPercent = Format(rspLeftPlyr.GetTime / rspLeftPlyr.GetLength * 100, "0.0") & "%"
            
            lblLTrackPercent.Refresh
            
        End If
        
        lblFadeOut.Caption = "Fade out :  " & lFadeOut
        lblFadeIn.Caption = "Fade in :  " & lFadeIn
        
        rspLeftPlyr.InternalVolume lFadeOut
        rspRightPlyr.InternalVolume lFadeIn
        
        Start = Timer
        Do While Timer < Start + PauseTime
            Sleep 1
            If m_bCancelfade Then
                GoTo final
            End If
            
            DoEvents
        Loop
        
        lFadeOut = (lFadeOut - 1)
        lFadeIn = (lFadeIn + 1)
        
        
        If m_bCancelfade Then
            GoTo final
        End If
        
        DoEvents
        
    Loop
    
    DoEvents
    
    rspLeftPlyr.CancelPlayback
    
    m_bLeftPlaying = False
    
final:
    
    m_bCancelfade = False
    m_bRIsRunning = False
    
End Sub

Private Sub cmdStart_Click()
    
    rspLeftPlyr.CancelPlayback
    rspRightPlyr.CancelPlayback
    
    m_bLeftPlaying = False
    m_bRightPlaying = False
    
    m_bCancelfade = True
    
    
    With rspLeftPlyr
        Call .CancelPlayback
        Call .InternalVolume(100)
        .PlayFile (txtLeftTrack)
    End With
    
    With rspRightPlyr
        Call .CancelPlayback
        Call .InternalVolume(0)
    End With
    
End Sub

Private Sub cmdStop_Click()
    
    rspLeftPlyr.CancelPlayback
    rspRightPlyr.CancelPlayback
    
    m_bLeftPlaying = False
    m_bRightPlaying = False
    
    m_bCancelfade = True
    
End Sub


Private Sub Form_Load()
    
    ' txtLeftTrack = App.Path & "\Track1.ogg"
    ' txtRightTrack = App.Path & "\Track2.ogg"
    
    ' rspLeftPlyr.SetWaveOutDevice 1
    '   rspRightPlyr.SetWaveOutDevice 1
    
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    
    m_bCancelfade = True
    
End Sub

Private Sub rspLeftPlyr_ErrorCode(ErrorNumber As Long, ErrorDescription As String)
    
    Static NumberOfErrors As Long
    
    NumberOfErrors = NumberOfErrors + 1
    
    'This event is raised in any exception
    With List1
        .AddItem NumberOfErrors & " Left player : " & ErrorNumber & " : " & ErrorDescription
        .ListIndex = .ListCount - 1
    End With
    
End Sub

Private Sub rspLeftPlyr_Finished()
    
    m_bLeftPlaying = False
    
End Sub

Private Sub rspLeftPlyr_PlayBackPosition(NewValue As Long)
    sldrCurrTrack.Value = NewValue
End Sub

Private Sub rspLeftPlyr_Progress(ProgressAsLong As Long, ProgressAsString As String)
    
    m_lLeftPos = ProgressAsLong
    
End Sub

Private Sub rspLeftPlyr_TimePosition(TimeAsSeconds As Long, TimeAsString As String)
    
    On Error GoTo Error1
    
    
    
    lblLTrackLen = TimeAsSeconds
    lblLTrackPos = m_lLeftPos
    lblLTrackPercent = Format(m_lLeftPos / TimeAsSeconds * 100, "0.0") & "%"
    
    m_lSecsLeft = (TimeAsSeconds - m_lLeftPos)
    
    
    If Check1.Value = 1 Then
        
        If (TimeAsSeconds - m_lLeftPos) <= Text1.Text Then
            
            If Not m_bRightPlaying Then
                
                tmrRightPlyr.Enabled = True
                
                m_bRightPlaying = True
                
            End If
            
        End If
        
    Else
        
        If m_lLeftPos / TimeAsSeconds * 100 >= CLng(txtDefFadePos) Then
            
            If Not m_bRightPlaying Then
                
                tmrRightPlyr.Enabled = True
                
                m_bRightPlaying = True
                
            End If
            
        End If
        
    End If
    
    
    
    Exit Sub
    
Error1:
    Err.Clear
    Exit Sub
    
End Sub

Private Sub rspRightPlyr_ErrorCode(ErrorNumber As Long, ErrorDescription As String)
    Static NumberOfErrors As Long
    
    NumberOfErrors = NumberOfErrors + 1
    
    List1.AddItem NumberOfErrors & " Right player : " & ErrorNumber & " : " & ErrorDescription    'This event is raised in any exception
    
    Dim Ret As Long
    
    Ret = List1.ListCount
    
    List1.ListIndex = Ret - 1
End Sub

Private Sub rspRightPlyr_Finished()
    m_bRightPlaying = False
End Sub

Private Sub rspRightPlyr_PlayBackPosition(NewValue As Long)
    SldrCueTrack.Value = NewValue
End Sub

Private Sub rspRightPlyr_Progress(ProgressAsLong As Long, ProgressAsString As String)
    m_lRightPos = ProgressAsLong
End Sub

Private Sub rspRightPlyr_TimePosition(TimeAsSeconds As Long, TimeAsString As String)
    
    On Error GoTo Error1
    
    
    
    lblRTrackLen = TimeAsSeconds
    lblRTrackPos = m_lRightPos
    lblRTrackPercent = Format(m_lRightPos / TimeAsSeconds * 100, "0.0") & "%"
    
    m_lSecsLeft = (TimeAsSeconds - m_lRightPos)
    
    If Check1.Value = 1 Then
        
        If (TimeAsSeconds - m_lRightPos) <= Text1.Text Then
            
            If Not m_bLeftPlaying Then
                
                tmrLeftPlyr.Enabled = True
                m_bLeftPlaying = True
                
            End If
            
        End If
        
    Else
        
        If m_lRightPos / TimeAsSeconds * 100 >= CLng(txtDefFadePos) Then
            
            If Not m_bLeftPlaying Then
                
                tmrLeftPlyr.Enabled = True
                m_bLeftPlaying = True
                
            End If
            
        End If
        
    End If
    
    Exit Sub
    
Error1:
    Err.Clear
    Exit Sub
    
End Sub

Private Sub SldrCueTrack_KeyUp(KeyCode As Integer, Shift As Integer)
    rspRightPlyr.SeekTo SldrCueTrack.Value
End Sub

Private Sub SldrCueTrack_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    rspRightPlyr.SeekTo SldrCueTrack.Value
End Sub

Private Sub SldrCueTrack_Scroll()
    rspRightPlyr.DisableSliderUpdateDuringSeek
End Sub

Private Sub sldrCurrTrack_KeyUp(KeyCode As Integer, Shift As Integer)
    rspLeftPlyr.SeekTo sldrCurrTrack.Value
End Sub

Private Sub sldrCurrTrack_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    rspLeftPlyr.SeekTo sldrCurrTrack.Value
End Sub

Private Sub sldrCurrTrack_Scroll()
    rspLeftPlyr.DisableSliderUpdateDuringSeek
End Sub

Private Sub tmrRightPlyr_Timer()
    
    Dim PauseTime As Double
    Dim Start As Double
    Dim lFadeOut As Long
    Dim lFadeIn As Long
    
    
    
    If m_bRIsRunning = True Then
        
        Debug.Print Time & " Already executing , exiting "
        Exit Sub
    End If
    
    lFadeOut = 100
    lFadeIn = 0
    
    m_bCancelfade = False
    
    tmrRightPlyr.Enabled = False
    
    m_bRIsRunning = True
    
    If Check1.Value = 1 Then
        
        m_lSecsLeft = Text1.Text
        
    End If
    
    If (m_lSecsLeft) <> 0 Then
        
        PauseTime = (m_lSecsLeft) / 100
        
    Else
        
        PauseTime = 0.1
        
    End If
    
    lblFadeInSecs.Caption = "Fade in seconds : " & m_lSecsLeft
    
    rspLeftPlyr.InternalVolume lFadeOut
    
    rspRightPlyr.InternalVolume lFadeIn
    
    With rspRightPlyr
        
        .PlayFile CStr(txtRightTrack)
        
    End With
    
    Do While lFadeOut >= 0
        Sleep 1
        lblRTrackLen = rspRightPlyr.GetLength
        
        lblRTrackPos = rspRightPlyr.GetTime
        
        If rspRightPlyr.GetLength <> 0 Then
            
            lblRTrackPercent = Format(rspRightPlyr.GetTime / rspRightPlyr.GetLength * 100, "0.0") & "%"
            
            lblRTrackPercent.Refresh
            
        End If
        
        lblLTrackLen = rspLeftPlyr.GetLength
        
        lblLTrackPos = rspLeftPlyr.GetTime
        
        If rspLeftPlyr.GetLength <> 0 Then
            
            lblLTrackPercent = Format(rspLeftPlyr.GetTime / rspLeftPlyr.GetLength * 100, "0.0") & "%"
            
            lblLTrackPercent.Refresh
            
        End If
        
        lblFadeOut.Caption = "Fade out :  " & lFadeOut
        
        lblFadeIn.Caption = "Fade in :  " & lFadeIn
        
        rspLeftPlyr.InternalVolume lFadeOut
        rspRightPlyr.InternalVolume lFadeIn
        
        Start = Timer
        Do While Timer < Start + PauseTime
            Sleep 1
            If m_bCancelfade Then
                GoTo final
            End If
            
            DoEvents
        Loop
        
        lFadeOut = (lFadeOut - 1)
        lFadeIn = (lFadeIn + 1)
        
        
        If m_bCancelfade Then
            GoTo final
        End If
        
        DoEvents
        
    Loop
    
    DoEvents
    
    m_bLeftPlaying = False
    
final:
    m_bCancelfade = False
    m_bRIsRunning = False
    
End Sub

Private Sub tmrLeftPlyr_Timer()
    
    Dim PauseTime As Double
    Dim Start As Double
    Dim lFadeOut As Long
    Dim lFadeIn As Long
    
    
    
    
    
    If m_bLIsRunning = True Then
        
        Debug.Print Time & " Already executing , exiting "
        Exit Sub
    End If
    
    lFadeOut = 100
    lFadeIn = 0
    m_bCancelfade = False
    tmrLeftPlyr.Enabled = False
    
    
    m_bLIsRunning = True
    
    
    If Check1.Value = 1 Then
        
        m_lSecsLeft = Text1.Text
        
    End If
    
    
    If (m_lSecsLeft) <> 0 Then
        
        PauseTime = (m_lSecsLeft) / 100
    Else
        PauseTime = 0.1
        
    End If
    
    lblFadeInSecs.Caption = "Fade in seconds : " & m_lSecsLeft
    
    rspRightPlyr.InternalVolume lFadeOut
    
    rspLeftPlyr.InternalVolume lFadeIn
    
    With rspLeftPlyr
        
        .PlayFile CStr(txtLeftTrack)
        
    End With
    
    Do While lFadeOut >= 0
        Sleep 1
        lblRTrackLen = rspRightPlyr.GetLength
        
        lblRTrackPos = rspRightPlyr.GetTime
        
        If rspRightPlyr.GetLength <> 0 Then
            
            lblRTrackPercent = Format(rspRightPlyr.GetTime / rspRightPlyr.GetLength * 100, "0.0") & "%"
            
            lblRTrackPercent.Refresh
            
        End If
        
        lblLTrackLen = rspLeftPlyr.GetLength
        
        lblLTrackPos = rspLeftPlyr.GetTime
        
        If rspLeftPlyr.GetLength <> 0 Then
            
            lblLTrackPercent = Format(rspLeftPlyr.GetTime / rspLeftPlyr.GetLength * 100, "0.0") & "%"
            
            lblLTrackPercent.Refresh
            
        End If
        
        
        lblFadeOut.Caption = "Fade out :  " & lFadeOut
        
        lblFadeIn.Caption = "Fade in :  " & lFadeIn
        
        rspRightPlyr.InternalVolume lFadeOut
        
        rspLeftPlyr.InternalVolume lFadeIn
        
        Start = Timer
        
        Do While Timer < Start + PauseTime
            Sleep 1
            If m_bCancelfade Then
                GoTo final
            End If
            
            DoEvents
            
        Loop
        
        lFadeOut = (lFadeOut - 1)
        lFadeIn = (lFadeIn + 1)
        
        If m_bCancelfade Then
            GoTo final
        End If
        
        DoEvents
        
    Loop
    
    DoEvents
    
    m_bRightPlaying = False
    
final:
    m_bCancelfade = False
    m_bLIsRunning = False
    
End Sub

Private Sub txtDefFadePos_Change()
    
    rspLeftPlyr.CancelPlayback
    rspRightPlyr.CancelPlayback
    
    m_bLeftPlaying = False
    m_bRightPlaying = False
    
    m_bCancelfade = True
    
End Sub
