'VBScript sample, based on OstroSoft SMTP component
'written by Igor Ostrovsky (OstroSoft)
'
'OstroSoft SMTP component is available for download at
'http://www.ostrosoft.com/download/smtp_component.zip
'
'full installation for OstroSoft SMTP component (in case your system 
'doesn't have VB run-time libraries) is available for download at
'http://www.ostrosoft.com/download/full/smtp_component.exe
'
'email questions, suggestions, comments to info@ostrosoft.com

Set oSMTPSession = CreateObject("OSSMTP.SMTPSession")

With oSMTPSession
  .MailFrom = """test sender"" test@mydomain.com"
  .SendTo = "rcpt@mydomain.com"
  .Server = "mailserver.mydomain.com"
  .Port = 25
  .MessageSubject = "test"
  .MessageText = "this is" & vbCrLf & "a multi-line" & vbCrLf & "test"

  'authenticate if your mail server require it
  '.AuthenticationType = 1 'POP3 authentication
  '.POPServer = "mailserver.mydomain.com"
  '.Username = "test"
  '.Password = "test"
  
  'if SMTP Component incorrectly detects message date/time, you can over-write it using TimeStamp property
  '.TimeStamp = "20 Oct 2003 19:22:50"
  
  'SMTP Component defaults to "US-ASCII" character set, to change it use Charset property
  '.Charset = "GB2312"
  
  'adding attachments
  'using Attachment object
  Set oAttachment = CreateObject("OSSMTP.Attachment")
  oAttachment.FilePath = "D:\temp\sample.txt"
  oAttachment.AttachmentName = "test file"
  oAttachment.ContentType = "application/xml"
  oAttachment.ContentTransferEncoding = 1 'enc7Bit
  .Attachments.Add oAttachment
  'by attachment location. In this case attachment_name = {file name}, content_type will be
  'autodetected (based on your Registry settings), content_transfer_encoding = {64 bit}
  .Attachments.Add "D:\temp\test.exe"
  
  'adding custom headers
  'using CustomHeader object
  Set oCustomHeader = CreateObject("OSSMTP.CustomHeader")
  oCustomHeader.HeaderName = "Return-Path"
  oCustomHeader.HeaderValue = "postmaster@mydomain.com"
  .CustomHeaders.Add oCustomHeader
  'in a single string
  .CustomHeaders.Add "Reply-To: errors@mydomain.com"
  
  .SendEmail
End With

Set oSMTPSession = Nothing
