package com.sciapp.demo;

import com.sciapp.table.ObjectTableModel;
/**
 *
 */
public class PersonTableModel extends ObjectTableModel {
/**
 *
 */
public PersonTableModel() {
	super(new String[] { "Name", "Country", "Telephone", "Married", "Weight (kg)", "Date of Birth" });
}
/**
 *
 */
public Object getValueAt(Object o,int index) {
	PersonDetails pd = (PersonDetails) o;
	Object ret = null;
	switch (index) {
		case 0: {
			ret = pd.name;
			break;
		}
		case 1: {
			ret = pd.country;
			break;
		}
		case 2: {
			ret = pd.tel;
			break;
		}
		case 3: {
			ret = new Boolean(pd.married);
			break;
		}
		case 4: {
			ret = new Integer(pd.weight);
			break;
		}
		case 5: {
			ret = pd.dob;
			break;
		}
	}
	return ret;
}
/**
 *
 */
public void setValueAt(Object o, Object value, int index) {
	PersonDetails pd = (PersonDetails) o;
	switch (index) {
		case 0: {
			pd.name = value.toString();
			break;
		}
		case 1: {
			pd.country = value.toString();
			break;
		}
		case 2: {
			pd.tel = value.toString();
			break;
		}
		case 3: {
			pd.married = ((Boolean) value).booleanValue();
			break;
		}
		case 4: {
			if (value == null || value.toString().equals("")) pd.weight = 0;
			else pd.weight = Integer.parseInt(value.toString());
			break;
		}
		case 5: {
			pd.dob = (java.util.Date) value;
			break;
		}
	}
}
}
