/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.SkinRootPaneUI;
import com.l2fprod.util.OS;
import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;

public interface Window {
    public static final String IS_SHADED_PROPERTY = "shaded";
    public static final String SHADE_BOUNDS_PROPERTY = "windowshadeBounds";

    public Container getContainer();

    public void addPropertyChangeListener(PropertyChangeListener var1);

    public void removePropertyChangeListener(PropertyChangeListener var1);

    public boolean isSelected();

    public void setSelected(boolean var1) throws PropertyVetoException;

    public boolean isIcon();

    public void setIcon(boolean var1) throws PropertyVetoException;

    public boolean isMaximum();

    public void setMaximum(boolean var1) throws PropertyVetoException;

    public boolean isShaded();

    public void setShaded(boolean var1);

    public boolean isMaximizable();

    public boolean isIconifiable();

    public boolean isClosable();

    public void setClosed(boolean var1) throws PropertyVetoException;

    public boolean isResizable();

    public String getTitle();

    public Icon getFrameIcon();

    public void dispatchEvent(AWTEvent var1);

    static class 1 {
        static /* synthetic */ Class class$java$awt$Frame;

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class FrameWindow
    implements Window {
        private JFrame frame = null;
        private JDialog dialog = null;
        private Rectangle restoreBounds = null;
        private Rectangle oldBounds = null;
        private boolean shaded = false;

        public void setFrame(java.awt.Window window) {
            if (window instanceof JDialog) {
                this.dialog = (JDialog)window;
            } else if (window instanceof JFrame) {
                this.frame = (JFrame)window;
            } else {
                this.frame = null;
                this.dialog = null;
            }
            this.oldBounds = null;
            this.shaded = false;
        }

        public void setSelected(boolean bl) throws PropertyVetoException {
            if (this.frame != null) {
                this.frame.show();
                this.frame.toFront();
            } else if (this.dialog != null) {
                this.dialog.show();
                this.dialog.toFront();
            }
        }

        public java.awt.Window getMainFrame() {
            java.awt.Window window = null;
            if (this.frame != null) {
                window = this.frame;
            } else if (this.dialog != null) {
                window = this.dialog;
            }
            return window;
        }

        public void setIcon(boolean bl) throws PropertyVetoException {
            if (this.frame != null) {
                this.frame.setState(1);
            } else if (this.dialog != null) {
                // empty if block
            }
        }

        public void setMaximum(boolean bl) throws PropertyVetoException {
            if (this.frame != null) {
                if (SkinRootPaneUI.getExtendedState(this.frame) != SkinRootPaneUI.Frame_MAXIMIZED_BOTH) {
                    this.restoreBounds = this.frame.getBounds();
                    SkinRootPaneUI.setExtendedState(this.frame, SkinRootPaneUI.Frame_MAXIMIZED_BOTH);
                } else if (this.restoreBounds != null) {
                    this.frame.setBounds(this.restoreBounds);
                }
                this.dispatchEvent(new ComponentEvent(this.frame, 101));
            } else if (this.dialog != null) {
                // empty if block
            }
        }

        public void setShaded(boolean bl) {
            java.awt.Window window;
            java.awt.Window window2 = window = this.frame == null ? this.dialog : this.frame;
            if (window == null || bl == this.shaded) {
                return;
            }
            if (bl) {
                Rectangle rectangle = window.getBounds();
                this.oldBounds = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                window.setBounds(this.oldBounds.x, this.oldBounds.y, this.oldBounds.width, window.getMinimumSize().height - 2);
            } else {
                Point point = window.getLocation();
                window.setBounds(point.x, point.y, this.oldBounds.width, this.oldBounds.height);
                this.oldBounds = null;
            }
            this.shaded = bl;
        }

        public void setClosed(boolean bl) throws PropertyVetoException {
            if (this.frame != null) {
                this.frame.dispatchEvent(new WindowEvent(this.frame, 201));
            } else if (this.dialog != null) {
                this.dialog.dispatchEvent(new WindowEvent(this.dialog, 201));
            }
        }

        public Container getContainer() {
            if (this.frame != null) {
                return this.frame.getContentPane();
            }
            if (this.dialog != null) {
                return this.dialog.getContentPane();
            }
            return null;
        }

        public boolean isSelected() {
            boolean bl = true;
            if (this.frame != null) {
                bl = this.frame.isShowing();
            } else if (this.dialog != null) {
                bl = this.dialog.isShowing();
            }
            return bl;
        }

        public boolean isIcon() {
            boolean bl = false;
            if (this.frame != null) {
                bl = this.frame.getState() == 1;
            }
            return bl;
        }

        public boolean isMaximum() {
            boolean bl = false;
            if (this.frame != null) {
                bl = SkinRootPaneUI.getExtendedState(this.frame) == SkinRootPaneUI.Frame_MAXIMIZED_BOTH;
            }
            return bl;
        }

        public boolean isMaximizable() {
            boolean bl = false;
            if (this.frame != null) {
                bl = this.frame.isResizable() && !this.isShaded();
            }
            return bl;
        }

        public boolean isShaded() {
            return this.shaded;
        }

        public boolean isIconifiable() {
            boolean bl = false;
            if (this.frame != null) {
                bl = this.frame.isResizable();
            }
            return bl;
        }

        public boolean isClosable() {
            return true;
        }

        public boolean isResizable() {
            boolean bl = false;
            if (this.frame != null) {
                bl = this.frame.isResizable();
            } else if (this.dialog != null) {
                return this.dialog.isResizable() && !this.isShaded();
            }
            return bl;
        }

        public String getTitle() {
            String string = "";
            if (this.frame != null) {
                string = this.frame.getTitle();
            } else if (this.dialog != null) {
                string = this.dialog.getTitle();
            }
            return string;
        }

        public Icon getFrameIcon() {
            Frame frame;
            ImageIcon imageIcon = null;
            Image image = null;
            if (this.frame != null) {
                image = this.frame.getIconImage();
            } else if (this.dialog != null && (frame = (Frame)SwingUtilities.getAncestorOfClass(1.class$java$awt$Frame == null ? (1.class$java$awt$Frame = 1.class$("java.awt.Frame")) : 1.class$java$awt$Frame, this.dialog)) != null) {
                image = frame.getIconImage();
            }
            if (image != null) {
                imageIcon = new ImageIcon(image);
            }
            return imageIcon;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.frame != null) {
                this.frame.addPropertyChangeListener(propertyChangeListener);
            } else if (this.dialog != null) {
                this.dialog.addPropertyChangeListener(propertyChangeListener);
            }
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.frame != null) {
                this.frame.removePropertyChangeListener(propertyChangeListener);
            } else if (this.dialog != null) {
                this.dialog.removePropertyChangeListener(propertyChangeListener);
            }
        }

        public void dispatchEvent(AWTEvent aWTEvent) {
            if (this.frame != null) {
                this.frame.dispatchEvent(aWTEvent);
            } else if (this.dialog != null) {
                this.dialog.dispatchEvent(aWTEvent);
            }
        }

        public String toString() {
            return super.toString() + "[title=" + this.getTitle() + "]";
        }
    }

    public static class InternalFrameWindow
    implements Window {
        JInternalFrame frame;
        boolean shaded = false;

        public InternalFrameWindow(JInternalFrame jInternalFrame) {
            this.frame = jInternalFrame;
        }

        public void setSelected(boolean bl) throws PropertyVetoException {
            this.frame.setSelected(bl);
        }

        public void setIcon(boolean bl) throws PropertyVetoException {
            this.frame.setIcon(bl);
        }

        public void setMaximum(boolean bl) throws PropertyVetoException {
            this.frame.setMaximum(bl);
        }

        public void setShaded(boolean bl) {
            if (bl == this.shaded) {
                return;
            }
            if (bl) {
                Rectangle rectangle = this.frame.getBounds();
                Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                this.frame.putClientProperty(Window.SHADE_BOUNDS_PROPERTY, rectangle2);
                this.frame.setBounds(rectangle2.x, rectangle2.y, rectangle2.width, this.frame.getMinimumSize().height - 2);
            } else {
                Point point = this.frame.getLocation();
                Rectangle rectangle = (Rectangle)this.frame.getClientProperty(Window.SHADE_BOUNDS_PROPERTY);
                this.frame.getDesktopPane().getDesktopManager().setBoundsForFrame(this.frame, point.x, point.y, rectangle.width, rectangle.height);
                this.frame.putClientProperty(Window.SHADE_BOUNDS_PROPERTY, null);
            }
            this.shaded = bl;
        }

        public void setClosed(boolean bl) throws PropertyVetoException {
            if (OS.isOneDotThreeOrMore()) {
                try {
                    Class.forName("javax.swing.JInternalFrame").getMethod("doDefaultCloseAction", new Class[0]).invoke((Object)this.frame, null);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                if (!bl) {
                    this.frame.setClosed(bl);
                    return;
                }
                this.doDefaultCloseAction();
            }
        }

        public Container getContainer() {
            return this.frame;
        }

        public boolean isSelected() {
            return this.frame.isSelected();
        }

        public boolean isIcon() {
            return this.frame.isIcon();
        }

        public boolean isMaximum() {
            return this.frame.isMaximum();
        }

        public boolean isShaded() {
            return this.shaded;
        }

        public boolean isMaximizable() {
            return this.frame.isMaximizable();
        }

        public boolean isIconifiable() {
            return this.frame.isIconifiable();
        }

        public boolean isClosable() {
            return this.frame.isClosable();
        }

        public boolean isResizable() {
            return !this.isShaded() && this.frame.isResizable();
        }

        public String getTitle() {
            return this.frame.getTitle();
        }

        public Icon getFrameIcon() {
            return this.frame.getFrameIcon();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.frame.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.frame.removePropertyChangeListener(propertyChangeListener);
        }

        public void dispatchEvent(AWTEvent aWTEvent) {
            this.frame.dispatchEvent(aWTEvent);
        }

        private void doDefaultCloseAction() {
            int n = this.frame.getDefaultCloseOperation();
            this.frame.setDefaultCloseOperation(0);
            switch (n) {
                case 1: {
                    try {
                        this.frame.setClosed(true);
                        this.frame.setVisible(false);
                        if (!this.frame.isSelected()) break;
                        this.frame.setSelected(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                    break;
                }
                case 2: {
                    try {
                        this.frame.setClosed(true);
                        this.frame.dispose();
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                    break;
                }
                case 3: {
                    System.exit(0);
                    break;
                }
                case 0: {
                    try {
                        this.frame.setClosed(true);
                        break;
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
            this.frame.setDefaultCloseOperation(n);
        }

        public String toString() {
            return super.toString() + "[title=" + this.getTitle() + "]";
        }
    }
}

