/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;

public final class SkinToolTipUI
extends BasicToolTipUI {
    static SkinToolTipUI sharedInstance = new SkinToolTipUI();
    private Font smallFont;
    private JToolTip tip;
    public static final int padSpaceBetweenStrings = 12;
    private String acceleratorDelimiter;

    public static ComponentUI createUI(JComponent jComponent) {
        return sharedInstance;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.tip = (JToolTip)jComponent;
        Font font = jComponent.getFont();
        this.smallFont = new Font(font.getName(), font.getStyle(), font.getSize() - 2);
        this.acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "-";
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        Font font = jComponent.getFont();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        String string = this.getAcceleratorString();
        String string2 = ((JToolTip)jComponent).getTipText();
        if (string2 == null) {
            string2 = "";
        }
        if (!string.equals("")) {
            graphics.setFont(this.smallFont);
            graphics.setColor(jComponent.getForeground());
            graphics.drawString(string, fontMetrics.stringWidth(string2) + 12, 2 + fontMetrics.getAscent());
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        String string = this.getAcceleratorString();
        if (!string.equals("")) {
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.smallFont);
            dimension.width += fontMetrics.stringWidth(string) + 12;
        }
        return dimension;
    }

    public String getAcceleratorString() {
        int n;
        JComponent jComponent = this.tip.getComponent();
        if (jComponent == null) {
            return "";
        }
        KeyStroke[] keyStrokeArray = jComponent.getRegisteredKeyStrokes();
        String string = "";
        for (n = 0; n < keyStrokeArray.length; ++n) {
            int n2 = keyStrokeArray[n].getModifiers();
            int n3 = jComponent.getConditionForKeyStroke(keyStrokeArray[n]);
            if (n3 != 2 || (n2 & 8) == 0 && (n2 & 2) == 0 && (n2 & 1) == 0 && (n2 & 4) == 0) continue;
            string = KeyEvent.getKeyModifiersText(n2) + this.acceleratorDelimiter + (char)keyStrokeArray[n].getKeyCode();
            break;
        }
        if (string.equals("") && jComponent instanceof JMenuItem && (n = ((JMenuItem)jComponent).getMnemonic()) != 0) {
            string = "Alt" + this.acceleratorDelimiter + (char)n;
        }
        return string;
    }
}

