
#ifndef QRCODEENCODEDLL_H
#define	QRCODEENCODEDLL_H

#ifdef QRCODEENCODEDLL_EXPORTS
#define QRCODEENCODEDLL_API __declspec(dllexport)
#else
#define QRCODEENCODEDLL_API __declspec(dllimport)
#endif

#include "stdafx.h"

typedef struct tagQRCODECONTEXT
{
	int		preferredVersion;
	int		selectedVersion;
	int*	controlChars;				// ݳ
	int		correctionLevel;
	int		encoding;
	int		eci;
	int		fnc1Mode;
	int		structuredAppendIndex; 
	int		structuredAppendCounter;
	int		applicationIndicator;
	int     nSize;
	bool	structuredAppend;
	bool	processTilde;
	bool	autoConfigurate;
	BYTE	nMargin;
	BYTE	nPixelSize;
	COLORREF clBackGround;
	COLORREF clForeGround;
	char	cData[7100];				// _$3342ַб;
} QRCODECONTEXT,*LPQRCODECONTEXT;

QRCODEENCODEDLL_API void InitWorkSpace(QRCODECONTEXT *pQRCodeCtx);
QRCODEENCODEDLL_API HBITMAP QRCodeEncode2Bitmap(QRCODECONTEXT *pQRCodeCtx);
QRCODEENCODEDLL_API BOOL QRCodeEncode2File(QRCODECONTEXT *pQRCodeCtx,LPCTSTR pImageFile);
QRCODEENCODEDLL_API BOOL FreeWorkSpace();

#endif	/*QRCODEENCODEDLL_H*/
