/*
 * Decompiled with CFR 0.152.
 */
package com.smardec.j2native;

import com.smardec.j2native.Argument;
import com.smardec.j2native.NumericType;
import com.smardec.j2native.g;

public abstract class NumericArgument
extends Argument
implements NumericType {
    protected void writeToStack(byte[] byArray, int n) {
        this.toBytesValue(byArray, n);
    }

    protected void readFromStack(byte[] byArray, int n) {
        this.fromBytesValue(byArray, n);
    }

    protected abstract long value2Bits();

    protected abstract void bits2Value(long var1);

    protected abstract boolean isSigned();

    protected abstract boolean isFloat();

    public byte[] toBytesValue() {
        byte[] byArray = new byte[this.getLength()];
        this.toBytesValue(byArray, 0);
        return byArray;
    }

    protected void toBytesValue(byte[] byArray, int n) {
        int n2 = this.getLength();
        long l = this.value2Bits();
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3 + n] = (byte)(l % 256L);
            l >>>= 8;
            ++n3;
        }
    }

    public void fromBytesValue(byte[] byArray, int n) {
        int n2 = Math.min(byArray.length - n, this.getLength());
        long l = 0L;
        int n3 = n2 + n - 1;
        while (n3 >= n) {
            l <<= 8;
            l |= (long)(byArray[n3] & 0xFF);
            --n3;
        }
        this.bits2Value(l);
    }

    public boolean equals(Object object) {
        if (this.getClass().equals(object.getClass())) {
            return this.value2Bits() == ((NumericArgument)object).value2Bits();
        }
        return false;
    }

    public int hashCode() {
        return this.intValue();
    }

    protected final void write(long l, int n) {
        switch (this.getLength()) {
            case 1: {
                g.getInstance().writeBYTE(l, n, this.byteValue());
                break;
            }
            case 2: {
                g.getInstance().writeWORD(l, n, this.shortValue());
                break;
            }
            case 4: {
                g.getInstance().writeDWORD(l, n, (int)this.value2Bits());
                break;
            }
            case 8: {
                g.getInstance().writeQWORD(l, n, this.value2Bits());
            }
        }
    }

    protected final void read(long l, int n) {
        switch (this.getLength()) {
            case 1: {
                this.bits2Value(g.getInstance().readBYTE(l, n));
                break;
            }
            case 2: {
                this.bits2Value(g.getInstance().readWORD(l, n));
                break;
            }
            case 4: {
                this.bits2Value(g.getInstance().readDWORD(l, n));
                break;
            }
            case 8: {
                this.bits2Value(g.getInstance().readQWORD(l, n));
            }
        }
    }
}

