#ifndef _EDCFORMULA_H
#define _EDCFORMULA_H

#include <queue>
#include <string>
#include <comutil.h>

using namespace std;
#define FORMULALEN 1024
#ifdef __BUILDING_THE_DLL
    #define __EXPORT_TYPE __declspec(dllexport)
#else
	#define __EXPORT_TYPE __declspec(dllexport)
#endif

typedef  struct {
  char* Operator;
  short priority;
  short NoOperants;
} OPERATOR;

typedef enum {
    endformulasy=-2,
    badsy,
/* integer and real */
	intsy=1,
	realsy,
/* string */
	stringsy,

	columnsy,
    fomulasy,      

	functionsy,

/* operators */
    equalsy,
    dividsy,
    multiplysy,
    plussy,
    minussy,
    negativesy,
    greatsy,
    lesssy,
    greateqsy,
    lesseqsy,
    andsy,
    orsy,
/* parenthese*/
    leftquosy,
    rightquosy,

    commasy
} Symbol;

struct Token{
    Symbol sy;
    _variant_t val;
    int index;

    Token():sy(badsy){};
};

#ifndef __BUILDING_ACTIVEX
class __EXPORT_TYPE DataAdapter{
public:
    // This method will be called when a context related element is encounted
    // it returns the value of the element in context
	virtual _variant_t GetOperantValue(const char* pOperantName);

    // This method will be called when another formula is encounted, it will return the formul
    // expression represented by the formula name
    virtual string GetFormulaByName(const char* pFormulaName);

    //Check if an element can be intepreted
    virtual bool    IsKnown(const char*  pOperantName);
};
DataAdapter DefaultAdapter;
#else
#include "EasyFormula_MFC_i.h"
typedef    IDataAdapter DataAdapter;
#endif


class __EXPORT_TYPE EFormula
{
public:
    EFormula(const char* formula);
    EFormula();

    Token GetNextToken();
    void SetFormulaStr(const char* strFormula);
    // compile the the internal formula
    // ErrorMsg contains error information in case of compile failed
    bool Compile(int &ErrPos, string &ErrorMsg);

    // Set serial Code
    void SetSerialCode(const char* Serial);

    // calculate the compiled formula
    // if ErrPos>0, the calculation is failed, it points to error position
    // Msg returns an error message string
    _variant_t Calculate(int &ErrPos, string &Msg);

    int GetCurrentPos() { return m_pos;}
#ifndef __BUILDING_ACTIVEX
    void SetDataAdapter(DataAdapter* pAdapter);
#else
    void SetDataAdapter(IDispatch* pAdapter);
#endif
    EFormula& operator=(const EFormula& src);
    char const *GetFormulaStr() const { return(m_strFormula);};

private:
    deque<Token> m_RP;         // compiled formula in reverse polish format
    char m_strFormula[FORMULALEN];
    char m_serial[128];
    int m_pos;
    int m_nTokens;
    bool m_bCompiled;
    bool IsOperator(const char *str, OPERATOR *pOp);
    short GetTokenPriority(Token tk);


    Token GetNumber();
    Token GetString();
    Token GetFunction();
    Token GetColumn();
    Token GetFormula();
    Token GetOperDel();
    DataAdapter *m_pAdapter;
    unsigned short OperantNum();
};


#endif
