/*

  Copyright (C) 2003-2005 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.asc.xpmenu;

import com.smardec.asc.animatepanel.AnimateTabHeaderRenderer;
import com.smardec.asc.animatepanel.JAnimateTabHeader;

import javax.swing.*;
import java.awt.*;
import java.io.Serializable;


/**
 * Sample class that demonstrates the usage of <code>JAnimatePanel</code>.
 */
public class XPTabHeaderRenderer extends JComponent implements AnimateTabHeaderRenderer, Serializable {
    private static final ImageIcon leftHeader = new ImageIcon(JXPMenuTab.class.getClassLoader().getResource("com/smardec/asc/img/XPRenderer/leftHeader.gif"));
    private static final ImageIcon rightHeader = new ImageIcon(JXPMenuTab.class.getClassLoader().getResource("com/smardec/asc/img/XPRenderer/rightHeader.gif"));
    private static final ImageIcon rightHeaderS = new ImageIcon(JXPMenuTab.class.getClassLoader().getResource("com/smardec/asc/img/XPRenderer/rightHeaderS.gif"));
    private static final ImageIcon rightHeaderUp = new ImageIcon(JXPMenuTab.class.getClassLoader().getResource("com/smardec/asc/img/XPRenderer/rightHeaderUp.gif"));
    private static final ImageIcon rightHeaderUpS = new ImageIcon(JXPMenuTab.class.getClassLoader().getResource("com/smardec/asc/img/XPRenderer/rightHeaderUpS.gif"));
    private static final ImageIcon centerHeader = new ImageIcon(JXPMenuTab.class.getClassLoader().getResource("com/smardec/asc/img/XPRenderer/centerHeader.gif"));

    private boolean mouseOver;
    private JAnimateTabHeader jAnimateTabHeader;

    public Component getAnimateTabHeaderRendererComponent(JAnimateTabHeader jAnimateTabHeader, boolean mouseOver, boolean mousePressed) {
        setOpaque(false);
        setSize(jAnimateTabHeader.getSize());

        this.mouseOver = mouseOver;
        this.jAnimateTabHeader = jAnimateTabHeader;

        return this;
    }

    protected void paintComponent(Graphics g) {
        int l_width = leftHeader.getImage().getWidth(this);
        int l_height = leftHeader.getImage().getHeight(this);
        g.drawImage(leftHeader.getImage(), 0, 0, l_width, l_height, this);


        int r_width;
        int r_height;
        int r_x;
        if (mouseOver) {
            r_width = rightHeaderS.getImage().getWidth(this);
            r_height = rightHeaderS.getImage().getHeight(this);
            r_x = getWidth() - l_width - r_width;
            if (jAnimateTabHeader.getAnimateTab() != null && jAnimateTabHeader.getAnimateTab().isSelected())
                g.drawImage(rightHeaderUpS.getImage(), r_x, 0, r_width, r_height, this);
            else
                g.drawImage(rightHeaderS.getImage(), r_x, 0, r_width, r_height, this);
        } else {
            r_width = rightHeader.getImage().getWidth(this);
            r_height = rightHeader.getImage().getHeight(this);
            r_x = getWidth() - l_width - r_width;
            if (jAnimateTabHeader.getAnimateTab() != null && jAnimateTabHeader.getAnimateTab().isSelected())
                g.drawImage(rightHeaderUp.getImage(), r_x, 0, r_width, r_height, this);
            else
                g.drawImage(rightHeader.getImage(), r_x, 0, r_width, r_height, this);
        }

        int c_width = centerHeader.getImage().getWidth(null);
        int c_height = centerHeader.getImage().getHeight(null);
        for (int i = 0; i <= r_x; i += (c_width))
            g.drawImage(centerHeader.getImage(), i, 0, c_width, c_height, this);

        g.setFont(jAnimateTabHeader.getFont());

        FontMetrics fontmetrics = getFontMetrics(jAnimateTabHeader.getFont());
        int w = fontmetrics.stringWidth(jAnimateTabHeader.getText());
        int h = fontmetrics.getHeight();

        g.drawString(jAnimateTabHeader.getText(), (getWidth() - w) / 2, (int) (getHeight() - h / 1.5));
    }
}

