/*

  Copyright (C) 2003-2005 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.asc.xpmenu;

import javax.swing.*;
import java.awt.*;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;


/**
 * Sample class that demonstrates the usage of <code>JAnimatePanel</code>.
 */
public class JXPMenuItem extends JLabel {
    private String text;

    public JXPMenuItem(String text, Icon icon) {
        super(icon, SwingConstants.LEFT);
        super.setForeground(Color.blue);
        this.text = text;
        super.setText("<html>" + JXPMenuItem.this.text + "</html>");

        addMouseListener(new MouseAdapter() {
            public void mouseEntered(MouseEvent e) {
                setText("<html><u>" + JXPMenuItem.this.text + "</u></html>");
            }

            public void mouseExited(MouseEvent e) {
                setText("<html>" + JXPMenuItem.this.text + "</html>");
            }

            public void mousePressed(MouseEvent e) {
                System.out.println("Item " + JXPMenuItem.this.text + " clicked");
            }
        });
    }
}
