/*

  Copyright (C) 2003-2005 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.asc.table;

import javax.swing.*;
import javax.swing.table.TableCellRenderer;
import java.awt.*;


/**
 * Renderer for table header. It displays arrows on sorted column's header.
 */
public class SortedTableHeaderRenderer implements TableCellRenderer {
    private static final ImageIcon ARROW_UP = new ImageIcon(SortedTableHeaderRenderer.class.getClassLoader().getResource("com/smardec/asc/img/table/ArrowUp.gif"));
    private static final ImageIcon ARROW_DOWN = new ImageIcon(SortedTableHeaderRenderer.class.getClassLoader().getResource("com/smardec/asc/img/table/ArrowDown.gif"));
    private JTable table;
    private SortedTableModel sortedTableModel;
    private TableCellRenderer defaultRenderer;

    /**
     * Creates <code>SortedTableHeaderRenderer</code> object with specified <code>JTable</code>
     * and <code>SortedTableModel</code>.
     *
     * @param table            <code>JTable</code> component
     * @param sortedTableModel <code>SortedTableModel</code> object
     */
    public SortedTableHeaderRenderer(JTable table, SortedTableModel sortedTableModel) {
        this.table = table;
        this.sortedTableModel = sortedTableModel;
        defaultRenderer = table.getTableHeader().getDefaultRenderer();
    }


    /**
     * Returns the component used for drawing the cell.  This method is
     * used to configure the renderer appropriately before drawing.
     *
     * @param	table		the <code>JTable</code> that is asking the
     * renderer to draw; can be <code>null</code>
     * @param	value		the value of the cell to be rendered.  It is
     * up to the specific renderer to interpret
     * and draw the value.  For example, if
     * <code>value</code>
     * is the string "true", it could be rendered as a
     * string or it could be rendered as a check
     * box that is checked.  <code>null</code> is a
     * valid value
     * @param	isSelected	true if the cell is to be rendered with the
     * selection highlighted; otherwise false
     * @param	hasFocus	if true, render cell appropriately.  For
     * example, put a special border on the cell, if
     * the cell can be edited, render in the color used
     * to indicate editing
     * @param	row	 the row index of the cell being drawn.  When
     * drawing the header, the value of
     * <code>row</code> is -1
     * @param	column	 the column index of the cell being drawn
     */
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component tableCellRendererComponent = defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (tableCellRendererComponent instanceof JLabel) {
            JLabel jLabel = (JLabel) tableCellRendererComponent;
            jLabel.setHorizontalTextPosition(JLabel.LEADING);
            jLabel.setIcon(getIcon(column));
        }
        return tableCellRendererComponent;
    }

    /**
     * Returns <code>Icon</code> that corresponds current ascending state.
     *
     * @param column column index
     * @return <code>Icon</code> that corresponds current ascending state.
     */
    private Icon getIcon(int column) {
        if (sortedTableModel.getSortingColumn() == table.convertColumnIndexToModel(column))
            return sortedTableModel.isAscending() ? ARROW_DOWN : ARROW_UP;
        return null;
    }
}
