/*

  Copyright (C) 2003-2005 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.asc.table;

import javax.swing.table.TableModel;


/**
 * A filter function used for filtering table rows.
 */
public interface RowFilter {
    /**
     * Filters table rows. Returns <code>true</code> if the row should be
     * excluded, <code>false</code> otherwise.
     *
     * @param row        row to check
     * @param tableModel table's model
     * @return <code>true</code> if the row should be
     *         excluded, <code>false</code> otherwise.
     */
    public boolean exclude(int row, TableModel tableModel);
}
