/*

  Copyright (C) 2003-2005 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.asc.table;

import javax.swing.table.TableModel;


/**
 * A comparison function used for sorting table rows.
 */
public interface RowComparator {

    /**
     * Compares two rows for order. Returns a negative integer, zero,
     * or a positive integer as the first row is less than, equal to,
     * or greater than the second.
     *
     * @param row1       the first row to be compared
     * @param row2       the second row to be compared
     * @param column     sorting column
     * @param tableModel table's model
     * @return a negative integer, zero, or a positive integer as the
     *         first row is less than, equal to, or greater than the
     *         second.
     */
    public int compare(int row1, int row2, int column, TableModel tableModel);
}
