/*

  Copyright (C) 2003-2005 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.asc.sliderpanel;


/**
 * Interface for slider panel listener.
 */
public interface SliderListener {
    /**
     * Invoked before the slider panel becomes visible.
     *
     * @param sliderOrientation the orientation of this <code>JSliderPanel</code>, one of the
     *                          following constants defined in <code>JSliderPanel</code>:
     *                          {@link JSliderPanel#LEFT_PANEL},
     *                          {@link JSliderPanel#RIGHT_PANEL},
     *                          {@link JSliderPanel#TOP_PANEL} or
     *                          {@link JSliderPanel#BOTTOM_PANEL}
     */
    public void sliderWillBecomeVisible(int sliderOrientation);

    /**
     * Invoked before the slider panel becomes invisible.
     *
     * @param sliderOrientation the orientation of this <code>JSliderPanel</code>, one of the
     *                          following constants defined in <code>JSliderPanel</code>:
     *                          {@link JSliderPanel#LEFT_PANEL},
     *                          {@link JSliderPanel#RIGHT_PANEL},
     *                          {@link JSliderPanel#TOP_PANEL} or
     *                          {@link JSliderPanel#BOTTOM_PANEL}
     */
    public void sliderWillBecomeInvisible(int sliderOrientation);

    /**
     * Invoked after the slider panel became visible.
     *
     * @param sliderOrientation the orientation of this <code>JSliderPanel</code>, one of the
     *                          following constants defined in <code>JSliderPanel</code>:
     *                          {@link JSliderPanel#LEFT_PANEL},
     *                          {@link JSliderPanel#RIGHT_PANEL},
     *                          {@link JSliderPanel#TOP_PANEL} or
     *                          {@link JSliderPanel#BOTTOM_PANEL}
     */
    public void sliderShown(int sliderOrientation);

    /**
     * Invoked after the slider panel became invisible.
     *
     * @param sliderOrientation the orientation of this <code>JSliderPanel</code>, one of the
     *                          following constants defined in <code>JSliderPanel</code>:
     *                          {@link JSliderPanel#LEFT_PANEL},
     *                          {@link JSliderPanel#RIGHT_PANEL},
     *                          {@link JSliderPanel#TOP_PANEL} or
     *                          {@link JSliderPanel#BOTTOM_PANEL}
     */
    public void sliderHidden(int sliderOrientation);

    /**
     * Invoked after the slider panel's animation process is started.
     *
     * @param sliderOrientation the orientation of this <code>JSliderPanel</code>, one of the
     *                          following constants defined in <code>JSliderPanel</code>:
     *                          {@link JSliderPanel#LEFT_PANEL},
     *                          {@link JSliderPanel#RIGHT_PANEL},
     *                          {@link JSliderPanel#TOP_PANEL} or
     *                          {@link JSliderPanel#BOTTOM_PANEL}
     */
    public void sliderAnimationStarted(int sliderOrientation);

    /**
     * Invoked after the slider panel's animation process is stopped.
     *
     * @param sliderOrientation the orientation of this <code>JSliderPanel</code>, one of the
     *                          following constants defined in <code>JSliderPanel</code>:
     *                          {@link JSliderPanel#LEFT_PANEL},
     *                          {@link JSliderPanel#RIGHT_PANEL},
     *                          {@link JSliderPanel#TOP_PANEL} or
     *                          {@link JSliderPanel#BOTTOM_PANEL}
     */
    public void sliderAnimationStoped(int sliderOrientation);
}
