/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.util;

import com.edb.PGConnection;
import com.edb.copy.CopyManager;
import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.engine.loader.TableColumnDescription;
import com.edb.gridsql.util.ParseArgs;
import com.edb.gridsql.util.Util;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XdbLoader {
    private static String tableName = null;
    private static String copyCommand = null;
    private static LoaderFilter filter = null;
    private static InputStream input = null;
    private static String copyDelimiter = null;
    private static boolean modeCSV = false;
    private static char quoteChar = (char)34;
    private static char quoteEscape = (char)34;
    private static String commentPrefix = null;
    private static int commitInterval = 0;
    private static int autoReduceRate = 0;
    private static int minCommitInterval = 1;
    private static File outputDir = null;
    private static boolean keepOriginalFormat = false;
    private static int totalChunkCount = 0;
    private static int badChunkCount = 0;
    private static long badLinesCount = 0L;
    private static String badFileName = null;
    private static final int DEFAULT_VERBOSE_COUNT = 100000;
    private static int verboseCount = 0;
    private static Connection oConn = null;

    private static void terminate(String string) {
        System.err.println(string);
        System.err.println("\nParameters: <connect> -t <table>  [-c <column_list>] [-i <inputfilename>]\n\t[-f <delimiter>] [-z <NULL>]\n\t[-v [-q <quote>] [-e <escape>] -n <column_list>\n\t[-o] [-a] [-r <prefix>] [-w [<count>]] [-b <filename>]\n\t[-k <commit_interval>[,<autoreducing_rate>[,<min_interval>]]\n\t\t -y <badchunkdir>[-x]]\n\twhere <connect> is\n\t  -j jdbc:edb://<host>:<port>/<database>?user=<username>&password=<password>\n\t  or [-h <host>] [-s <port>] -d <database> -u <user> [-p <password>]\n\t-h <host> : Host where XDBServer is running. Default is localhost\n\t-s <port> : XDBServer's port. Default is 6453\n\t-d <database> : Name of database to connect to.\n\t-u <user>, -p <password> : Login to the database\n\t-t <table> : target table name\n\t-c <column_list> : comma or space separated list of columns\n\t-i <inputfilename> : name of file with data to be loaded.\n\t\tStandard input is used if omitted\n\t-f <delimiter> : field delimiter. Default is \\t (tab character)\n\t-z <NULL> : value to indicate NULL. Default is \\N \n\t-v : CSV mode\n\t-q <quote> : Quote character, default \" (CSV mode only)\n\t-e <quote> : Escape of character. Default is quote character (double)\n\t\t (CSV mode only)\n\t-n <column_list>: Force not null. Values for this column are never\n\t\t treated as NULL, as if they was qouted\n\t-a : remove trailing delimiter\n\t-o : same as WITH OIDS\n\t-r <prefix> : ignore data lines starting from specified prefix\n\t-w [<count>] : verbose- every <count> lines (default 100000)\n\t\t display number of lines read\n\t-b <filename> : file where to output invalid lines for simple checks\n\t-k <commit_interval>[,<autoreducing_rate>[,<min_interval>]]:\n\t   <commit_interval> : number of lines to commit at a time\n\t   <autoreducing_rate> : if chunk failed, divide into this\n\t    number of chunks and retry\n\t   <min_interval> : do not further divide chunks of specified size\n\t-y <badchunkdir> : directory where to output failed chunks \n\t-x keep original format for failed chunks \n");
        System.exit(1);
    }

    private static String getRequiredArg(Map<String, List<String>> map, String string, String string2) {
        String string3 = ParseArgs.getStrArg(map, string);
        if (string3 == null || string3.length() == 0) {
            XdbLoader.terminate(string2);
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        block50: {
            try {
                Object object3;
                Object object4;
                Map<String, List<String>> map = ParseArgs.parse(stringArray, "jhsduptcifzvqenoarkyxb");
                modeCSV = map.containsKey("-v");
                copyDelimiter = ParseArgs.getStrArg(map, "-f");
                copyDelimiter = copyDelimiter == null ? (modeCSV ? "," : "\t") : ParseCmdLine.stripEscapes((String)copyDelimiter);
                String string = ParseArgs.getStrArg(map, "-i");
                commentPrefix = ParseArgs.getStrArg(map, "-r");
                input = string == null || string.length() == 0 ? System.in : new FileInputStream(string);
                object2 = ParseArgs.getStrArg(map, "-k");
                if (object2 != null) {
                    int n = ((String)object2).indexOf(",");
                    if (n > 0) {
                        commitInterval = Integer.parseInt(((String)object2).substring(0, n));
                        if ((n = ((String)(object2 = ((String)object2).substring(n + 1))).indexOf(",")) > 0) {
                            autoReduceRate = Integer.parseInt(((String)object2).substring(0, n));
                            minCommitInterval = Integer.parseInt(((String)object2).substring(n + 1));
                        } else {
                            autoReduceRate = Integer.parseInt((String)object2);
                        }
                    } else {
                        commitInterval = Integer.parseInt((String)object2);
                    }
                    keepOriginalFormat = map.containsKey("-x");
                }
                filter = new LoaderFilter(new BufferedInputStream(input), 1024, commitInterval);
                XdbLoader.filter.filterTrailingDelimiter = map.containsKey("-a");
                if (copyDelimiter != null && copyDelimiter.length() > 0) {
                    if (copyDelimiter.length() == 1) {
                        XdbLoader.filter.delimiter = copyDelimiter.charAt(0);
                    } else {
                        XdbLoader.terminate("Delimiter is specified as \"" + copyDelimiter + "\", it must be single character");
                    }
                }
                XdbLoader.filter.commentPrefix = commentPrefix;
                object = new StringBuffer();
                tableName = XdbLoader.getRequiredArg(map, "-t", "Target table is not specified");
                ((StringBuffer)object).append("COPY ").append(tableName);
                List<String> list = map.get("-c");
                if (list != null) {
                    ((StringBuffer)object).append("(");
                    for (String object62 : list) {
                        ((StringBuffer)object).append(object62).append(",");
                    }
                    ((StringBuffer)object).setLength(((StringBuffer)object).length() - 1);
                    ((StringBuffer)object).append(")");
                }
                ((StringBuffer)object).append(" FROM STDIN WITH DELIMITER '").append(ParseCmdLine.escape((String)copyDelimiter)).append("'");
                Object object7 = ParseArgs.getStrArg(map, "-z");
                if (object7 != null) {
                    object7 = ParseCmdLine.stripEscapes((String)object7);
                    ((StringBuffer)object).append(" NULL '").append(ParseCmdLine.escape((String)object7)).append("'");
                    XdbLoader.filter.nulls = object7;
                } else {
                    String string2 = XdbLoader.filter.nulls = modeCSV ? "" : "\\N";
                }
                if (map.containsKey("-g")) {
                    ((StringBuffer)object).append(" OIDS");
                }
                XdbLoader.filter.modeCSV = modeCSV;
                Collection collection = map.get("-n");
                if (collection != null) {
                    object4 = new HashSet();
                    for (Object sQLException : collection) {
                        int n = 0;
                        int n2 = 0;
                        while ((n2 = ((String)sQLException).indexOf(",", n)) > n) {
                            object4.add(((String)sQLException).substring(n, n2));
                            n = n2 + 1;
                        }
                        object4.add(((String)sQLException).substring(n));
                    }
                }
                if (modeCSV) {
                    ((StringBuffer)object).append(" CSV");
                    object4 = ParseArgs.getStrArg(map, "-q");
                    if (object4 != null) {
                        if (((String)(object4 = ParseCmdLine.stripEscapes((String)object4))).length() != 1) {
                            throw new Exception("Quote must be single charachter");
                        }
                        ((StringBuffer)object).append(" QUOTE '").append(ParseCmdLine.escape((String)object4)).append("'");
                        quoteEscape = quoteChar = ((String)object4).charAt(0);
                    }
                    if ((object4 = ParseArgs.getStrArg(map, "-e")) != null) {
                        if (((String)(object4 = ParseCmdLine.stripEscapes((String)object4))).length() != 1) {
                            throw new Exception("Quote escape must be single charachter");
                        }
                        ((StringBuffer)object).append(" ESCAPE '").append(ParseCmdLine.escape((String)object4)).append("'");
                        quoteEscape = ((String)object4).charAt(0);
                    }
                    XdbLoader.filter.quoteChar = quoteChar;
                    XdbLoader.filter.quoteEscape = quoteEscape;
                    if (collection != null && collection.size() > 0) {
                        ((StringBuffer)object).append(" FORCE NOT NULL ");
                        for (Object sQLException : collection) {
                            ((StringBuffer)object).append((String)sQLException).append(", ");
                        }
                        ((StringBuffer)object).setLength(((StringBuffer)object).length() - 2);
                    }
                }
                copyCommand = ((StringBuffer)object).toString();
                badFileName = ParseArgs.getStrArg(map, "-b");
                object4 = ParseArgs.getStrArg(map, "-y");
                if (object4 != null) {
                    object3 = new File((String)object4);
                    if (((File)object3).isDirectory()) {
                        outputDir = object3;
                    }
                    XdbLoader.filter.keepOriginalFormat = keepOriginalFormat;
                }
                if (commitInterval > 0 && outputDir == null) {
                    throw new Exception("Output directory for rejected chunks must be specified if commit interval is limited.");
                }
                if (tableName == null && copyCommand == null) {
                    XdbLoader.terminate("Either table name or copy command should be specified");
                }
                if (map.containsKey("-w")) {
                    object3 = ParseArgs.getStrArg(map, "-w");
                    verboseCount = object3 != null && ((String)object3).length() > 0 ? Integer.valueOf((String)object3) : 100000;
                }
                oConn = Util.connect(map);
                if (badFileName == null) break block50;
                XdbLoader.filter.badLines = new FileOutputStream(badFileName);
                object3 = new LinkedHashMap();
                try {
                    Object sQLException;
                    sQLException = oConn.getMetaData().getColumns("", "", tableName, null);
                    try {
                        while (sQLException.next()) {
                            String linkedList = sQLException.getString("COLUMN_NAME");
                            TableColumnDescription tableColumnDescription = new TableColumnDescription();
                            tableColumnDescription.setName(linkedList);
                            boolean string4 = sQLException.getInt("NULLABLE") != 0 || collection != null && collection.contains(linkedList);
                            tableColumnDescription.setNullable(string4);
                            object3.put(linkedList, tableColumnDescription);
                        }
                    }
                    finally {
                        sQLException.close();
                    }
                    if (object3.isEmpty()) {
                        System.out.println("WARNING: Table info is requested from server, but empty response is returned");
                        break block50;
                    }
                    if (list == null) {
                        XdbLoader.filter.columnDescriptions = object3.values().toArray(new TableColumnDescription[object3.size()]);
                        break block50;
                    }
                    LinkedList<TableColumnDescription> linkedList = new LinkedList<TableColumnDescription>();
                    for (String string3 : list) {
                        TableColumnDescription tableColumnDescription;
                        String string4;
                        int n = 0;
                        int n3 = 0;
                        while ((n3 = string3.indexOf(",", n)) != -1) {
                            string4 = string3.substring(n, n3);
                            tableColumnDescription = (TableColumnDescription)object3.get(string4);
                            linkedList.add(tableColumnDescription);
                            n = n3 + 1;
                        }
                        string4 = string3.substring(n);
                        tableColumnDescription = (TableColumnDescription)object3.get(string4);
                        linkedList.add(tableColumnDescription);
                    }
                    XdbLoader.filter.columnDescriptions = linkedList.toArray(new TableColumnDescription[linkedList.size()]);
                }
                catch (SQLException sQLException) {}
            }
            catch (Exception exception) {
                XdbLoader.terminate(exception.getMessage());
            }
        }
        long l = System.currentTimeMillis();
        try {
            object2 = (PGConnection)oConn;
            object = object2.getCopyAPI();
            while (!XdbLoader.filter.exhausted) {
                filter.resetChunk();
                try {
                    ++totalChunkCount;
                    object.copyInQuery(copyCommand, (InputStream)filter);
                }
                catch (SQLException sQLException) {
                    if (commitInterval > 1) {
                        XdbLoader.autoretry((CopyManager)object, XdbLoader.filter.lastChunk, XdbLoader.filter.originalChunk, 0, XdbLoader.filter.chunkPos, sQLException.getMessage());
                        continue;
                    }
                    throw sQLException;
                }
            }
            System.out.println("Loading is finished");
            System.out.println(XdbLoader.filter.lineCount - XdbLoader.filter.badLineCount + " input rows have been sent to Server in " + totalChunkCount + " chunks");
            if (XdbLoader.filter.badLineCount > 0L) {
                System.out.println(XdbLoader.filter.badLineCount + " rows do not match target table's layout and have been written to " + badFileName);
            }
            if (badChunkCount > 0) {
                System.out.println(badChunkCount + " chunks containing " + badLinesCount + " rows have been rejected by server and written to " + outputDir.getAbsolutePath());
            }
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException: " + sQLException.getMessage());
            for (object = sQLException.getNextException(); object != null; object = ((SQLException)object).getNextException()) {
                System.out.println("Next SQLException: " + ((Throwable)object).getMessage());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        long l2 = System.currentTimeMillis();
        System.out.printf("\nTime : " + (double)(l2 - l) / 1000.0 + " (seconds)\n", new Object[0]);
        System.exit(0);
    }

    private static void autoretry(CopyManager copyManager, byte[][] byArray, byte[][] byArray2, int n, int n2, String string) throws IOException {
        if (autoReduceRate < 2 || n2 <= minCommitInterval) {
            ++badChunkCount;
            badLinesCount += (long)n2;
            File file = File.createTempFile("rejected", "tbl");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            if (commentPrefix != null && commentPrefix.length() > 0 && string != null && string.length() > 0) {
                fileOutputStream.write(commentPrefix.getBytes());
                fileOutputStream.write(string.getBytes());
                fileOutputStream.write(System.getProperty("line.separator").getBytes());
            }
            for (int i = n; i < n + n2; ++i) {
                fileOutputStream.write(keepOriginalFormat ? byArray2[i] : byArray[i]);
            }
            fileOutputStream.close();
            file.renameTo(new File(outputDir, "rejected" + totalChunkCount + ".tbl"));
        } else {
            int n3 = (n2 - 1) / autoReduceRate + 1;
            for (int i = n; i < n + n2; i += n3) {
                int n4 = Math.min(n + n2 - i, n3);
                try {
                    ++totalChunkCount;
                    ByteMatrixInputStream byteMatrixInputStream = new ByteMatrixInputStream(byArray, i, n4);
                    copyManager.copyInQuery(copyCommand, (InputStream)byteMatrixInputStream);
                    continue;
                }
                catch (SQLException sQLException) {
                    XdbLoader.autoretry(copyManager, byArray, byArray2, i, n4, sQLException.getMessage());
                }
            }
        }
    }

    private static class ByteMatrixInputStream
    extends InputStream {
        byte[][] matrix;
        byte[] currentLine;
        int lastLinePos;
        int currentLinePos;
        int currentPos;

        ByteMatrixInputStream(byte[][] byArray, int n, int n2) {
            this.matrix = byArray;
            this.currentLinePos = n;
            this.lastLinePos = Math.min(n + n2, byArray.length);
            this.currentLine = byArray[this.currentLinePos++];
            if (this.currentLine == null) {
                this.moveToNextLine();
            }
        }

        public int available() throws IOException {
            return this.currentLine == null ? 0 : this.currentLine.length - this.currentPos;
        }

        public synchronized void mark(int n) {
            throw new UnsupportedOperationException();
        }

        public boolean markSupported() {
            return false;
        }

        public int read() throws IOException {
            if (this.currentLine == null) {
                return -1;
            }
            if (this.currentLine.length == this.currentPos) {
                this.moveToNextLine();
            }
            return this.currentLine == null ? -1 : this.currentLine[this.currentPos++] & 0xFF;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            int n3 = 0;
            while (n3 < n2 && this.currentLine != null) {
                if (this.currentLine.length - this.currentPos < n2 - n3) {
                    if (this.currentLine.length > this.currentPos) {
                        System.arraycopy(this.currentLine, this.currentPos, byArray, n + n3, this.currentLine.length - this.currentPos);
                        n3 += this.currentLine.length - this.currentPos;
                        this.currentPos = this.currentLine.length;
                    }
                    this.moveToNextLine();
                    continue;
                }
                System.arraycopy(this.currentLine, this.currentPos, byArray, n + n3, n2 - n3);
                this.currentPos += n2 - n3;
                n3 = n2;
            }
            return n3 == 0 && n2 != 0 ? -1 : n3;
        }

        public synchronized void reset() throws IOException {
            throw new UnsupportedOperationException();
        }

        private void moveToNextLine() {
            this.currentLine = null;
            this.currentPos = 0;
            while (this.currentLine == null && this.currentLinePos < this.lastLinePos) {
                this.currentLine = this.matrix[this.currentLinePos++];
                if (this.currentLine == null || this.currentLine.length != 0) continue;
                this.currentLine = null;
            }
        }
    }

    private static class LoaderFilter
    extends FilterInputStream {
        byte[] outBuffer;
        int outHead = 0;
        int outTail = 0;
        boolean exhausted = false;
        boolean filterTrailingDelimiter = false;
        char delimiter = (char)9;
        String nulls = "\\N";
        boolean modeCSV = false;
        char quoteChar = (char)34;
        char quoteEscape = (char)34;
        TableColumnDescription[] columnDescriptions = null;
        String commentPrefix = null;
        int chunkSize = 0;
        byte[][] lastChunk = null;
        boolean keepOriginalFormat = false;
        int originalTail = 0;
        byte[] originalBuffer = null;
        byte[][] originalChunk = null;
        int chunkPos = 0;
        long lineCount = 0L;
        OutputStream badLines = null;
        long badLineCount = 0L;
        int ch;
        boolean charInBuffer = false;

        LoaderFilter(InputStream inputStream, int n, int n2) {
            super(inputStream);
            this.outBuffer = new byte[n < 256 ? 256 : n];
            this.chunkSize = n2;
        }

        public int available() throws IOException {
            return this.outTail - this.outHead;
        }

        public synchronized void mark(int n) {
            throw new UnsupportedOperationException();
        }

        public boolean markSupported() {
            return false;
        }

        public int read() throws IOException {
            if (this.outHead == this.outTail && !this.exhausted) {
                if (this.lastChunk != null) {
                    if (this.chunkPos < this.lastChunk.length) {
                        this.readLine();
                        if (this.outTail > 0) {
                            byte[] byArray;
                            if (this.keepOriginalFormat) {
                                byArray = new byte[this.originalTail];
                                System.arraycopy(this.originalBuffer, 0, byArray, 0, this.originalTail);
                                this.originalChunk[this.chunkPos] = byArray;
                            }
                            byArray = new byte[this.outTail];
                            System.arraycopy(this.outBuffer, 0, byArray, 0, this.outTail);
                            this.lastChunk[this.chunkPos++] = byArray;
                        }
                    }
                } else {
                    this.readLine();
                }
            }
            return this.outHead < this.outTail ? this.outBuffer[this.outHead++] & 0xFF : -1;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            int n3 = 0;
            while (!(n3 >= n2 || this.exhausted && this.outHead >= this.outTail)) {
                if (this.outTail - this.outHead < n2 - n3) {
                    if (this.outTail > this.outHead) {
                        System.arraycopy(this.outBuffer, this.outHead, byArray, n + n3, this.outTail - this.outHead);
                        n3 += this.outTail - this.outHead;
                        this.outHead = this.outTail;
                    }
                    if (this.lastChunk != null) {
                        byte[] byArray2;
                        if (this.chunkPos >= this.lastChunk.length) break;
                        this.readLine();
                        if (this.outTail <= 0) continue;
                        if (this.keepOriginalFormat) {
                            byArray2 = new byte[this.originalTail];
                            System.arraycopy(this.originalBuffer, 0, byArray2, 0, this.originalTail);
                            this.originalChunk[this.chunkPos] = byArray2;
                        }
                        byArray2 = new byte[this.outTail];
                        System.arraycopy(this.outBuffer, 0, byArray2, 0, this.outTail);
                        this.lastChunk[this.chunkPos++] = byArray2;
                        continue;
                    }
                    this.readLine();
                    continue;
                }
                System.arraycopy(this.outBuffer, this.outHead, byArray, n + n3, n2 - n3);
                this.outHead += n2 - n3;
                n3 = n2;
            }
            return n3 == 0 && n2 != 0 ? -1 : n3;
        }

        public synchronized void reset() throws IOException {
            throw new UnsupportedOperationException();
        }

        public void resetChunk() {
            if (this.chunkSize > 1) {
                this.lastChunk = new byte[this.chunkSize][];
                this.chunkPos = 0;
                if (this.keepOriginalFormat) {
                    this.originalChunk = new byte[this.chunkSize][];
                }
            }
        }

        private byte[] expandBuffer(byte[] byArray) {
            byte[] byArray2 = new byte[byArray.length * 2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            return byArray2;
        }

        private int getNextChar() throws IOException {
            int n = this.in.read();
            if (this.keepOriginalFormat && n != -1) {
                this.originalBuffer[this.originalTail++] = (byte)n;
                if (this.originalTail == this.originalBuffer.length) {
                    this.originalBuffer = this.expandBuffer(this.originalBuffer);
                }
            }
            return n;
        }

        private void outputNextChar(int n) {
            this.outBuffer[this.outTail++] = (byte)n;
            if (this.outTail == this.outBuffer.length) {
                this.outBuffer = this.expandBuffer(this.outBuffer);
            }
        }

        private void readLine() throws IOException {
            TableColumnDescription tableColumnDescription;
            this.outHead = 0;
            this.outTail = 0;
            boolean bl = this.commentPrefix != null && this.commentPrefix.length() > 0;
            boolean bl2 = true;
            boolean bl3 = false;
            int n = 0;
            int n2 = 0;
            String string = null;
            if (this.keepOriginalFormat) {
                this.originalTail = 0;
                this.originalBuffer = new byte[this.outBuffer.length];
            }
            while (true) {
                if (this.charInBuffer) {
                    this.charInBuffer = false;
                } else {
                    this.ch = this.getNextChar();
                }
                if (this.ch == -1) {
                    this.exhausted = true;
                    break;
                }
                if (this.modeCSV && bl3) {
                    this.outputNextChar(this.ch);
                    if (this.ch == this.quoteEscape) {
                        this.ch = this.getNextChar();
                        if (this.ch == this.quoteChar) {
                            this.outputNextChar(this.ch);
                            continue;
                        }
                        this.charInBuffer = true;
                        if (this.quoteChar != this.quoteEscape) continue;
                        bl3 = false;
                        if (this.ch == this.delimiter || this.ch == 13 || this.ch == 10) continue;
                        string = "Found characters after closing quote";
                        continue;
                    }
                    if (this.ch != this.quoteChar) continue;
                    this.ch = this.getNextChar();
                    this.charInBuffer = true;
                    bl3 = false;
                    if (this.ch == this.delimiter || this.ch == 13 || this.ch == 10) continue;
                    string = "Found characters after closing quote";
                    continue;
                }
                if (this.ch == 13) {
                    if (this.ch == 10) {
                        this.outBuffer[this.outTail++] = (byte)this.ch;
                        if (this.outTail != this.outBuffer.length) break;
                        this.outBuffer = this.expandBuffer(this.outBuffer);
                        break;
                    }
                    this.charInBuffer = true;
                    break;
                }
                if (this.ch == 10) {
                    this.outBuffer[this.outTail++] = (byte)this.ch;
                    if (this.outTail != this.outBuffer.length) break;
                    this.outBuffer = this.expandBuffer(this.outBuffer);
                    break;
                }
                if (this.ch == this.delimiter) {
                    tableColumnDescription = null;
                    if (this.columnDescriptions != null) {
                        if (n < this.columnDescriptions.length) {
                            tableColumnDescription = this.columnDescriptions[n++];
                        } else {
                            string = "Extra data after last field";
                        }
                    }
                    if (tableColumnDescription != null && bl2 && !tableColumnDescription.isNullable()) {
                        string = "Column " + tableColumnDescription.getName() + " does not allow nulls";
                    }
                    if (this.filterTrailingDelimiter) {
                        if (this.columnDescriptions != null && n == this.columnDescriptions.length) continue;
                        this.ch = this.in.read();
                        if (this.keepOriginalFormat && this.ch != -1) {
                            this.originalBuffer[this.originalTail++] = (byte)this.ch;
                            if (this.originalTail == this.originalBuffer.length) {
                                this.originalBuffer = this.expandBuffer(this.originalBuffer);
                            }
                        }
                        if (this.ch != 13 && this.ch != 10 && this.ch != -1) {
                            this.outBuffer[this.outTail++] = (byte)this.delimiter;
                            if (this.outTail == this.outBuffer.length) {
                                this.outBuffer = this.expandBuffer(this.outBuffer);
                            }
                        }
                        this.charInBuffer = true;
                        continue;
                    }
                    this.outBuffer[this.outTail++] = (byte)this.delimiter;
                    if (this.outTail != this.outBuffer.length) continue;
                    this.outBuffer = this.expandBuffer(this.outBuffer);
                    continue;
                }
                if (bl && this.outTail < this.commentPrefix.length() && this.ch != this.commentPrefix.charAt(this.outTail)) {
                    bl = false;
                }
                if (bl2 && (this.outTail - n2 < this.nulls.length() && this.ch != this.nulls.charAt(this.outTail - n2) || this.outTail - n2 >= this.nulls.length())) {
                    bl2 = false;
                }
                this.outBuffer[this.outTail++] = (byte)this.ch;
                if (this.outTail != this.outBuffer.length) continue;
                this.outBuffer = this.expandBuffer(this.outBuffer);
            }
            if (this.outTail == 0) {
                return;
            }
            if (bl && this.outTail > this.commentPrefix.length()) {
                this.outTail = 0;
                return;
            }
            if (!this.filterTrailingDelimiter && this.columnDescriptions != null) {
                tableColumnDescription = null;
                if (n < this.columnDescriptions.length) {
                    tableColumnDescription = this.columnDescriptions[n++];
                } else {
                    string = "Extra data after last field";
                }
                if (tableColumnDescription != null && bl2 && !tableColumnDescription.isNullable()) {
                    string = "Column " + tableColumnDescription.getName() + " does not allow nulls";
                }
            }
            if (this.columnDescriptions != null && string == null && n != this.columnDescriptions.length) {
                if (this.outTail == 1 && (this.outBuffer[0] == 13 || this.outBuffer[0] == 10) || this.outTail == 2 && this.outBuffer[0] == 13 && this.outBuffer[1] == 10) {
                    this.outTail = 0;
                    return;
                }
                string = "Too few columns in the line";
            }
            ++this.lineCount;
            if (verboseCount > 0 && this.lineCount % (long)verboseCount == 0L) {
                System.out.print(this.lineCount);
                System.out.println(" lines read");
            }
            if (string != null) {
                if (this.badLines != null) {
                    if (this.commentPrefix != null) {
                        this.badLines.write(this.commentPrefix.getBytes());
                        this.badLines.write(32);
                        this.badLines.write(string.getBytes());
                        this.badLines.write(10);
                    }
                } else {
                    throw new IOException(string);
                }
                this.badLines.write(this.outBuffer, 0, this.outTail);
                this.outTail = 0;
                ++this.badLineCount;
            }
        }
    }
}

