/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.util;

import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.util.ParseArgs;
import com.edb.gridsql.util.Util;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class CreateDb {
    private static void terminate(String string) {
        System.err.println(string);
        System.err.println("Parameters:  <connect> -d <database> [-o <owner>] -n <nodelist> [-m]\n\twhere <connect> is -j jdbc:edb://<host>:<port>/" + Props.XDB_ADMIN_DATABASE + "?user=<username>&password=<password>\n" + "\tor [-h <host>] [-s <port>] -u <user> [-p <password>]\n" + "\t-h <host> : Host name or IP address where XDBServer is running. Default is localhost\n" + "\t-s <port> : XDBServer's port. Default is 6453\n" + "\t-u <user>, -p <password> : Login to the database\n" + "\t-d <database> : Name of database to create.\n" + "\t-o <owner> : Name of database owner.\n" + "\t-n <nodelist> : Comma or space separated list of numbers of nodes where the database will be created. Nodes must be up and running.\n" + "\t-m : Manual mode. Do not create node databases. Databases must exist if -m is specified.\n");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Connection connection = null;
        Statement statement = null;
        try {
            Object object;
            Map<String, List<String>> map = ParseArgs.parse(stringArray, "jhsdoupnm");
            String string = ParseArgs.getStrArg(map, "-d");
            StringBuffer stringBuffer = new StringBuffer();
            List<String> list = map.get("-n");
            if (list == null) {
                CreateDb.terminate("No nodes specified");
            }
            for (String string2 : list) {
                object = new StringTokenizer(string2, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string3 = ((StringTokenizer)object).nextToken();
                    try {
                        Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        CreateDb.terminate("The node id should be an integer.");
                    }
                    if (!stringBuffer.toString().equals("")) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(string3);
                }
            }
            if (stringBuffer.length() == 0) {
                CreateDb.terminate("No Nodes specified");
            }
            String string4 = ParseArgs.getStrArg(map, "-o");
            boolean bl = map.containsKey("-m");
            connection = Util.connect(map, true);
            statement = connection.createStatement();
            object = "CREATE DATABASE " + string;
            if (string4 != null) {
                object = (String)object + " OWNER " + (String)string4;
            }
            if (bl) {
                object = (String)object + " MANUAL";
            }
            object = (String)object + " ON NODES " + stringBuffer.toString();
            statement.execute((String)object);
        }
        catch (Exception exception) {
            CreateDb.terminate(exception.getMessage());
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        System.out.println("OK");
        System.exit(0);
    }
}

