/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.queryproc;

import com.edb.gridsql.common.ColumnMetaData;
import com.edb.gridsql.common.ResultSetImpl;
import com.edb.gridsql.common.XDBResultSetMetaData;
import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.MultinodeExecutor;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBSecurityException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SyncCreateTable;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.SysTablespace;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.misc.Timer;
import com.edb.gridsql.misc.combinedresultset.ServerResultSetImpl;
import com.edb.gridsql.optimizer.AttributeColumn;
import com.edb.gridsql.optimizer.IRebuildString;
import com.edb.gridsql.optimizer.Optimizer;
import com.edb.gridsql.optimizer.QueryCondition;
import com.edb.gridsql.optimizer.QueryTree;
import com.edb.gridsql.optimizer.RelationNode;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import com.edb.gridsql.planner.ExecutionPlan;
import com.edb.gridsql.planner.ExecutionStep;
import com.edb.gridsql.planner.QueryPlan;
import com.edb.gridsql.planner.StepDetail;
import com.edb.gridsql.queryproc.QueryCombiner;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryProcessor
implements IPreparable,
IXDBSql {
    private static final XLogger logger = XLogger.getLogger(QueryProcessor.class);
    private Timer DataDownTimer;
    private Timer QueryTimer;
    private String finalSelectClause;
    private MultinodeExecutor aMultinodeExecutor;
    private ServerResultSetImpl finalResultSet;
    private List unionGroup1;
    private List unionGroup2;
    private XDBSessionContext client;
    private QueryTree query = null;
    private QueryTree resultTree = null;
    private QueryPlan aQueryPlan = null;
    private ExecutionPlan aExecPlan = null;
    private Collection skipPermissionCheck = null;
    private long cost = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQueryExecPlan(ExecutionPlan executionPlan) throws XDBServerException {
        if (executionPlan.unionPlanList.size() > 0) {
            this.executeUnionQuery(executionPlan);
        }
        for (ExecutionPlan object : executionPlan.scalarPlanList) {
            this.executeScalarQuery(object);
        }
        for (ExecutionPlan executionPlan2 : executionPlan.relationPlanList) {
            this.executeQueryExecPlan(executionPlan2);
        }
        for (ExecutionStep executionStep : executionPlan.stepList) {
            if (executionStep.correlatedSubPlan != null) {
                this.executeQueryExecPlan(executionStep.correlatedSubPlan);
            }
            if (executionStep.uncorrelatedSubPlanList != null) {
                for (ExecutionPlan executionPlan3 : executionStep.uncorrelatedSubPlanList) {
                    this.executeQueryExecPlan(executionPlan3);
                }
            }
            for (ExecutionPlan executionPlan3 : executionPlan.scalarPlanList) {
                if (executionStep.aStepDetail != null && executionStep.aStepDetail.queryString != null) {
                    executionStep.aStepDetail.queryString = this.scalarReplace(executionStep.aStepDetail.queryString, executionPlan3.scalarPlaceholderNo, executionPlan3.scalarResult);
                }
                if (executionStep.coordStepDetail == null || executionStep.coordStepDetail.queryString == null) continue;
                executionStep.coordStepDetail.queryString = this.scalarReplace(executionStep.coordStepDetail.queryString, executionPlan3.scalarPlaceholderNo, executionPlan3.scalarResult);
            }
            if (executionStep.outerSubPlan != null) {
                this.executeQueryExecPlan(executionStep.outerSubPlan);
            }
            this.executeQueryStep(executionStep.aStepDetail, executionStep.coordStepDetail, executionStep.nodeUsageTable, executionStep.producerCount, executionStep.consumerCount, executionStep.isExtraStep, executionStep.destNodeList, executionStep.isFinalStep);
            if (executionStep.correlatedSendDownStep == null) continue;
            this.executeQueryStep(executionStep.correlatedSendDownStep.aStepDetail, executionStep.correlatedSendDownStep.coordStepDetail, executionStep.correlatedSendDownStep.nodeUsageTable, executionStep.correlatedSendDownStep.producerCount, executionStep.correlatedSendDownStep.consumerCount, executionStep.correlatedSendDownStep.isExtraStep, executionStep.correlatedSendDownStep.destNodeList, executionStep.isFinalStep);
            if (executionStep.correlatedSendDownStep2 == null) continue;
            this.executeQueryStep(executionStep.correlatedSendDownStep2.aStepDetail, executionStep.correlatedSendDownStep2.coordStepDetail, executionStep.correlatedSendDownStep2.nodeUsageTable, executionStep.correlatedSendDownStep2.producerCount, executionStep.correlatedSendDownStep2.consumerCount, executionStep.correlatedSendDownStep2.isExtraStep, executionStep.correlatedSendDownStep2.destNodeList, executionStep.isFinalStep);
        }
        this.finalSelectClause = executionPlan.finalProjString;
        for (ExecutionPlan executionPlan4 : executionPlan.scalarPlanList) {
            this.finalSelectClause = this.scalarReplace(this.finalSelectClause, executionPlan4.scalarPlaceholderNo, executionPlan4.scalarResult);
        }
    }

    private void addUnionResultSet(ServerResultSetImpl serverResultSetImpl, int n) {
        if (n == 1) {
            if (this.unionGroup1 == null) {
                this.unionGroup1 = new ArrayList();
            }
            this.unionGroup1.add(serverResultSetImpl);
        } else {
            if (this.unionGroup2 == null) {
                this.unionGroup2 = new ArrayList();
            }
            this.unionGroup2.add(serverResultSetImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUnionQuery(ExecutionPlan executionPlan) {
        for (int i = 0; i < executionPlan.unionPlanList.size(); ++i) {
            ServerResultSetImpl serverResultSetImpl;
            Collection<? extends ResultSet> collection;
            ExecutionPlan executionPlan2 = executionPlan.unionPlanList.get(i);
            this.executeQueryExecPlan(executionPlan2);
            if (!executionPlan.isTopLevelUnion) continue;
            ExecutionStep executionStep = executionPlan2.stepList.get(executionPlan2.stepList.size() - 1);
            if (executionStep.aStepDetail.isProducer) {
                collection = this.aMultinodeExecutor.getFinalResultSets();
                try {
                    serverResultSetImpl = new ServerResultSetImpl(collection, executionStep.aStepDetail.finalUnionPartSortInfo, executionStep.aStepDetail.finalUnionPartIsDistinct, this.aQueryPlan.getLimit(), this.aQueryPlan.getOffset(), new XDBResultSetMetaData(this.aQueryPlan.getMetaData()));
                }
                catch (SQLException sQLException) {
                    logger.catching(sQLException);
                    XDBServerException xDBServerException = new XDBServerException("Creating union part ResultSet failed " + sQLException.getMessage(), sQLException);
                    logger.throwing(xDBServerException);
                    throw xDBServerException;
                }
                serverResultSetImpl.setFinalCoordTempTableList(null);
                serverResultSetImpl.setFinalNodeTempTableList(executionStep.aStepDetail.dropList);
                this.addUnionResultSet(serverResultSetImpl, executionStep.aStepDetail.unionResultGroup);
                continue;
            }
            collection = this.aMultinodeExecutor.getFinalResultSets();
            try {
                serverResultSetImpl = new ServerResultSetImpl(collection, executionStep.coordStepDetail.finalUnionPartSortInfo, executionStep.coordStepDetail.finalUnionPartIsDistinct, this.aQueryPlan.getLimit(), this.aQueryPlan.getOffset(), new XDBResultSetMetaData(this.aQueryPlan.getMetaData()));
            }
            catch (SQLException sQLException) {
                logger.catching(sQLException);
                XDBServerException xDBServerException = new XDBServerException("Creating union part ResultSet failed " + sQLException.getMessage(), sQLException);
                logger.throwing(xDBServerException);
                throw xDBServerException;
            }
            serverResultSetImpl.setFinalCoordTempTableList(executionStep.coordStepDetail.dropList);
            serverResultSetImpl.setFinalNodeTempTableList(null);
            this.addUnionResultSet(serverResultSetImpl, executionStep.coordStepDetail.unionResultGroup);
        }
        this.finalSelectClause = executionPlan.finalProjString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeScalarQuery(ExecutionPlan executionPlan) {
        ResultSet resultSet = null;
        this.executeQueryExecPlan(executionPlan);
        String string = "SELECT * FROM " + IdentifierHandler.quote(executionPlan.finalTempTableName);
        QueryCombiner queryCombiner = new QueryCombiner(this.client, "");
        resultSet = queryCombiner.queryOnCoord(string);
        try {
            executionPlan.scalarResult = resultSet.next() ? resultSet.getString(1) : null;
        }
        catch (SQLException sQLException) {
            throw new XDBServerException(ErrorMessageRepository.SQL_EXEC_FAILURE + string, sQLException, ErrorMessageRepository.SQL_EXEC_FAILURE_CODE);
        }
        try {
            if (executionPlan.scalarResult != null && resultSet.next()) {
                throw new XDBServerException(ErrorMessageRepository.SCALAR_QUERY_RESULT_ERROR, 0, ErrorMessageRepository.SCALAR_QUERY_RESULT_ERROR_CODE);
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                queryCombiner.dropTempTables(Collections.singleton(executionPlan.finalTempTableName));
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String scalarReplace(String string, int n, String string2) {
        block3: {
            if (string2 == null) break block3;
            String string3 = ParseCmdLine.replace(string, "&x" + n + "x&", string2);
            return string3;
        }
        String string4 = ParseCmdLine.replace(string, "&x" + n + "x&", "NULL");
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQueryStep(StepDetail stepDetail, StepDetail stepDetail2, Map map, int n, int n2, boolean bl, List list, boolean bl2) throws XDBServerException {
        QueryCombiner queryCombiner = null;
        if (bl2 && stepDetail2 != null && stepDetail2.isProducer && (stepDetail2.getDestType() == 2 || stepDetail2.getDestType() == 6) && !stepDetail2.isFinalUnionPart) {
            try {
                this.setFinalResultSetOnCoordinator(stepDetail2.queryString, stepDetail2.unionResultGroup, stepDetail2);
                return;
            }
            catch (SQLException sQLException) {
                throw new XDBServerException(ErrorMessageRepository.SQL_EXEC_FAILURE + " executing on coordinator (" + stepDetail2.queryString + " )", sQLException, ErrorMessageRepository.SQL_EXEC_FAILURE_CODE);
            }
        }
        if (bl) {
            queryCombiner = new QueryCombiner(this.client, stepDetail2.targetTable);
            queryCombiner.sCreateStatement = stepDetail2.targetSchema;
            queryCombiner.createTempTable();
            try {
                queryCombiner.execute("INSERT INTO " + stepDetail2.targetTable + " " + stepDetail2.queryString);
            }
            catch (SQLException sQLException) {
                throw new XDBServerException(ErrorMessageRepository.SQL_EXEC_FAILURE + " ( " + stepDetail2.queryString + ") " + sQLException.getMessage(), sQLException, ErrorMessageRepository.SQL_EXEC_FAILURE_CODE);
            }
            queryCombiner.finishInserts();
            queryCombiner.dropTempTables(stepDetail2.dropList);
            return;
        }
        if (stepDetail2 != null && stepDetail2.isConsumer && stepDetail2.isProducer && !stepDetail.isConsumer) {
            queryCombiner = new QueryCombiner(this.client, stepDetail2.targetTable);
            queryCombiner.sCreateStatement = stepDetail2.targetSchema;
            queryCombiner.createTempTable();
            try {
                queryCombiner.execute("INSERT INTO " + IdentifierHandler.quote(stepDetail2.targetTable) + " " + stepDetail2.queryString);
            }
            catch (SQLException sQLException) {
                throw new XDBServerException(ErrorMessageRepository.SQL_EXEC_FAILURE + " ( " + stepDetail2.queryString + ") " + sQLException.getMessage(), sQLException, ErrorMessageRepository.SQL_EXEC_FAILURE_CODE);
            }
            queryCombiner.dropTempTables(stepDetail2.dropList);
            return;
        }
        queryCombiner = new QueryCombiner(this.client, stepDetail.targetTable);
        this.QueryTimer.startTimer();
        try {
            this.aMultinodeExecutor.executeStep(queryCombiner, stepDetail, stepDetail2, map, n, n2);
        }
        catch (Exception exception) {
            throw new XDBServerException(ErrorMessageRepository.SQL_EXEC_FAILURE + " ( " + stepDetail.queryString + ") eQS " + exception.getMessage(), exception, ErrorMessageRepository.SQL_EXEC_FAILURE_CODE);
        }
        this.QueryTimer.stopTimer();
        if (stepDetail.combineOnCoordFirst) {
            this.DataDownTimer.startTimer();
            try {
                this.aMultinodeExecutor.sendTableDownDistinct(stepDetail, list, queryCombiner);
            }
            catch (Exception exception) {
                throw new XDBServerException(ErrorMessageRepository.ERROR_EXEC_STEP, exception, ErrorMessageRepository.ERROR_EXEC_STEP_CODE);
            }
            this.DataDownTimer.stopTimer();
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFinalResultSetOnCoordinator(String string, int n, StepDetail stepDetail) throws SQLException {
        QueryCombiner queryCombiner = new QueryCombiner(this.client, null);
        ResultSet resultSet = queryCombiner.queryOnCoord(string);
        Vector<ResultSet> vector = new Vector<ResultSet>();
        vector.add(resultSet);
        this.finalResultSet = new ServerResultSetImpl(vector, null, false, this.aQueryPlan.getLimit(), this.aQueryPlan.getOffset(), new XDBResultSetMetaData(this.aQueryPlan.getMetaData()));
        this.finalResultSet.setFinalCoordTempTableList(stepDetail.dropList);
        if (n > 0) {
            this.addUnionResultSet(this.finalResultSet, n);
        }
    }

    public QueryProcessor(XDBSessionContext xDBSessionContext, QueryTree queryTree) {
        this.client = xDBSessionContext;
        this.DataDownTimer = new Timer();
        this.QueryTimer = new Timer();
        this.query = queryTree;
    }

    public void setSkipPermissionCheck(Collection collection) {
        this.skipPermissionCheck = collection;
    }

    @Override
    public boolean isPrepared() {
        return this.aExecPlan != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() throws Exception {
        Object object;
        Object object22;
        SysDatabase sysDatabase = this.client.getSysDatabase();
        HashSet hashSet = new HashSet();
        this.getTablesFromQTree(sysDatabase, this.query, hashSet);
        for (Object object22 : hashSet) {
            if (this.skipPermissionCheck != null && this.skipPermissionCheck.contains(((SysTable)object22).getTableName().toUpperCase())) continue;
            ((SysTable)object22).checkPermission(this.client.getCurrentUser(), (short)0);
        }
        if (this.query.getIntoTableName() != null) {
            if (this.client.getCurrentUser().getUserClass() == 2) {
                object = new XDBSecurityException("You are not allowed to create tables");
                logger.throwing((Throwable)object);
                throw object;
            }
            if (sysDatabase.isTableExists(this.query.getIntoTableName()) || this.client.getTempTableName(this.query.getIntoTableName()) != null) {
                throw new XDBServerException(ErrorMessageRepository.DUP_TABLE_NAME + "(" + this.query.getIntoTableName() + ")", 0, ErrorMessageRepository.DUP_TABLE_NAME_CODE);
            }
        }
        object = this.foldQueryTree(this.query);
        this.handleOrCondition((QueryTree)object);
        object22 = new Optimizer(this.client);
        this.resultTree = ((Optimizer)object22).determineQueryPath((QueryTree)object);
        this.aQueryPlan = new QueryPlan(this.client);
        this.aQueryPlan.createMainPlanFromTree(this.resultTree);
        this.aExecPlan = new ExecutionPlan(null, this.aQueryPlan, null, null, false, this.client);
        this.aExecPlan.correctDestinations();
    }

    public void prepareParameters(List<SqlExpression> list) {
        if (this.aExecPlan != null) {
            int[] nArray = new int[list.size()];
            for (SqlExpression sqlExpression : list) {
                nArray[sqlExpression.getParamNumber() - 1] = sqlExpression.getExprDataType().type;
            }
            this.aExecPlan.prepareParameters(nArray);
        }
    }

    public void resetExecPlan(List<SqlExpression> list) {
        String[] stringArray = new String[list.size()];
        for (SqlExpression sqlExpression : list) {
            stringArray[sqlExpression.getParamNumber() - 1] = sqlExpression.getParamValue();
        }
        this.aExecPlan.substituteParameterValues(stringArray);
    }

    private void handleOrCondition(QueryTree queryTree) {
        IRebuildString iRebuildString;
        if (this.needsOrHandling(queryTree)) {
            this.handleOrQuery(queryTree);
        }
        for (RelationNode iRebuildString2 : queryTree.getRelationNodeList()) {
            iRebuildString = iRebuildString2;
            if (((RelationNode)iRebuildString).getNodeType() != 4 && ((RelationNode)iRebuildString).getNodeType() != 3 && ((RelationNode)iRebuildString).getNodeType() != 5) continue;
            this.handleOrQuery(((RelationNode)iRebuildString).getSubqueryTree());
        }
        for (QueryTree queryTree2 : queryTree.getUnionQueryTreeList()) {
            iRebuildString = queryTree2;
            this.handleOrQuery((QueryTree)iRebuildString);
        }
    }

    private void handleOrQuery(QueryTree queryTree) {
        AbstractCollection abstractCollection;
        List<QueryCondition> list = this.getOrConditions(queryTree.getConditionList());
        Vector[] vectorArray = new Vector[list.size()];
        int n = 0;
        for (QueryCondition queryCondition : list) {
            abstractCollection = this.getAndConditions(queryCondition);
            if (abstractCollection == null || ((Vector)abstractCollection).isEmpty()) continue;
            vectorArray[n++] = abstractCollection;
        }
        HashSet hashSet = new HashSet();
        if (vectorArray.length > 0) {
            hashSet.addAll(this.getRelationsOfOneNodeCondition(vectorArray[0]));
            for (int i = 1; i < vectorArray.length; ++i) {
                abstractCollection = new HashSet();
                abstractCollection.addAll(this.getRelationsOfOneNodeCondition(vectorArray[i]));
                hashSet.retainAll(abstractCollection);
            }
            Vector<QueryCondition> vector = new Vector<QueryCondition>();
            for (int i = 0; i < queryTree.getRelationNodeList().size(); ++i) {
                QueryCondition queryCondition = null;
                RelationNode relationNode = queryTree.getRelationNodeList().get(i);
                if (!hashSet.contains(relationNode)) continue;
                for (Vector vector2 : vectorArray) {
                    vector.add(this.createCondition(vector2, relationNode));
                }
                queryCondition = this.createOperatorConditions(vector, "OR");
                vector.clear();
                queryTree.getRelationNodeList().get(i).getConditionList().add(queryCondition);
            }
        }
    }

    private QueryCondition createCondition(Vector vector, RelationNode relationNode) {
        QueryCondition queryCondition = null;
        Vector<QueryCondition> vector2 = new Vector<QueryCondition>();
        for (int i = 0; i < vector.size(); ++i) {
            QueryCondition queryCondition2 = (QueryCondition)vector.get(i);
            RelationNode relationNode2 = this.getOneNodeCondition(queryCondition2);
            if (!relationNode.equals(relationNode2)) continue;
            vector2.add(queryCondition2);
        }
        queryCondition = this.createOperatorConditions(vector2, "AND");
        return queryCondition;
    }

    private Collection<RelationNode> getRelationsOfOneNodeCondition(Vector vector) {
        HashSet<RelationNode> hashSet = new HashSet<RelationNode>();
        for (int i = 0; i < vector.size(); ++i) {
            RelationNode relationNode = this.getOneNodeCondition((QueryCondition)vector.get(i));
            if (relationNode == null) continue;
            hashSet.add(relationNode);
        }
        return hashSet;
    }

    private RelationNode getOneNodeCondition(QueryCondition queryCondition) {
        RelationNode relationNode = null;
        if (queryCondition.getCondType() == 16) {
            if (queryCondition.getLeftCond().getCondType() == 4 && queryCondition.getLeftCond().getExpr().getExprType() == 4) {
                relationNode = queryCondition.getLeftCond().getExpr().getColumn().relationNode;
            }
            if (queryCondition.getRightCond().getCondType() == 4 && queryCondition.getRightCond().getExpr().getExprType() == 4) {
                relationNode = relationNode == null ? queryCondition.getRightCond().getExpr().getColumn().relationNode : null;
            }
        }
        return relationNode;
    }

    private Vector getAndConditions(QueryCondition queryCondition) {
        Vector<QueryCondition> vector = new Vector<QueryCondition>();
        if (queryCondition.getCondType() == 8 && queryCondition.getOperator().equals("AND")) {
            Vector vector2 = this.getAndConditions(queryCondition.getLeftCond());
            Vector vector3 = this.getAndConditions(queryCondition.getRightCond());
            vector.addAll(vector2);
            vector.addAll(vector3);
            return vector;
        }
        vector.add(queryCondition);
        return vector;
    }

    private List<QueryCondition> getOrConditions(List<QueryCondition> list) {
        LinkedList<QueryCondition> linkedList = new LinkedList<QueryCondition>();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getCondType() != 8) continue;
            linkedList.addAll(this.getOrConditions(list.get(i)));
        }
        return linkedList;
    }

    private Vector getOrConditions(QueryCondition queryCondition) {
        Vector<QueryCondition> vector = new Vector<QueryCondition>();
        if (queryCondition.getCondType() == 8 && queryCondition.getOperator().equals("OR")) {
            Vector vector2 = this.getOrConditions(queryCondition.getLeftCond());
            Vector vector3 = this.getOrConditions(queryCondition.getRightCond());
            vector.addAll(vector2);
            vector.addAll(vector3);
            return vector;
        }
        vector.add(queryCondition);
        return vector;
    }

    private boolean needsOrHandling(QueryTree queryTree) {
        if (queryTree.getConditionList() == null || queryTree.getConditionList().size() == 0) {
            return false;
        }
        for (int i = 0; i < queryTree.getConditionList().size(); ++i) {
            if (this.isCanonicalCondition(queryTree.getConditionList().get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isCanonicalCondition(QueryCondition queryCondition) {
        if (queryCondition == null || queryCondition.getCondType() == 4) {
            return true;
        }
        if (queryCondition.getCondType() == 16) {
            return true;
        }
        if (queryCondition.getCondType() == 8 && queryCondition.getOperator().equals("OR") && this.isCanonicalCondition(queryCondition.getLeftCond())) {
            return this.isCanonicalCondition(queryCondition.getRightCond());
        }
        return queryCondition.getCondType() == 8 && queryCondition.getOperator().equals("AND") && this.canMove(queryCondition);
    }

    public ColumnMetaData[] getMetaData() {
        if (!this.isPrepared()) {
            try {
                this.prepare();
            }
            catch (Exception exception) {
                logger.catching(exception);
            }
        }
        return this.aQueryPlan.getMetaData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        Collection<? extends ResultSet> collection;
        Object object;
        block11: {
            block10: {
                if (this.finalResultSet != null) return ExecutionResult.createResultSetResult(0, this.finalResultSet);
                if (!this.isPrepared()) {
                    this.prepare();
                }
                if (this.isBalanceable()) {
                    this.setExecNode(this.client.getSysDatabase().getBalancer().getNextNodeId());
                }
                this.aMultinodeExecutor = this.client.getMultinodeExecutor(this.aQueryPlan.queryNodeTable.values());
                if (this.aQueryPlan.getIntoTable() != null) {
                    this.setLastStepTablespace(this.aExecPlan.stepList.get(this.aExecPlan.stepList.size() - 1));
                }
                this.executeQueryExecPlan(this.aExecPlan);
                if (this.aQueryPlan.getIntoTable() == null) break block10;
                return this.createIntoTable(this.aExecPlan.stepList.get(this.aExecPlan.stepList.size() - 1));
            }
            if (this.aExecPlan.isTopLevelUnion) {
                object = new ServerResultSetImpl(this.unionGroup1, this.aQueryPlan.sortInfo, true, this.aQueryPlan.getLimit(), this.aQueryPlan.getOffset(), new XDBResultSetMetaData(this.aQueryPlan.getMetaData()));
                if (this.unionGroup2 == null) {
                    this.finalResultSet = object;
                } else {
                    Vector<Object> vector = new Vector<Object>();
                    vector.add(object);
                    vector.addAll(this.unionGroup2);
                    this.finalResultSet = new ServerResultSetImpl(vector, this.aQueryPlan.sortInfo, false, this.aQueryPlan.getLimit(), this.aQueryPlan.getOffset(), new XDBResultSetMetaData(this.aQueryPlan.getMetaData()));
                }
                this.finalResultSet.setFinalCoordTempTableList(this.aExecPlan.coordTempTableDropList);
                this.finalResultSet.setFinalNodeTempTableList(this.aExecPlan.nodeTempTableDropList);
                return ExecutionResult.createResultSetResult(0, this.finalResultSet);
            }
            if (!this.aExecPlan.combineResults) return ExecutionResult.createResultSetResult(0, this.finalResultSet);
            object = this.aExecPlan.stepList.get(this.aExecPlan.stepList.size() - 1);
            collection = this.aMultinodeExecutor.getFinalResultSets();
            if (collection.size() != 1 || ((ExecutionStep)object).aStepDetail.dropList.size() != 0) break block11;
            ResultSet resultSet = collection.iterator().next();
            if (!(resultSet instanceof ResultSetImpl)) return ExecutionResult.createResultSetResult(0, resultSet);
            ((ResultSetImpl)resultSet).setColumnMetaData(this.aQueryPlan.getMetaData());
            return ExecutionResult.createResultSetResult(0, resultSet);
        }
        this.finalResultSet = new ServerResultSetImpl(collection, this.aQueryPlan.sortInfo, this.aQueryPlan.isDistinct, this.aQueryPlan.getLimit(), this.aQueryPlan.getOffset(), new XDBResultSetMetaData(this.aQueryPlan.getMetaData()));
        this.finalResultSet.setFinalCoordTempTableList(null);
        this.finalResultSet.setFinalNodeTempTableList(((ExecutionStep)object).aStepDetail.dropList);
        return ExecutionResult.createResultSetResult(0, this.finalResultSet);
    }

    private boolean canPredefineTablespace() {
        return this.aQueryPlan.getIntoTable().isTemporary() && Props.XDB_TEMPORARY_INTERMEDIATE_TABLES || !this.aQueryPlan.getIntoTable().isTemporary() && !Props.XDB_TEMPORARY_INTERMEDIATE_TABLES;
    }

    private void setLastStepTablespace(ExecutionStep executionStep) {
        SysTablespace sysTablespace;
        if (this.canPredefineTablespace() && (sysTablespace = this.aQueryPlan.getIntoTable().getTablespace()) != null && executionStep.aStepDetail.isConsumer) {
            for (Integer n : sysTablespace.getLocations().keySet()) {
                executionStep.aStepDetail.addCreateTablespace(n, sysTablespace.getNodeTablespaceName(n));
            }
        }
    }

    private ExecutionResult createIntoTable(ExecutionStep executionStep) {
        if (this.aQueryPlan.getIntoTable().isTemporary()) {
            if (Props.XDB_TEMPORARY_INTERMEDIATE_TABLES) {
                this.renameFinalTable(executionStep.aStepDetail.targetTable, this.aQueryPlan.getIntoTable().getTableName());
            } else {
                this.copyFinalTable(executionStep.aStepDetail.targetTable, this.aQueryPlan.getIntoTable().getTableName(), true);
            }
            this.client.getSysDatabase().addSysTempTable(this.aQueryPlan.getIntoTable());
            this.client.registerTempTableWithSession(this.aQueryPlan.getIntoTableReferenceName(), this.aQueryPlan.getIntoTable().getTableName());
        } else {
            SyncCreateTable syncCreateTable = this.aQueryPlan.getSyncCreateTable();
            MetaData.getMetaData().beginTransaction();
            try {
                syncCreateTable.execute(this.client);
                if (Props.XDB_TEMPORARY_INTERMEDIATE_TABLES) {
                    this.copyFinalTable(executionStep.aStepDetail.targetTable, this.aQueryPlan.getIntoTable().getTableName(), false);
                } else {
                    this.renameFinalTable(executionStep.aStepDetail.targetTable, this.aQueryPlan.getIntoTable().getTableName());
                }
                MetaData.getMetaData().commitTransaction(syncCreateTable);
            }
            catch (Exception exception) {
                MetaData.getMetaData().rollbackTransaction();
                throw new XDBServerException("Failed to create target table", exception);
            }
        }
        return ExecutionResult.createSuccessResult(0);
    }

    private void renameFinalTable(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("oldname", IdentifierHandler.quote(string));
        hashMap.put("newname", IdentifierHandler.quote(string2));
        String string3 = ParseCmdLine.substitute(Props.XDB_SQLCOMMAND_RENAMETABLE_TEMPLATE, hashMap);
        this.aMultinodeExecutor.executeCommand(string3, this.aQueryPlan.getIntoTable().getNodeList(), true);
    }

    private void copyFinalTable(String string, String string2, boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("oldname", IdentifierHandler.quote(string));
        hashMap.put("newname", IdentifierHandler.quote(string2));
        String string3 = ParseCmdLine.substitute(bl ? Props.XDB_SQLCOMMAND_SELECTINTOTEMP_TEMPLATE : Props.XDB_SQLCOMMAND_SELECTINTO_TEMPLATE, hashMap);
        SysTablespace sysTablespace = this.aQueryPlan.getIntoTable().getTablespace();
        if (sysTablespace != null) {
            HashMap<DBNode, String> hashMap2 = new HashMap<DBNode, String>();
            for (Integer n : sysTablespace.getLocations().keySet()) {
                int n2 = string3.toUpperCase().indexOf("AS SELECT ");
                String string4 = string3.substring(0, n2) + " TABLESPACE " + sysTablespace.getNodeTablespaceName(n) + " " + string3.substring(n2);
                hashMap2.put(this.client.getSysDatabase().getDBNode(n), string4);
            }
            this.aMultinodeExecutor.executeCommand(hashMap2, true);
        } else {
            this.aMultinodeExecutor.executeCommand(string3, this.aQueryPlan.getIntoTable().getNodeList(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCost() {
        if (this.cost == 0L) {
            try {
                if (!this.isPrepared()) {
                    this.prepare();
                }
                this.cost = this.resultTree.getCost();
                Iterator<QueryTree> iterator = this.resultTree.getUnionQueryTreeList().iterator();
                while (iterator.hasNext()) {
                    QueryTree queryTree;
                    QueryTree queryTree2 = queryTree = iterator.next();
                    this.cost += queryTree2.getEstimatedCost();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        long l = this.cost;
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        SysDatabase sysDatabase = this.client.getSysDatabase();
        HashSet hashSet = new HashSet();
        this.getTablesFromQTree(sysDatabase, this.query, hashSet);
        List list = Collections.emptyList();
        LockSpecification<SysTable> lockSpecification = new LockSpecification<SysTable>(hashSet, list);
        return lockSpecification;
    }

    public boolean isBalanceable() {
        if (this.isPrepared() && this.aExecPlan.stepList.size() == 1) {
            ExecutionStep executionStep = this.aExecPlan.stepList.get(0);
            if (executionStep.isLookupStep && !executionStep.aStepDetail.isConsumer && executionStep.correlatedSubPlan == null && executionStep.uncorrelatedSubPlanList == null && this.aExecPlan.relationPlanList.size() == 0 && this.aExecPlan.unionPlanList.size() == 0 && this.aExecPlan.scalarPlanList.size() == 0) {
                return true;
            }
        }
        return false;
    }

    public void setExecNode(int n) {
        ExecutionStep executionStep = this.aExecPlan.stepList.get(0);
        executionStep.setSingleExecNode(n);
        this.aQueryPlan.setSingleQueryNode(n);
    }

    private void getTablesFromQTree(SysDatabase sysDatabase, QueryTree queryTree, Collection collection) {
        if (queryTree == null) {
            return;
        }
        for (RelationNode iRebuildString : queryTree.getRelationNodeList()) {
            if (iRebuildString.getNodeType() == 2) {
                String string = iRebuildString.getTableName();
                SysTable sysTable = sysDatabase.getSysTable(string);
                this.addWithChildren(sysTable, collection);
                continue;
            }
            this.getTablesFromQTree(sysDatabase, iRebuildString.getSubqueryTree(), collection);
        }
        for (QueryTree queryTree2 : queryTree.getUnionQueryTreeList()) {
            this.getTablesFromQTree(sysDatabase, queryTree2, collection);
        }
    }

    private void addWithChildren(SysTable sysTable, Collection collection) {
        if (!collection.contains(sysTable)) {
            collection.add(sysTable);
            List list = sysTable.getChildrenTables();
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    this.addWithChildren((SysTable)iterator.next(), collection);
                }
            }
        }
    }

    @Override
    public Collection<DBNode> getNodeList() {
        HashSet<DBNode> hashSet = new HashSet<DBNode>();
        SysDatabase sysDatabase = this.client.getSysDatabase();
        for (RelationNode relationNode : this.query.getRelationNodeList()) {
            if (relationNode.getNodeType() != 2) continue;
            String string = relationNode.getTableName();
            SysTable sysTable = sysDatabase.getSysTable(string);
            hashSet.addAll(sysTable.getNodeList());
        }
        Object object = null;
        try {
            object = this.query.createIntoTable(this.client);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object != null) {
            hashSet.addAll(((SysTable)object).getNodeList());
        }
        return hashSet;
    }

    private QueryTree foldQueryTree(QueryTree queryTree) {
        QueryTree queryTree2 = null;
        switch (this.assignCase(queryTree)) {
            case 0: {
                queryTree2 = queryTree;
                break;
            }
            case 1: 
            case 2: {
                queryTree2 = this.remakeQuery(queryTree, 1);
                break;
            }
            case 3: {
                queryTree2 = this.remakeQuery(queryTree, 3);
                break;
            }
            case 4: {
                queryTree2 = this.remakeQuery(queryTree, 5);
                break;
            }
            case 5: {
                queryTree2 = this.remakeQuery(queryTree, 5);
                break;
            }
            case 6: {
                queryTree2 = this.remakeQuery(queryTree, 6);
                break;
            }
            case 7: {
                queryTree2 = this.remakeQuery(queryTree, 7);
                break;
            }
            default: {
                queryTree2 = queryTree;
            }
        }
        return queryTree2;
    }

    private QueryCondition getNewCondition(QueryCondition queryCondition, RelationNode relationNode) {
        Vector<RelationNode> vector = new Vector<RelationNode>();
        Vector<AttributeColumn> vector2 = new Vector<AttributeColumn>();
        if (queryCondition == null) {
            return null;
        }
        queryCondition.getRelationNodeList().clear();
        queryCondition.getColumnList().clear();
        if (queryCondition.getCondType() != 2) {
            if (queryCondition.getCondType() == 8 || queryCondition.getCondType() == 16) {
                queryCondition.setLeftCond(this.getNewCondition(queryCondition.getLeftCond(), relationNode));
                vector.addAll(queryCondition.getLeftCond().getRelationNodeList());
                vector2.addAll(queryCondition.getLeftCond().getColumnList());
                queryCondition.setRightCond(this.getNewCondition(queryCondition.getRightCond(), relationNode));
                vector.addAll(queryCondition.getRightCond().getRelationNodeList());
                vector2.addAll(queryCondition.getRightCond().getColumnList());
            } else if (queryCondition.getCondType() == 4) {
                queryCondition.setExpr(this.remakeExpression(queryCondition.getExpr(), relationNode));
                Vector<SqlExpression> vector3 = queryCondition.getExpr().getNodes(queryCondition.getExpr(), 4);
                for (SqlExpression sqlExpression : vector3) {
                    vector.add(sqlExpression.getColumn().relationNode);
                    vector2.add(sqlExpression.getColumn());
                }
            }
        }
        for (int i = 0; i < vector2.size(); ++i) {
            ((AttributeColumn)vector2.get(i)).setParentQueryCondition(queryCondition);
        }
        queryCondition.setRelationNodeList(vector);
        queryCondition.setColumnList(vector2);
        queryCondition.rebuildCondString();
        return queryCondition;
    }

    private int assignCase(QueryTree queryTree) {
        int n = 0;
        if (queryTree.getRelationSubqueryList() == null || queryTree.getRelationSubqueryList().size() == 0) {
            return 0;
        }
        if (queryTree.getRelationSubqueryList().size() != 1) {
            return 0;
        }
        if (queryTree.getOrderByList().size() != 0) {
            return 0;
        }
        for (RelationNode relationNode : queryTree.getRelationNodeList()) {
            if (relationNode.getSubqueryTree() != null && relationNode.getSubqueryTree().getOrderByList().size() != 0) {
                return 0;
            }
            if (relationNode.getNodeType() != 4) {
                return 0;
            }
            if (!(!relationNode.getSubqueryTree().isHasUnion() || relationNode.getSubqueryTree().isContainsAggregates() || relationNode.getSubqueryTree().isCorrelatedSubtree() || relationNode.getSubqueryTree().isPartOfExistClause() || relationNode.getSubqueryTree().isDistinct() || relationNode.getSubqueryTree().getLastOuterLevel() != -1)) {
                if (queryTree.isCorrelatedSubtree() || queryTree.isDistinct() || queryTree.isContainsAggregates() || queryTree.isPartitionedGroupBy() || queryTree.isPartOfExistClause() || queryTree.getLastOuterLevel() != -1) {
                    return 0;
                }
                if (queryTree.getConditionList().isEmpty()) {
                    if (queryTree.getRelationNodeList() != null && queryTree.getRelationNodeList().size() == 1) {
                        return 6;
                    }
                    return 0;
                }
                return 7;
            }
            if (!(!relationNode.getSubqueryTree().isContainsAggregates() || relationNode.getSubqueryTree().isHasUnion() || relationNode.getSubqueryTree().isCorrelatedSubtree() || relationNode.getSubqueryTree().isPartOfExistClause() || relationNode.getSubqueryTree().isDistinct() || relationNode.getSubqueryTree().getLastOuterLevel() != -1)) {
                if (queryTree.isCorrelatedSubtree() || queryTree.isDistinct() || queryTree.isPartitionedGroupBy() || queryTree.isPartOfExistClause() || queryTree.getLastOuterLevel() != -1) {
                    return 0;
                }
                if (queryTree.isContainsAggregates()) {
                    return 5;
                }
                if (!queryTree.getConditionList().isEmpty()) {
                    return 4;
                }
                if (queryTree.getConditionList().isEmpty()) {
                    if (this.hasAggFunction(queryTree.getWhereRootCondition()) && this.canMove(queryTree.getWhereRootCondition())) {
                        return 3;
                    }
                    if (queryTree.getWhereRootCondition() == null) {
                        return 3;
                    }
                    return 0;
                }
                return 0;
            }
            if (relationNode.getSubqueryTree().isContainsAggregates() || relationNode.getSubqueryTree().isHasUnion() || relationNode.getSubqueryTree().isCorrelatedSubtree() || relationNode.getSubqueryTree().isPartOfExistClause() || relationNode.getSubqueryTree().isDistinct() || relationNode.getSubqueryTree().getLastOuterLevel() != -1) continue;
            if (queryTree.isCorrelatedSubtree() || queryTree.isDistinct() || queryTree.isContainsAggregates() || queryTree.isPartitionedGroupBy() || queryTree.isPartOfExistClause() || queryTree.getLastOuterLevel() != -1 || queryTree.isHasUnion()) {
                return 0;
            }
            return 1;
        }
        return n;
    }

    private SqlExpression remakeExpression(SqlExpression sqlExpression, RelationNode relationNode) {
        if (sqlExpression.getExprType() == 4) {
            if (sqlExpression.getMappedExpression() != null && sqlExpression.getColumn().relationNode == relationNode) {
                return sqlExpression.getMappedExpression();
            }
            return sqlExpression;
        }
        if (sqlExpression.getExprType() == 2) {
            return sqlExpression;
        }
        if (sqlExpression.getExprType() == 32) {
            if (sqlExpression.getFunctionParams() != null && sqlExpression.getFunctionParams().size() != 0) {
                Vector<SqlExpression> vector = new Vector<SqlExpression>();
                Iterator<SqlExpression> iterator = sqlExpression.getFunctionParams().iterator();
                while (iterator.hasNext()) {
                    SqlExpression sqlExpression2;
                    SqlExpression sqlExpression3 = sqlExpression2 = iterator.next();
                    vector.add(this.remakeExpression(sqlExpression3, relationNode));
                }
                sqlExpression.setFunctionParams(vector);
            }
            return sqlExpression;
        }
        if (sqlExpression.getExprType() == 16) {
            sqlExpression.setLeftExpr(this.remakeExpression(sqlExpression.getLeftExpr(), relationNode));
            sqlExpression.setRightExpr(this.remakeExpression(sqlExpression.getRightExpr(), relationNode));
        }
        return sqlExpression;
    }

    private QueryCondition addConditionToWhere(QueryCondition queryCondition, QueryCondition queryCondition2) {
        if (queryCondition == null) {
            return null;
        }
        QueryCondition queryCondition3 = new QueryCondition();
        if (queryCondition2 != null) {
            queryCondition3.setLeftCond(queryCondition2);
            queryCondition3.setRightCond(queryCondition);
            queryCondition3.setCondType(8);
            queryCondition3.setOperator("AND");
            queryCondition3.rebuildCondString();
        } else {
            queryCondition3 = queryCondition;
        }
        return queryCondition3;
    }

    /*
     * WARNING - void declaration
     */
    private QueryTree remakeQuery(QueryTree queryTree, int n) {
        if (n >= 1 || n <= 7) {
            ArrayList<SqlExpression> arrayList = new ArrayList<SqlExpression>();
            RelationNode relationNode = queryTree.getRelationSubqueryList().get(0);
            if (n == 5 || n == 4) {
                QueryCondition queryCondition = queryTree.getWhereRootCondition();
                if (queryCondition != null) {
                    List<RelationNode> list = queryCondition.getRelationNodeList();
                    if (list.size() == 1 && list.get(0) == relationNode) {
                        QueryCondition queryCondition2 = queryTree.getRelationSubqueryList().get(0).getSubqueryTree().getWhereRootCondition();
                        QueryCondition queryCondition3 = queryTree.getWhereRootCondition();
                        QueryCondition queryCondition4 = new QueryCondition();
                        queryCondition4 = this.createNewCondition(queryCondition3, null);
                        queryCondition4 = this.addConditionToWhere(queryCondition4, queryCondition2);
                        queryCondition4.setParentQueryTree(relationNode.getSubqueryTree());
                        queryTree.getRelationSubqueryList().get(0).getSubqueryTree().setWhereRootCondition(queryCondition4);
                        queryTree.getFromClauseConditions().clear();
                        relationNode.getConditionList().clear();
                        relationNode.getCondColumnList().clear();
                        queryTree.getRelationSubqueryList().get(0).getSubqueryTree().getConditionList().add(queryCondition4);
                    }
                    queryTree.rebuildString();
                }
                return queryTree;
            }
            if (n == 7) {
                QueryCondition queryCondition = queryTree.getWhereRootCondition();
                if (queryCondition != null) {
                    List<RelationNode> list = queryCondition.getRelationNodeList();
                    if (list.size() == 1 && list.get(0) == relationNode) {
                        QueryCondition queryCondition5 = queryTree.getRelationSubqueryList().get(0).getSubqueryTree().getWhereRootCondition();
                        QueryCondition queryCondition6 = this.addConditionToWhere(queryTree.getWhereRootCondition(), queryCondition5);
                        queryTree.setWhereRootCondition(null);
                        queryTree.getRelationSubqueryList().get(0).getSubqueryTree().setWhereRootCondition(queryCondition6);
                    }
                    queryTree.rebuildString();
                }
                return queryTree;
            }
            if (n == 6) {
                Object object;
                Vector<Object> vector;
                IRebuildString iRebuildString22;
                RelationNode relationNode2 = queryTree.getRelationSubqueryList().get(0);
                QueryTree queryTree2 = relationNode2.getSubqueryTree();
                List<SqlExpression> list = queryTree2.getProjectionList();
                List<SqlExpression> list2 = queryTree2.getUnionQueryTreeList().get(0).getProjectionList();
                for (IRebuildString iRebuildString22 : queryTree.getProjectionList()) {
                    iRebuildString22.setBelongsToTree(queryTree2);
                    arrayList.add(this.remakeExpression((SqlExpression)iRebuildString22, relationNode));
                }
                QueryCondition queryCondition = queryTree.getWhereRootCondition();
                iRebuildString22 = this.getNewCondition(queryCondition, relationNode);
                QueryCondition queryCondition7 = new QueryCondition();
                queryCondition7 = this.createNewCondition((QueryCondition)iRebuildString22, null);
                QueryTree queryTree3 = relationNode.getSubqueryTree();
                queryTree3.setProjectionList(arrayList);
                if (queryCondition != null) {
                    queryTree3.setWhereRootCondition((QueryCondition)iRebuildString22);
                    queryTree3.getConditionList().add((QueryCondition)iRebuildString22);
                    vector = QueryCondition.getNodes((QueryCondition)iRebuildString22, 4);
                    Enumeration<Object> enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        QueryCondition object2 = (QueryCondition)enumeration.nextElement();
                        object = object2.getExpr();
                        SqlExpression sqlExpression = object;
                        int n2 = -1;
                        queryCondition7.getRelationNodeList().clear();
                        queryCondition7.getColumnList().clear();
                        if (((SqlExpression)object).getExprType() == 4) {
                            n2 = this.findInProjectList((SqlExpression)object, list);
                            sqlExpression = list2.get(n2);
                            queryCondition7 = this.changeExpression(queryCondition7, (SqlExpression)object, sqlExpression);
                            continue;
                        }
                        if (((SqlExpression)object).getExprType() != 2) {
                            Vector<SqlExpression> vector2 = ((SqlExpression)object).getNodes((SqlExpression)object, 4);
                            for (SqlExpression sqlExpression2 : vector2) {
                                n2 = this.findInProjectList(sqlExpression2, list);
                                sqlExpression = list2.get(n2);
                                queryCondition7 = this.changeExpression(queryCondition7, (SqlExpression)object, sqlExpression);
                            }
                            continue;
                        }
                        queryCondition7 = this.changeExpression(queryCondition7, (SqlExpression)object, sqlExpression);
                    }
                    HashSet<RelationNode> iRebuildString3 = new HashSet<RelationNode>(queryCondition7.getRelationNodeList());
                    queryCondition7.setRelationNodeList(new Vector<RelationNode>(iRebuildString3));
                    object = new HashSet<AttributeColumn>(queryCondition7.getColumnList());
                    queryCondition7.setColumnList(new Vector<AttributeColumn>((Collection<AttributeColumn>)object));
                    queryTree3.getUnionQueryTreeList().get(0).setWhereRootCondition(queryCondition7);
                    queryTree3.getUnionQueryTreeList().get(0).getConditionList().add(queryCondition7);
                }
                vector = new Vector();
                for (int i = 0; i < queryTree3.getProjectionList().size(); ++i) {
                    SqlExpression sqlExpression = queryTree3.getUnionQueryTreeList().get(0).getProjectionList().get(i);
                    object = sqlExpression.copy();
                    object = SqlExpression.copy(sqlExpression, (SqlExpression)object);
                    ((SqlExpression)object).setBelongsToTree(queryTree3.getUnionQueryTreeList().get(0));
                    object = this.remakeExpression((SqlExpression)object, relationNode);
                    object = this.changeInExpression((SqlExpression)object, list, list2);
                    vector.add(object);
                }
                queryTree3.getUnionQueryTreeList().get(0).setProjectionList(vector);
                queryTree3.copyIntoTableInfo(queryTree);
                return queryTree3;
            }
            if (n == 3 || n == 1 || n == 2) {
                void var15_46;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                List<SqlExpression> list = queryTree.getProjectionList();
                List<RelationNode> list3 = queryTree.getRelationNodeList();
                List<SqlExpression> list4 = relationNode.getSubqueryTree().getProjectionList();
                QueryCondition queryCondition = queryTree.getWhereRootCondition();
                QueryCondition queryCondition8 = relationNode.getSubqueryTree().getWhereRootCondition();
                List<QueryCondition> list5 = queryTree.getConditionList();
                Vector<QueryCondition> vector = new Vector<QueryCondition>();
                List<QueryCondition> list6 = relationNode.getSubqueryTree().getConditionList();
                Vector<SqlExpression> vector3 = new Vector<SqlExpression>();
                for (SqlExpression sqlExpression : list) {
                    object4 = sqlExpression;
                    object3 = ((SqlExpression)object4).copy();
                    ((SqlExpression)object3).setBelongsToTree(relationNode.getSubqueryTree());
                    object3 = this.remakeExpression((SqlExpression)object3, relationNode);
                    object3 = this.changeInExpression((SqlExpression)object3, list4, list4);
                    vector3.add((SqlExpression)object3);
                }
                list5.addAll(list6);
                for (QueryCondition queryCondition2 : list5) {
                    object4 = queryCondition2;
                    ((QueryCondition)object4).getRelationNodeList().remove(relationNode);
                    vector.add(this.getNewCondition((QueryCondition)object4, relationNode));
                }
                Object object6 = new QueryCondition();
                object6 = this.addConditionToWhere(queryCondition, queryCondition8);
                Object var15_42 = null;
                if (this.hasAggFunction((QueryCondition)object6)) {
                    QueryCondition queryCondition3 = new QueryCondition();
                    object4 = this.getAndCondition((QueryCondition)object6);
                    object3 = new Vector();
                    object2 = ((Vector)object4).iterator();
                    while (object2.hasNext()) {
                        object = (QueryCondition)object2.next();
                        if (!this.hasAggFunction((QueryCondition)object)) continue;
                        ((Vector)object3).add(object);
                    }
                    QueryCondition queryCondition5 = this.createOperatorConditions((Vector)object3, "AND");
                    queryCondition5 = this.getNewCondition(queryCondition5, relationNode);
                    ((Vector)object4).removeAll((Collection<?>)object3);
                    object6 = this.createOperatorConditions((Vector)object4, "AND");
                }
                object4 = relationNode.getSubqueryTree();
                ((QueryTree)object4).setProjectionList(vector3);
                ((QueryTree)object4).setConditionList(vector);
                ((QueryTree)object4).setWhereRootCondition((QueryCondition)object6);
                if (var15_46 != null) {
                    ((QueryTree)object4).getHavingList().add((QueryCondition)var15_46);
                }
                list3.remove(relationNode);
                ((QueryTree)object4).getRelationNodeList().addAll(list3);
                for (int i = 0; i < ((QueryTree)object4).getRelationNodeList().size(); ++i) {
                    ((QueryTree)object4).getRelationNodeList().get(i).setNodeId(i + 1);
                }
                if (relationNode.getConditionList().size() != 0) {
                    QueryCondition queryCondition6 = relationNode.getConditionList().get(0);
                    object2 = QueryCondition.getNodes(queryCondition6, 4);
                    object = ((Vector)object2).iterator();
                    while (object.hasNext()) {
                        QueryCondition queryCondition7 = (QueryCondition)object.next();
                        if (queryCondition7.getCondType() != 4 || queryCondition7.getExpr().getMappedExpression() == null) continue;
                        SqlExpression sqlExpression = queryCondition7.getExpr().getMappedExpression();
                        sqlExpression.getColumn().relationNode.getConditionList().add(this.getNewCondition(queryCondition6, relationNode));
                    }
                }
                this.createJoinListOfRelNodes(((QueryTree)object4).getRelationNodeList(), ((QueryTree)object4).getConditionList());
                ((QueryTree)object4).setParentTree(null);
                ((QueryTree)object4).copyIntoTableInfo(queryTree);
                return this.foldQueryTree((QueryTree)object4);
            }
        }
        return queryTree;
    }

    private void createJoinListOfRelNodes(List<RelationNode> list, List<QueryCondition> list2) {
        for (RelationNode relationNode : list) {
            for (QueryCondition queryCondition : list2) {
                if (!queryCondition.isJoin() || !queryCondition.getRelationNodeList().contains(relationNode)) continue;
                HashSet<RelationNode> hashSet = new HashSet<RelationNode>(queryCondition.getRelationNodeList());
                if (hashSet.contains(relationNode)) {
                    hashSet.remove(relationNode);
                }
                relationNode.getJoinList().addAll(hashSet);
            }
            HashSet<RelationNode> hashSet = new HashSet<RelationNode>(relationNode.getJoinList());
            relationNode.setJoinList(new Vector<RelationNode>(hashSet));
        }
    }

    private SqlExpression changeInExpression(SqlExpression sqlExpression, List<SqlExpression> list, List<SqlExpression> list2) {
        int n = list.indexOf(sqlExpression);
        if (n > -1) {
            return list2.get(n);
        }
        if (sqlExpression.getExprType() != 4 && sqlExpression.getExprType() != 2) {
            if (sqlExpression.getLeftExpr() != null) {
                n = list.indexOf(sqlExpression.getLeftExpr());
                if (n == -1) {
                    this.changeInExpression(sqlExpression.getLeftExpr(), list, list2);
                } else {
                    sqlExpression.setLeftExpr(list2.get(n));
                }
            }
            if (sqlExpression.getRightExpr() != null) {
                n = list.indexOf(sqlExpression.getRightExpr());
                if (n == -1) {
                    this.changeInExpression(sqlExpression.getRightExpr(), list, list2);
                } else {
                    sqlExpression.setRightExpr(list2.get(n));
                }
            }
            if (sqlExpression.getFunctionParams() != null && sqlExpression.getFunctionParams().size() > 0) {
                for (int i = 0; i < sqlExpression.getFunctionParams().size(); ++i) {
                    n = list.indexOf(sqlExpression.getFunctionParams().get(i));
                    if (n == -1) {
                        this.changeInExpression(sqlExpression.getFunctionParams().get(i), list, list2);
                        continue;
                    }
                    sqlExpression.getFunctionParams().set(i, list2.get(n));
                }
            }
            return sqlExpression;
        }
        SqlExpression sqlExpression2 = null;
        Iterator<SqlExpression> iterator = list.iterator();
        while (iterator.hasNext()) {
            SqlExpression sqlExpression3;
            SqlExpression sqlExpression4 = sqlExpression3 = iterator.next();
            if ((!sqlExpression.getOuterAlias().equalsIgnoreCase(sqlExpression4.getOuterAlias()) || sqlExpression.getOuterAlias().length() <= 0) && (!sqlExpression.getAlias().equalsIgnoreCase(sqlExpression4.getAlias()) || sqlExpression.getAlias().length() <= 0)) continue;
            if (sqlExpression2 == null) {
                sqlExpression2 = sqlExpression4;
                continue;
            }
            if (!sqlExpression.getExprString().equalsIgnoreCase(sqlExpression4.getExprString())) continue;
            sqlExpression2 = sqlExpression4;
        }
        if (sqlExpression2 != null) {
            SqlExpression.copy(sqlExpression2, sqlExpression);
        }
        return sqlExpression;
    }

    private QueryCondition createNewCondition(QueryCondition queryCondition, QueryCondition queryCondition2) {
        if (queryCondition == null) {
            return null;
        }
        QueryCondition queryCondition3 = new QueryCondition();
        queryCondition3.setACompositeClause(queryCondition.getACompositeClause());
        queryCondition3.setAnyAllFlag(queryCondition.isAnyAllFlag());
        queryCondition3.setAnyAllString(queryCondition.getAnyAllString());
        queryCondition3.setCondType(queryCondition.getCondType());
        queryCondition3.setExpr(queryCondition.getExpr());
        queryCondition3.setAtomic(queryCondition.isAtomic());
        queryCondition3.setInPlan(queryCondition.isInPlan());
        queryCondition3.setJoin(queryCondition.isJoin());
        queryCondition3.setPositive(queryCondition.isPositive());
        queryCondition3.setLeftCond(this.createNewCondition(queryCondition.getLeftCond(), queryCondition3));
        queryCondition3.setOperator(queryCondition.getOperator());
        queryCondition3.setParentQueryCondition(queryCondition2);
        queryCondition3.setParentQueryTree(queryCondition.getParentQueryTree());
        queryCondition3.setProjectedColumns(queryCondition.getProjectedColumns());
        queryCondition3.setRightCond(this.createNewCondition(queryCondition.getRightCond(), queryCondition3));
        queryCondition3.rebuildCondString();
        return queryCondition3;
    }

    private QueryCondition changeExpression(QueryCondition queryCondition, SqlExpression sqlExpression, SqlExpression sqlExpression2) {
        if (queryCondition == null) {
            return null;
        }
        if (queryCondition.getCondType() == 4) {
            if (queryCondition.getExpr() == sqlExpression) {
                queryCondition.setExpr(sqlExpression2);
                Vector<RelationNode> vector = new Vector<RelationNode>();
                Vector<Object> vector2 = new Vector();
                vector2 = sqlExpression2.getNodes(sqlExpression2, 4);
                for (SqlExpression sqlExpression3 : vector2) {
                    vector.add(sqlExpression3.getColumn().relationNode);
                }
                queryCondition.getRelationNodeList().addAll(vector);
                queryCondition.getColumnList().add(this.getColumnList(sqlExpression2));
                queryCondition.rebuildCondString();
                return queryCondition;
            }
            return queryCondition;
        }
        if (queryCondition.getCondType() == 2) {
            if (queryCondition.getExpr() == sqlExpression) {
                queryCondition.setExpr(sqlExpression2);
                Vector<RelationNode> vector = new Vector<RelationNode>();
                Vector<Object> vector3 = new Vector();
                vector3 = sqlExpression2.getNodes(sqlExpression2, 4);
                for (SqlExpression sqlExpression4 : vector3) {
                    vector.add(sqlExpression4.getColumn().relationNode);
                }
                queryCondition.getRelationNodeList().addAll(vector);
                queryCondition.getColumnList().add(this.getColumnList(sqlExpression2));
            }
            queryCondition.setLeftCond(this.changeExpression(queryCondition.getLeftCond(), sqlExpression, sqlExpression2));
            if (queryCondition.getLeftCond() != null) {
                queryCondition.getRelationNodeList().addAll(queryCondition.getLeftCond().getRelationNodeList());
            }
            queryCondition.setRightCond(this.changeExpression(queryCondition.getRightCond(), sqlExpression, sqlExpression2));
            if (queryCondition.getRightCond() != null) {
                queryCondition.getRelationNodeList().addAll(queryCondition.getRightCond().getRelationNodeList());
            }
            queryCondition.getColumnList().add(this.getColumnList(sqlExpression2));
            queryCondition.setACompositeClause(queryCondition.getACompositeClause().changeExpression(sqlExpression, sqlExpression2));
            queryCondition.rebuildCondString();
            return queryCondition;
        }
        if (queryCondition.getCondType() == 8 || queryCondition.getCondType() == 16) {
            queryCondition.setLeftCond(this.changeExpression(queryCondition.getLeftCond(), sqlExpression, sqlExpression2));
            queryCondition.getRelationNodeList().addAll(queryCondition.getLeftCond().getRelationNodeList());
            queryCondition.setRightCond(this.changeExpression(queryCondition.getRightCond(), sqlExpression, sqlExpression2));
            queryCondition.getRelationNodeList().addAll(queryCondition.getRightCond().getRelationNodeList());
            queryCondition.getColumnList().add(this.getColumnList(sqlExpression2));
            queryCondition.rebuildCondString();
            return queryCondition;
        }
        return null;
    }

    private AttributeColumn getColumnList(SqlExpression sqlExpression) {
        if (sqlExpression.getExprType() == 4) {
            return sqlExpression.getColumn();
        }
        return null;
    }

    private int findInProjectList(SqlExpression sqlExpression, List<SqlExpression> list) {
        int n = -1;
        for (n = 0; n < list.size(); ++n) {
            SqlExpression sqlExpression2 = list.get(n);
            if (sqlExpression2.getExprType() != 4) continue;
            if (sqlExpression2.getAlias() != null && sqlExpression2.getAlias().equalsIgnoreCase(sqlExpression.getAlias())) {
                return n;
            }
            if (sqlExpression2.getColumn().columnAlias != null && sqlExpression2.getAlias().equalsIgnoreCase(sqlExpression.getColumn().columnAlias)) {
                return n;
            }
            if (sqlExpression2.getColumn().columnName == null || !sqlExpression2.getAlias().equalsIgnoreCase(sqlExpression.getColumn().columnName)) continue;
            return n;
        }
        return n;
    }

    private Vector getAndCondition(QueryCondition queryCondition) {
        Vector<QueryCondition> vector = new Vector<QueryCondition>();
        if (queryCondition == null) {
            return vector;
        }
        if (queryCondition.getCondType() != 8) {
            vector.add(queryCondition);
            return vector;
        }
        if (queryCondition.getOperator() == "AND") {
            vector.add(queryCondition.getRightCond());
            vector.addAll(this.getAndCondition(queryCondition.getLeftCond()));
            return vector;
        }
        vector.add(queryCondition);
        return vector;
    }

    private boolean canMove(QueryCondition queryCondition) {
        if (queryCondition == null) {
            return true;
        }
        if (queryCondition.getCondType() == 4 || queryCondition.getCondType() == 2 || queryCondition.getCondType() == 16) {
            return true;
        }
        if (queryCondition.getCondType() != 8) {
            return false;
        }
        if (queryCondition.getOperator() == "AND") {
            return this.canMove(queryCondition.getRightCond()) & this.canMove(queryCondition.getLeftCond());
        }
        return false;
    }

    private boolean hasAggFunction(QueryCondition queryCondition) {
        if (queryCondition == null) {
            return false;
        }
        Vector<QueryCondition> vector = QueryCondition.getNodes(queryCondition, 4);
        for (QueryCondition queryCondition2 : vector) {
            if (queryCondition2.getExpr().isAggregateExpression()) {
                return true;
            }
            if (queryCondition2.getExpr().getMappedExpression() == null || !queryCondition2.getExpr().getMappedExpression().isAggregateExpression()) continue;
            return true;
        }
        return false;
    }

    private QueryCondition createOperatorConditions(Vector vector, String string) {
        Object object = vector.iterator();
        while (object.hasNext()) {
            if (object.next() != null) continue;
            object.remove();
        }
        object = new QueryCondition();
        Vector vector2 = new Vector();
        vector2.addAll(vector);
        if (vector2 == null || vector2.isEmpty()) {
            return null;
        }
        if (vector2.size() == 1) {
            if (vector2.get(0) == null) {
                return null;
            }
            return (QueryCondition)vector2.get(0);
        }
        if (vector2.get(1) == null) {
            return null;
        }
        ((QueryCondition)object).setCondType(8);
        ((QueryCondition)object).setOperator(string);
        ((QueryCondition)object).setLeftCond((QueryCondition)vector2.get(0));
        vector2.remove(0);
        ((QueryCondition)object).setRightCond(this.createOperatorConditions(vector2, string));
        ((QueryCondition)object).rebuildCondString();
        return object;
    }

    @Override
    public boolean needCoordinatorConnection() {
        return true;
    }
}

