/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.protocol;

import com.edb.gridsql.common.util.Property;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class PgProtocolMessage {
    private static final int INITIAL_CAPACITY = 256;
    private static final String CHARSET_NAME = Property.get("xdb.charset", "ISO-8859-1");
    public static final byte MESSAGE_TYPE_INITIAL = 0;
    public static final byte MESSAGE_TYPE_AUTHENTICATION = 82;
    public static final byte MESSAGE_TYPE_ERROR_RESPONSE = 69;
    public static final byte MESSAGE_TYPE_BACKEND_KEY_DATA = 75;
    public static final byte MESSAGE_TYPE_PARAMETER_STATUS = 83;
    public static final byte MESSAGE_TYPE_READY_FOR_QUERY = 90;
    public static final byte MESSAGE_TYPE_PASSWORD_MESSAGE = 112;
    public static final byte MESSAGE_TYPE_TERMINATE = 88;
    public static final byte MESSAGE_TYPE_SSL_YES = 83;
    public static final byte MESSAGE_TYPE_SSL_NO = 78;
    public static final byte MESSAGE_TYPE_QUERY = 81;
    public static final byte MESSAGE_TYPE_PARSE = 80;
    public static final byte MESSAGE_TYPE_PARSE_COMPLETE = 49;
    public static final byte MESSAGE_TYPE_EMPTY_QUERY_RESPONSE = 73;
    public static final byte MESSAGE_TYPE_BIND = 66;
    public static final byte MESSAGE_TYPE_BIND_COMPLETE = 50;
    public static final byte MESSAGE_TYPE_EXECUTE = 69;
    public static final byte MESSAGE_TYPE_COMMAND_COMPLETE = 67;
    public static final byte MESSAGE_TYPE_DESCRIBE = 68;
    public static final byte MESSAGE_TYPE_PARAMETER_DESCRIPTION = 116;
    public static final byte MESSAGE_TYPE_NO_DATA = 110;
    public static final byte MESSAGE_TYPE_ROW_DESCRIPTION = 84;
    public static final byte MESSAGE_TYPE_SYNC = 83;
    public static final byte MESSAGE_TYPE_DATA_ROW = 68;
    public static final byte MESSAGE_TYPE_PORTAL_SUSPENDED = 115;
    public static final byte MESSAGE_TYPE_CLOSE = 67;
    public static final byte MESSAGE_TYPE_CLOSE_COMPLETE = 51;
    public static final byte MESSAGE_TYPE_FUNCTION_CALL = 70;
    public static final byte MESSAGE_TYPE_FUNCTION_CALL_RESPONSE = 86;
    public static final byte MESSAGE_TYPE_COPY_IN_RESPONSE = 71;
    public static final byte MESSAGE_TYPE_COPY_OUT_RESPONSE = 72;
    public static final byte MESSAGE_TYPE_COPY_DATA = 100;
    public static final byte MESSAGE_TYPE_COPY_DONE = 99;
    public static final byte MESSAGE_TYPE_COPY_FAIL = 102;
    public static final PgProtocolMessage MSG_AUTHENTICATION_OK = new PgProtocolMessage(82, new byte[]{0, 0, 0, 0});
    public static final PgProtocolMessage MSG_AUTHENTICATION_KERBEROS_V4 = new PgProtocolMessage(82, new byte[]{0, 0, 0, 1});
    public static final PgProtocolMessage MSG_AUTHENTICATION_KERBEROS_V5 = new PgProtocolMessage(82, new byte[]{0, 0, 0, 2});
    public static final PgProtocolMessage MSG_AUTHENTICATION_CLEARTEXT_PASSWORD = new PgProtocolMessage(82, new byte[]{0, 0, 0, 3});
    public static final PgProtocolMessage MSG_SSL_YES = new PgProtocolMessage(83, null);
    public static final PgProtocolMessage MSG_SSL_NO = new PgProtocolMessage(78, null);
    public static final PgProtocolMessage MSG_PARSE_COMPLETE = new PgProtocolMessage(49, new byte[0]);
    public static final PgProtocolMessage MSG_EMPTY_QUERY_RESPONSE = new PgProtocolMessage(73, new byte[0]);
    public static final PgProtocolMessage MSG_BIND_COMPLETE = new PgProtocolMessage(50, new byte[0]);
    public static final PgProtocolMessage MSG_NO_DATA = new PgProtocolMessage(110, new byte[0]);
    public static final PgProtocolMessage MSG_PORTAL_SUSPENDED = new PgProtocolMessage(115, new byte[0]);
    public static final PgProtocolMessage MSG_CLOSE_COMPLETE = new PgProtocolMessage(51, new byte[0]);
    public static final PgProtocolMessage MSG_COPY_DONE = new PgProtocolMessage(99, new byte[0]);
    private byte messageType;
    private int messageLength;
    private byte[] messageBody;
    private int currentPos = 0;

    public static final byte[] encodeString(String string) {
        try {
            return string == null ? null : string.getBytes(CHARSET_NAME);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static final String decodeString(byte[] byArray, int n, int n2) {
        try {
            return byArray == null ? null : new String(byArray, n, n2, CHARSET_NAME);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static final String decodeString(byte[] byArray) {
        try {
            return byArray == null ? null : new String(byArray, CHARSET_NAME);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public PgProtocolMessage(byte by, byte[] byArray) {
        this.messageType = by;
        this.messageBody = byArray;
        this.messageLength = byArray == null ? (this.messageLength = -1) : byArray.length;
    }

    public int getLength() {
        return this.messageLength;
    }

    public int getCapacity() {
        return this.messageBody == null ? 0 : this.messageBody.length;
    }

    public void ensureCapacity(int n) {
        if (this.messageBody == null) {
            this.messageBody = new byte[n > 256 ? n : 256];
            this.messageLength = 0;
        } else if (this.messageBody.length < n) {
            byte[] byArray = new byte[n > this.messageBody.length * 2 ? n : this.messageBody.length * 2];
            System.arraycopy(this.messageBody, 0, byArray, 0, this.messageLength);
            this.messageBody = byArray;
        }
    }

    public ByteBuffer getAsByteBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            byteBuffer = this.messageLength < 0 ? ByteBuffer.allocate(1) : ByteBuffer.allocate(5 + this.messageLength);
        }
        byteBuffer.put(this.messageType);
        if (this.messageLength >= 0) {
            byteBuffer.putInt(this.messageLength + 4);
            if (this.messageBody != null && this.messageBody.length > 0) {
                byteBuffer.put(this.messageBody, 0, this.messageLength);
            }
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    public byte getMessageType() {
        return this.messageType;
    }

    public int getPosition() {
        return this.currentPos;
    }

    public void setPosition(int n) {
        this.currentPos = n > this.messageLength ? this.messageLength : n;
    }

    public int getInt8() {
        return this.messageBody[this.currentPos++] & 0xFF;
    }

    public void putInt8(int n) {
        this.ensureCapacity(this.messageLength + 1);
        this.messageBody[this.currentPos++] = (byte)n;
        if (this.messageLength < this.currentPos) {
            this.messageLength = this.currentPos;
        }
    }

    public int getInt16() {
        return this.getInt8() << 8 | this.getInt8();
    }

    public void putInt16(int n) {
        this.ensureCapacity(this.messageLength + 2);
        this.messageBody[this.currentPos++] = (byte)(n >> 8);
        this.messageBody[this.currentPos++] = (byte)n;
        if (this.messageLength < this.currentPos) {
            this.messageLength = this.currentPos;
        }
    }

    public int getInt32() {
        return this.getInt8() << 24 | this.getInt8() << 16 | this.getInt8() << 8 | this.getInt8();
    }

    public void putInt32(int n) {
        this.ensureCapacity(this.messageLength + 4);
        this.messageBody[this.currentPos++] = (byte)(n >> 24);
        this.messageBody[this.currentPos++] = (byte)(n >> 16);
        this.messageBody[this.currentPos++] = (byte)(n >> 8);
        this.messageBody[this.currentPos++] = (byte)n;
        if (this.messageLength < this.currentPos) {
            this.messageLength = this.currentPos;
        }
    }

    public int[] getInt8Array(int n) {
        if (n < 0) {
            return null;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.getInt8();
        }
        return nArray;
    }

    public int[] getInt16Array(int n) {
        if (n < 0) {
            return null;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.getInt16();
        }
        return nArray;
    }

    public int[] getInt32Array(int n) {
        if (n < 0) {
            return null;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.getInt32();
        }
        return nArray;
    }

    public byte[] getBytes(int n) {
        if (n < 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        if (n > 0) {
            System.arraycopy(this.messageBody, this.currentPos, byArray, 0, n);
            this.currentPos += n;
        }
        return byArray;
    }

    public void putBytes(byte[] byArray) {
        this.putBytes(byArray, 0, byArray.length);
    }

    public void putBytes(byte[] byArray, int n, int n2) {
        if (byArray == null || byArray.length == 0) {
            return;
        }
        this.ensureCapacity(this.messageLength + n2);
        System.arraycopy(byArray, n, this.messageBody, this.currentPos, n2);
        this.currentPos += n2;
        if (this.messageLength < this.currentPos) {
            this.messageLength = this.currentPos;
        }
    }

    public String getString() {
        byte[] byArray = new byte[256];
        byte by = (byte)this.getInt8();
        int n = 0;
        while (by != 0) {
            if (n == byArray.length) {
                byte[] byArray2 = new byte[byArray.length * 2];
                System.arraycopy(byArray, 0, byArray2, 0, n);
                byArray = byArray2;
            }
            byArray[n] = by;
            by = (byte)this.getInt8();
            ++n;
        }
        return PgProtocolMessage.decodeString(byArray, 0, n);
    }

    public void putString(String string) {
        if (string != null) {
            this.putBytes(PgProtocolMessage.encodeString(string));
        }
        this.putInt8(0);
    }

    public boolean hasMoreData() {
        return this.messageLength > this.currentPos;
    }
}

