/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.planner;

import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.NodeDBConnectionInfo;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.partitions.HashPartitionMap;
import com.edb.gridsql.metadata.partitions.PartitionMap;
import com.edb.gridsql.metadata.partitions.ReplicatedPartitionMap;
import com.edb.gridsql.parser.ExpressionType;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import com.edb.gridsql.planner.Leaf;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StepDetail
implements Serializable {
    private static final long serialVersionUID = 644465276880869900L;
    private static final XLogger logger = XLogger.getLogger(StepDetail.class);
    private transient XDBSessionContext client;
    public int requestId;
    public int stepNo;
    public boolean isProducer;
    public boolean isConsumer;
    public String queryString;
    public String targetTable;
    public String targetSchema;
    public List<String> dropList;
    private short destType;
    private int destNode;
    public ArrayList<Integer> consumerNodeList;
    public boolean combineOnCoordFirst = false;
    private String hashColumn;
    private int hashColumnPosition = 0;
    private ExpressionType hashDataType = null;
    private PartitionMap partitionMap;
    public static final short DEST_TYPE_BROADCAST = 1;
    public static final short DEST_TYPE_COORD = 2;
    public static final short DEST_TYPE_ONE = 3;
    public static final short DEST_TYPE_HASH = 4;
    public static final short DEST_TYPE_BROADCAST_AND_COORD = 5;
    public static final short DEST_TYPE_COORD_FINAL = 6;
    public static final short DEST_TYPE_NODEID = 7;
    private transient SysDatabase database;
    public boolean isFinalUnionPart = false;
    public short unionResultGroup = 0;
    public List finalUnionPartSortInfo;
    public boolean finalUnionPartIsDistinct = false;
    protected String nonProjectionSelectPart;
    protected boolean isLookupStep = false;
    private boolean isOuterStep = false;
    public boolean suppressSendingNodeId = false;
    public NodeDBConnectionInfo[] nodeInfos = null;
    private String indexColumnString;
    private String insertColumnString;
    private String outerNodeIdColumn;
    private short serialColumnPosition = (short)-1;
    private Map<Integer, String> createTablespaceMap;

    public StepDetail() {
    }

    public StepDetail(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.dropList = new ArrayList<String>();
        this.database = MetaData.getMetaData().getSysDatabase(xDBSessionContext.getDBName());
        if (Props.XDB_USE_LOAD_FOR_STEP) {
            Collection<DBNode> collection = this.database.getDBNodeList();
            this.nodeInfos = new NodeDBConnectionInfo[collection.size()];
            int n = 0;
            for (DBNode dBNode : collection) {
                this.nodeInfos[n++] = dBNode.getNodeDBConnectionInfo();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDropTable(String string) {
        this.dropList.add(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNodeId(String string) {
        int n = this.partitionMap.getPartitions(string).iterator().next();
        return n;
    }

    public StepDetail copy() {
        StepDetail stepDetail = new StepDetail(this.client);
        stepDetail.requestId = this.requestId;
        stepDetail.stepNo = this.stepNo;
        stepDetail.isProducer = this.isProducer;
        stepDetail.isConsumer = this.isConsumer;
        stepDetail.queryString = this.queryString;
        stepDetail.nonProjectionSelectPart = this.nonProjectionSelectPart;
        stepDetail.targetTable = this.targetTable;
        stepDetail.targetSchema = this.targetSchema;
        stepDetail.dropList = this.dropList;
        stepDetail.destType = this.destType;
        stepDetail.destNode = this.destNode;
        stepDetail.combineOnCoordFirst = this.combineOnCoordFirst;
        stepDetail.hashColumn = this.hashColumn;
        stepDetail.hashColumnPosition = this.hashColumnPosition;
        stepDetail.hashDataType = this.hashDataType;
        stepDetail.partitionMap = this.partitionMap;
        stepDetail.consumerNodeList = this.consumerNodeList;
        stepDetail.database = this.database;
        stepDetail.suppressSendingNodeId = this.suppressSendingNodeId;
        stepDetail.nodeInfos = this.nodeInfos;
        stepDetail.indexColumnString = this.indexColumnString;
        stepDetail.insertColumnString = this.insertColumnString;
        stepDetail.isOuterStep = this.isOuterStep;
        stepDetail.outerNodeIdColumn = this.outerNodeIdColumn;
        stepDetail.serialColumnPosition = this.serialColumnPosition;
        stepDetail.createTablespaceMap = this.createTablespaceMap;
        return stepDetail;
    }

    public String toString() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertLeafToStep(Leaf leaf, Leaf leaf2, Leaf leaf3, int n, boolean bl) {
        this.stepNo = leaf.getLeafStepNo();
        this.isLookupStep = leaf.isLookupStep();
        this.outerNodeIdColumn = leaf.getOuterNodeIdColumn();
        this.serialColumnPosition = leaf.getSerialColumnPosition();
        if (leaf2 == null) {
            this.isConsumer = false;
        } else if (!(leaf2.isCombineOnMain() || leaf.isCombinerStep() || leaf.isExtraStep())) {
            this.isConsumer = true;
        } else {
            this.isConsumer = false;
            if (leaf2.isCombinerStep() && leaf.groupByColumns.size() - leaf.getAddedGroupCount() > 0) {
                this.isConsumer = true;
            }
        }
        if (!(leaf.isCombineOnMain() || leaf.isCombinerStep() || leaf.isExtraStep())) {
            this.isProducer = true;
        } else {
            this.isProducer = false;
            if (leaf.isCombinerStep() && leaf.groupByColumns.size() > 0) {
                this.isProducer = true;
            }
        }
        this.targetTable = leaf.getTargetTableName();
        this.targetSchema = leaf.getTempTargetCreateStmt();
        this.destType = (short)-1;
        if (this.isProducer) {
            this.updateProducerStepInfo(leaf, leaf2, leaf3, this);
        }
        if (n > 0 && !bl) {
            this.addNodeIdToStep(n, leaf2 != null);
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertLeafToStepCoord(Leaf leaf, Leaf leaf2, Leaf leaf3, int n, boolean bl) {
        this.stepNo = leaf.getLeafStepNo();
        this.outerNodeIdColumn = leaf.getOuterNodeIdColumn();
        if (leaf2 == null) {
            this.isConsumer = true;
        } else {
            if (!(leaf2.isCombineOnMain() || leaf.isCombinerStep() || leaf.isExtraStep())) {
                this.isConsumer = leaf2.subplan != null;
            } else {
                this.isConsumer = true;
                if (leaf2.isCombinerStep() && leaf.groupByColumns.size() - leaf.getAddedGroupCount() > 0) {
                    this.isConsumer = false;
                }
            }
            if (leaf3 != null && leaf3.isExtraStep()) {
                this.isConsumer = true;
            }
        }
        if (leaf.isCombineOnMain() || leaf.isCombinerStep() || leaf.isExtraStep()) {
            this.isProducer = true;
            if (leaf.isCombinerStep() && leaf.groupByColumns.size() - leaf.getAddedGroupCount() > 0) {
                this.isProducer = false;
            }
        } else {
            this.isProducer = false;
        }
        if (!this.isConsumer && !this.isProducer) {
            return;
        }
        this.targetTable = leaf.getTargetTableName();
        this.targetSchema = leaf.getTempTargetCreateStmt();
        this.destType = (short)-1;
        if (this.isProducer) {
            this.updateProducerStepInfo(leaf, leaf2, leaf3, this);
        }
        if (n > 0 && !bl) {
            this.addNodeIdToStep(n, leaf2 != null);
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProducerStepInfo(Leaf leaf, Leaf leaf2, Leaf leaf3, StepDetail stepDetail) {
        block21: {
            SysTable sysTable = null;
            stepDetail.queryString = leaf.getSelect();
            stepDetail.nonProjectionSelectPart = leaf.getNonProjectionSelectPart();
            stepDetail.dropList = new ArrayList<String>(leaf.tempTableDropList);
            if (leaf2 == null) {
                stepDetail.setDestTypeCoordinator();
                break block21;
            }
            if (leaf2.subplan != null) {
                stepDetail.setDestTypeCoordinator();
                break block21;
            }
            if (leaf3 != null && leaf3.isExtraStep()) {
                stepDetail.setDestTypeBrodcastAndCoordinator();
                break block21;
            }
            if (leaf2.isCombinerStep()) {
                if (leaf.groupByColumns.size() - leaf.getAddedGroupCount() > 0) {
                    HashPartitionMap hashPartitionMap = new HashPartitionMap();
                    Collection<DBNode> collection = this.database.getDBNodeList();
                    ArrayList<Integer> arrayList = new ArrayList<Integer>(collection.size());
                    for (DBNode dBNode : collection) {
                        arrayList.add(dBNode.getNodeId());
                    }
                    hashPartitionMap.generateDistribution(arrayList);
                    Leaf.Projection projection = leaf.groupByColumns.get(0);
                    if (projection.groupByPosition == 0) {
                        stepDetail.setDestTypeHash(Leaf.normalizeHashColumnName(projection.projectString), (PartitionMap)hashPartitionMap);
                    } else {
                        stepDetail.setDestTypeHash(projection.groupByPosition, (PartitionMap)hashPartitionMap);
                    }
                } else {
                    stepDetail.setDestTypeCoordinator();
                }
                break block21;
            }
            if (leaf2.isCombineOnMain() || leaf.isCombinerStep() || leaf.isExtraStep()) {
                stepDetail.setDestTypeCoordinator();
                break block21;
            }
            if (leaf2.getHashColumn() != null) {
                sysTable = SysTable.getPartitionTable(leaf2.getHashTableName(), this.database);
                stepDetail.setDestTypeHash(leaf2.getHashColumn(), sysTable.getPartitionMap());
                return;
            }
            try {
                sysTable = SysTable.getPartitionTable(leaf2.getTableName(), this.database);
            }
            catch (Exception exception) {
                stepDetail.setDestTypeBrodcast();
                return;
            }
            if (sysTable.getPartitionScheme() == 1) {
                stepDetail.setDestTypeOne(sysTable.getPartitionMap().joinPartitions().iterator().next());
            } else if (sysTable.getPartitionScheme() == 2) {
                stepDetail.setDestTypeOne(Props.XDB_COORDINATOR_NODE);
            } else if (leaf2.isSingleStepCorrelated() && leaf2.getSingleCorrelatedHash() != null) {
                stepDetail.setDestTypeHash(leaf2.getSingleCorrelatedHash(), sysTable.getPartitionMap());
            } else {
                stepDetail.setDestTypeBrodcast();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertLeafToStepCorrDown1(Leaf leaf) {
        this.stepNo = 1000 + leaf.getLeafStepNo();
        this.isConsumer = true;
        this.isProducer = true;
        this.outerNodeIdColumn = leaf.getOuterNodeIdColumn();
        this.queryString = leaf.getCorrelatedSelectString();
        this.targetTable = leaf.correlatedJoinTableName + "A";
        this.targetSchema = leaf.getCreateCorrelatedTableString().replaceFirst(leaf.correlatedJoinTableName, this.targetTable);
        HashPartitionMap hashPartitionMap = new HashPartitionMap();
        Collection<DBNode> collection = this.database.getDBNodeList();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(collection.size());
        for (DBNode dBNode : collection) {
            arrayList.add(dBNode.getNodeId());
        }
        hashPartitionMap.generateDistribution(arrayList);
        this.setDestTypeHash(1, (PartitionMap)hashPartitionMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertLeafToStepCorrDown2(Leaf leaf) {
        this.stepNo = 1000 + leaf.getLeafStepNo();
        this.isConsumer = true;
        this.isProducer = true;
        this.outerNodeIdColumn = leaf.getOuterNodeIdColumn();
        this.targetTable = leaf.correlatedJoinTableName;
        this.targetSchema = leaf.getCreateCorrelatedTableString();
        this.queryString = "SELECT DISTINCT * FROM " + IdentifierHandler.quote(this.targetTable + "A");
        this.dropList.add(this.targetTable + "A");
        this.setDestTypeBrodcast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertLeafToStepCorrelatedDown(Leaf leaf, Leaf leaf2) {
        this.stepNo = leaf.getLeafStepNo();
        this.isConsumer = true;
        this.isProducer = true;
        this.outerNodeIdColumn = leaf.getOuterNodeIdColumn();
        this.targetTable = leaf2.getTargetTableName();
        this.targetSchema = leaf2.getTempTargetCreateStmt();
        String string = leaf.correlatedParentHashableExpression.getAlias() != null && leaf.correlatedParentHashableExpression.getAlias().length() > 0 ? leaf.correlatedParentHashableExpression.getAlias() : leaf.correlatedParentHashableExpression.getExprString();
        string = Leaf.normalizeHashColumnName(string);
        HashPartitionMap hashPartitionMap = new HashPartitionMap();
        Collection<DBNode> collection = this.database.getDBNodeList();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(collection.size());
        for (DBNode dBNode : collection) {
            arrayList.add(dBNode.getNodeId());
        }
        hashPartitionMap.generateDistribution(arrayList);
        this.setDestTypeHash(string, (PartitionMap)hashPartitionMap);
    }

    protected void addNodeIdToStep(int n, boolean bl) {
        int n2;
        if (this.queryString != null) {
            n2 = this.queryString.indexOf(" FROM ");
            this.queryString = this.queryString.substring(0, n2) + ", XNODEID" + n + this.queryString.substring(n2);
        }
        if (this.targetSchema != null && bl) {
            n2 = this.targetSchema.lastIndexOf(")");
            this.targetSchema = this.targetSchema.substring(0, n2) + ", XNODEID" + n + " INTEGER)";
        } else {
            this.suppressSendingNodeId = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertLeafToStepCorrDownNodeId(Leaf leaf, int n) {
        this.stepNo = 1000 + leaf.getLeafStepNo();
        this.isConsumer = true;
        this.isProducer = true;
        this.queryString = leaf.getCorrelatedSelectString();
        this.targetTable = leaf.correlatedJoinTableName;
        this.targetSchema = leaf.getCreateCorrelatedTableString();
        this.setDestTypeBrodcast();
        this.addNodeIdToStep(n + 1, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertLeafToStepCorrelatedNodeIdDown(Leaf leaf, Leaf leaf2, int n) {
        this.stepNo = leaf.getLeafStepNo();
        this.isConsumer = true;
        this.isProducer = true;
        this.targetTable = leaf2.getTargetTableName();
        this.targetSchema = leaf2.getTempTargetCreateStmt();
        this.setDestTypeNodeID();
        this.addNodeIdToStep(n + 1, true);
    }

    public void setIndexColumnString(String string) {
        this.indexColumnString = string;
    }

    public String getCorrelatedIndex() {
        String string = null;
        if (this.indexColumnString != null) {
            string = "CREATE INDEX IDX_TMP_" + this.targetTable + " ON " + IdentifierHandler.quote(this.targetTable) + " (" + this.indexColumnString + ")";
        }
        return string;
    }

    public String getInsertColumnString() {
        return this.insertColumnString;
    }

    public void setIsOuterStep(boolean bl) {
        this.isOuterStep = bl;
    }

    public boolean getIsOuterStep() {
        return this.isOuterStep;
    }

    public String getOuterNodeIdColumn() {
        return this.outerNodeIdColumn;
    }

    public short getSerialColumnPosition() {
        return this.serialColumnPosition;
    }

    public ExpressionType getHashDataType() {
        return this.hashDataType;
    }

    public void setHashDataType(ExpressionType expressionType) {
        this.hashDataType = expressionType;
    }

    public void addCreateTablespace(int n, String string) {
        if (this.createTablespaceMap == null) {
            this.createTablespaceMap = new HashMap<Integer, String>();
        }
        this.createTablespaceMap.put(n, string);
    }

    public boolean usesTablespace() {
        return this.createTablespaceMap != null;
    }

    public String getTablespaceClause(int n) {
        String string = null;
        if (this.createTablespaceMap != null) {
            string = this.createTablespaceMap.get(n);
        }
        return string;
    }

    public void setDestTypeNodeID() {
        this.destType = (short)7;
        this.partitionMap = null;
        this.hashColumnPosition = 0;
        this.hashColumn = null;
        this.destNode = 0;
    }

    public void setDestTypeOne(int n) {
        this.destType = (short)3;
        this.partitionMap = new ReplicatedPartitionMap();
        this.partitionMap.generateDistribution(Collections.singleton(n));
        this.hashColumnPosition = 0;
        this.hashColumn = null;
        this.destNode = n;
    }

    public void setDestTypeCoordinatorFinal() {
        this.destType = (short)6;
    }

    public void setDestTypeCoordinator() {
        this.destType = (short)2;
        this.partitionMap = new ReplicatedPartitionMap();
        this.partitionMap.generateDistribution(Collections.singleton(Props.XDB_COORDINATOR_NODE));
        this.hashColumnPosition = 0;
        this.hashColumn = null;
        this.destNode = 0;
    }

    public void setDestTypeBrodcast() {
        this.destType = 1;
        this.partitionMap = null;
        this.hashColumnPosition = 0;
        this.hashColumn = null;
        this.destNode = 0;
    }

    public void setDestTypeBrodcastAndCoordinator() {
        this.destType = (short)5;
        this.partitionMap = null;
        this.hashColumnPosition = 0;
        this.hashColumn = null;
        this.destNode = 0;
    }

    public void setDestTypeHash(int n, PartitionMap partitionMap) {
        this.destType = (short)4;
        this.partitionMap = partitionMap;
        this.hashColumnPosition = n;
        this.hashColumn = null;
        this.destNode = 0;
    }

    public void setDestTypeHash(String string, PartitionMap partitionMap) {
        this.destType = (short)4;
        this.partitionMap = partitionMap;
        this.hashColumnPosition = 0;
        this.hashColumn = string;
        this.destNode = 0;
    }

    public int getDestType() {
        return this.destType;
    }

    public int getHashColumnPosition() {
        return this.hashColumnPosition;
    }

    public String getHashColumn() {
        return this.hashColumn;
    }

    public int getDestNode() {
        return this.destNode;
    }

    public PartitionMap getPartitionMap() {
        return this.partitionMap;
    }

    public void setPartitionMap(PartitionMap partitionMap) {
        this.partitionMap = partitionMap;
    }
}

