/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.planner;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.partitions.HashPartitionMap;
import com.edb.gridsql.metadata.partitions.PartitionMap;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.ExpressionType;
import com.edb.gridsql.planner.ExecutionPlan;
import com.edb.gridsql.planner.Leaf;
import com.edb.gridsql.planner.NodeUsage;
import com.edb.gridsql.planner.QueryPlan;
import com.edb.gridsql.planner.StepDetail;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionStep {
    private static final XLogger logger = XLogger.getLogger(ExecutionStep.class);
    private XDBSessionContext client = null;
    public StepDetail aStepDetail;
    public StepDetail coordStepDetail;
    public HashMap<Integer, NodeUsage> nodeUsageTable;
    public int producerCount;
    public int consumerCount;
    public boolean isExtraStep;
    public boolean isFinalStep = false;
    public List<DBNode> destNodeList;
    public ExecutionPlan correlatedSubPlan = null;
    public List<ExecutionPlan> uncorrelatedSubPlanList = null;
    public ExecutionStep correlatedSendDownStep = null;
    public ExecutionStep correlatedSendDownStep2 = null;
    public ExecutionPlan outerSubPlan;
    private ExecutionPlan parentPlan;
    private Leaf origLeaf;
    public boolean isLookupStep = false;

    protected ExecutionStep(ExecutionPlan executionPlan, XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.nodeUsageTable = new HashMap();
        this.parentPlan = executionPlan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convertFromLeaf(Leaf leaf, Leaf leaf2, Leaf leaf3, Leaf leaf4, HashMap<Integer, NodeUsage> hashMap, List<DBNode> list, boolean bl, int n) {
        Iterator<NodeUsage> iterator;
        Object object;
        this.origLeaf = leaf;
        if (leaf.subplan != null) {
            this.correlatedSubPlan = new ExecutionPlan(this.parentPlan, leaf.subplan, null, null, false, this.client, this.parentPlan.correlatedDepth + 1, leaf.isCorrelatedHashable());
        }
        this.isExtraStep = leaf.isExtraStep();
        this.aStepDetail = new StepDetail(this.client);
        this.aStepDetail.convertLeafToStep(leaf, leaf2, leaf3, this.parentPlan.correlatedDepth, this.parentPlan.isCorrelatedHashable);
        this.isLookupStep = this.aStepDetail.isLookupStep;
        this.coordStepDetail = new StepDetail(this.client);
        this.coordStepDetail.convertLeafToStepCoord(leaf, leaf2, leaf3, this.parentPlan.correlatedDepth, this.parentPlan.isCorrelatedHashable);
        if (!this.coordStepDetail.isConsumer && !this.coordStepDetail.isProducer) {
            this.coordStepDetail = null;
        }
        this.producerCount = 0;
        if (this.aStepDetail.isProducer) {
            this.producerCount = leaf.queryNodeList.size();
            for (DBNode object2 : leaf.queryNodeList) {
                object = new NodeUsage(object2.getNode().getNodeid(), this.aStepDetail.isProducer, false);
                this.nodeUsageTable.put(new Integer(object2.getNode().getNodeid()), (NodeUsage)object);
            }
        }
        this.consumerCount = 0;
        if (this.aStepDetail.isConsumer) {
            this.consumerCount = leaf2.queryNodeList.size();
            this.aStepDetail.consumerNodeList = new ArrayList();
            for (DBNode dBNode : leaf2.queryNodeList) {
                this.aStepDetail.consumerNodeList.add(dBNode.getNode().getNodeid());
                object = this.nodeUsageTable.get(new Integer(dBNode.getNode().getNodeid()));
                if (object != null) {
                    ((NodeUsage)object).isConsumer = true;
                    continue;
                }
                object = new NodeUsage(dBNode.getNode().getNodeid(), false, this.aStepDetail.isConsumer);
                this.nodeUsageTable.put(new Integer(dBNode.getNode().getNodeid()), (NodeUsage)object);
            }
            if (this.coordStepDetail != null) {
                this.coordStepDetail.consumerNodeList = this.aStepDetail.consumerNodeList;
            }
        }
        this.destNodeList = leaf2 != null ? leaf2.queryNodeList : null;
        for (QueryPlan queryPlan : leaf.uncorrelatedSubplanList) {
            object = new ExecutionPlan(this.parentPlan, queryPlan, this.nodeUsageTable, leaf.queryNodeList, false, this.client);
            if (this.uncorrelatedSubPlanList == null) {
                this.uncorrelatedSubPlanList = new ArrayList<ExecutionPlan>();
            }
            this.uncorrelatedSubPlanList.add((ExecutionPlan)object);
        }
        if (list != null && leaf2 == null && !bl) {
            this.aStepDetail.isConsumer = true;
            if (leaf.finalInClausePartitioningTable != null) {
                iterator = MetaData.getMetaData().getSysDatabase(this.client.getDBName());
                SysTable sysTable = ((SysDatabase)((Object)iterator)).getSysTable(leaf.finalInClausePartitioningTable);
                object = new ExpressionType(sysTable.getPartitionedColumn());
                this.aStepDetail.setDestTypeHash(1, sysTable.getPartitionMap());
                this.aStepDetail.setHashDataType((ExpressionType)object);
                if (!this.coordStepDetail.isProducer) {
                    this.coordStepDetail = null;
                } else {
                    this.coordStepDetail.isConsumer = false;
                    this.coordStepDetail.setDestTypeHash(1, sysTable.getPartitionMap());
                    this.coordStepDetail.setHashDataType((ExpressionType)object);
                }
            } else {
                this.aStepDetail.setDestTypeBrodcast();
                if (!this.coordStepDetail.isProducer) {
                    this.coordStepDetail = null;
                } else {
                    this.coordStepDetail.isConsumer = false;
                    this.coordStepDetail.setDestTypeBrodcast();
                }
            }
            this.destNodeList = list;
            this.consumerCount = this.destNodeList.size();
            this.aStepDetail.consumerNodeList = new ArrayList();
            for (NodeUsage nodeUsage : hashMap.values()) {
                this.aStepDetail.consumerNodeList.add(new Integer(nodeUsage.nodeId));
                object = this.nodeUsageTable.get(new Integer(nodeUsage.nodeId));
                if (object != null) {
                    ((NodeUsage)object).isConsumer = true;
                    continue;
                }
                object = new NodeUsage(nodeUsage.nodeId, false, true);
                this.nodeUsageTable.put(new Integer(nodeUsage.nodeId), (NodeUsage)object);
            }
            if (this.coordStepDetail != null) {
                this.coordStepDetail.consumerNodeList = this.aStepDetail.consumerNodeList;
            }
        }
        if (n == 1 && leaf2 == null && leaf.subplan == null) {
            this.convertToNodeStep();
        }
        if (leaf2 == null && bl && this.coordStepDetail != null && this.parentPlan.parentExecutionPlan != null && this.parentPlan.parentExecutionPlan.parentExecutionPlan != null) {
            this.convertToNodeStep();
        }
        if (leaf.subplan != null) {
            this.prepareCorrelatedJoin(leaf, leaf2);
        }
        if (leaf2 != null && leaf2.subplan != null) {
            this.prepareCorrelatedParentAndDownTables(leaf, leaf2);
        }
        if (leaf.outerSubplan != null) {
            this.outerSubPlan = new ExecutionPlan(this.parentPlan, leaf.outerSubplan, this.nodeUsageTable, leaf.queryNodeList, false, this.client);
            iterator = this.outerSubPlan.stepList.get(0);
            ((ExecutionStep)((Object)iterator)).aStepDetail.setDestTypeNodeID();
            ((ExecutionStep)((Object)iterator)).aStepDetail.setIsOuterStep(true);
            this.aStepDetail.nonProjectionSelectPart = this.aStepDetail.nonProjectionSelectPart.replace("&xnodecount&", Integer.toString(((ExecutionStep)((Object)iterator)).producerCount));
            this.aStepDetail.queryString = this.aStepDetail.queryString.replace("&xnodecount&", Integer.toString(((ExecutionStep)((Object)iterator)).producerCount));
            this.aStepDetail.dropList.add(((ExecutionStep)((Object)iterator)).aStepDetail.targetTable);
        }
    }

    private void convertToNodeStep() {
        this.aStepDetail.isConsumer = true;
        StepDetail stepDetail = this.aStepDetail.isProducer ? this.aStepDetail : this.coordStepDetail;
        SysDatabase sysDatabase = this.client.getSysDatabase();
        this.destNodeList = new ArrayList<DBNode>();
        stepDetail.consumerNodeList = new ArrayList();
        HashPartitionMap hashPartitionMap = new HashPartitionMap();
        Collection<DBNode> collection = sysDatabase.getDBNodeList();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(collection.size());
        for (DBNode dBNode : collection) {
            this.destNodeList.add(dBNode);
            stepDetail.consumerNodeList.add(dBNode.getNodeId());
            arrayList.add(dBNode.getNodeId());
        }
        hashPartitionMap.generateDistribution(arrayList);
        stepDetail.setDestTypeHash(1, (PartitionMap)hashPartitionMap);
        if (this.coordStepDetail != null && !this.coordStepDetail.isProducer) {
            this.coordStepDetail = null;
        }
        this.consumerCount = this.destNodeList.size();
        for (DBNode dBNode : sysDatabase.getDBNodeList()) {
            NodeUsage nodeUsage = this.nodeUsageTable.get(new Integer(dBNode.getNode().getNodeid()));
            if (nodeUsage != null) {
                nodeUsage.isConsumer = true;
                continue;
            }
            nodeUsage = new NodeUsage(dBNode.getNode().getNodeid(), false, true);
            this.nodeUsageTable.put(new Integer(dBNode.getNode().getNodeid()), nodeUsage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareCorrelatedJoin(Leaf leaf, Leaf leaf2) {
        Object object;
        Object object4;
        Object object2;
        SysDatabase sysDatabase = MetaData.getMetaData().getSysDatabase(this.client.getDBName());
        int n = sysDatabase.getDBNodeList().size();
        ExecutionStep executionStep = this.correlatedSubPlan.stepList.get(this.correlatedSubPlan.stepList.size() - 1);
        if (executionStep.aStepDetail.isProducer) {
            executionStep.aStepDetail.isConsumer = true;
            executionStep.consumerCount = n;
            for (DBNode object62 : sysDatabase.getDBNodeList()) {
                if (executionStep.aStepDetail.consumerNodeList == null) {
                    executionStep.aStepDetail.consumerNodeList = new ArrayList();
                }
                executionStep.aStepDetail.consumerNodeList.add(new Integer(object62.getNode().getNodeid()));
                object2 = executionStep.nodeUsageTable.get(new Integer(object62.getNode().getNodeid()));
                if (object2 != null) {
                    ((NodeUsage)object2).isConsumer = true;
                    continue;
                }
                object2 = new NodeUsage(object62.getNode().getNodeid(), false, true);
                executionStep.nodeUsageTable.put(new Integer(object62.getNode().getNodeid()), (NodeUsage)object2);
            }
            executionStep.coordStepDetail = null;
            if (leaf.correlatedChildHashableExpression == null) {
                executionStep.aStepDetail.setDestTypeNodeID();
            } else {
                object4 = leaf.correlatedChildHashableExpression.getAlias().length() > 0 ? leaf.correlatedChildHashableExpression.getAlias() : leaf.correlatedChildHashableExpression.getExprString();
                object4 = Leaf.normalizeHashColumnName((String)object4);
                executionStep.aStepDetail.setHashDataType(leaf.correlatedChildHashableExpression.getExprDataType());
                HashPartitionMap hashPartitionMap = new HashPartitionMap();
                object2 = sysDatabase.getDBNodeList();
                Object object3 = new ArrayList(object2.size());
                Iterator<DBNode> iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    ((ArrayList)object3).add(((DBNode)object).getNodeId());
                }
                hashPartitionMap.generateDistribution((Collection<Integer>)object3);
                executionStep.aStepDetail.setDestTypeHash((String)object4, (PartitionMap)hashPartitionMap);
            }
            object4 = "";
            List<String> list = leaf.getCorrelatedColumns();
            if (list != null) {
                for (Object object3 : list) {
                    if (((String)object4).length() > 0) {
                        object4 = (String)object4 + ",";
                    }
                    object4 = (String)object4 + (String)object3;
                }
            }
            if (((String)object4).length() > 0) {
                executionStep.aStepDetail.setIndexColumnString((String)object4);
            }
        }
        this.aStepDetail.isProducer = true;
        this.aStepDetail.isConsumer = true;
        this.producerCount = n;
        this.coordStepDetail = null;
        object4 = new HashPartitionMap();
        Collection<DBNode> collection = sysDatabase.getDBNodeList();
        object2 = new ArrayList(collection.size());
        for (DBNode dBNode : collection) {
            ((ArrayList)object2).add(dBNode.getNodeId());
        }
        object4.generateDistribution((Collection<Integer>)object2);
        this.aStepDetail.setDestTypeHash(1, (PartitionMap)object4);
        this.aStepDetail.consumerNodeList = new ArrayList();
        for (DBNode dBNode : sysDatabase.getDBNodeList()) {
            object = new Integer(dBNode.getNode().getNodeid());
            NodeUsage nodeUsage = this.nodeUsageTable.get(new Integer(dBNode.getNode().getNodeid()));
            if (nodeUsage != null) {
                nodeUsage.isProducer = true;
                nodeUsage.isConsumer = true;
            } else {
                nodeUsage = new NodeUsage(dBNode.getNode().getNodeid(), true, true);
                this.nodeUsageTable.put((Integer)object, nodeUsage);
            }
            if (!this.aStepDetail.consumerNodeList.contains(object)) {
                this.aStepDetail.consumerNodeList.add((Integer)object);
            }
            this.consumerCount = this.aStepDetail.consumerNodeList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareCorrelatedParentAndDownTables(Leaf leaf, Leaf leaf2) {
        if (this.coordStepDetail != null && this.coordStepDetail.consumerNodeList != null) {
            this.aStepDetail.consumerNodeList = this.coordStepDetail.consumerNodeList;
        }
        this.coordStepDetail = null;
        if (leaf2.correlatedParentHashableExpression != null) {
            this.aStepDetail.convertLeafToStepCorrelatedDown(leaf2, leaf);
        } else {
            this.aStepDetail.convertLeafToStepCorrelatedNodeIdDown(leaf2, leaf, this.parentPlan.correlatedDepth);
        }
        SysDatabase sysDatabase = MetaData.getMetaData().getSysDatabase(this.client.getDBName());
        for (DBNode dBNode : sysDatabase.getDBNodeList()) {
            NodeUsage nodeUsage;
            if (this.aStepDetail.consumerNodeList == null) {
                this.aStepDetail.consumerNodeList = new ArrayList(sysDatabase.getDBNodeList().size());
            }
            if (!this.aStepDetail.consumerNodeList.contains(dBNode.getNodeId())) {
                this.aStepDetail.consumerNodeList.add(new Integer(dBNode.getNode().getNodeid()));
            }
            if ((nodeUsage = this.nodeUsageTable.get(new Integer(dBNode.getNode().getNodeid()))) != null) {
                nodeUsage.isConsumer = true;
                continue;
            }
            nodeUsage = new NodeUsage(dBNode.getNode().getNodeid(), false, true);
            this.nodeUsageTable.put(new Integer(dBNode.getNode().getNodeid()), nodeUsage);
        }
        if (leaf2.correlatedParentHashableExpression != null) {
            this.correlatedSendDownStep = new ExecutionStep(null, this.client);
            this.correlatedSendDownStep.convertExtraCorrelated(leaf, leaf2);
            this.correlatedSendDownStep2 = new ExecutionStep(null, this.client);
            this.correlatedSendDownStep2.convertExtraCorrelated2(leaf, leaf2);
        } else {
            this.correlatedSendDownStep = new ExecutionStep(null, this.client);
            this.correlatedSendDownStep.convertExtraCorrelatedNodeId(leaf, leaf2, this.parentPlan.correlatedDepth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertExtraCorrelated(Leaf leaf, Leaf leaf2) {
        this.coordStepDetail = null;
        this.aStepDetail = new StepDetail(this.client);
        this.aStepDetail.convertLeafToStepCorrDown1(leaf2);
        this.isExtraStep = leaf.isExtraStep();
        Leaf leaf3 = leaf2.subplan.getFirstLeaf();
        SysDatabase sysDatabase = MetaData.getMetaData().getSysDatabase(this.client.getDBName());
        this.consumerCount = sysDatabase.getDBNodeList().size();
        this.producerCount = leaf3.queryNodeList.size();
        this.aStepDetail.consumerNodeList = new ArrayList();
        for (DBNode dBNode : sysDatabase.getDBNodeList()) {
            this.aStepDetail.consumerNodeList.add(new Integer(dBNode.getNodeId()));
            NodeUsage nodeUsage = this.nodeUsageTable.get(new Integer(dBNode.getNodeId()));
            if (nodeUsage != null) {
                nodeUsage.isConsumer = true;
                continue;
            }
            nodeUsage = new NodeUsage(dBNode.getNodeId(), true, true);
            this.nodeUsageTable.put(new Integer(dBNode.getNodeId()), nodeUsage);
        }
        this.destNodeList = leaf3 != null ? leaf3.queryNodeList : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertExtraCorrelated2(Leaf leaf, Leaf leaf2) {
        this.aStepDetail = new StepDetail(this.client);
        this.coordStepDetail = null;
        this.aStepDetail.convertLeafToStepCorrDown2(leaf2);
        this.isExtraStep = leaf.isExtraStep();
        Leaf leaf3 = leaf2.subplan.getFirstLeaf();
        this.consumerCount = leaf3.queryNodeList.size();
        this.producerCount = leaf3.queryNodeList.size();
        this.aStepDetail.consumerNodeList = new ArrayList();
        for (DBNode object : leaf3.queryNodeList) {
            this.aStepDetail.consumerNodeList.add(new Integer(object.getNodeId()));
            NodeUsage nodeUsage = this.nodeUsageTable.get(new Integer(object.getNodeId()));
            if (nodeUsage != null) {
                nodeUsage.isConsumer = true;
                continue;
            }
            NodeUsage nodeUsage2 = new NodeUsage(object.getNodeId(), true, true);
            this.nodeUsageTable.put(new Integer(object.getNodeId()), nodeUsage2);
        }
        SysDatabase sysDatabase = MetaData.getMetaData().getSysDatabase(this.client.getDBName());
        for (DBNode dBNode : sysDatabase.getDBNodeList()) {
            NodeUsage nodeUsage = this.nodeUsageTable.get(new Integer(dBNode.getNodeId()));
            if (nodeUsage != null) continue;
            nodeUsage = new NodeUsage(dBNode.getNodeId(), true, false);
            this.nodeUsageTable.put(new Integer(dBNode.getNodeId()), nodeUsage);
        }
        this.destNodeList = leaf3 != null ? leaf3.queryNodeList : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertExtraCorrelatedNodeId(Leaf leaf, Leaf leaf2, int n) {
        this.coordStepDetail = null;
        this.aStepDetail = new StepDetail(this.client);
        this.aStepDetail.convertLeafToStepCorrDownNodeId(leaf2, n);
        this.isExtraStep = leaf.isExtraStep();
        Leaf leaf3 = leaf2.subplan.getFirstLeaf();
        SysDatabase sysDatabase = MetaData.getMetaData().getSysDatabase(this.client.getDBName());
        this.consumerCount = sysDatabase.getDBNodeList().size();
        this.producerCount = leaf3.queryNodeList.size();
        this.aStepDetail.consumerNodeList = new ArrayList();
        for (DBNode dBNode : sysDatabase.getDBNodeList()) {
            this.aStepDetail.consumerNodeList.add(new Integer(dBNode.getNodeId()));
            NodeUsage nodeUsage = this.nodeUsageTable.get(new Integer(dBNode.getNodeId()));
            if (nodeUsage != null) {
                nodeUsage.isConsumer = true;
                continue;
            }
            nodeUsage = new NodeUsage(dBNode.getNodeId(), true, true);
            this.nodeUsageTable.put(new Integer(dBNode.getNodeId()), nodeUsage);
        }
        this.destNodeList = leaf3 != null ? leaf3.queryNodeList : null;
    }

    public String toString() {
        return null;
    }

    private void updateNodeProducerTableConsumer(boolean bl, List<Integer> list) {
        for (NodeUsage nodeUsage : this.nodeUsageTable.values()) {
            nodeUsage.isConsumer = bl;
            if (!bl) continue;
            list.add(nodeUsage.nodeId);
        }
    }

    private int getProducerNode() {
        for (NodeUsage nodeUsage : this.nodeUsageTable.values()) {
            if (!nodeUsage.isProducer) continue;
            return nodeUsage.nodeId;
        }
        return -1;
    }

    private void updateNodeProducerTableSetTargetConsumer(int n, List<Integer> list) {
        for (NodeUsage nodeUsage : this.nodeUsageTable.values()) {
            if (nodeUsage.nodeId == n) {
                nodeUsage.isConsumer = true;
                list.add(nodeUsage.nodeId);
                continue;
            }
            nodeUsage.isConsumer = false;
        }
    }

    protected void correctDestinations(ExecutionStep executionStep) {
        if (this.aStepDetail.isProducer ? !executionStep.origLeaf.extendedTableList.contains(this.aStepDetail.targetTable) && this.parentPlan.parentExecutionPlan != null && this.parentPlan.parentExecutionPlan.relationPlanList.contains(this.parentPlan) : !executionStep.origLeaf.extendedTableList.contains(this.coordStepDetail.targetTable)) {
            return;
        }
        if (executionStep.coordStepDetail != null && executionStep.coordStepDetail.isProducer) {
            if (this.coordStepDetail != null && this.coordStepDetail.isProducer) {
                if (this.coordStepDetail.getDestType() != 2 || this.coordStepDetail.getDestType() != 6) {
                    this.coordStepDetail.setDestTypeCoordinator();
                    this.aStepDetail.isConsumer = false;
                    this.aStepDetail.consumerNodeList = new ArrayList();
                    this.consumerCount = 0;
                    this.updateNodeProducerTableConsumer(false, this.aStepDetail.consumerNodeList);
                }
            } else if (this.aStepDetail.getDestType() != 2 || this.aStepDetail.getDestType() != 6) {
                this.aStepDetail.setDestTypeCoordinator();
                this.aStepDetail.isConsumer = false;
                this.aStepDetail.consumerNodeList = new ArrayList();
                this.consumerCount = 0;
                this.updateNodeProducerTableConsumer(false, this.aStepDetail.consumerNodeList);
                if (this.coordStepDetail == null) {
                    this.coordStepDetail = new StepDetail(this.client);
                    this.coordStepDetail.requestId = this.aStepDetail.requestId;
                    this.coordStepDetail.stepNo = this.aStepDetail.stepNo;
                    this.coordStepDetail.isProducer = false;
                    this.coordStepDetail.isConsumer = true;
                    this.coordStepDetail.targetSchema = this.aStepDetail.targetSchema;
                    this.coordStepDetail.targetTable = this.aStepDetail.targetTable;
                    this.coordStepDetail.setDestTypeCoordinator();
                }
            }
        } else {
            if (this.coordStepDetail != null && this.coordStepDetail.isProducer) {
                if (executionStep.producerCount == 1) {
                    this.coordStepDetail.setDestTypeOne(executionStep.getProducerNode());
                    this.aStepDetail.isConsumer = true;
                    this.aStepDetail.consumerNodeList = new ArrayList();
                    this.updateNodeProducerTableSetTargetConsumer(this.coordStepDetail.getDestNode(), this.aStepDetail.consumerNodeList);
                    this.consumerCount = this.aStepDetail.consumerNodeList.size();
                    return;
                }
            } else if (executionStep.producerCount == 1) {
                this.aStepDetail.setDestTypeOne(executionStep.getProducerNode());
                this.aStepDetail.isConsumer = true;
                this.aStepDetail.consumerNodeList = new ArrayList();
                this.updateNodeProducerTableSetTargetConsumer(this.aStepDetail.getDestNode(), this.aStepDetail.consumerNodeList);
                this.consumerCount = this.aStepDetail.consumerNodeList.size();
                return;
            }
            if (this.aStepDetail.getDestType() == 2 || this.aStepDetail.getDestType() == 6) {
                this.aStepDetail.isConsumer = true;
                this.aStepDetail.consumerNodeList = new ArrayList();
                this.aStepDetail.setDestTypeBrodcast();
                this.updateNodeProducerTableConsumer(true, this.aStepDetail.consumerNodeList);
                this.consumerCount = this.aStepDetail.consumerNodeList.size();
            }
        }
    }

    public void setSingleExecNode(int n) {
        if (this.aStepDetail.isProducer) {
            NodeUsage nodeUsage = new NodeUsage(n, true, false);
            this.nodeUsageTable = new HashMap();
            this.nodeUsageTable.put(new Integer(n), nodeUsage);
        }
    }

    protected SqlExpression getPartitionParameterExpression() {
        return this.origLeaf.getPartitionParameterExpression();
    }
}

